/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.stash.internal.mesh;

import com.atlassian.bitbucket.internal.mesh.RpcManagementClient;
import com.atlassian.bitbucket.mesh.MeshNode;
import com.atlassian.bitbucket.mesh.rpc.v1.RpcNode;
import com.atlassian.bitbucket.mesh.rpc.v1.RpcSetConfigurationRequest;
import com.atlassian.bitbucket.mesh.rpc.v1.RpcTopology;
import com.atlassian.stash.internal.mesh.ConfigVersion;
import com.atlassian.stash.internal.mesh.ControlPlaneState;
import com.atlassian.stash.internal.mesh.MeshConfig;
import com.atlassian.stash.internal.mesh.MeshNodeConfigurer;
import jakarta.annotation.Nonnull;
import jakarta.annotation.Nullable;
import java.io.Serializable;
import java.util.List;
import java.util.Objects;
import org.apache.commons.lang3.StringUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

class ConfigureSidecarTask
implements Serializable {
    private static final Logger log = LoggerFactory.getLogger(ConfigureSidecarTask.class);
    private static final long serialVersionUID = -8806523326966008313L;
    private final MeshConfig config;
    private final ConfigVersion currentVersion;
    private final String nodeListHash;

    private ConfigureSidecarTask(MeshConfig config, String nodeListHash, ConfigVersion currentVersion) {
        this.config = config;
        this.currentVersion = currentVersion;
        this.nodeListHash = nodeListHash;
    }

    @Nullable
    static ConfigureSidecarTask maybeCreate(@Nullable ControlPlaneState state, @Nonnull ConfigVersion currentVersion) {
        Objects.requireNonNull(currentVersion, "currentVersion");
        if (state == null || state.getConfig().getHash().equals(currentVersion.getConfigHash()) && state.getNodeListHash().equals(currentVersion.getNodeListHash())) {
            return null;
        }
        return new ConfigureSidecarTask(state.getConfig(), state.getNodeListHash(), currentVersion);
    }

    @Nonnull
    ConfigVersion configure(@Nonnull RpcManagementClient managementClient, @Nonnull MeshNode sidecar, @Nonnull List<MeshNode> nodes, @Nonnull MeshNodeConfigurer meshNodeConfigurer) {
        Objects.requireNonNull(managementClient, "managementClient");
        Objects.requireNonNull(sidecar, "sidecar");
        Objects.requireNonNull(meshNodeConfigurer, "meshNodeConfigurer");
        managementClient.updateConfig(sidecar, RpcSetConfigurationRequest.newBuilder().setNodeConfiguration(meshNodeConfigurer.buildNodeConfiguration(this.config, sidecar)).setTopology(ConfigureSidecarTask.buildTopology(nodes)).build());
        log.debug("Configured sidecar (config {} -> {})", (Object)StringUtils.defaultString((String)this.currentVersion.getConfigHash(), (String)"-"), (Object)this.config.getHash());
        return new ConfigVersion(ConfigVersion.nodeHash(sidecar), this.nodeListHash, this.config.getHash(), ConfigVersion.NULL_HASH, ConfigVersion.NULL_HASH);
    }

    private static RpcTopology buildTopology(List<MeshNode> nodes) {
        RpcTopology.Builder builder = RpcTopology.newBuilder();
        for (MeshNode node : nodes) {
            if (node.isSidecar()) continue;
            builder.addNodes(RpcNode.newBuilder().setId(Long.toString(node.getId())).setName(StringUtils.defaultString((String)node.getName())).setRpcUrl(node.getRpcUrl()));
        }
        return builder.build();
    }
}

