/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.stash.internal.mesh;

import com.atlassian.bitbucket.mesh.MeshNode;
import com.atlassian.stash.internal.mesh.ConfigVersion;
import com.atlassian.stash.internal.mesh.MeshConfig;
import jakarta.annotation.Nonnull;
import java.io.Serializable;
import java.util.HashMap;
import java.util.Map;
import java.util.Objects;
import java.util.Set;
import java.util.stream.Collectors;

class ControlPlaneState
implements Serializable {
    private static final long serialVersionUID = 3509190716619788582L;
    private final Map<Long, ConfigVersion> configVersions;
    private MeshConfig config;
    private String nodeListHash;
    private String topologyHash;

    ControlPlaneState() {
        this(new MeshConfig.Builder(false).build(), ConfigVersion.NULL_HASH, ConfigVersion.NULL_HASH);
    }

    ControlPlaneState(@Nonnull MeshConfig config, @Nonnull String nodeListHash, @Nonnull String topologyHash) {
        this.config = Objects.requireNonNull(config, "config");
        this.nodeListHash = Objects.requireNonNull(nodeListHash, "nodeListHash");
        this.topologyHash = Objects.requireNonNull(topologyHash, "topologyId");
        this.configVersions = new HashMap<Long, ConfigVersion>();
    }

    public boolean clearNodeState(long nodeId) {
        return this.configVersions.remove(nodeId) != null;
    }

    public boolean clearNodeStates() {
        if (this.configVersions.isEmpty()) {
            return false;
        }
        this.configVersions.clear();
        return true;
    }

    @Nonnull
    public MeshConfig getConfig() {
        return this.config;
    }

    @Nonnull
    public Set<Long> getFailedNodeIds() {
        return this.configVersions.entrySet().stream().filter(entry -> ((ConfigVersion)entry.getValue()).getFailedCount() > 0).map(Map.Entry::getKey).collect(Collectors.toSet());
    }

    @Nonnull
    public String getNodeListHash() {
        return this.nodeListHash;
    }

    @Nonnull
    public String getTopologyHash() {
        return this.topologyHash;
    }

    @Nonnull
    public String getTopologySliceHash(long nodeId) {
        ConfigVersion configVersion = this.configVersions.get(nodeId);
        return configVersion == null ? "" : configVersion.getTopologySliceHash();
    }

    boolean hasCurrentConfig(@Nonnull MeshNode node) {
        Objects.requireNonNull(node, "node");
        ConfigVersion state = this.configVersions.get(node.getId());
        return state != null && state.getConfigHash().equals(this.config.getHash());
    }

    boolean hasCurrentNodeDetails(@Nonnull MeshNode node) {
        Objects.requireNonNull(node, "node");
        ConfigVersion state = this.configVersions.get(node.getId());
        return state != null && ConfigVersion.nodeHash(node).equals(state.getNodeHash());
    }

    boolean hasCurrentTopology(@Nonnull MeshNode node) {
        Objects.requireNonNull(node, "node");
        ConfigVersion state = this.configVersions.get(node.getId());
        return state != null && state.getTopologyHash().equals(this.topologyHash);
    }

    int markFailed(@Nonnull MeshNode node) {
        Objects.requireNonNull(node, "node");
        return this.configVersions.computeIfAbsent(node.getId(), id -> new ConfigVersion()).incrementFailedCount();
    }

    void markUpToDate(@Nonnull MeshNode node, @Nonnull String topologySliceHash) {
        Objects.requireNonNull(node, "node");
        Objects.requireNonNull(topologySliceHash, "topologySliceHash");
        this.configVersions.put(node.getId(), new ConfigVersion(ConfigVersion.nodeHash(node), this.nodeListHash, this.config.getHash(), this.topologyHash, topologySliceHash));
    }

    boolean setConfig(@Nonnull MeshConfig config) {
        Objects.requireNonNull(config, "config");
        if (this.config.getHash().equals(config.getHash())) {
            return false;
        }
        this.config = config;
        return true;
    }

    boolean setNodeListHash(@Nonnull String nodeListHash) {
        if (Objects.requireNonNull(nodeListHash, "nodesHash").equals(this.nodeListHash)) {
            return false;
        }
        this.nodeListHash = nodeListHash;
        return true;
    }

    boolean setTopologyHash(@Nonnull String topologyHash) {
        if (Objects.requireNonNull(topologyHash, "topologyHash").equals(this.topologyHash)) {
            return false;
        }
        this.topologyHash = topologyHash;
        return true;
    }
}

