/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.stash.internal.mesh;

import com.atlassian.nutcluster.core.EntryView;
import com.atlassian.nutcluster.map.merge.LatestUpdateMapMergePolicy;
import com.atlassian.nutcluster.map.merge.MapMergePolicy;
import com.atlassian.nutcluster.nio.ObjectDataInput;
import com.atlassian.nutcluster.nio.ObjectDataOutput;
import com.atlassian.stash.internal.mesh.ControlPlaneState;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class ControlPlaneStateMergePolicy
implements MapMergePolicy {
    private static final Logger log = LoggerFactory.getLogger(ControlPlaneStateMergePolicy.class);

    public Object merge(String mapName, EntryView mergingEntry, EntryView existingEntry) {
        Object mergingValue = mergingEntry.getValue();
        Object existingValue = existingEntry.getValue();
        if (existingValue == null) {
            return mergingValue;
        }
        if (mergingValue == null) {
            return existingValue;
        }
        if (mergingValue instanceof ControlPlaneState && existingValue instanceof ControlPlaneState) {
            ControlPlaneState mergingState = (ControlPlaneState)mergingValue;
            ControlPlaneState existingState = (ControlPlaneState)existingValue;
            if (!(existingState.getConfig().equals(mergingState.getConfig()) && existingState.getNodeListHash().equals(mergingState.getNodeListHash()) && existingState.getTopologyHash().equals(mergingState.getTopologyHash()))) {
                log.info("Triggering full Mesh reconfiguration after a network partition was resolved");
                existingState.clearNodeStates();
            }
            return existingState;
        }
        log.warn("Incompatible values (existing = {}, merging = {}) detected in {}. Falling back to last updated policy", new Object[]{existingValue.getClass().getName(), mergingValue.getClass().getName(), mapName});
        return new LatestUpdateMapMergePolicy().merge(mapName, mergingEntry, existingEntry);
    }

    public void readData(ObjectDataInput in) {
    }

    public void writeData(ObjectDataOutput out) {
    }
}

