/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.stash.internal.mesh;

import com.atlassian.stash.internal.mesh.InternalMeshClientConfig;
import com.atlassian.stash.internal.mesh.MeshConfig;
import com.atlassian.stash.internal.mesh.MeshRoutingMode;
import jakarta.annotation.Nonnull;
import java.util.Objects;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.core.env.Environment;
import org.springframework.stereotype.Component;

@Component
public class DefaultMeshClientConfig
implements InternalMeshClientConfig {
    private static final String ROUTING_AZ_AFFINITY = "mesh.routing.az-affinity";
    private final Environment environment;
    private volatile Settings current;

    @Autowired
    public DefaultMeshClientConfig(Environment environment) {
        this.environment = environment;
        this.current = new Settings(environment, null);
    }

    @Nonnull
    public MeshRoutingMode getRoutingMode() {
        return this.current.routingMode;
    }

    @Override
    public void reload(@Nonnull MeshConfig config) {
        this.current = new Settings(this.environment, Objects.requireNonNull(config, "config"));
    }

    private static class Settings {
        private final MeshRoutingMode routingMode;

        Settings(Environment environment, MeshConfig config) {
            String quorumMode = Settings.getQuorumMode(environment, config);
            this.routingMode = "always".equalsIgnoreCase(quorumMode) ? MeshRoutingMode.FIXED : (Settings.hasAvailabilityZoneAffinity(environment) ? MeshRoutingMode.AVAILABILITY_ZONE_AFFINITY : MeshRoutingMode.RANDOM);
        }

        private static String getQuorumMode(Environment environment, MeshConfig config) {
            String result;
            if (config != null && (result = config.getProperties().get("replication.quorum-mode")) != null) {
                return result;
            }
            return environment.getProperty("mesh.replication.quorum-mode", "majority");
        }

        private static boolean hasAvailabilityZoneAffinity(Environment environment) {
            return (Boolean)environment.getProperty(DefaultMeshClientConfig.ROUTING_AZ_AFFINITY, Boolean.class, (Object)false);
        }
    }
}

