/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.stash.internal.mesh;

import com.atlassian.bitbucket.ServiceException;
import com.atlassian.bitbucket.dmz.mesh.DmzMeshController;
import com.atlassian.bitbucket.dmz.mesh.DmzMeshService;
import com.atlassian.bitbucket.dmz.mesh.MeshConfigProvider;
import com.atlassian.bitbucket.dmz.mesh.MeshConfigUpdatedEvent;
import com.atlassian.bitbucket.dmz.mesh.MeshNodeUnregisteredEvent;
import com.atlassian.bitbucket.dmz.mesh.MissingRepositoryReplicaDetectedEvent;
import com.atlassian.bitbucket.dmz.repository.DmzRepository;
import com.atlassian.bitbucket.dmz.repository.RemoteRepositoryId;
import com.atlassian.bitbucket.event.cluster.ClusterNodeAddedEvent;
import com.atlassian.bitbucket.event.mesh.MeshNodeAvailabilityChangedEvent;
import com.atlassian.bitbucket.event.mesh.MeshNodeRegisteredEvent;
import com.atlassian.bitbucket.event.mesh.MeshNodeUpdatedEvent;
import com.atlassian.bitbucket.internal.mesh.RpcManagementClient;
import com.atlassian.bitbucket.mesh.MeshNode;
import com.atlassian.bitbucket.mesh.MeshNodeConnectionException;
import com.atlassian.bitbucket.mesh.rpc.v1.RpcInconsistentReplica;
import com.atlassian.bitbucket.mesh.rpc.v1.RpcMarkRepositoriesInconsistentRequest;
import com.atlassian.bitbucket.permission.Permission;
import com.atlassian.bitbucket.user.EscalatedSecurityContext;
import com.atlassian.bitbucket.user.SecurityService;
import com.atlassian.event.api.EventListener;
import com.atlassian.nutcluster.core.EntryEvent;
import com.atlassian.nutcluster.core.ExecutionCallback;
import com.atlassian.nutcluster.core.IMap;
import com.atlassian.nutcluster.core.NutclusterInstance;
import com.atlassian.nutcluster.map.AbstractEntryProcessor;
import com.atlassian.nutcluster.map.EntryBackupProcessor;
import com.atlassian.nutcluster.map.EntryProcessor;
import com.atlassian.nutcluster.map.listener.EntryAddedListener;
import com.atlassian.nutcluster.map.listener.EntryUpdatedListener;
import com.atlassian.nutcluster.map.listener.MapListener;
import com.atlassian.plugin.spring.AvailableToPlugins;
import com.atlassian.scheduler.JobRunner;
import com.atlassian.scheduler.JobRunnerRequest;
import com.atlassian.scheduler.JobRunnerResponse;
import com.atlassian.scheduler.SchedulerService;
import com.atlassian.scheduler.SchedulerServiceException;
import com.atlassian.scheduler.config.JobConfig;
import com.atlassian.scheduler.config.JobId;
import com.atlassian.scheduler.config.JobRunnerKey;
import com.atlassian.scheduler.config.RunMode;
import com.atlassian.scheduler.config.Schedule;
import com.atlassian.stash.internal.mesh.ConfigVersion;
import com.atlassian.stash.internal.mesh.ConfigureMeshTask;
import com.atlassian.stash.internal.mesh.ConfigureSidecarTask;
import com.atlassian.stash.internal.mesh.ControlPlaneState;
import com.atlassian.stash.internal.mesh.InternalMeshClientConfig;
import com.atlassian.stash.internal.mesh.MeshConfig;
import com.atlassian.stash.internal.mesh.MeshController;
import com.atlassian.stash.internal.mesh.MeshNodeConfigurer;
import com.atlassian.stash.internal.mesh.MeshTopologyUpdatedEvent;
import com.atlassian.stash.internal.mesh.MutableMeshNodeRegistry;
import com.atlassian.stash.internal.mesh.SidecarUnavailableException;
import com.atlassian.stash.internal.mode.DefaultApplicationMode;
import com.atlassian.stash.internal.scheduling.ScheduledJobSource;
import com.atlassian.stash.internal.spring.AbstractSmartLifecycle;
import com.google.common.annotations.VisibleForTesting;
import com.google.common.collect.ImmutableSet;
import io.grpc.StatusRuntimeException;
import jakarta.annotation.Nonnull;
import jakarta.annotation.PreDestroy;
import java.time.Duration;
import java.time.temporal.ChronoUnit;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.Date;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.Set;
import java.util.concurrent.CompletableFuture;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.beans.factory.annotation.Value;
import org.springframework.boot.autoconfigure.condition.ConditionalOnProperty;
import org.springframework.boot.convert.DurationUnit;
import org.springframework.security.access.prepost.PreAuthorize;
import org.springframework.stereotype.Component;

@AvailableToPlugins(interfaces={DmzMeshController.class})
@Component(value="meshController")
@ConditionalOnProperty(name={"mesh.enabled"}, havingValue="true")
public class DefaultMeshController
extends AbstractSmartLifecycle
implements MeshController,
ScheduledJobSource {
    private static final String JOB_NAME = MeshConfigurationJob.class.getSimpleName();
    private static final JobId JOB_ID = JobId.of((String)JOB_NAME);
    private static final JobRunnerKey JOB_RUNNER_KEY = JobRunnerKey.of((String)JOB_NAME);
    private static final String KEY = "__state__";
    private static final Logger log = LoggerFactory.getLogger(DefaultMeshController.class);
    private static final ExecutionCallback<String> LOG_ON_FAILURE = new ExecutionCallback<String>(){

        public void onFailure(Throwable t) {
            log.warn("Mesh configuration failed", t);
        }

        public void onResponse(String response) {
        }
    };
    private final Set<MeshConfigProvider> configProviders;
    private final IMap<String, ControlPlaneState> controlPlaneState;
    private final RpcManagementClient managementClient;
    private final InternalMeshClientConfig meshClientConfig;
    private final MeshNodeConfigurer meshNodeConfigurer;
    private final MutableMeshNodeRegistry meshNodeRegistry;
    private final DmzMeshService meshService;
    private final EscalatedSecurityContext withSysAdmin;
    private Duration jobInterval;
    private volatile ConfigVersion sidecarConfigVersion;
    private String subscription;

    @Autowired
    public DefaultMeshController(Collection<MeshConfigProvider> configProviders, NutclusterInstance nutclusterInstance, RpcManagementClient managementClient, InternalMeshClientConfig meshClientConfig, MeshNodeConfigurer meshNodeConfigurer, MutableMeshNodeRegistry meshNodeRegistry, DmzMeshService meshService, SecurityService securityService) {
        ArrayList<MeshConfigProvider> priorityConfigProviders = new ArrayList<MeshConfigProvider>(configProviders);
        Collections.reverse(priorityConfigProviders);
        this.configProviders = ImmutableSet.copyOf(priorityConfigProviders);
        this.managementClient = managementClient;
        this.meshClientConfig = meshClientConfig;
        this.meshNodeConfigurer = meshNodeConfigurer;
        this.meshNodeRegistry = meshNodeRegistry;
        this.meshService = meshService;
        this.controlPlaneState = nutclusterInstance.getMap("mesh.control.plane");
        this.jobInterval = Duration.ofMinutes(5L);
        this.sidecarConfigVersion = new ConfigVersion();
        this.withSysAdmin = securityService.withPermission(Permission.SYS_ADMIN, ((Object)((Object)this)).getClass().getSimpleName());
    }

    public void configure(@Nonnull MeshNode node) {
        Objects.requireNonNull(node, "node");
        if (node.isSidecar()) {
            this.maybeConfigureSidecar();
        } else {
            this.controlPlaneState.executeOnKey((Object)KEY, (EntryProcessor)ConfigureMeshTask.forForcedUpdate(node.getId()));
        }
    }

    @PreDestroy
    public void destroy() {
        this.controlPlaneState.removeEntryListener(this.subscription);
        this.subscription = null;
    }

    public CompletableFuture<Void> forceTopologyUpdate() {
        final CompletableFuture<Void> future = new CompletableFuture<Void>();
        this.controlPlaneState.submitToKey((Object)KEY, (EntryProcessor)ConfigureMeshTask.forForcedTopologyUpdate(), (ExecutionCallback)new ExecutionCallback<Object>(){

            public void onFailure(Throwable t) {
                future.completeExceptionally(t);
                LOG_ON_FAILURE.onFailure(t);
            }

            public void onResponse(Object response) {
                future.complete(null);
            }
        });
        return future;
    }

    public int getPhase() {
        return 20;
    }

    @EventListener
    public void onConfigUpdated(MeshConfigUpdatedEvent event) {
        this.controlPlaneState.submitToKey((Object)KEY, (EntryProcessor)ConfigureMeshTask.forConfigUpdate(MeshConfig.update(event.getConfigProvider())), LOG_ON_FAILURE);
    }

    @EventListener
    public void onMeshNodeAvailabilityUpdated(MeshNodeAvailabilityChangedEvent event) {
        if (event.isAvailable()) {
            if (event.getNode().isSidecar()) {
                this.maybeConfigureSidecar();
            } else {
                this.controlPlaneState.submitToKey((Object)KEY, (EntryProcessor)ConfigureMeshTask.forUpToDateCheck(), LOG_ON_FAILURE);
            }
        } else if (event.getNode().isSidecar()) {
            this.sidecarConfigVersion = new ConfigVersion();
        } else {
            this.controlPlaneState.submitToKey((Object)KEY, (EntryProcessor)new ClearNodeState(event.getNodeId()), LOG_ON_FAILURE);
        }
    }

    @EventListener
    public void onMeshNodeRegistered(MeshNodeRegisteredEvent event) {
        this.onTopologyUpdated();
    }

    @EventListener
    public void onMeshNodeUnregistered(MeshNodeUnregisteredEvent event) {
        this.onTopologyUpdated();
    }

    @EventListener
    public void onMeshNodeUpdated(MeshNodeUpdatedEvent event) {
        this.onTopologyUpdated();
    }

    @EventListener
    public void onMeshTopologyChanged(MeshTopologyUpdatedEvent event) {
        this.onTopologyUpdated();
    }

    @EventListener
    public void onMissingRepositoryReplicaDetected(MissingRepositoryReplicaDetectedEvent event) {
        this.managementClient.markRepositoriesInconsistent(event.getNode(), RpcMarkRepositoriesInconsistentRequest.newBuilder().addInconsistentReplicas(RpcInconsistentReplica.newBuilder().setRepository(RemoteRepositoryId.format((DmzRepository)event.getRepository())).setVersion(1L)).build());
    }

    @EventListener
    public void onNodeAdded(ClusterNodeAddedEvent event) {
        if (event.isMaybeNetworkPartitionResolved()) {
            this.controlPlaneState.submitToKey((Object)KEY, (EntryProcessor)ConfigureMeshTask.forUpToDateCheck());
        }
    }

    @PreAuthorize(value="hasGlobalPermission('SYS_ADMIN')")
    public void refreshConfiguration() {
        this.configProviders.forEach(MeshConfigProvider::refresh);
        this.controlPlaneState.submitToKey((Object)KEY, (EntryProcessor)ConfigureMeshTask.forConfigUpdate(MeshConfig.fullConfig(this.configProviders)), LOG_ON_FAILURE);
    }

    @DefaultApplicationMode
    public void schedule(@Nonnull SchedulerService schedulerService) throws SchedulerServiceException {
        long intervalMs = this.jobInterval.toMillis();
        schedulerService.registerJobRunner(JOB_RUNNER_KEY, (JobRunner)new MeshConfigurationJob());
        schedulerService.scheduleJob(JOB_ID, JobConfig.forJobRunnerKey((JobRunnerKey)JOB_RUNNER_KEY).withRunMode(RunMode.RUN_ONCE_PER_CLUSTER).withSchedule(Schedule.forInterval((long)intervalMs, (Date)new Date(System.currentTimeMillis() + intervalMs))));
    }

    @Value(value="${mesh.jobs.configuration.interval}")
    public void setJobInterval(@DurationUnit(value=ChronoUnit.SECONDS) @Nonnull Duration value) {
        this.jobInterval = Objects.requireNonNull(value, "jobInterval");
    }

    public void start() {
        super.start();
        this.subscription = this.controlPlaneState.addEntryListener((MapListener)new ControlPlaneStateListener(), true);
        this.controlPlaneState.submitToKey((Object)KEY, (EntryProcessor)ConfigureMeshTask.forConfigUpdate(MeshConfig.fullConfig(this.configProviders)), LOG_ON_FAILURE);
        try {
            this.maybeConfigureSidecar();
        }
        catch (ServiceException | SidecarUnavailableException | StatusRuntimeException e) {
            log.error("Failed to configure sidecar on initialization", e);
        }
    }

    public void unschedule(@Nonnull SchedulerService schedulerService) {
        schedulerService.unregisterJobRunner(JOB_RUNNER_KEY);
    }

    private void configureClient(MeshConfig config) {
        this.meshClientConfig.reload(config);
    }

    private void maybeConfigureSidecar() {
        ((Optional)this.withSysAdmin.call(() -> ((DmzMeshService)this.meshService).getSidecar())).ifPresent(sidecar -> {
            ConfigureSidecarTask task = (ConfigureSidecarTask)this.controlPlaneState.executeOnKey((Object)KEY, (EntryProcessor)new MaybeCreateConfigureSidecarTask(this.sidecarConfigVersion));
            this.maybeConfigureSidecar((MeshNode)sidecar, task);
        });
    }

    private void maybeConfigureSidecar(MeshNode sidecar, ConfigureSidecarTask task) {
        if (task != null) {
            try {
                this.sidecarConfigVersion = task.configure(this.managementClient, sidecar, (List)this.withSysAdmin.call(() -> ((DmzMeshService)this.meshService).getMembers()), this.meshNodeConfigurer);
            }
            catch (MeshNodeConnectionException e) {
                throw new SidecarUnavailableException("Sidecar is currently unavailable");
            }
        }
    }

    private void onTopologyUpdated() {
        this.controlPlaneState.submitToKey((Object)KEY, (EntryProcessor)ConfigureMeshTask.forTopologyUpdate());
    }

    @VisibleForTesting
    static class ClearNodeState
    extends AbstractEntryProcessor<String, ControlPlaneState> {
        private final long nodeId;

        ClearNodeState(long nodeId) {
            this.nodeId = nodeId;
        }

        public Object process(Map.Entry<String, ControlPlaneState> entry) {
            ControlPlaneState state = entry.getValue();
            if (state != null && state.clearNodeState(this.nodeId)) {
                entry.setValue(state);
            }
            return null;
        }

        @VisibleForTesting
        long getNodeId() {
            return this.nodeId;
        }
    }

    private class MeshConfigurationJob
    implements JobRunner {
        private MeshConfigurationJob() {
        }

        public JobRunnerResponse runJob(@Nonnull JobRunnerRequest request) {
            try {
                DefaultMeshController.this.withSysAdmin.call(() -> {
                    if (DefaultMeshController.this.meshService.getMembers().stream().anyMatch(arg_0 -> ((MutableMeshNodeRegistry)DefaultMeshController.this.meshNodeRegistry).isFailed(arg_0))) {
                        log.debug("Configuring Mesh nodes that are not up-to-date");
                        DefaultMeshController.this.controlPlaneState.submitToKey((Object)DefaultMeshController.KEY, (EntryProcessor)ConfigureMeshTask.forUpToDateCheck(), LOG_ON_FAILURE);
                    }
                    return null;
                });
                return JobRunnerResponse.success();
            }
            catch (RuntimeException e) {
                log.warn("Mesh configuration job failed", (Throwable)e);
                return JobRunnerResponse.failed((Throwable)e);
            }
        }
    }

    @VisibleForTesting
    class ControlPlaneStateListener
    implements EntryAddedListener<String, ControlPlaneState>,
    EntryUpdatedListener<String, ControlPlaneState> {
        ControlPlaneStateListener() {
        }

        public void entryAdded(EntryEvent<String, ControlPlaneState> event) {
            this.onUpdated((ControlPlaneState)event.getValue());
        }

        public void entryUpdated(EntryEvent<String, ControlPlaneState> event) {
            this.onUpdated((ControlPlaneState)event.getValue());
        }

        private void onUpdated(ControlPlaneState state) {
            try {
                if (state != null) {
                    DefaultMeshController.this.meshNodeRegistry.setFailedNodes(state.getFailedNodeIds());
                    ((Optional)DefaultMeshController.this.withSysAdmin.call(() -> ((DmzMeshService)DefaultMeshController.this.meshService).getSidecar())).ifPresent(sidecar -> DefaultMeshController.this.maybeConfigureSidecar((MeshNode)sidecar, ConfigureSidecarTask.maybeCreate(state, DefaultMeshController.this.sidecarConfigVersion)));
                    DefaultMeshController.this.configureClient(state.getConfig());
                }
            }
            catch (ServiceException | SidecarUnavailableException | StatusRuntimeException e) {
                log.error("Failed to configure sidecar", e);
            }
        }
    }

    @VisibleForTesting
    static class MaybeCreateConfigureSidecarTask
    implements EntryProcessor<String, ControlPlaneState> {
        private static final long serialVersionUID = 7587118220989409700L;
        private final ConfigVersion sidecarConfigVersion;

        MaybeCreateConfigureSidecarTask(ConfigVersion sidecarConfigVersion) {
            this.sidecarConfigVersion = sidecarConfigVersion;
        }

        public EntryBackupProcessor<String, ControlPlaneState> getBackupProcessor() {
            return null;
        }

        public Object process(Map.Entry<String, ControlPlaneState> entry) {
            return ConfigureSidecarTask.maybeCreate(entry.getValue(), this.sidecarConfigVersion);
        }
    }
}

