/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.stash.internal.mesh;

import com.atlassian.bitbucket.dmz.systemsigning.SystemSigningConfigurationException;
import com.atlassian.bitbucket.mesh.MeshNode;
import com.atlassian.bitbucket.mesh.rpc.v1.RpcNodeConfiguration;
import com.atlassian.stash.internal.mesh.MeshConfig;
import com.atlassian.stash.internal.mesh.MeshKeyManager;
import com.atlassian.stash.internal.mesh.MeshKeySecurityUtils;
import com.atlassian.stash.internal.mesh.MeshNodeConfigurer;
import com.google.common.annotations.VisibleForTesting;
import jakarta.annotation.Nonnull;
import jakarta.annotation.Nullable;
import java.security.PublicKey;
import java.util.Objects;
import java.util.function.BiFunction;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.boot.autoconfigure.condition.ConditionalOnProperty;
import org.springframework.stereotype.Component;

@Component(value="meshNodeConfigurer")
@ConditionalOnProperty(name={"mesh.enabled"}, havingValue="true")
public class DefaultMeshNodeConfigurer
implements MeshNodeConfigurer {
    private static final Logger log = LoggerFactory.getLogger(DefaultMeshNodeConfigurer.class);
    private final MeshKeyManager keyManager;
    private final BiFunction<String, PublicKey, String> systemSigningKeyEncryptor;

    @Autowired
    public DefaultMeshNodeConfigurer(MeshKeyManager keyManager) {
        this(keyManager, MeshKeySecurityUtils::encrypt);
    }

    @VisibleForTesting
    DefaultMeshNodeConfigurer(@Nonnull MeshKeyManager keyManager, @Nonnull BiFunction<String, PublicKey, String> systemSigningKeyEncryptor) {
        this.keyManager = Objects.requireNonNull(keyManager, "keyManager");
        this.systemSigningKeyEncryptor = Objects.requireNonNull(systemSigningKeyEncryptor, "systemSigningKeyEncryptor");
    }

    @Override
    @Nonnull
    public RpcNodeConfiguration buildNodeConfiguration(@Nullable MeshConfig config, @Nonnull MeshNode node) {
        Objects.requireNonNull(node, "node");
        RpcNodeConfiguration.Builder builder = RpcNodeConfiguration.newBuilder();
        if (node.getAvailabilityZone() != null) {
            builder.putProperties("node.availability-zone", node.getAvailabilityZone());
        }
        builder.putProperties("node.id", node.getRpcId()).putProperties("node.name", node.getName()).putProperties("node.rpc-url", node.getRpcUrl());
        if (config != null) {
            builder.putAllProperties(config.getProperties());
        }
        this.configureSystemSigningKey(builder, node);
        return builder.build();
    }

    private void configureSystemSigningKey(RpcNodeConfiguration.Builder builder, MeshNode node) {
        boolean isSystemSigningEnabled = Boolean.parseBoolean((String)builder.getPropertiesMap().get("git.signing.enabled"));
        if (!isSystemSigningEnabled) {
            log.debug("System signing is not enabled, skipping node specific configuration");
            return;
        }
        PublicKey publicKey = node.isSidecar() ? this.keyManager.getSidecarKeys().getPublic() : (PublicKey)this.keyManager.getKeysByNode(node).stream().findFirst().orElseThrow(() -> new SystemSigningConfigurationException(String.format("Failed to retrieve public key for mesh node '%s'", node)));
        String systemSigningKey = (String)builder.getPropertiesMap().get("git.signing.encrypted-secret-key");
        if (systemSigningKey == null) {
            throw new SystemSigningConfigurationException("There is no system signing key available");
        }
        String secretPassphrase = (String)builder.getPropertiesMap().get("git.signing.encrypted-secret-passphrase");
        if (secretPassphrase == null) {
            throw new SystemSigningConfigurationException("There is no system signing key passphrase");
        }
        try {
            builder.putProperties("git.signing.encrypted-secret-key", this.systemSigningKeyEncryptor.apply(systemSigningKey, publicKey));
            builder.putProperties("git.signing.encrypted-secret-passphrase", this.systemSigningKeyEncryptor.apply(secretPassphrase, publicKey));
        }
        catch (MeshKeySecurityUtils.MeshKeySecurityException e) {
            throw new SystemSigningConfigurationException("There was an error encrypting the system signing key", (Throwable)e);
        }
    }
}

