/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.stash.internal.mesh;

import com.atlassian.bitbucket.dmz.mesh.MeshNodeIdleEvent;
import com.atlassian.bitbucket.event.mesh.MeshNodeAvailabilityChangedEvent;
import com.atlassian.bitbucket.mesh.MeshNode;
import com.atlassian.event.api.EventPublisher;
import com.atlassian.stash.internal.mesh.MutableMeshNodeRegistry;
import com.google.common.collect.ImmutableSet;
import com.google.common.collect.Maps;
import com.google.common.collect.Sets;
import jakarta.annotation.Nonnull;
import java.time.Clock;
import java.util.Collection;
import java.util.Date;
import java.util.Map;
import java.util.Objects;
import java.util.Set;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Component;

@Component(value="meshNodeRegistry")
public class DefaultMeshNodeRegistry
implements MutableMeshNodeRegistry {
    private static final Logger log = LoggerFactory.getLogger(DefaultMeshNodeRegistry.class);
    private final Clock clock;
    private final EventPublisher eventPublisher;
    private final Map<Long, Date> lastSeenDates;
    private final Set<Long> offlineNodes;
    private volatile Set<Long> failedNodes;

    @Autowired
    public DefaultMeshNodeRegistry(EventPublisher eventPublisher) {
        this(Clock.systemDefaultZone(), eventPublisher);
    }

    public DefaultMeshNodeRegistry(Clock clock, EventPublisher eventPublisher) {
        this.clock = clock;
        this.eventPublisher = eventPublisher;
        this.failedNodes = ImmutableSet.of();
        this.lastSeenDates = Maps.newConcurrentMap();
        this.offlineNodes = Sets.newConcurrentHashSet();
    }

    public Date getLastSeenDate(@Nonnull MeshNode node) {
        return this.lastSeenDates.get(Objects.requireNonNull(node, "node").getId());
    }

    public boolean isAvailable(@Nonnull MeshNode node) {
        long nodeId = Objects.requireNonNull(node, "node").getId();
        return !this.offlineNodes.contains(nodeId) && !this.failedNodes.contains(nodeId);
    }

    public boolean isFailed(@Nonnull MeshNode node) {
        return this.failedNodes.contains(Objects.requireNonNull(node, "node").getId());
    }

    public void reportIdle(@Nonnull MeshNode node) {
        this.eventPublisher.publish((Object)new MeshNodeIdleEvent((Object)this, node));
    }

    public void setFailedNodes(@Nonnull Collection<Long> nodeIds) {
        ImmutableSet failedNodes = ImmutableSet.copyOf(Objects.requireNonNull(nodeIds, "nodeIds"));
        Set<Long> prevFailed = this.failedNodes;
        this.failedNodes = failedNodes;
        if (!failedNodes.equals(prevFailed)) {
            log.info("Updated the set of failed nodes from {} to {}", prevFailed, (Object)failedNodes);
        }
    }

    public void setOnline(@Nonnull MeshNode node, boolean online) {
        Objects.requireNonNull(node, "node");
        if (online) {
            if (this.offlineNodes.remove(node.getId())) {
                this.eventPublisher.publish((Object)new MeshNodeAvailabilityChangedEvent((Object)this, node, true));
                log.info("Node {} ({}) came online", (Object)node.getName(), (Object)node.getRpcUrl());
            }
        } else if (this.offlineNodes.add(node.getId())) {
            this.eventPublisher.publish((Object)new MeshNodeAvailabilityChangedEvent((Object)this, node, false));
            log.info("Node {} ({}) went offline", (Object)node.getName(), (Object)node.getRpcUrl());
        }
    }

    public void touchLastSeen(@Nonnull MeshNode node) {
        this.lastSeenDates.put(Objects.requireNonNull(node, "node").getId(), new Date(this.clock.millis()));
    }
}

