/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.stash.internal.mesh;

import com.atlassian.bitbucket.EntityOutOfDateException;
import com.atlassian.bitbucket.NoSuchEntityException;
import com.atlassian.bitbucket.ServiceException;
import com.atlassian.bitbucket.concurrent.LockService;
import com.atlassian.bitbucket.dmz.mesh.DmzMeshPartitionMigrationService;
import com.atlassian.bitbucket.dmz.mesh.MeshPartitionMigration;
import com.atlassian.bitbucket.dmz.mesh.MeshPartitionMigrationCancelledException;
import com.atlassian.bitbucket.dmz.mesh.MeshPartitionMigrationFailedException;
import com.atlassian.bitbucket.dmz.mesh.MeshPartitionMigrationJobState;
import com.atlassian.bitbucket.dmz.mesh.MeshPartitionMigrationNotCancellableException;
import com.atlassian.bitbucket.dmz.mesh.MeshPartitionMigrationRequest;
import com.atlassian.bitbucket.dmz.mesh.MeshPartitionMigrationSearchRequest;
import com.atlassian.bitbucket.dmz.mesh.MeshPartitionMigrationSourceConflict;
import com.atlassian.bitbucket.dmz.mesh.MeshPartitionReplica;
import com.atlassian.bitbucket.dmz.mesh.MeshPartitionReplicaAlreadyExistsException;
import com.atlassian.bitbucket.dmz.mesh.ReplicaState;
import com.atlassian.bitbucket.dmz.mesh.UpdatePartitionReplicaStateRequest;
import com.atlassian.bitbucket.dmz.repository.RemoteRepositoryId;
import com.atlassian.bitbucket.event.mesh.MeshNodeAvailabilityChangedEvent;
import com.atlassian.bitbucket.event.repository.RepositoryDeletedEvent;
import com.atlassian.bitbucket.i18n.I18nService;
import com.atlassian.bitbucket.i18n.KeyedMessage;
import com.atlassian.bitbucket.mesh.MeshNode;
import com.atlassian.bitbucket.permission.Permission;
import com.atlassian.bitbucket.repository.Repository;
import com.atlassian.bitbucket.topic.Topic;
import com.atlassian.bitbucket.topic.TopicService;
import com.atlassian.bitbucket.topic.TopicSettings;
import com.atlassian.bitbucket.user.SecurityService;
import com.atlassian.bitbucket.util.MoreCollectors;
import com.atlassian.bitbucket.util.Page;
import com.atlassian.bitbucket.util.PageRequest;
import com.atlassian.bitbucket.util.PageUtils;
import com.atlassian.bitbucket.util.concurrent.LockGuard;
import com.atlassian.event.api.EventListener;
import com.atlassian.plugin.spring.AvailableToPlugins;
import com.atlassian.scheduler.JobRunnerRequest;
import com.atlassian.scheduler.JobRunnerResponse;
import com.atlassian.scheduler.SchedulerService;
import com.atlassian.scheduler.SchedulerServiceException;
import com.atlassian.scheduler.config.JobConfig;
import com.atlassian.scheduler.config.JobId;
import com.atlassian.scheduler.config.JobRunnerKey;
import com.atlassian.scheduler.config.RunMode;
import com.atlassian.scheduler.config.Schedule;
import com.atlassian.stash.internal.AbstractService;
import com.atlassian.stash.internal.InternalConverter;
import com.atlassian.stash.internal.annotation.Unsecured;
import com.atlassian.stash.internal.mesh.InternalMeshNode;
import com.atlassian.stash.internal.mesh.InternalMeshPartitionMigration;
import com.atlassian.stash.internal.mesh.InternalMeshPartitionMigrationService;
import com.atlassian.stash.internal.mesh.MeshPartitionMigrationDao;
import com.atlassian.stash.internal.mesh.MeshPartitionReplicaService;
import com.atlassian.stash.internal.mesh.MeshRepositoryReplicaDao;
import com.atlassian.stash.internal.mesh.MeshRepositoryReplicaObservation;
import com.atlassian.stash.internal.mesh.MeshRepositoryReplicaObservedEvent;
import com.atlassian.stash.internal.mode.DefaultApplicationMode;
import com.atlassian.stash.internal.scheduling.ScheduledJobSource;
import com.atlassian.stash.internal.spring.SpringTransactionUtils;
import com.atlassian.stash.internal.spring.TransactionSynchronizer;
import com.google.common.annotations.VisibleForTesting;
import com.google.common.base.MoreObjects;
import com.google.common.collect.Iterables;
import io.atlassian.fugue.retry.RetryFactory;
import jakarta.annotation.Nonnull;
import jakarta.annotation.Nullable;
import jakarta.annotation.PostConstruct;
import jakarta.persistence.OptimisticLockException;
import java.io.Serializable;
import java.lang.reflect.Constructor;
import java.lang.reflect.InvocationTargetException;
import java.time.Duration;
import java.time.Instant;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Date;
import java.util.HashSet;
import java.util.List;
import java.util.Objects;
import java.util.Set;
import java.util.concurrent.CompletableFuture;
import java.util.concurrent.CompletionException;
import java.util.concurrent.CompletionStage;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.ConcurrentMap;
import java.util.concurrent.ExecutorService;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.atomic.AtomicBoolean;
import java.util.concurrent.locks.Lock;
import java.util.function.Function;
import java.util.function.Supplier;
import org.apache.commons.lang3.mutable.MutableLong;
import org.hibernate.StaleStateException;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.dao.OptimisticLockingFailureException;
import org.springframework.security.access.prepost.PreAuthorize;
import org.springframework.stereotype.Service;
import org.springframework.transaction.PlatformTransactionManager;
import org.springframework.transaction.annotation.Propagation;
import org.springframework.transaction.annotation.Transactional;
import org.springframework.transaction.support.TransactionSynchronization;
import org.springframework.transaction.support.TransactionTemplate;
import org.springframework.util.ReflectionUtils;

@AvailableToPlugins(interfaces={DmzMeshPartitionMigrationService.class})
@Service(value="meshPartitionMigrationService")
public class DefaultMeshPartitionMigrationService
extends AbstractService
implements InternalMeshPartitionMigrationService,
ScheduledJobSource {
    @VisibleForTesting
    static final String COMPLETION_TOPIC = "atl.mesh.migration.completion";
    private static final long EVERY_HOUR = TimeUnit.HOURS.toMillis(1L);
    private static final String JOB_NAME = "MeshPartitionMigrationService.clusterMaintenanceJob";
    private static final JobId JOB_ID = JobId.of((String)"MeshPartitionMigrationService.clusterMaintenanceJob");
    private static final JobRunnerKey JOB_RUNNER_KEY = JobRunnerKey.of((String)"MeshPartitionMigrationService.clusterMaintenanceJob");
    private static final MeshPartitionMigrationJobState[] TOPOLOGY_UPDATE_STATES = (MeshPartitionMigrationJobState[])Arrays.stream(MeshPartitionMigrationJobState.values()).filter(MeshPartitionMigrationJobState::shouldSendTopology).toArray(MeshPartitionMigrationJobState[]::new);
    private static final Logger log = LoggerFactory.getLogger(DefaultMeshPartitionMigrationService.class);
    private final Topic<CompletionMessage> completionTopic;
    private final ExecutorService executorService;
    private final I18nService i18nService;
    private final LockService lockService;
    private final MeshPartitionMigrationDao migrationDao;
    private final ConcurrentMap<Long, Set<CompletableFuture<Void>>> migrationFinishFutures;
    private final MeshPartitionReplicaService partitionReplicaService;
    private final TransactionTemplate readOnlyTransaction;
    private final TransactionTemplate readWriteTransaction;
    private final MeshRepositoryReplicaDao repositoryReplicaDao;
    private final SecurityService securityService;
    private final TransactionSynchronizer transactionSynchronizer;

    @Autowired
    public DefaultMeshPartitionMigrationService(LockService lockService, MeshPartitionMigrationDao migrationDao, ExecutorService executorService, MeshPartitionReplicaService partitionReplicaService, I18nService i18nService, MeshRepositoryReplicaDao repositoryReplicaDao, TopicService topicService, PlatformTransactionManager transactionManager, TransactionSynchronizer transactionSynchronizer, SecurityService securityService) {
        this.lockService = lockService;
        this.migrationDao = migrationDao;
        this.executorService = executorService;
        this.partitionReplicaService = partitionReplicaService;
        this.i18nService = i18nService;
        this.repositoryReplicaDao = repositoryReplicaDao;
        this.transactionSynchronizer = transactionSynchronizer;
        this.securityService = securityService;
        this.readWriteTransaction = new TransactionTemplate(transactionManager, SpringTransactionUtils.definitionFor((int)0));
        this.readOnlyTransaction = new TransactionTemplate(transactionManager, SpringTransactionUtils.definitionFor((int)0, (boolean)true));
        this.migrationFinishFutures = new ConcurrentHashMap<Long, Set<CompletableFuture<Void>>>();
        this.completionTopic = topicService.getTopic(COMPLETION_TOPIC, TopicSettings.builder(CompletionMessage.class).queueSize(200).dedupePendingMessages(false).build());
    }

    @Transactional(propagation=Propagation.REQUIRED)
    @PreAuthorize(value="hasGlobalPermission('SYS_ADMIN')")
    public <T> T batchMigrations(@Nonnull Function<DmzMeshPartitionMigrationService.MigrationBatch, T> batch) {
        Objects.requireNonNull(batch, "batch");
        final ArrayList controllers = new ArrayList();
        Object result = this.partitionReplicaService.runBatch(batchOperation -> batch.apply(request -> {
            Objects.requireNonNull(request, "request");
            InternalMeshPartitionMigration migration = this.internalCreateMigration(request, (MeshPartitionReplicaService.BatchOperation)batchOperation);
            MigrationTask controller = new MigrationTask(migration);
            controllers.add(controller);
            return controller.getFuture();
        }));
        this.transactionSynchronizer.register(new TransactionSynchronization(){

            public void afterCommit() {
                controllers.forEach(MigrationTask::execute);
            }
        });
        return (T)result;
    }

    @Transactional(propagation=Propagation.REQUIRED)
    @PreAuthorize(value="hasGlobalPermission('SYS_ADMIN')")
    public void cancel(long migrationId) {
        final InternalMeshPartitionMigration updatedMigration = this.updateJobState(migrationId, null, MeshPartitionMigrationJobState.CANCELLING);
        this.transactionSynchronizer.register(new TransactionSynchronization(){

            public void afterCommit() {
                new MigrationTask(updatedMigration).execute();
            }
        });
    }

    @Nonnull
    @Unsecured(value="Internal only method")
    public List<MeshPartitionMigration> getAllForTopologyUpdate() {
        return (List)PageUtils.toStream(request -> this.migrationDao.search(new MeshPartitionMigrationSearchRequest.Builder().states(TOPOLOGY_UPDATE_STATES).build(), request), (int)1000).collect(MoreCollectors.toImmutableList());
    }

    @Nullable
    public MeshPartitionMigration getById(long id) {
        return (MeshPartitionMigration)this.migrationDao.getById((Object)id);
    }

    @Nonnull
    @Unsecured(value="Only exposed over JMX")
    @Transactional(readOnly=true)
    public InternalMeshPartitionMigrationService.MigrationStatistics getMigrationStatistics() {
        final MutableLong longRunning1h = new MutableLong();
        final MutableLong longRunning8h = new MutableLong();
        final MutableLong longRunning24h = new MutableLong();
        final long inProgress = PageUtils.toStream(page -> this.search(new MeshPartitionMigrationSearchRequest.Builder().states((Iterable)MeshPartitionMigrationJobState.NON_TERMINAL_STATES).build(), page), (int)1000).peek(migration -> {
            Instant createdDate = migration.getCreatedDate();
            if (createdDate.isBefore(Instant.now().minus(Duration.ofHours(1L)))) {
                longRunning1h.increment();
            }
            if (createdDate.isBefore(Instant.now().minus(Duration.ofHours(8L)))) {
                longRunning8h.increment();
            }
            if (createdDate.isBefore(Instant.now().minus(Duration.ofHours(24L)))) {
                longRunning24h.increment();
            }
        }).count();
        final long failed = PageUtils.toStream(page -> this.search(new MeshPartitionMigrationSearchRequest.Builder().states(new MeshPartitionMigrationJobState[]{MeshPartitionMigrationJobState.FAILED}).build(), page), (int)1000).count();
        return new InternalMeshPartitionMigrationService.MigrationStatistics(){

            public long getFailedCount() {
                return failed;
            }

            public long getInProgressCount() {
                return inProgress;
            }

            public long getLongRunningFor1hCount() {
                return longRunning1h.longValue();
            }

            public long getLongRunningFor24hCount() {
                return longRunning24h.longValue();
            }

            public long getLongRunningFor8hCount() {
                return longRunning8h.longValue();
            }
        };
    }

    @PostConstruct
    public void init() {
        this.completionTopic.subscribe(message -> {
            if (!message.getSource().isLocal()) {
                CompletionMessage completion = (CompletionMessage)message.getMessage();
                if (completion.getException() == null) {
                    this.handleCompleteMigration(completion.getMigrationId());
                } else {
                    this.handleCompleteMigrationExceptionally(completion.getMigrationId(), completion.getException());
                }
            }
        });
    }

    @Nonnull
    @PreAuthorize(value="hasGlobalPermission('SYS_ADMIN')")
    @Transactional(propagation=Propagation.REQUIRED)
    public MeshPartitionMigration migrate(@Nonnull MeshPartitionMigrationRequest request) {
        Objects.requireNonNull(request, "request");
        final InternalMeshPartitionMigration migration = Objects.requireNonNull((InternalMeshPartitionMigration)this.partitionReplicaService.runBatch(batchOperation -> this.internalCreateMigration(request, (MeshPartitionReplicaService.BatchOperation)batchOperation)), "result");
        this.transactionSynchronizer.register(new TransactionSynchronization(){

            public void afterCommit() {
                new MigrationTask(migration).execute();
            }
        });
        return migration;
    }

    @EventListener
    public void onMeshNodeAvailabilityUpdated(MeshNodeAvailabilityChangedEvent event) {
        if (event.isAvailable()) {
            return;
        }
        PageUtils.toStream(pageRequest -> Objects.requireNonNull((Page)this.readOnlyTransaction.execute(status -> this.migrationDao.search(new MeshPartitionMigrationSearchRequest.Builder().targetNodeId(event.getNodeId()).states(new MeshPartitionMigrationJobState[]{MeshPartitionMigrationJobState.SYNCHRONIZING}).build(), pageRequest))), (int)1000).forEach(migration -> new MigrationTask((InternalMeshPartitionMigration)migration).execute());
    }

    @EventListener
    public void onReplicaObserved(MeshRepositoryReplicaObservedEvent event) {
        MeshRepositoryReplicaObservation observation = event.getObservation();
        String repositoryId = observation.getRepositoryId();
        RemoteRepositoryId remoteId = RemoteRepositoryId.parse((String)repositoryId);
        if (remoteId == null) {
            log.debug("{}: Received observation for unexpected repository", (Object)repositoryId);
            return;
        }
        Set nodeIds = observation.getNodeIds();
        if (observation.getState() != ReplicaState.CONSISTENT) {
            return;
        }
        int partition = remoteId.getPartition();
        PageUtils.toStream(request -> Objects.requireNonNull((Page)this.readOnlyTransaction.execute(status -> this.migrationDao.search(new MeshPartitionMigrationSearchRequest.Builder().partition(Integer.valueOf(partition)).states(new MeshPartitionMigrationJobState[]{MeshPartitionMigrationJobState.INITIALIZING, MeshPartitionMigrationJobState.SYNCHRONIZING}).targetNodeIds((Iterable)nodeIds).build(), request))), (int)1000).forEach(migration -> new MigrationTask((InternalMeshPartitionMigration)migration).execute());
    }

    @EventListener
    public void onRepositoryDeleted(RepositoryDeletedEvent event) {
        int partition = InternalConverter.convertToInternalRepository((Repository)event.getRepository()).getPartition();
        PageUtils.toStream(request -> Objects.requireNonNull((Page)this.readOnlyTransaction.execute(status -> this.migrationDao.search(new MeshPartitionMigrationSearchRequest.Builder().partition(Integer.valueOf(partition)).states(new MeshPartitionMigrationJobState[]{MeshPartitionMigrationJobState.INITIALIZING, MeshPartitionMigrationJobState.SYNCHRONIZING}).build(), request))), (int)1000).forEach(migration -> new MigrationTask((InternalMeshPartitionMigration)migration).execute());
    }

    @DefaultApplicationMode
    public void schedule(@Nonnull SchedulerService schedulerService) throws SchedulerServiceException {
        schedulerService.registerJobRunner(JOB_RUNNER_KEY, this::clusterMaintenanceJob);
        JobConfig jobConfig = JobConfig.forJobRunnerKey((JobRunnerKey)JOB_RUNNER_KEY).withRunMode(RunMode.RUN_ONCE_PER_CLUSTER).withSchedule(Schedule.forInterval((long)EVERY_HOUR, (Date)new Date(System.currentTimeMillis() + 60000L)));
        schedulerService.scheduleJob(JOB_ID, jobConfig);
    }

    @Nonnull
    @PreAuthorize(value="hasGlobalPermission('SYS_ADMIN')")
    @Transactional(propagation=Propagation.REQUIRED)
    public Page<MeshPartitionMigration> search(@Nonnull MeshPartitionMigrationSearchRequest request, @Nonnull PageRequest pageRequest) {
        return this.migrationDao.search(request, pageRequest).transform(MeshPartitionMigration.class::cast);
    }

    public void unschedule(@Nonnull SchedulerService schedulerService) throws SchedulerServiceException {
        schedulerService.unscheduleJob(JOB_ID);
        schedulerService.unregisterJobRunner(JOB_RUNNER_KEY);
    }

    private void clusterMaintenanceFinishFutures() {
        this.readOnlyTransaction.executeWithoutResult(tx -> Iterables.partition(this.migrationFinishFutures.keySet(), (int)1000).forEach(batch -> this.migrationDao.getByIds((Collection)batch).forEach(migration -> {
            MeshPartitionMigrationJobState state = migration.getState();
            if (state == MeshPartitionMigrationJobState.FINISHED) {
                this.handleCompleteMigration(migration.getId());
            } else if (state == MeshPartitionMigrationJobState.CANCELLED) {
                this.handleCompleteMigrationExceptionally(migration.getId(), (ServiceException)new MeshPartitionMigrationCancelledException(this.i18nService.createKeyedMessage("bitbucket.service.mesh.partition.migration.job.cancelled", new Object[]{migration.getId()})));
            } else if (state.isTerminal()) {
                this.handleCompleteMigrationExceptionally(migration.getId(), (ServiceException)new MeshPartitionMigrationFailedException(this.i18nService.createKeyedMessage("bitbucket.service.mesh.partition.migration.job.failed", new Object[]{migration.getId()})));
            }
        })));
    }

    private JobRunnerResponse clusterMaintenanceJob(JobRunnerRequest jobRunnerRequest) {
        Exception exception = null;
        try {
            this.clusterMaintenanceFinishFutures();
        }
        catch (Exception e) {
            exception = e;
        }
        try (LockGuard guard = LockGuard.tryLock((Lock)this.lockService.getLock(JOB_NAME));){
            if (guard != null) {
                this.readOnlyTransaction.executeWithoutResult(tx -> this.resumeMigrations());
            }
        }
        catch (Exception e) {
            if (exception != null) {
                exception.addSuppressed(e);
            }
            exception = e;
        }
        if (exception != null) {
            return JobRunnerResponse.failed((Throwable)exception);
        }
        return JobRunnerResponse.success();
    }

    private void completeMigration(long migrationId) {
        this.handleCompleteMigration(migrationId);
        this.completionTopic.publish((Serializable)new CompletionMessage(migrationId));
    }

    private void completeMigrationExceptionally(long migrationId, @Nonnull ServiceException exception) {
        this.handleCompleteMigrationExceptionally(migrationId, exception);
        this.completionTopic.publish((Serializable)new CompletionMessage(migrationId, exception));
    }

    private void handleCompleteMigration(long migrationId) {
        this.migrationFinishFutures.computeIfPresent(migrationId, (ignored, futures) -> {
            futures.forEach(future -> future.complete(null));
            return null;
        });
    }

    private void handleCompleteMigrationExceptionally(long migrationId, @Nonnull ServiceException exception) {
        this.migrationFinishFutures.computeIfPresent(migrationId, (ignored, futures) -> {
            futures.forEach(future -> future.completeExceptionally(exception));
            return null;
        });
    }

    private InternalMeshPartitionMigration internalCreateMigration(@Nonnull MeshPartitionMigrationRequest request, @Nonnull MeshPartitionReplicaService.BatchOperation batchOperation) {
        Page migrationPage = this.migrationDao.search(new MeshPartitionMigrationSearchRequest.Builder().partition(Integer.valueOf(request.getPartitionId())).targetNodeId(request.getTargetNode().getId()).sourceNodeId(request.getSourceNode().getId()).states((Iterable)MeshPartitionMigrationJobState.NON_TERMINAL_STATES).build(), PageUtils.newRequest((int)0, (int)1));
        if (migrationPage.getSize() > 0) {
            return (InternalMeshPartitionMigration)Iterables.getOnlyElement((Iterable)migrationPage.getValues());
        }
        Page conflictingMigrations = this.migrationDao.search(new MeshPartitionMigrationSearchRequest.Builder().partition(Integer.valueOf(request.getPartitionId())).sourceNodeId(request.getSourceNode().getId()).states((Iterable)MeshPartitionMigrationJobState.NON_TERMINAL_STATES).build(), PageUtils.newRequest((int)0, (int)1));
        if (conflictingMigrations.getSize() > 0) {
            throw this.newMeshPartitionMigrationSourceConflict(request, (MeshPartitionMigration)Iterables.get((Iterable)conflictingMigrations.getValues(), (int)0));
        }
        MeshPartitionReplica targetReplica = this.partitionReplicaService.findByNodeAndPartition(request.getTargetNode(), request.getPartitionId());
        if (targetReplica != null) {
            throw this.newTargetNodeReplicaAlreadyExistsException(request);
        }
        InternalMeshPartitionMigration migration = Objects.requireNonNull((InternalMeshPartitionMigration)this.readWriteTransaction.execute(tx -> {
            InternalMeshPartitionMigration newMigration = this.migrationDao.create(request);
            batchOperation.assignPartitionReplica((MeshNode)newMigration.getTargetNode(), newMigration.getPartition());
            return newMigration;
        }));
        log.info("Migration #{}: Created migration moving partition {} from {} to {}", new Object[]{migration.getId(), migration.getPartition(), migration.getSourceNode().getId(), migration.getTargetNode().getId()});
        return migration;
    }

    private MeshPartitionMigrationSourceConflict newMeshPartitionMigrationSourceConflict(MeshPartitionMigrationRequest request, MeshPartitionMigration conflict) {
        return new MeshPartitionMigrationSourceConflict(this.i18nService.createKeyedMessage("bitbucket.service.mesh.partition.migration.conflict.source", new Object[]{request.getPartitionId(), request.getSourceNode().getId(), request.getTargetNode().getId(), conflict.getSourceNode().getId(), conflict.getTargetNode().getId()}));
    }

    private MeshPartitionReplicaAlreadyExistsException newTargetNodeReplicaAlreadyExistsException(MeshPartitionMigrationRequest request) {
        return new MeshPartitionReplicaAlreadyExistsException(this.i18nService.createKeyedMessage("bitbucket.service.mesh.partition.migration.already.exists", new Object[]{request.getTargetNode().getName(), request.getPartitionId()}));
    }

    private void resumeMigrations() {
        long[] migrationIds;
        for (long id : migrationIds = PageUtils.toStream(request -> this.migrationDao.search(new MeshPartitionMigrationSearchRequest.Builder().states((Iterable)MeshPartitionMigrationJobState.NON_TERMINAL_STATES).build(), request), (int)1000).mapToLong(InternalMeshPartitionMigration::getId).toArray()) {
            new MigrationTask((InternalMeshPartitionMigration)this.migrationDao.getById((Object)id)).execute();
        }
    }

    private InternalMeshPartitionMigration updateJobState(long migrationId, @Nullable MeshPartitionMigrationJobState expected, MeshPartitionMigrationJobState targetState) {
        Supplier<InternalMeshPartitionMigration> attempt = () -> {
            InternalMeshPartitionMigration current = (InternalMeshPartitionMigration)this.readOnlyTransaction.execute(tx -> (InternalMeshPartitionMigration)this.migrationDao.getById((Object)migrationId));
            if (current == null) {
                throw new NoSuchEntityException(this.i18nService.createKeyedMessage("bitbucket.service.mesh.partition.migration.not.exist", new Object[]{migrationId}));
            }
            MeshPartitionMigrationJobState currentState = current.getState();
            if (expected != null && currentState != expected) {
                throw new UnexpectedMigrationStateException("While transitioning to state " + String.valueOf(targetState) + ", expected job state " + String.valueOf(expected) + " but was " + String.valueOf(currentState) + ". Aborting.");
            }
            if (targetState == MeshPartitionMigrationJobState.CANCELLING && !currentState.isCancellable()) {
                throw new MeshPartitionMigrationNotCancellableException(this.i18nService.createKeyedMessage("bitbucket.service.mesh.partition.migration.not.cancellable", new Object[]{migrationId, currentState}));
            }
            InternalMeshPartitionMigration result = Objects.requireNonNull((InternalMeshPartitionMigration)this.readWriteTransaction.execute(tx -> (InternalMeshPartitionMigration)this.migrationDao.update((Object)new InternalMeshPartitionMigration.Builder(current).state(targetState).build())));
            log.debug("Migration #{}: Switched state {} => {}", new Object[]{migrationId, currentState, result.getState()});
            return result;
        };
        return (InternalMeshPartitionMigration)RetryFactory.create(attempt, (int)3, e -> {
            if (e instanceof EntityOutOfDateException || e instanceof OptimisticLockException || e instanceof StaleStateException || e instanceof OptimisticLockingFailureException) {
                log.debug("Migration: #{}: Failed to update job state {} => {} due to optimistic lock failure. Retrying", new Object[]{migrationId, expected, targetState, e});
                return;
            }
            throw e;
        }).get();
    }

    public static class CompletionMessage
    implements Serializable {
        final Class<? extends ServiceException> exceptionClass;
        final String localizedMessage;
        final String messageKey;
        final long migrationId;
        final String rootMessage;

        CompletionMessage(long migrationId) {
            this.migrationId = migrationId;
            this.localizedMessage = null;
            this.rootMessage = null;
            this.messageKey = null;
            this.exceptionClass = null;
        }

        CompletionMessage(long migrationId, @Nonnull ServiceException exception) {
            this.exceptionClass = ((Object)((Object)exception)).getClass();
            this.messageKey = exception.getKeyedMessage().getKey();
            this.localizedMessage = exception.getKeyedMessage().getLocalisedMessage();
            this.rootMessage = exception.getKeyedMessage().getRootMessage();
            this.migrationId = migrationId;
        }

        public boolean equals(Object o) {
            if (this == o) {
                return true;
            }
            if (o == null || this.getClass() != o.getClass()) {
                return false;
            }
            CompletionMessage that = (CompletionMessage)o;
            return this.migrationId == that.migrationId && Objects.equals(this.exceptionClass, that.exceptionClass) && Objects.equals(this.localizedMessage, that.localizedMessage) && Objects.equals(this.messageKey, that.messageKey) && Objects.equals(this.rootMessage, that.rootMessage);
        }

        @Nullable
        public ServiceException getException() {
            if (this.messageKey != null && this.localizedMessage != null && this.rootMessage != null && this.exceptionClass != null) {
                try {
                    Constructor constructor = ReflectionUtils.accessibleConstructor(this.exceptionClass, (Class[])new Class[]{KeyedMessage.class});
                    return (ServiceException)((Object)constructor.newInstance(new KeyedMessage(this.messageKey, this.localizedMessage, this.rootMessage)));
                }
                catch (IllegalAccessException | InstantiationException | NoSuchMethodException e) {
                    throw new RuntimeException("Couldn't initialize exception from topic message", e);
                }
                catch (InvocationTargetException e) {
                    throw new RuntimeException("Couldn't initialize exception from topic message", e.getCause());
                }
            }
            return null;
        }

        public long getMigrationId() {
            return this.migrationId;
        }

        public int hashCode() {
            return Objects.hash(this.exceptionClass, this.localizedMessage, this.messageKey, this.migrationId, this.rootMessage);
        }

        public String toString() {
            MoreObjects.ToStringHelper helper = MoreObjects.toStringHelper((Object)this).add("migrationId", this.migrationId);
            if (this.exceptionClass != null && this.localizedMessage != null && this.messageKey != null && this.rootMessage != null) {
                helper.add("exceptionClass", this.exceptionClass).add("localizedMessage", (Object)this.localizedMessage).add("messageKey", (Object)this.messageKey).add("rootMessage", (Object)this.rootMessage);
            }
            return helper.toString();
        }
    }

    class MigrationTask {
        private final CompletableFuture<Void> future;
        private final AtomicBoolean futureRegistered;
        private final InternalMeshPartitionMigration initialMigration;

        public MigrationTask(InternalMeshPartitionMigration migration) {
            this.initialMigration = migration;
            this.future = new CompletableFuture();
            this.futureRegistered = new AtomicBoolean(false);
        }

        public CompletableFuture<Void> getFuture() {
            if (this.futureRegistered.compareAndSet(false, true)) {
                DefaultMeshPartitionMigrationService.this.migrationFinishFutures.compute(this.initialMigration.getId(), (id, set) -> {
                    if (set == null) {
                        set = new HashSet<CompletableFuture<Void>>();
                    }
                    set.add(this.future);
                    return set;
                });
            }
            return this.future;
        }

        void execute() {
            this.internalExecute(this.initialMigration, true);
        }

        void internalExecute(InternalMeshPartitionMigration givenMigration, boolean reload) {
            InternalMeshPartitionMigration migration;
            if (reload) {
                try {
                    migration = (InternalMeshPartitionMigration)DefaultMeshPartitionMigrationService.this.readWriteTransaction.execute(tx -> {
                        InternalMeshPartitionMigration current = (InternalMeshPartitionMigration)DefaultMeshPartitionMigrationService.this.migrationDao.getById((Object)givenMigration.getId());
                        if (current == null) {
                            return null;
                        }
                        return (InternalMeshPartitionMigration)DefaultMeshPartitionMigrationService.this.migrationDao.updateAndFlush((Object)givenMigration);
                    });
                }
                catch (EntityOutOfDateException | OptimisticLockException | StaleStateException | OptimisticLockingFailureException e2) {
                    log.debug("Migration #{}: Aborting handling of state {} based on outdated data.", (Object)givenMigration.getId(), (Object)givenMigration.getState());
                    return;
                }
                if (migration == null) {
                    log.warn("Migration #{}: Has been deleted while it was running. Aborting.", (Object)givenMigration.getId());
                    return;
                }
                if (migration.getState() != givenMigration.getState()) {
                    log.debug("Migration #{}: Not executing state {} as it is now in {}", new Object[]{migration.getId(), givenMigration.getState(), migration.getState()});
                    return;
                }
            } else {
                migration = givenMigration;
            }
            MeshPartitionMigrationJobState state = migration.getState();
            long migrationId = migration.getId();
            log.debug("Migration #{}: Executing stage: {}", (Object)migrationId, (Object)state);
            CompletionStage result = (CompletionStage)DefaultMeshPartitionMigrationService.this.readWriteTransaction.execute(tx -> this.executeStage(migration, state));
            Objects.requireNonNull(result, "result").whenCompleteAsync((nextState, exception) -> DefaultMeshPartitionMigrationService.this.securityService.withPermission(Permission.SYS_ADMIN, "Call MeshService methods").call(() -> {
                if (exception != null) {
                    log.error("Migration #{}: exception while handling stage {}", new Object[]{migrationId, state, exception});
                    return null;
                }
                if (nextState != null) {
                    try {
                        InternalMeshPartitionMigration updatedMigration = DefaultMeshPartitionMigrationService.this.updateJobState(migrationId, state, (MeshPartitionMigrationJobState)nextState);
                        this.internalExecute(updatedMigration, false);
                    }
                    catch (UnexpectedMigrationStateException e) {
                        log.debug("Migration #{}: {}", (Object)migrationId, (Object)e.getMessage());
                    }
                    catch (ServiceException e) {
                        log.warn("Migration #{}: Exception while executing stage {}: {}", new Object[]{migrationId, nextState, e.getMessage(), log.isDebugEnabled() ? e : null});
                    }
                }
                return null;
            }), DefaultMeshPartitionMigrationService.this.executorService).exceptionally(e -> {
                log.error("Migration #{}: exception while applying the result of stage {}, setting failed state", new Object[]{migrationId, state, e instanceof CompletionException ? e.getCause() : e});
                DefaultMeshPartitionMigrationService.this.updateJobState(migrationId, null, MeshPartitionMigrationJobState.FAILED);
                DefaultMeshPartitionMigrationService.this.completeMigrationExceptionally(migration.getId(), (ServiceException)new MeshPartitionMigrationFailedException(DefaultMeshPartitionMigrationService.this.i18nService.createKeyedMessage("bitbucket.service.mesh.partition.migration.job.failed", new Object[]{migration.getId()}), e));
                return null;
            });
        }

        private CompletionStage<Void> drainPartitionReplica(MeshPartitionMigrationJobState jobState, long migrationId, InternalMeshNode sourceNode, int partition) {
            try {
                return DefaultMeshPartitionMigrationService.this.partitionReplicaService.updatePartitionReplicaState(new UpdatePartitionReplicaStateRequest.Builder((MeshNode)sourceNode, partition, UpdatePartitionReplicaStateRequest.StateUpdate.DISABLED).build());
            }
            catch (NoSuchEntityException e) {
                log.warn("Migration #{}: While executing {}, found that partition {} has no replica on node with ID {}. Finishing draining.", new Object[]{jobState, migrationId, partition, sourceNode});
                return CompletableFuture.completedFuture(null);
            }
        }

        @Nonnull
        private CompletionStage<MeshPartitionMigrationJobState> executeStage(@Nonnull InternalMeshPartitionMigration migration, @Nonnull MeshPartitionMigrationJobState state) {
            switch (state) {
                case INITIALIZING: {
                    return CompletableFuture.completedFuture(MeshPartitionMigrationJobState.SYNCHRONIZING);
                }
                case SYNCHRONIZING: {
                    if (migration.getTargetNode().isOffline()) {
                        return CompletableFuture.completedFuture(MeshPartitionMigrationJobState.DRAINING);
                    }
                    if (DefaultMeshPartitionMigrationService.this.repositoryReplicaDao.isConsistent(migration.getPartition(), migration.getTargetNode().getId())) {
                        return CompletableFuture.completedFuture(MeshPartitionMigrationJobState.DRAINING);
                    }
                    return CompletableFuture.completedFuture(null);
                }
                case DRAINING: {
                    return this.drainPartitionReplica(MeshPartitionMigrationJobState.DRAINING, migration.getId(), migration.getSourceNode(), migration.getPartition()).thenApply(unused -> MeshPartitionMigrationJobState.DELETING);
                }
                case DELETING: {
                    this.unassignPartitionReplica(migration, migration.getSourceNode());
                    return CompletableFuture.completedFuture(MeshPartitionMigrationJobState.FINISHED);
                }
                case CANCELLING: {
                    return DefaultMeshPartitionMigrationService.this.partitionReplicaService.updatePartitionReplicaState(new UpdatePartitionReplicaStateRequest.Builder((MeshNode)migration.getSourceNode(), migration.getPartition(), UpdatePartitionReplicaStateRequest.StateUpdate.AVAILABLE).build()).thenCompose(unused -> this.drainPartitionReplica(MeshPartitionMigrationJobState.CANCELLING, migration.getId(), migration.getTargetNode(), migration.getPartition())).thenAcceptAsync(unused -> this.unassignPartitionReplica(migration, migration.getTargetNode()), DefaultMeshPartitionMigrationService.this.executorService).thenApply(unused -> MeshPartitionMigrationJobState.CANCELLED);
                }
                case FINISHED: {
                    DefaultMeshPartitionMigrationService.this.completeMigration(migration.getId());
                    return CompletableFuture.completedFuture(null);
                }
                case CANCELLED: {
                    DefaultMeshPartitionMigrationService.this.completeMigrationExceptionally(migration.getId(), (ServiceException)new MeshPartitionMigrationCancelledException(DefaultMeshPartitionMigrationService.this.i18nService.createKeyedMessage("bitbucket.service.mesh.partition.migration.job.cancelled", new Object[]{migration.getId()})));
                    return CompletableFuture.completedFuture(null);
                }
                case FAILED: {
                    DefaultMeshPartitionMigrationService.this.completeMigrationExceptionally(migration.getId(), (ServiceException)new MeshPartitionMigrationFailedException(DefaultMeshPartitionMigrationService.this.i18nService.createKeyedMessage("bitbucket.service.mesh.partition.migration.job.failed", new Object[]{migration.getId()})));
                    return CompletableFuture.completedFuture(null);
                }
            }
            throw new IllegalStateException("Can't handle unknown state");
        }

        private void unassignPartitionReplica(InternalMeshPartitionMigration migration, InternalMeshNode node) {
            try {
                DefaultMeshPartitionMigrationService.this.partitionReplicaService.unassignPartitionReplica((MeshNode)node, migration.getPartition());
            }
            catch (NoSuchEntityException e) {
                log.debug("Migration #{}: attempted to delete nonexistent replica {}@{}", new Object[]{migration.getPartition(), node, migration.getId(), e});
            }
        }
    }

    static class UnexpectedMigrationStateException
    extends IllegalStateException {
        public UnexpectedMigrationStateException(String s) {
            super(s);
        }
    }
}

