/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.stash.internal.mesh;

import com.atlassian.bitbucket.dmz.mesh.DmzMeshPartitionRegistry;
import com.atlassian.bitbucket.dmz.mesh.InconsistentRepositoryReplica;
import com.atlassian.bitbucket.dmz.mesh.MeshNodeUnregisteredEvent;
import com.atlassian.bitbucket.dmz.mesh.MeshPartition;
import com.atlassian.bitbucket.dmz.mesh.MeshPartitionReplica;
import com.atlassian.bitbucket.dmz.mesh.MeshRepositoryConsistencySummary;
import com.atlassian.bitbucket.dmz.mesh.MissingRepositoryReplicaDetectedEvent;
import com.atlassian.bitbucket.dmz.mesh.ReplicaState;
import com.atlassian.bitbucket.dmz.mesh.RepositoryReplicaDetails;
import com.atlassian.bitbucket.dmz.repository.DmzRepository;
import com.atlassian.bitbucket.dmz.repository.RemoteRepositoryId;
import com.atlassian.bitbucket.event.cluster.ClusterNodeAddedEvent;
import com.atlassian.bitbucket.event.mesh.MeshNodeRegisteredEvent;
import com.atlassian.bitbucket.event.mesh.MeshNodeUpdatedEvent;
import com.atlassian.bitbucket.mesh.MeshNode;
import com.atlassian.bitbucket.repository.Repository;
import com.atlassian.bitbucket.topic.Topic;
import com.atlassian.bitbucket.topic.TopicService;
import com.atlassian.bitbucket.topic.TopicSettings;
import com.atlassian.event.api.EventListener;
import com.atlassian.plugin.spring.AvailableToPlugins;
import com.atlassian.stash.internal.mesh.InternalMeshPartitionRegistry;
import com.atlassian.stash.internal.mesh.InternalMeshPartitionReplica;
import com.atlassian.stash.internal.mesh.InternalMeshRepositoryReplica;
import com.atlassian.stash.internal.mesh.MeshPartitionReplicaDao;
import com.atlassian.stash.internal.mesh.MeshRepositoryReplicaDao;
import com.atlassian.stash.internal.mesh.MeshRepositoryReplicaObservation;
import com.atlassian.stash.internal.mesh.MeshTopologyUpdatedEvent;
import com.atlassian.stash.internal.mesh.SimpleMeshPartition;
import com.atlassian.stash.internal.repository.InternalRepository;
import com.atlassian.stash.internal.repository.RepositoryDao;
import com.atlassian.stash.internal.spring.SpringTransactionUtils;
import com.google.common.collect.ImmutableMap;
import com.google.common.collect.Maps;
import jakarta.annotation.Nonnull;
import jakarta.annotation.PostConstruct;
import java.io.Serializable;
import java.time.Instant;
import java.time.temporal.ChronoUnit;
import java.util.Collection;
import java.util.Collections;
import java.util.Date;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.Set;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.ConcurrentMap;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.beans.factory.annotation.Value;
import org.springframework.dao.DataIntegrityViolationException;
import org.springframework.dao.OptimisticLockingFailureException;
import org.springframework.stereotype.Component;
import org.springframework.transaction.PlatformTransactionManager;
import org.springframework.transaction.TransactionStatus;
import org.springframework.transaction.support.TransactionCallback;
import org.springframework.transaction.support.TransactionTemplate;

@AvailableToPlugins(interfaces={DmzMeshPartitionRegistry.class})
@Component(value="meshPartitionRegistry")
public class DefaultMeshPartitionRegistry
implements InternalMeshPartitionRegistry {
    static final String INCONSISTENT_REPLICA_TOPIC = "atl.bbs.mesh.inconsistent-replicas";
    static final int MAX_REPORT_OBSERVATION_ATTEMPTS = 10;
    static final String REFRESH_MESSAGE = "";
    static final String REFRESH_TOPIC = "atl.bbs.mesh.partition-registry-refresh";
    private static final Logger log = LoggerFactory.getLogger(DefaultMeshPartitionRegistry.class);
    private final Topic<long[]> inconsistentReplicaTopic;
    private final Object inconsistentReplicasLock;
    private final boolean meshEnabled;
    private final MeshPartitionReplicaDao partitionReplicaDao;
    private final TransactionTemplate readOnlyTx;
    private final Topic<String> refreshTopic;
    private final RepositoryDao repositoryDao;
    private final MeshRepositoryReplicaDao repositoryReplicaDao;
    private final TransactionTemplate requiresNewTx;
    private volatile ConcurrentMap<Long, Set<Integer>> inconsistentByNode;
    private volatile Map<Integer, MeshPartition> partitionsById;

    @Autowired
    public DefaultMeshPartitionRegistry(@Value(value="${mesh.enabled}") boolean meshEnabled, MeshPartitionReplicaDao partitionReplicaDao, RepositoryDao repositoryDao, MeshRepositoryReplicaDao repositoryReplicaDao, TopicService topicService, PlatformTransactionManager transactionManager, @Value(value="${mesh.inconsistent-replica.topic-queue-size:5000}") int inconsistentReplicaTopicQueueSize) {
        this.meshEnabled = meshEnabled;
        this.partitionReplicaDao = partitionReplicaDao;
        this.repositoryDao = repositoryDao;
        this.repositoryReplicaDao = repositoryReplicaDao;
        this.inconsistentByNode = new ConcurrentHashMap<Long, Set<Integer>>();
        this.inconsistentReplicasLock = new Object();
        this.partitionsById = Collections.emptyMap();
        this.readOnlyTx = new TransactionTemplate(transactionManager, SpringTransactionUtils.definitionFor((int)0, (boolean)true));
        this.requiresNewTx = new TransactionTemplate(transactionManager, SpringTransactionUtils.REQUIRES_NEW);
        this.inconsistentReplicaTopic = topicService.getTopic(INCONSISTENT_REPLICA_TOPIC, TopicSettings.builder(long[].class).queueSize(inconsistentReplicaTopicQueueSize).dedupePendingMessages(false).build());
        this.refreshTopic = topicService.getTopic(REFRESH_TOPIC, TopicSettings.builder(String.class).queueSize(5).dedupePendingMessages(true).build());
    }

    @Nonnull
    public Map<Integer, Long> countRepositoriesPerPartition() {
        return (Map)this.readOnlyTx.execute(tx -> this.repositoryDao.countAllByPartition());
    }

    @Nonnull
    public Collection<MeshPartition> getAllPartitions() {
        return this.partitionsById.values();
    }

    @Nonnull
    public Collection<InconsistentRepositoryReplica> getInconsistentRepositoryReplicas(@Nonnull MeshNode node) {
        Objects.requireNonNull(node, "node");
        return (Collection)this.readOnlyTx.execute(tx -> this.repositoryReplicaDao.getInconsistentByNode(node.getId()));
    }

    @Nonnull
    public Optional<MeshPartition> getPartition(int partition) {
        return Optional.ofNullable(this.partitionsById.get(partition));
    }

    @Nonnull
    public RepositoryReplicaDetails getReplicaDetails(@Nonnull MeshNode node, @Nonnull Repository repository) {
        Objects.requireNonNull(node, "node");
        Objects.requireNonNull(repository, "repository");
        InternalMeshRepositoryReplica replica = (InternalMeshRepositoryReplica)this.readOnlyTx.execute(tx -> this.repositoryReplicaDao.findByNodePartitionAndRepository(node.getId(), repository.getPartition(), repository.getId()));
        if (replica == null) {
            return new RepositoryReplicaDetails.Builder(ReplicaState.CONSISTENT).build();
        }
        return new RepositoryReplicaDetails.Builder(replica.getState()).observedVersion(replica.getReportedVersion()).build();
    }

    @PostConstruct
    public void init() {
        this.refresh();
        this.inconsistentReplicaTopic.subscribe(message -> this.reloadInconsistentReplicas((long[])message.getMessage()));
        this.refreshTopic.subscribe(message -> {
            if (!message.getSource().isLocal()) {
                this.refresh();
            }
        });
    }

    public boolean hasNonEmptyPartition(@Nonnull MeshNode node) {
        Objects.requireNonNull(node, "node");
        return this.partitionReplicaDao.existsWithRepositoriesByNode(node.getId());
    }

    public void initializePartitionReplica(@Nonnull InternalMeshPartitionReplica partitionReplica) {
        this.repositoryReplicaDao.markAllMissingForPartitionReplica(partitionReplica);
    }

    public boolean isConsistent(@Nonnull MeshNode node, int repositoryId) {
        Objects.requireNonNull(node, "node");
        Set inconsistentIds = (Set)this.inconsistentByNode.get(node.getId());
        return inconsistentIds == null || !inconsistentIds.contains(repositoryId);
    }

    @EventListener
    public void onClusterNodeAdded(@Nonnull ClusterNodeAddedEvent event) {
        if (event.isMaybeNetworkPartitionResolved()) {
            this.reloadInconsistentReplicas(null);
        }
    }

    @EventListener
    public void onMeshNodeRegistered(@Nonnull MeshNodeRegisteredEvent ignored) {
        this.triggerRefresh();
    }

    @EventListener
    public void onMeshNodeUnregistered(@Nonnull MeshNodeUnregisteredEvent ignored) {
        this.triggerRefresh();
    }

    @EventListener
    public void onMeshNodeUpdated(@Nonnull MeshNodeUpdatedEvent ignored) {
        this.triggerRefresh();
    }

    @EventListener
    public void onMeshTopologyUpdatedEvent(@Nonnull MeshTopologyUpdatedEvent ignored) {
        this.triggerRefresh();
    }

    @EventListener
    public void onMissingRepositoryReplicaDetected(@Nonnull MissingRepositoryReplicaDetectedEvent event) {
        MeshNode node = event.getNode();
        log.info("Marking {} as missing on {}", (Object)event.getRepository(), (Object)node);
        this.reportObservation(new MeshRepositoryReplicaObservation.Builder(RemoteRepositoryId.format((DmzRepository)event.getRepository())).force(true).nodeId(node.getId()).state(ReplicaState.MISSING).version(1L).build());
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void refresh() {
        if (this.meshEnabled) {
            this.partitionsById = (Map)this.readOnlyTx.execute(tx -> DefaultMeshPartitionRegistry.buildPartitionMap(this.partitionReplicaDao.getAll()));
            log.debug("Loaded {} Mesh partitions from database", (Object)this.partitionsById.size());
            Object object = this.inconsistentReplicasLock;
            synchronized (object) {
                this.inconsistentByNode = new ConcurrentHashMap<Long, Set<Integer>>((Map)this.readOnlyTx.execute(tx -> this.repositoryReplicaDao.getInconsistencyMap()));
                log.debug("Loaded inconsistency map. Nodes with inconsistent repositories: {}", this.inconsistentByNode.keySet());
            }
        }
    }

    public void reportObservation(@Nonnull MeshRepositoryReplicaObservation observation) {
        String repositoryId = observation.getRepositoryId();
        RemoteRepositoryId remoteId = RemoteRepositoryId.parse((String)repositoryId);
        if (remoteId == null) {
            log.debug("{}: Received observation for unexpected repository", (Object)repositoryId);
            return;
        }
        log.debug("{}: Received observation: {}/{}", new Object[]{repositoryId, observation.getState(), observation.getNodeIds()});
        HashSet<Long> updatedNodeIds = new HashSet<Long>();
        Iterator iterator = observation.getNodeIds().iterator();
        while (iterator.hasNext()) {
            long nodeId = (Long)iterator.next();
            if (Boolean.TRUE != this.processReplicaObservation(remoteId, new RepositoryReplicaObservationCallback(nodeId, remoteId, observation))) continue;
            updatedNodeIds.add(nodeId);
        }
        if (!updatedNodeIds.isEmpty()) {
            this.inconsistentReplicaTopic.publish((Serializable)DefaultMeshPartitionRegistry.toLongArray(updatedNodeIds));
        }
    }

    public void reportRepositoryConsistencySummary(@Nonnull MeshRepositoryConsistencySummary summary) {
        long nodeId;
        Iterator iterator;
        String repositoryId = summary.getRepositoryId();
        RemoteRepositoryId remoteId = RemoteRepositoryId.parse((String)repositoryId);
        if (remoteId == null) {
            log.debug("{}: Received observation for unexpected repository", (Object)repositoryId);
            return;
        }
        int consistentCount = summary.getConsistentReplicas().size();
        int unavailableCount = summary.getUnavailableReplicas().size();
        int inconsistentCount = summary.getInconsistentReplicas().size();
        int quorumSize = (consistentCount + unavailableCount + inconsistentCount) / 2 + 1;
        Instant staleTimestamp = summary.getStartTimestamp();
        if (unavailableCount > 0 || inconsistentCount > 0) {
            log.info("[{}] Not all replicas are consistent: consistent = {}, inconsistent = {}, unavailable = {}", new Object[]{repositoryId, summary.getConsistentReplicas(), summary.getInconsistentReplicas(), summary.getUnavailableReplicas()});
        } else {
            log.debug("[{}] All replicas are consistent", (Object)repositoryId);
        }
        HashSet<Long> updatedNodeIds = new HashSet<Long>();
        if (unavailableCount < quorumSize) {
            iterator = summary.getConsistentReplicas().iterator();
            while (iterator.hasNext()) {
                nodeId = (Long)iterator.next();
                if (Boolean.TRUE != this.processReplicaObservation(remoteId, new RepositoryReplicaObservationCallback(nodeId, remoteId, false, false, ReplicaState.CONSISTENT, summary.getVersion(), staleTimestamp))) continue;
                updatedNodeIds.add(nodeId);
            }
            iterator = summary.getUnavailableReplicas().iterator();
            while (iterator.hasNext()) {
                nodeId = (Long)iterator.next();
                if (Boolean.TRUE != this.processReplicaObservation(remoteId, new RepositoryReplicaObservationCallback(nodeId, remoteId, false, false, ReplicaState.INCONSISTENT, summary.getVersion(), staleTimestamp))) continue;
                updatedNodeIds.add(nodeId);
            }
        } else {
            log.warn("[{}] Too many replicas are offline to reliably determine Mesh replica consistency. Start the offline replicas ({}) and check consistency again.", (Object)repositoryId, (Object)summary.getInconsistentReplicas());
        }
        iterator = summary.getInconsistentReplicas().iterator();
        while (iterator.hasNext()) {
            nodeId = (Long)iterator.next();
            if (Boolean.TRUE != this.processReplicaObservation(remoteId, new RepositoryReplicaObservationCallback(nodeId, remoteId, false, false, ReplicaState.INCONSISTENT, summary.getVersion(), staleTimestamp))) continue;
            updatedNodeIds.add(nodeId);
        }
        if (!updatedNodeIds.isEmpty()) {
            this.inconsistentReplicaTopic.publish((Serializable)DefaultMeshPartitionRegistry.toLongArray(updatedNodeIds));
        }
    }

    public void resetHierarchy(int partitionId, @Nonnull String hierarchyId) {
        Objects.requireNonNull(hierarchyId, "hierarchyId");
        MeshPartition partition = this.getPartition(partitionId).orElse(null);
        if (partition == null) {
            log.debug("Cannot reset {}/{}; the partition does not exist", (Object)partitionId, (Object)hierarchyId);
            return;
        }
        this.requiresNewTx.executeWithoutResult(tx -> {
            int updated = this.repositoryReplicaDao.deleteByPartitionAndHierarchy(partitionId, hierarchyId);
            if (updated > 0) {
                log.debug("Reset hierarchy {}/{} ({} replica state rows deleted)", new Object[]{partitionId, hierarchyId, updated});
                this.inconsistentReplicaTopic.publish((Serializable)partition.getReplicas().stream().map(MeshPartitionReplica::getNode).mapToLong(MeshNode::getId).toArray());
            }
        });
    }

    public void resetRepository(@Nonnull Repository repository) {
        int partitionId = Objects.requireNonNull(repository, "repository").getPartition();
        MeshPartition partition = this.getPartition(partitionId).orElse(null);
        if (partition == null) {
            log.debug("Cannot reset {}; partition {} does not exist", (Object)repository, (Object)partitionId);
            return;
        }
        this.requiresNewTx.executeWithoutResult(tx -> {
            int updated = this.repositoryReplicaDao.deleteByRepository(repository.getId());
            if (updated > 0) {
                log.debug("Reset repository {} ({} replica state rows deleted)", (Object)repository, (Object)updated);
                this.inconsistentReplicaTopic.publish((Serializable)partition.getReplicas().stream().map(MeshPartitionReplica::getNode).mapToLong(MeshNode::getId).toArray());
            }
        });
    }

    public int size() {
        return this.partitionsById.size();
    }

    private static Map<Integer, MeshPartition> buildPartitionMap(List<InternalMeshPartitionReplica> partitionReplicas) {
        HashMap<Integer, SimpleMeshPartition.Builder> builders = new HashMap<Integer, SimpleMeshPartition.Builder>();
        for (MeshPartitionReplica meshPartitionReplica : partitionReplicas) {
            builders.computeIfAbsent(meshPartitionReplica.getPartition(), SimpleMeshPartition.Builder::new).replicas(meshPartitionReplica, new MeshPartitionReplica[0]);
        }
        return ImmutableMap.copyOf((Map)Maps.transformEntries(builders, (partition, builder) -> builder.build()));
    }

    private static long[] toLongArray(Collection<Long> values) {
        long[] result = new long[values.size()];
        int index = 0;
        for (Long value : values) {
            result[index++] = value;
        }
        return result;
    }

    private Boolean processReplicaObservation(RemoteRepositoryId remoteId, TransactionCallback<Boolean> callback) {
        for (int i = 1; i <= 10; ++i) {
            try {
                return (Boolean)this.requiresNewTx.execute(callback);
            }
            catch (DataIntegrityViolationException e) {
                if (i == 10) {
                    log.warn("{}: Failed to insert repository replica observation (Attempt {}/{})", new Object[]{remoteId.getLocalId(), i, 10, log.isDebugEnabled() ? e : null});
                } else {
                    log.debug("{}: Failed to insert repository replica observation (Attempt {}/{})", new Object[]{remoteId.getLocalId(), i, 10, e});
                }
            }
            catch (OptimisticLockingFailureException e) {
                if (i == 10) {
                    log.warn("{}: Failed to update repository replica observation (Attempt {}/{})", new Object[]{remoteId.getLocalId(), i, 10, log.isDebugEnabled() ? e : null});
                }
                log.debug("{}: Failed to update repository replica observation (Attempt {}/{})", new Object[]{remoteId.getLocalId(), i, 10, e});
            }
            if (i != 10) continue;
            log.warn("{}: Discarding repository replica observation after {} attempts", (Object)remoteId.getLocalId(), (Object)10);
        }
        return Boolean.FALSE;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void reloadInconsistentReplicas(long[] nodeIds) {
        Object object = this.inconsistentReplicasLock;
        synchronized (object) {
            this.readOnlyTx.executeWithoutResult(tx -> {
                if (nodeIds == null || nodeIds.length == 0) {
                    this.inconsistentByNode = new ConcurrentHashMap<Long, Set<Integer>>(this.repositoryReplicaDao.getInconsistencyMap());
                    log.debug("Refreshed inconsistency map. Nodes with inconsistent repositories: {}", this.inconsistentByNode.keySet());
                } else {
                    for (long nodeId : nodeIds) {
                        Set repositoryIds = this.repositoryReplicaDao.getInconsistencySetByNode(nodeId);
                        log.debug("Refreshed inconsistency set for node {} (size = {}).", (Object)nodeId, (Object)repositoryIds.size());
                        if (repositoryIds.isEmpty()) {
                            this.inconsistentByNode.remove(nodeId);
                            continue;
                        }
                        this.inconsistentByNode.put(nodeId, repositoryIds);
                    }
                }
            });
        }
    }

    private void triggerRefresh() {
        this.refresh();
        this.refreshTopic.publish((Serializable)((Object)REFRESH_MESSAGE));
    }

    private class RepositoryReplicaObservationCallback
    implements TransactionCallback<Boolean> {
        private final boolean createIfConsistent;
        private final boolean force;
        private final long nodeId;
        private final int partition;
        private final int repositoryId;
        private final Instant staleTimestamp;
        private final ReplicaState state;
        private final long version;

        RepositoryReplicaObservationCallback(long nodeId, RemoteRepositoryId id, MeshRepositoryReplicaObservation o) {
            this(nodeId, id, true, o.isForce(), o.getState(), o.getVersion(), null);
        }

        RepositoryReplicaObservationCallback(long nodeId, RemoteRepositoryId id, boolean createIfConsistent, boolean force, ReplicaState state, long version, Instant staleTimestamp) {
            this.createIfConsistent = createIfConsistent;
            this.force = force;
            this.nodeId = nodeId;
            this.staleTimestamp = staleTimestamp == null ? Instant.now().minus(1L, ChronoUnit.DAYS) : staleTimestamp;
            this.state = state;
            this.version = version;
            this.partition = id.getPartition();
            this.repositoryId = id.getLocalId();
        }

        public Boolean doInTransaction(@Nonnull TransactionStatus status) {
            ReplicaState currentState;
            InternalMeshRepositoryReplica.Builder builder;
            InternalMeshRepositoryReplica current = DefaultMeshPartitionRegistry.this.repositoryReplicaDao.findByNodePartitionAndRepository(this.nodeId, this.partition, this.repositoryId);
            if (current == null) {
                if (this.state == ReplicaState.CONSISTENT && !this.createIfConsistent) {
                    log.debug("{}: Discarding CONSISTENT observation for already consistent replica", (Object)this.repositoryId);
                    return false;
                }
                InternalMeshPartitionReplica partitionReplica = DefaultMeshPartitionRegistry.this.partitionReplicaDao.findByNodeAndPartition(this.nodeId, this.partition);
                if (partitionReplica == null) {
                    log.warn("{}: Discarding observation for nonexistent partition replica {}/{}", new Object[]{this.repositoryId, this.partition, this.nodeId});
                    return false;
                }
                InternalRepository repository = (InternalRepository)DefaultMeshPartitionRegistry.this.repositoryDao.getById((Object)this.repositoryId);
                if (repository == null) {
                    log.warn("{}: Discarding observation for nonexistent repository", (Object)this.repositoryId);
                    return false;
                }
                builder = new InternalMeshRepositoryReplica.Builder(partitionReplica, repository);
                currentState = ReplicaState.CONSISTENT;
            } else if (this.shouldUpdate(current)) {
                builder = new InternalMeshRepositoryReplica.Builder(current);
                currentState = current.getState();
            } else {
                log.debug("{}: Discarding out-of-order repository replica observation ({}@{} vs {}@{})", new Object[]{this.repositoryId, this.state, this.version, current.getState(), current.getReportedVersion()});
                return false;
            }
            DefaultMeshPartitionRegistry.this.repositoryReplicaDao.update((Object)builder.reportedAt(new Date()).reportedVersion(this.version).state(this.state).build());
            return currentState.isConsistent() != this.state.isConsistent();
        }

        private boolean shouldUpdate(InternalMeshRepositoryReplica existing) {
            return this.force || existing.getReportedAt().toInstant().isBefore(this.staleTimestamp) || this.version > existing.getReportedVersion() || this.version == existing.getReportedVersion() && this.state.isConsistent() && !existing.getState().isConsistent();
        }
    }
}

