/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.stash.internal.mesh;

import com.atlassian.bitbucket.NoSuchEntityException;
import com.atlassian.bitbucket.concurrent.LockService;
import com.atlassian.bitbucket.dmz.mesh.MeshPartitionReplica;
import com.atlassian.bitbucket.dmz.mesh.UpdatePartitionReplicaStateRequest;
import com.atlassian.bitbucket.i18n.I18nService;
import com.atlassian.bitbucket.internal.mesh.RpcManagementClient;
import com.atlassian.bitbucket.mesh.MeshNode;
import com.atlassian.bitbucket.repository.RepositoryOfflineException;
import com.atlassian.bitbucket.util.PageUtils;
import com.atlassian.bitbucket.util.concurrent.LockGuard;
import com.atlassian.event.api.EventPublisher;
import com.atlassian.scheduler.JobRunnerRequest;
import com.atlassian.scheduler.JobRunnerResponse;
import com.atlassian.scheduler.SchedulerService;
import com.atlassian.scheduler.SchedulerServiceException;
import com.atlassian.scheduler.config.JobConfig;
import com.atlassian.scheduler.config.JobId;
import com.atlassian.scheduler.config.JobRunnerKey;
import com.atlassian.scheduler.config.RunMode;
import com.atlassian.scheduler.config.Schedule;
import com.atlassian.stash.internal.InternalConverter;
import com.atlassian.stash.internal.annotation.Unsecured;
import com.atlassian.stash.internal.mesh.InternalMeshPartitionRegistry;
import com.atlassian.stash.internal.mesh.InternalMeshPartitionReplica;
import com.atlassian.stash.internal.mesh.MeshPartitionReplicaDao;
import com.atlassian.stash.internal.mesh.MeshPartitionReplicaService;
import com.atlassian.stash.internal.mesh.MeshTopologyUpdatedEvent;
import com.atlassian.stash.internal.mode.DefaultApplicationMode;
import com.atlassian.stash.internal.scheduling.ScheduledJobSource;
import com.atlassian.stash.internal.spring.SpringTransactionUtils;
import jakarta.annotation.Nonnull;
import jakarta.annotation.Nullable;
import java.util.Date;
import java.util.Objects;
import java.util.concurrent.CompletableFuture;
import java.util.concurrent.CompletionStage;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.locks.Lock;
import java.util.function.Function;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.beans.factory.annotation.Value;
import org.springframework.context.ApplicationContext;
import org.springframework.context.ApplicationListener;
import org.springframework.context.event.ContextRefreshedEvent;
import org.springframework.security.access.prepost.PreAuthorize;
import org.springframework.stereotype.Service;
import org.springframework.transaction.PlatformTransactionManager;
import org.springframework.transaction.annotation.Propagation;
import org.springframework.transaction.annotation.Transactional;
import org.springframework.transaction.support.TransactionTemplate;

@Service(value="meshPartitionReplicaService")
public class DefaultMeshPartitionReplicaService
implements MeshPartitionReplicaService,
ApplicationListener<ContextRefreshedEvent>,
ScheduledJobSource {
    private static final long EVERY_HOUR = TimeUnit.HOURS.toMillis(1L);
    private static final String JOB_NAME = MeshPartitionReplicaService.class.getSimpleName() + ".clusterMaintenanceJob";
    private static final JobId JOB_ID = JobId.of((String)JOB_NAME);
    private static final JobRunnerKey JOB_RUNNER_KEY = JobRunnerKey.of((String)JOB_NAME);
    private static final int MAX_ATTEMPTS = 3;
    private static final Logger log = LoggerFactory.getLogger(DefaultMeshPartitionReplicaService.class);
    private final EventPublisher eventPublisher;
    private final I18nService i18nService;
    private final LockService lockService;
    private final boolean meshEnabled;
    private final MeshPartitionReplicaDao partitionDao;
    private final InternalMeshPartitionRegistry partitionRegistry;
    private final TransactionTemplate readOnlyTransaction;
    private final TransactionTemplate readWriteTransaction;
    private MeshPartitionReplicaService.BatchOperation batchOperation;
    private RpcManagementClient managementClient;

    @Autowired
    public DefaultMeshPartitionReplicaService(EventPublisher eventPublisher, MeshPartitionReplicaDao partitionDao, @Value(value="${mesh.enabled}") boolean meshEnabled, InternalMeshPartitionRegistry partitionRegistry, I18nService i18nService, LockService lockService, PlatformTransactionManager transactionManager) {
        this.eventPublisher = eventPublisher;
        this.partitionDao = partitionDao;
        this.meshEnabled = meshEnabled;
        this.partitionRegistry = partitionRegistry;
        this.lockService = lockService;
        this.i18nService = i18nService;
        this.readOnlyTransaction = new TransactionTemplate(transactionManager, SpringTransactionUtils.definitionFor((int)0, (boolean)true));
        this.readWriteTransaction = new TransactionTemplate(transactionManager, SpringTransactionUtils.definitionFor((int)0));
        this.batchOperation = new MeshPartitionReplicaService.BatchOperation(){

            @Nonnull
            public MeshPartitionReplica assignPartitionReplica(@Nonnull MeshNode node, int partition) {
                return DefaultMeshPartitionReplicaService.this.internalAssignPartitionReplica(node, partition);
            }

            public void unassignPartitionReplica(@Nonnull MeshNode node, int partition) {
                DefaultMeshPartitionReplicaService.this.internalUnassignPartitionReplica(node, partition);
            }
        };
    }

    @Nonnull
    @PreAuthorize(value="hasGlobalPermission('SYS_ADMIN')")
    @Transactional(propagation=Propagation.REQUIRED)
    public MeshPartitionReplica assignPartitionReplica(@Nonnull MeshNode node, int partition) {
        InternalMeshPartitionReplica result = this.internalAssignPartitionReplica(node, partition);
        this.eventPublisher.publish((Object)new MeshTopologyUpdatedEvent((Object)this));
        return result;
    }

    @PreAuthorize(value="hasGlobalPermission('SYS_ADMIN')")
    @Transactional(readOnly=true, propagation=Propagation.REQUIRED)
    @Nullable
    public MeshPartitionReplica findByNodeAndPartition(@Nonnull MeshNode node, int partition) {
        return this.partitionDao.findByNodeAndPartition(node.getId(), partition);
    }

    @Transactional(propagation=Propagation.SUPPORTS)
    public void onApplicationEvent(@Nonnull ContextRefreshedEvent event) {
        ApplicationContext applicationContext = event.getApplicationContext();
        if (this.meshEnabled) {
            this.managementClient = (RpcManagementClient)applicationContext.getBean(RpcManagementClient.class);
        }
    }

    @PreAuthorize(value="hasGlobalPermission('SYS_ADMIN')")
    public <T> T runBatch(@Nonnull Function<MeshPartitionReplicaService.BatchOperation, T> batchOperations) {
        Objects.requireNonNull(batchOperations, "batchOperations");
        Object result = this.readWriteTransaction.execute(tx -> batchOperations.apply(this.batchOperation));
        this.eventPublisher.publish((Object)new MeshTopologyUpdatedEvent((Object)this));
        return (T)result;
    }

    @DefaultApplicationMode
    public void schedule(@Nonnull SchedulerService schedulerService) throws SchedulerServiceException {
        schedulerService.registerJobRunner(JOB_RUNNER_KEY, this::clusterMaintenanceJob);
        JobConfig jobConfig = JobConfig.forJobRunnerKey((JobRunnerKey)JOB_RUNNER_KEY).withRunMode(RunMode.RUN_ONCE_PER_CLUSTER).withSchedule(Schedule.forInterval((long)EVERY_HOUR, (Date)new Date(System.currentTimeMillis() + 60000L)));
        schedulerService.scheduleJob(JOB_ID, jobConfig);
    }

    @PreAuthorize(value="hasGlobalPermission('SYS_ADMIN')")
    @Transactional(propagation=Propagation.REQUIRED)
    public void unassignPartitionReplica(@Nonnull MeshNode node, int partition) {
        this.internalUnassignPartitionReplica(node, partition);
        this.eventPublisher.publish((Object)new MeshTopologyUpdatedEvent((Object)this));
    }

    public void unschedule(@Nonnull SchedulerService schedulerService) {
        schedulerService.unscheduleJob(JOB_ID);
        schedulerService.unregisterJobRunner(JOB_RUNNER_KEY);
    }

    @Nonnull
    @Transactional(readOnly=true)
    @Unsecured(value="Only called internally")
    public CompletionStage<Void> updatePartitionReplicaState(@Nonnull UpdatePartitionReplicaStateRequest request) {
        Objects.requireNonNull(request, "request");
        InternalMeshPartitionReplica current = this.partitionDao.findByNodeAndPartition(request.getNode().getId(), request.getPartition());
        if (current == null) {
            throw this.newMeshPartitionReplicaNotFoundException(request.getPartition(), request.getNode());
        }
        if (current.getState() == request.getState().getState()) {
            return CompletableFuture.completedFuture(null);
        }
        MeshPartitionReplica.State targetState = request.getState().getState() == MeshPartitionReplica.State.DISABLED ? MeshPartitionReplica.State.DRAINING : MeshPartitionReplica.State.AVAILABLE;
        this.readWriteTransaction.executeWithoutResult(tx -> this.partitionDao.update((Object)new InternalMeshPartitionReplica.Builder(current).state(targetState).build()));
        if (targetState == MeshPartitionReplica.State.DRAINING) {
            return new DrainAndDisableReplicaTask(request.getNode(), request.getPartition()).drainThenDisableAsync();
        }
        return CompletableFuture.completedFuture(null);
    }

    private JobRunnerResponse clusterMaintenanceJob(JobRunnerRequest request) {
        try (LockGuard guard = LockGuard.tryLock((Lock)this.lockService.getLock(JOB_NAME));){
            if (guard != null) {
                this.disableDrainedReplicas();
            }
        }
        catch (Exception e) {
            return JobRunnerResponse.failed((Throwable)e);
        }
        return JobRunnerResponse.success();
    }

    private void disableDrainedReplicas() {
        this.readOnlyTransaction.executeWithoutResult(tx -> PageUtils.toStream(pageRequest -> this.partitionDao.findByState(MeshPartitionReplica.State.DRAINING, pageRequest), (int)100).forEach(replica -> new DrainAndDisableReplicaTask((MeshNode)replica.getNode(), replica.getPartition()).run()));
    }

    private InternalMeshPartitionReplica internalAssignPartitionReplica(MeshNode node, int partition) {
        Objects.requireNonNull(node, "node");
        InternalMeshPartitionReplica result = (InternalMeshPartitionReplica)this.partitionDao.create((Object)new InternalMeshPartitionReplica.Builder().node(InternalConverter.convertMeshNode((MeshNode)node)).partition(partition).build());
        log.debug("Assigned Mesh replica (id = {}) of partition {} to node {}", new Object[]{result.getId(), partition, node.getId()});
        this.partitionRegistry.initializePartitionReplica(result);
        return result;
    }

    private void internalUnassignPartitionReplica(MeshNode node, int partition) {
        InternalMeshPartitionReplica replica = this.partitionDao.findByNodeAndPartition(node.getId(), partition);
        if (replica == null) {
            throw this.newMeshPartitionReplicaNotFoundException(partition, node);
        }
        log.debug("Unassigned Mesh replica (id = {}) of partition {} on node {}", new Object[]{replica.getId(), partition, node.getId()});
        this.partitionDao.deleteById((Object)replica.getId());
    }

    private NoSuchEntityException newMeshPartitionReplicaNotFoundException(int partition, MeshNode node) {
        return new NoSuchEntityException(this.i18nService.createKeyedMessage("bitbucket.service.mesh.partition.replica.notfound", new Object[]{partition, node.getId()}));
    }

    class DrainAndDisableReplicaTask
    implements Runnable {
        private final MeshNode node;
        private final int partition;
        private int attempt;

        public DrainAndDisableReplicaTask(MeshNode node, int partition) {
            this.node = node;
            this.partition = partition;
        }

        public CompletionStage<Void> drainThenDisableAsync() {
            ++this.attempt;
            InternalMeshPartitionReplica current = (InternalMeshPartitionReplica)DefaultMeshPartitionReplicaService.this.readOnlyTransaction.execute(tx -> DefaultMeshPartitionReplicaService.this.partitionDao.findByNodeAndPartition(this.node.getId(), this.partition));
            if (this.maybeAbortDrain(current)) {
                return CompletableFuture.completedFuture(null);
            }
            return DefaultMeshPartitionReplicaService.this.managementClient.drainReplica((MeshPartitionReplica)current).handle((result, throwable) -> {
                if (throwable != null) {
                    if (current.getNode().isOffline()) {
                        log.info("Replica {}#{} was/went offline while draining. Assuming draining is complete.", new Object[]{this.partition, this.node.getId(), throwable instanceof RepositoryOfflineException ? null : throwable});
                    } else {
                        if (this.attempt < 3) {
                            log.info("Retrying draining of replica {}#{} after failure (attempt {}/{}).", new Object[]{this.partition, this.node.getId(), this.attempt + 1, 3, throwable});
                            return this.drainThenDisableAsync();
                        }
                        log.warn("Abandoning draining of replica {}#{} after {} failed attempts", new Object[]{this.partition, this.node.getId(), this.attempt, throwable});
                        return CompletableFuture.completedFuture(null);
                    }
                }
                if (this.disableReplica()) {
                    log.info("Replica {}#{} has drained and has now been disabled", (Object)this.partition, (Object)this.node.getId());
                }
                return CompletableFuture.completedFuture(null);
            }).thenCompose(Function.identity());
        }

        @Override
        public void run() {
            this.drainThenDisableAsync();
        }

        private boolean disableReplica() {
            return Boolean.TRUE.equals(DefaultMeshPartitionReplicaService.this.readWriteTransaction.execute(tx -> {
                InternalMeshPartitionReplica drained = DefaultMeshPartitionReplicaService.this.partitionDao.findByNodeAndPartition(this.node.getId(), this.partition);
                if (this.maybeAbortDrain(drained)) {
                    return false;
                }
                DefaultMeshPartitionReplicaService.this.partitionDao.update((Object)new InternalMeshPartitionReplica.Builder(drained).state(MeshPartitionReplica.State.DISABLED).build());
                return true;
            }));
        }

        private boolean maybeAbortDrain(InternalMeshPartitionReplica current) {
            if (current == null) {
                log.info("Aborted draining replica {}#{}. The replica has been deleted", (Object)this.partition, (Object)this.node.getId());
                return true;
            }
            if (current.getState() != MeshPartitionReplica.State.DRAINING) {
                if (current.getState() != MeshPartitionReplica.State.DISABLED) {
                    log.info("Draining of replica {}#{} was aborted (state = {})", new Object[]{this.partition, this.node.getId(), current.getState()});
                }
                return true;
            }
            return false;
        }
    }
}

