/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.stash.internal.mesh;

import com.atlassian.bitbucket.dmz.mesh.DmzMeshPartitionRegistry;
import com.atlassian.bitbucket.dmz.mesh.DmzMeshRemigrator;
import com.atlassian.bitbucket.dmz.mesh.DmzMeshService;
import com.atlassian.bitbucket.dmz.mesh.MeshPartitionReplica;
import com.atlassian.bitbucket.dmz.migration.MeshMigrationFailedException;
import com.atlassian.bitbucket.dmz.server.DmzStorageService;
import com.atlassian.bitbucket.i18n.I18nService;
import com.atlassian.bitbucket.internal.mesh.RpcManagementClient;
import com.atlassian.bitbucket.mesh.MeshNode;
import com.atlassian.bitbucket.mesh.RepositoryInconsistentException;
import com.atlassian.bitbucket.repository.Repository;
import com.atlassian.bitbucket.scm.CreateCommandParameters;
import com.atlassian.bitbucket.scm.ForkCommandParameters;
import com.atlassian.bitbucket.util.MoreFiles;
import com.atlassian.bitbucket.util.PageUtils;
import com.atlassian.bitbucket.util.PagedIterable;
import com.atlassian.plugin.spring.AvailableToPlugins;
import com.atlassian.stash.internal.InternalConverter;
import com.atlassian.stash.internal.migration.MeshMigrationUnavailableException;
import com.atlassian.stash.internal.migration.MigrationPaths;
import com.atlassian.stash.internal.repository.InternalRepository;
import com.atlassian.stash.internal.repository.InternalRepositoryService;
import com.atlassian.stash.internal.scm.InternalScmService;
import jakarta.annotation.Nonnull;
import java.io.IOException;
import java.io.UncheckedIOException;
import java.nio.file.CopyOption;
import java.nio.file.Files;
import java.nio.file.LinkOption;
import java.nio.file.Path;
import java.util.ArrayList;
import java.util.LinkedHashSet;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.Set;
import java.util.concurrent.CancellationException;
import java.util.concurrent.ExecutionException;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.security.access.prepost.PreAuthorize;
import org.springframework.stereotype.Service;
import org.springframework.transaction.annotation.Transactional;

@AvailableToPlugins(value=DmzMeshRemigrator.class)
@PreAuthorize(value="hasGlobalPermission('SYS_ADMIN')")
@Service(value="meshRemigrator")
@Transactional
public class DefaultMeshRemigrator
implements DmzMeshRemigrator {
    private static final Logger log = LoggerFactory.getLogger(DefaultMeshRemigrator.class);
    private final I18nService i18nService;
    private final RpcManagementClient managementClient;
    private final DmzMeshService meshService;
    private final DmzMeshPartitionRegistry partitionRegistry;
    private final InternalRepositoryService repositoryService;
    private final InternalScmService scmService;
    private final DmzStorageService storageService;

    @Autowired
    public DefaultMeshRemigrator(I18nService i18nService, Optional<RpcManagementClient> managementClient, DmzMeshService meshService, DmzMeshPartitionRegistry partitionRegistry, InternalRepositoryService repositoryService, InternalScmService scmService, DmzStorageService storageService) {
        this.i18nService = i18nService;
        this.managementClient = managementClient.orElse(null);
        this.meshService = meshService;
        this.partitionRegistry = partitionRegistry;
        this.repositoryService = repositoryService;
        this.scmService = scmService;
        this.storageService = storageService;
    }

    public void abort(@Nonnull Repository repository) {
        Objects.requireNonNull(repository, "repository");
        for (Repository repo : this.getHierarchyRepos(repository)) {
            this.repositoryService.setReadOnly(repo, false);
        }
        this.maybeRestoreHierarchyMigrationBackupDirectory(repository);
    }

    public void commit(@Nonnull Repository repository) {
        Objects.requireNonNull(repository, "repository");
        String hierarchyId = repository.getHierarchyId();
        MoreFiles.deleteQuietly((Path)this.getHierarchyMigrationDir(repository));
        this.maybeClearHierarchyMigrationBackupDirectory(repository);
        this.repositoryService.updatePartitionForHierarchy(hierarchyId, -1);
        for (Repository repo : this.getHierarchyRepos(repository)) {
            this.repositoryService.setReadOnly(repo, false);
        }
    }

    @Nonnull
    public List<Repository> prepare(@Nonnull Repository repository) {
        if (Objects.requireNonNull(repository, "repository").isLocal()) {
            throw new IllegalArgumentException(String.valueOf(repository) + " is already local");
        }
        LinkedHashSet<Repository> ancestors = new LinkedHashSet<Repository>();
        for (Repository repo : this.getHierarchyRepos(repository)) {
            this.maybeCreateOnDisk(repo);
            this.repositoryService.setReadOnly(repo, true);
            DefaultMeshRemigrator.addAncestors(ancestors, repo);
        }
        this.maybeBackupHierarchyMigrationDirectory(repository);
        return new ArrayList<Repository>(ancestors);
    }

    public void remigrate(@Nonnull Repository repository) {
        if (this.managementClient == null) {
            throw new MeshMigrationUnavailableException(this.i18nService.createKeyedMessage("bitbucket.service.migration.mesh.remigration-disabled", new Object[0]));
        }
        if (Objects.requireNonNull(repository, "repository").isLocal()) {
            throw new IllegalArgumentException(String.valueOf(repository) + " is already local");
        }
        try {
            MeshNode sidecar = (MeshNode)this.meshService.getSidecar().orElseThrow(() -> new MeshMigrationFailedException("No sidecar has been configured"));
            MeshNode repairSourceNode = this.getRepairSource(repository).orElseThrow(() -> new RepositoryInconsistentException(this.i18nService.createKeyedMessage("bitbucket.git.repository.inconsistent", new Object[]{repository.getId()})));
            log.info("[{}]: Mesh node [{}] has a consistent replica, attempting to repair from it", (Object)repository, (Object)repairSourceNode);
            InternalRepository internalRepository = this.maybeCreateOnDisk(repository);
            this.repositoryService.setReadOnly(repository, true);
            if (!((Boolean)this.managementClient.repairRepository(repairSourceNode, sidecar, repository, (Repository)internalRepository).get()).booleanValue()) {
                log.error("[{}]: Failed to repair from [{}]", (Object)internalRepository, (Object)repairSourceNode);
                throw new MeshMigrationFailedException(String.format("[%s] : Failed to repair from Mesh node [%s]", repository, repairSourceNode));
            }
            log.info("[{}]: Repaired repo successfully from Mesh node [{}]", (Object)internalRepository, (Object)repairSourceNode);
        }
        catch (CancellationException e) {
            throw new MeshMigrationFailedException(String.format("[%s]: Failed to repair from Mesh", repository), (Throwable)e);
        }
        catch (ExecutionException e) {
            throw new MeshMigrationFailedException(String.format("[%s]: Failed to repair from Mesh", repository), e.getCause());
        }
        catch (InterruptedException e) {
            Thread.currentThread().interrupt();
            throw new MeshMigrationFailedException(String.format("[%s]: Interrupted while waiting for repairs to complete", repository), (Throwable)e);
        }
        log.info("[{}]: Successfully migrated from Mesh to Shared Home", (Object)repository);
    }

    public void setPartition(@Nonnull Repository repository, int partition) {
        Objects.requireNonNull(repository, "repository");
        this.repositoryService.updatePartitionForHierarchy(repository.getHierarchyId(), partition);
    }

    private static void addAncestors(Set<Repository> ancestors, Repository repository) {
        if (repository != null) {
            DefaultMeshRemigrator.addAncestors(ancestors, repository.getOrigin());
            ancestors.add(repository);
        }
    }

    private Path getHierarchyMigrationBackupDir(Repository repository) {
        return this.storageService.getHierarchyDataDir(repository.getHierarchyId()).resolve(MigrationPaths.MESH_MIGRATION_DATA_BACKUP_PATH);
    }

    private Path getHierarchyMigrationDir(Repository repository) {
        return this.storageService.getHierarchyDataDir(repository.getHierarchyId()).resolve(MigrationPaths.MESH_MIGRATION_DATA_PATH);
    }

    private Iterable<Repository> getHierarchyRepos(Repository repository) {
        return new PagedIterable(request -> this.repositoryService.findByHierarchyId(repository.getHierarchyId(), request), PageUtils.newRequest((int)0, (int)1000));
    }

    private Optional<MeshNode> getRepairSource(Repository repository) {
        int partitionId = repository.getPartition();
        return this.partitionRegistry.getPartition(partitionId).flatMap(p -> p.getReplicas().stream().filter(replica -> replica.isAvailable() && this.partitionRegistry.isConsistent(replica.getNode(), repository.getId())).map(MeshPartitionReplica::getNode).findFirst());
    }

    private void maybeBackupHierarchyMigrationDirectory(Repository repository) {
        Path hierarchyMigrationDir = this.getHierarchyMigrationDir(repository);
        if (Files.isDirectory(hierarchyMigrationDir, new LinkOption[0])) {
            try {
                Files.move(hierarchyMigrationDir, this.getHierarchyMigrationBackupDir(repository), new CopyOption[0]);
                log.info("Backed up hierarchy migration directory for hierarchy [{}]", (Object)repository.getHierarchyId());
            }
            catch (IOException e) {
                log.error("Couldn't backup hierarchy migration directory");
                throw new UncheckedIOException(e);
            }
        }
    }

    private void maybeClearHierarchyMigrationBackupDirectory(Repository repository) {
        Path hierarchyMigrationBackupDir = this.getHierarchyMigrationBackupDir(repository);
        if (Files.isDirectory(hierarchyMigrationBackupDir, new LinkOption[0])) {
            if (MoreFiles.deleteQuietly((Path)hierarchyMigrationBackupDir)) {
                log.info("Cleared hierarchy migration backup directory for hierarchy [{}]", (Object)repository.getHierarchyId());
            } else {
                log.warn("Hierarchy migration backup directory for the hierarchy [{}] couldn't be deleted. It will need to be deleted manually", (Object)repository.getHierarchyId());
            }
        }
    }

    private InternalRepository maybeCreateOnDisk(Repository repository) {
        Path migratedDir;
        InternalRepository localRepository = new InternalRepository.Builder(InternalConverter.convertToInternalRepository((Repository)repository)).partition(-1).hierarchyId(repository.getHierarchyId()).build();
        Path repositoryDir = this.storageService.getRepositoryDir((Repository)localRepository);
        if (Files.isDirectory(repositoryDir, new LinkOption[0])) {
            log.debug("[{}]: Already exists on disk, not creating a new directory for it", (Object)repository);
            return localRepository;
        }
        Repository origin = repository.getOrigin();
        if (origin != null) {
            this.maybeCreateOnDisk(origin);
        }
        if (Files.isDirectory(migratedDir = repositoryDir.resolveSibling(String.valueOf(repositoryDir.getFileName()) + "-migrated"), new LinkOption[0])) {
            try {
                Files.move(migratedDir, repositoryDir, new CopyOption[0]);
                log.info("Moved {} back to {}", (Object)migratedDir, (Object)repositoryDir);
                return localRepository;
            }
            catch (IOException e) {
                log.warn("Could not move {} back to {}", new Object[]{migratedDir, repositoryDir, e});
            }
        }
        if (origin == null) {
            log.debug("[{}]: Creating a new directory on Shared Home", (Object)localRepository);
            this.scmService.create((Repository)localRepository, new CreateCommandParameters.Builder().defaultBranch(this.repositoryService.getDefaultBranch(repository).getId()).build());
        } else {
            InternalRepository localOrigin = new InternalRepository.Builder(InternalConverter.convertToInternalRepository((Repository)origin)).partition(-1).hierarchyId(origin.getHierarchyId()).build();
            log.debug("[{}]: Creating a new directory on Shared Home", (Object)localRepository);
            this.scmService.fork((Repository)localOrigin, new ForkCommandParameters.Builder((Repository)localRepository).defaultBranch(this.repositoryService.getDefaultBranch(repository).getId()).build());
        }
        return localRepository;
    }

    private void maybeRestoreHierarchyMigrationBackupDirectory(Repository repository) {
        Path hierarchyMigrationBackupDir = this.getHierarchyMigrationBackupDir(repository);
        if (Files.isDirectory(hierarchyMigrationBackupDir, new LinkOption[0])) {
            try {
                Files.move(hierarchyMigrationBackupDir, this.getHierarchyMigrationDir(repository), new CopyOption[0]);
                log.info("Restored hierarchy migration directory");
            }
            catch (IOException e) {
                log.warn("Couldn't restore migration directory for hierarchy [{}], this will need to be restored manually", (Object)repository.getHierarchyId(), (Object)e);
            }
        }
    }
}

