/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.stash.internal.mesh;

import com.atlassian.bitbucket.IllegalEntityStateException;
import com.atlassian.bitbucket.cluster.ClusterExecutionException;
import com.atlassian.bitbucket.cluster.ClusterNode;
import com.atlassian.bitbucket.concurrent.LockService;
import com.atlassian.bitbucket.dmz.mesh.AnalyticsMeshNodeRegisteredEvent;
import com.atlassian.bitbucket.dmz.mesh.AnalyticsMeshNodeUnregisteredEvent;
import com.atlassian.bitbucket.dmz.mesh.AnalyticsMeshNodeUpdatedEvent;
import com.atlassian.bitbucket.dmz.mesh.AssignPartitionRequest;
import com.atlassian.bitbucket.dmz.mesh.ConnectivityNode;
import com.atlassian.bitbucket.dmz.mesh.ConnectivityReportNodeType;
import com.atlassian.bitbucket.dmz.mesh.DmzMeshPartitionMigrationService;
import com.atlassian.bitbucket.dmz.mesh.DmzMeshService;
import com.atlassian.bitbucket.dmz.mesh.InconsistentRepositoryReplica;
import com.atlassian.bitbucket.dmz.mesh.MeshConnectivityReport;
import com.atlassian.bitbucket.dmz.mesh.MeshConnectivitySummary;
import com.atlassian.bitbucket.dmz.mesh.MeshPartitionMigration;
import com.atlassian.bitbucket.dmz.mesh.MeshPartitionMigrationJobState;
import com.atlassian.bitbucket.dmz.mesh.MeshPartitionMigrationSearchRequest;
import com.atlassian.bitbucket.dmz.mesh.MeshPartitionReplica;
import com.atlassian.bitbucket.dmz.mesh.MeshResetHierarchyFailedException;
import com.atlassian.bitbucket.dmz.mesh.MeshSettings;
import com.atlassian.bitbucket.dmz.mesh.MeshSettingsUpdateRequest;
import com.atlassian.bitbucket.dmz.mesh.MeshSupportZipException;
import com.atlassian.bitbucket.dmz.mesh.ReplicaState;
import com.atlassian.bitbucket.dmz.repository.RemoteRepositoryId;
import com.atlassian.bitbucket.i18n.I18nService;
import com.atlassian.bitbucket.internal.mesh.RpcCapabilityClient;
import com.atlassian.bitbucket.internal.mesh.RpcManagementClient;
import com.atlassian.bitbucket.mesh.InvalidMeshNodeStateException;
import com.atlassian.bitbucket.mesh.InvalidMeshNodeUrlException;
import com.atlassian.bitbucket.mesh.MeshNode;
import com.atlassian.bitbucket.mesh.MeshNodeConnectionException;
import com.atlassian.bitbucket.mesh.MeshNodeIncompatibleException;
import com.atlassian.bitbucket.mesh.MeshNodeNameAlreadyExistsException;
import com.atlassian.bitbucket.mesh.MeshNodeUrlAlreadyExistsException;
import com.atlassian.bitbucket.mesh.MeshService;
import com.atlassian.bitbucket.mesh.NoSuchMeshNodeException;
import com.atlassian.bitbucket.mesh.RegisterMeshNodeRequest;
import com.atlassian.bitbucket.mesh.UpdateMeshNodeRequest;
import com.atlassian.bitbucket.mesh.rpc.v1.RpcGetSupportZipRequest;
import com.atlassian.bitbucket.mesh.rpc.v1.RpcNodeConfiguration;
import com.atlassian.bitbucket.mesh.rpc.v1.RpcSetConfigurationRequest;
import com.atlassian.bitbucket.permission.Permission;
import com.atlassian.bitbucket.repository.Repository;
import com.atlassian.bitbucket.repository.RepositoryOfflineException;
import com.atlassian.bitbucket.server.StorageService;
import com.atlassian.bitbucket.user.EscalatedSecurityContext;
import com.atlassian.bitbucket.user.SecurityService;
import com.atlassian.bitbucket.util.DevModeUtils;
import com.atlassian.bitbucket.util.MoreCollectors;
import com.atlassian.bitbucket.util.MoreFiles;
import com.atlassian.bitbucket.util.Page;
import com.atlassian.bitbucket.util.PageUtils;
import com.atlassian.bitbucket.util.PagedIterable;
import com.atlassian.bitbucket.util.concurrent.LockGuard;
import com.atlassian.event.api.EventPublisher;
import com.atlassian.nutcluster.core.IExecutorService;
import com.atlassian.nutcluster.core.Member;
import com.atlassian.nutcluster.core.MultiExecutionCallback;
import com.atlassian.nutcluster.spring.context.SpringAware;
import com.atlassian.plugin.spring.AvailableToPlugins;
import com.atlassian.scheduler.JobRunnerRequest;
import com.atlassian.scheduler.JobRunnerResponse;
import com.atlassian.scheduler.SchedulerService;
import com.atlassian.scheduler.SchedulerServiceException;
import com.atlassian.scheduler.config.JobConfig;
import com.atlassian.scheduler.config.JobId;
import com.atlassian.scheduler.config.JobRunnerKey;
import com.atlassian.scheduler.config.RunMode;
import com.atlassian.scheduler.config.Schedule;
import com.atlassian.stash.internal.ApplicationConstants;
import com.atlassian.stash.internal.annotation.Unsecured;
import com.atlassian.stash.internal.cluster.NutclusterClusterNode;
import com.atlassian.stash.internal.maintenance.latch.ResultCollectingExecutionCallback;
import com.atlassian.stash.internal.mesh.InternalMeshNode;
import com.atlassian.stash.internal.mesh.InternalMeshPartitionRegistry;
import com.atlassian.stash.internal.mesh.InternalMeshService;
import com.atlassian.stash.internal.mesh.MeshKeyManager;
import com.atlassian.stash.internal.mesh.MeshNodeDao;
import com.atlassian.stash.internal.mesh.MeshRepositoryReplicaDao;
import com.atlassian.stash.internal.mesh.MeshRepositoryReplicaObservation;
import com.atlassian.stash.internal.mesh.PartitionAllocationStrategy;
import com.atlassian.stash.internal.mesh.PartitionAssignmentStrategy;
import com.atlassian.stash.internal.mode.DefaultApplicationMode;
import com.atlassian.stash.internal.repository.InternalRepository;
import com.atlassian.stash.internal.repository.RepositoryDao;
import com.atlassian.stash.internal.scheduling.ScheduledJobSource;
import com.atlassian.stash.internal.server.InternalApplicationPropertiesService;
import com.atlassian.stash.internal.spring.SpringTransactionUtils;
import com.atlassian.stash.internal.spring.TransactionSynchronizer;
import com.fasterxml.jackson.core.JsonEncoding;
import com.fasterxml.jackson.core.JsonGenerator;
import com.fasterxml.jackson.databind.ObjectMapper;
import com.google.common.base.Preconditions;
import com.google.common.collect.ImmutableList;
import com.google.common.collect.ImmutableMap;
import com.google.common.collect.ImmutableSet;
import com.google.common.collect.Iterables;
import jakarta.annotation.Nonnull;
import java.io.IOException;
import java.io.OutputStream;
import java.io.Serializable;
import java.net.InetAddress;
import java.net.URI;
import java.net.URISyntaxException;
import java.net.UnknownHostException;
import java.nio.file.Files;
import java.nio.file.OpenOption;
import java.nio.file.Path;
import java.nio.file.attribute.FileAttribute;
import java.security.PublicKey;
import java.time.LocalDateTime;
import java.time.format.DateTimeFormatter;
import java.util.Collection;
import java.util.Collections;
import java.util.Date;
import java.util.HashSet;
import java.util.List;
import java.util.Locale;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.Set;
import java.util.concurrent.Callable;
import java.util.concurrent.CompletionStage;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.locks.Lock;
import java.util.stream.Collectors;
import java.util.zip.ZipEntry;
import java.util.zip.ZipOutputStream;
import org.apache.commons.lang3.StringUtils;
import org.apache.commons.lang3.mutable.MutableLong;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.beans.factory.annotation.Qualifier;
import org.springframework.beans.factory.annotation.Value;
import org.springframework.context.ApplicationContext;
import org.springframework.context.ApplicationListener;
import org.springframework.context.event.ContextRefreshedEvent;
import org.springframework.security.access.prepost.PreAuthorize;
import org.springframework.stereotype.Service;
import org.springframework.transaction.PlatformTransactionManager;
import org.springframework.transaction.annotation.Propagation;
import org.springframework.transaction.annotation.Transactional;
import org.springframework.transaction.support.TransactionSynchronization;
import org.springframework.transaction.support.TransactionTemplate;

@AvailableToPlugins(interfaces={DmzMeshService.class, MeshService.class})
@Service(value="meshService")
public class DefaultMeshService
implements InternalMeshService,
ApplicationListener<ContextRefreshedEvent>,
ScheduledJobSource {
    private static final DateTimeFormatter DATE_TIME_FORMATTER = DateTimeFormatter.ofPattern("yyyy-MM-dd-HH-mm-ss.SSS");
    private static final long EVERY_HOUR = TimeUnit.HOURS.toMillis(1L);
    private static final RpcGetSupportZipRequest GET_SUPPORT_ZIP_REQUEST = RpcGetSupportZipRequest.newBuilder().setConfig(true).setLogs(true).build();
    private static final String JOB_NAME = MeshService.class.getSimpleName() + ".clusterMaintenanceJob";
    private static final JobId JOB_ID = JobId.of((String)JOB_NAME);
    private static final JobRunnerKey JOB_RUNNER_KEY = JobRunnerKey.of((String)JOB_NAME);
    private static final int MAX_ATTEMPTS = 3;
    private static final String NODE_REGISTRATION_LOCK = MeshService.class.getSimpleName() + "_node_registration";
    private static final String PROP_CONNECTIVITY_REPORT_TIMEOUT = "${mesh.connectivity-report.timeout:60}";
    private static final String PROP_REPLICATION_FACTOR = "${plugin.bitbucket-git.mesh.replication.factor:3}";
    private static final Set<String> VALID_SCHEMES = ImmutableSet.of((Object)"http", (Object)"https");
    private static final Logger log = LoggerFactory.getLogger(DefaultMeshService.class);
    private final IExecutorService clusterExecutorService;
    private final long connectivityReportTimeout;
    private final EventPublisher eventPublisher;
    private final I18nService i18nService;
    private final LockService lockService;
    private final boolean meshEnabled;
    private final MeshNodeDao nodeDao;
    private final PartitionAllocationStrategy partitionAllocationStrategy;
    private final PartitionAssignmentStrategy partitionAssignmentStrategy;
    private final DmzMeshPartitionMigrationService partitionMigrationService;
    private final InternalMeshPartitionRegistry partitionRegistry;
    private final InternalApplicationPropertiesService propertiesService;
    private final TransactionTemplate readOnlyTransaction;
    private final TransactionTemplate readWriteTransaction;
    private final int replicationFactor;
    private final RepositoryDao repositoryDao;
    private final MeshRepositoryReplicaDao repositoryReplicaDao;
    private final StorageService storageService;
    private final TransactionSynchronizer transactionSynchronizer;
    private final EscalatedSecurityContext withSysAdmin;
    private RpcCapabilityClient capabilityClient;
    private MeshKeyManager keyManager;
    private RpcManagementClient managementClient;
    private volatile MeshNode sidecar;

    @Autowired
    public DefaultMeshService(@Qualifier(value="clusterExecutor") IExecutorService clusterExecutorService, @Value(value="${mesh.connectivity-report.timeout:60}") long connectivityReportTimeout, EventPublisher eventPublisher, @Qualifier(value="balanced") PartitionAssignmentStrategy partitionAssignmentStrategy, I18nService i18nService, LockService lockService, @Value(value="${mesh.enabled}") boolean meshEnabled, MeshNodeDao nodeDao, PartitionAllocationStrategy partitionAllocationStrategy, DmzMeshPartitionMigrationService partitionMigrationService, InternalMeshPartitionRegistry partitionRegistry, InternalApplicationPropertiesService propertiesService, @Value(value="${plugin.bitbucket-git.mesh.replication.factor:3}") int replicationFactor, RepositoryDao repositoryDao, MeshRepositoryReplicaDao repositoryReplicaDao, SecurityService securityService, StorageService storageService, PlatformTransactionManager transactionManager, TransactionSynchronizer transactionSynchronizer) {
        this.clusterExecutorService = clusterExecutorService;
        this.connectivityReportTimeout = connectivityReportTimeout;
        this.eventPublisher = eventPublisher;
        this.partitionAssignmentStrategy = partitionAssignmentStrategy;
        this.i18nService = i18nService;
        this.lockService = lockService;
        this.meshEnabled = meshEnabled;
        this.nodeDao = nodeDao;
        this.partitionAllocationStrategy = partitionAllocationStrategy;
        this.partitionMigrationService = partitionMigrationService;
        this.partitionRegistry = partitionRegistry;
        this.propertiesService = propertiesService;
        this.replicationFactor = replicationFactor;
        this.repositoryDao = repositoryDao;
        this.repositoryReplicaDao = repositoryReplicaDao;
        this.storageService = storageService;
        this.transactionSynchronizer = transactionSynchronizer;
        this.readOnlyTransaction = new TransactionTemplate(transactionManager, SpringTransactionUtils.REQUIRES_NEW);
        this.readOnlyTransaction.setReadOnly(true);
        this.readWriteTransaction = new TransactionTemplate(transactionManager, SpringTransactionUtils.REQUIRES_NEW);
        this.withSysAdmin = securityService.withPermission(Permission.SYS_ADMIN, "For cleaning up Mesh nodes");
    }

    @Transactional(readOnly=true)
    @Unsecured(value="This internal API is only called as part of creating a repository, after appropriate permission checks")
    public int assignPartitionForHierarchy(@Nonnull AssignPartitionRequest request) {
        boolean onMesh;
        Objects.requireNonNull(request, "request");
        boolean bl = onMesh = this.meshEnabled && "git".equals(request.getScmId()) && (this.propertiesService.isMeshRepositoryCreationEnabled() || request.isOverrideEnabled());
        if (!onMesh) {
            return -1;
        }
        return this.partitionAssignmentStrategy.assign(request);
    }

    @Transactional(propagation=Propagation.REQUIRED)
    @PreAuthorize(value="hasGlobalPermission('SYS_ADMIN')")
    public void ensurePartitionCount() {
        this.partitionAllocationStrategy.ensurePartitionCount();
    }

    @Nonnull
    @PreAuthorize(value="hasGlobalPermission('SYS_ADMIN')")
    @Transactional(propagation=Propagation.SUPPORTS)
    public List<MeshConnectivityReport> getConnectivityReports() {
        ClusterConnectivityCallback callback = new ClusterConnectivityCallback(this.connectivityReportTimeout);
        this.clusterExecutorService.submitToAllMembers((Callable)new GetClusterConnectivityResults(), (MultiExecutionCallback)callback);
        return callback.getResult();
    }

    @Nonnull
    @Unsecured(value="Internal service method; no permission check necessary")
    @Transactional(propagation=Propagation.SUPPORTS)
    public List<MeshConnectivitySummary> getConnectivitySummaries() {
        List<MeshNode> nodes = this.getMembers();
        ImmutableList.Builder summaries = ImmutableList.builder();
        for (MeshNode node : nodes) {
            MeshConnectivitySummary.Builder summaryBuilder = new MeshConnectivitySummary.Builder(new ConnectivityNode(String.valueOf(node.getId()), node.getName(), ConnectivityReportNodeType.MESH));
            try {
                summaryBuilder.roundTripTime(this.managementClient.ping(node)).reachable(true);
            }
            catch (MeshNodeConnectionException e) {
                summaryBuilder.errorMessage(e.getMessage());
            }
            summaries.add((Object)summaryBuilder.build());
        }
        return summaries.build();
    }

    @Nonnull
    @Transactional(readOnly=true)
    @Unsecured(value="This method is exposed via JMX, so it needs to be unsecured")
    public Map<Integer, Long> getInconsistentRepositoryReplicaSummary() {
        return this.repositoryReplicaDao.getInconsistentRepositoryReplicaCounts();
    }

    @Nonnull
    @PreAuthorize(value="hasGlobalPermission('SYS_ADMIN')")
    @Transactional(propagation=Propagation.SUPPORTS)
    public Map<MeshNode, Collection<InconsistentRepositoryReplica>> getInconsistentRepositoryReplicas() {
        ImmutableMap.Builder builder = ImmutableMap.builder();
        for (MeshNode node : this.getMembers()) {
            if (node.isSidecar()) continue;
            builder.put((Object)node, (Object)this.partitionRegistry.getInconsistentRepositoryReplicas(node));
        }
        return builder.build();
    }

    @Nonnull
    @PreAuthorize(value="hasGlobalPermission('SYS_ADMIN')")
    @Transactional(readOnly=true)
    public MeshNode getMember(long id) {
        return this.getNodeOrThrow(id);
    }

    @Nonnull
    @PreAuthorize(value="hasGlobalPermission('SYS_ADMIN')")
    @Transactional(readOnly=true)
    public Map<String, String> getMemberInfo(long nodeId) {
        MeshNode node = this.getMember(nodeId);
        return this.managementClient.getNodeInfo(node);
    }

    @Nonnull
    @PreAuthorize(value="hasGlobalPermission('SYS_ADMIN')")
    @Transactional(readOnly=true)
    public List<MeshNode> getMembers() {
        ImmutableList.Builder builder = ImmutableList.builder();
        if (this.sidecar != null) {
            builder.add((Object)this.sidecar);
        }
        builder.addAll((Iterable)this.nodeDao.getAll());
        return builder.build();
    }

    @Nonnull
    @PreAuthorize(value="hasGlobalPermission('SYS_ADMIN')")
    @Transactional(readOnly=true)
    public List<MeshNode> getMembersByPartition(int partition) {
        if (partition < 0) {
            return this.sidecar == null ? ImmutableList.of() : ImmutableList.of((Object)this.sidecar);
        }
        return this.partitionRegistry.getPartition(partition).map(part -> (List)part.getReplicas().stream().map(MeshPartitionReplica::getNode).collect(MoreCollectors.toImmutableList())).orElseGet(ImmutableList::of);
    }

    @Nonnull
    @Unsecured(value="Exposed via JMX only")
    @Transactional(readOnly=true)
    public InternalMeshService.NodeStatistics getNodeStatistics() {
        final MutableLong offlineCount = new MutableLong();
        final MutableLong unavailableCount = new MutableLong();
        final MutableLong inconsistentCount = new MutableLong();
        final long totalCount = this.getMembers().stream().filter(node -> !node.isSidecar()).peek(node -> {
            if (node.isOffline()) {
                offlineCount.increment();
            }
            if (!node.isAvailable()) {
                unavailableCount.increment();
            }
            if (!this.partitionRegistry.getInconsistentRepositoryReplicas(node).isEmpty()) {
                inconsistentCount.increment();
            }
        }).count();
        return new InternalMeshService.NodeStatistics(){

            public long getInconsistentCount() {
                return inconsistentCount.longValue();
            }

            public long getOfflineCount() {
                return offlineCount.longValue();
            }

            public long getTotalCount() {
                return totalCount;
            }

            public long getUnavailableCount() {
                return unavailableCount.longValue();
            }
        };
    }

    @Unsecured(value="Internal API")
    public int getReplicationFactor() {
        return this.replicationFactor;
    }

    @Nonnull
    @PreAuthorize(value="hasGlobalPermission('SYS_ADMIN')")
    @Transactional(readOnly=true)
    public MeshSettings getSettings() {
        return new MeshSettings.Builder().repositoryCreationEnabled(this.propertiesService.isMeshRepositoryCreationEnabled()).build();
    }

    @Nonnull
    @PreAuthorize(value="hasGlobalPermission('SYS_ADMIN')")
    @Transactional(propagation=Propagation.SUPPORTS)
    public Optional<MeshNode> getSidecar() {
        return Optional.ofNullable(this.sidecar);
    }

    @Nonnull
    @PreAuthorize(value="hasGlobalPermission('SYS_ADMIN')")
    @Transactional(propagation=Propagation.SUPPORTS)
    public Path getSupportZip(long nodeId) throws IOException {
        InternalMeshNode node = this.getNodeOrThrow(nodeId);
        return this.managementClient.getSupportZip((MeshNode)node, GET_SUPPORT_ZIP_REQUEST);
    }

    @Nonnull
    @PreAuthorize(value="hasGlobalPermission('SYS_ADMIN')")
    @Transactional(propagation=Propagation.SUPPORTS)
    public Path getSupportZips() {
        ClusterConnectivityCallback callback = new ClusterConnectivityCallback(this.connectivityReportTimeout);
        this.clusterExecutorService.submitToAllMembers((Callable)new GetClusterConnectivityResults(), (MultiExecutionCallback)callback);
        List nodes = this.getMembers().stream().filter(node -> !node.isSidecar()).collect(Collectors.toList());
        String filename = String.format("Bitbucket-Mesh_all_support_%s", LocalDateTime.now().format(DATE_TIME_FORMATTER));
        Path sharedHomeDir = this.storageService.getSharedHomeDir();
        Path supportZip = MoreFiles.mkdir((Path)sharedHomeDir.resolve("export")).resolve(filename + ".zip");
        Path supportFile = null;
        try (ZipOutputStream zipStream = new ZipOutputStream(Files.newOutputStream(supportZip, new OpenOption[0]));){
            for (MeshNode node2 : nodes) {
                try {
                    supportFile = this.managementClient.getSupportZip(node2, GET_SUPPORT_ZIP_REQUEST);
                }
                catch (IOException | RuntimeException e) {
                    log.warn("Failed to get the support zip for node {}", (Object)node2, (Object)e);
                    supportFile = this.getErrorSupportFile(e, node2.getId());
                }
                this.addNodeSupportZip(zipStream, supportFile);
                MoreFiles.deleteQuietly((Path)supportFile);
            }
            this.addConnectivityResultToZip(zipStream, callback.getResult());
        }
        catch (IOException e) {
            MoreFiles.deleteQuietly(supportFile);
            MoreFiles.deleteQuietly((Path)supportZip);
            log.error("Failed to populate the main support zip", (Throwable)e);
            throw new MeshSupportZipException(this.i18nService.createKeyedMessage("bitbucket.service.mesh.support.error.populatingzip", new Object[0]), (Throwable)e);
        }
        return supportZip;
    }

    public boolean isEnabled() {
        return this.meshEnabled;
    }

    @Transactional(propagation=Propagation.SUPPORTS)
    public void onApplicationEvent(@Nonnull ContextRefreshedEvent event) {
        ApplicationContext applicationContext = event.getApplicationContext();
        if (this.meshEnabled) {
            this.capabilityClient = (RpcCapabilityClient)applicationContext.getBean(RpcCapabilityClient.class);
            this.keyManager = (MeshKeyManager)applicationContext.getBean(MeshKeyManager.class);
            this.managementClient = (RpcManagementClient)applicationContext.getBean(RpcManagementClient.class);
        }
    }

    @Nonnull
    @PreAuthorize(value="hasGlobalPermission('SYS_ADMIN')")
    public MeshNode register(@Nonnull RegisterMeshNodeRequest request) {
        Objects.requireNonNull(request, "request");
        Preconditions.checkState((boolean)this.meshEnabled, (Object)"mesh is not enabled");
        Preconditions.checkState((this.managementClient != null ? 1 : 0) != 0, (Object)"managementClient is not available");
        try (LockGuard ignored = LockGuard.lock((Lock)this.lockService.getLock(NODE_REGISTRATION_LOCK));){
            String name = this.chooseName(request.getName(), request.getRpcUrl());
            this.checkNameNotUsed(name);
            String rpcUrl = request.getRpcUrl();
            this.checkIsValidUrl(rpcUrl);
            this.checkUrlNotUsed(rpcUrl);
            this.checkConnectivity(rpcUrl, null);
            this.checkNoMigrationsRunning();
            InternalMeshNode node = (InternalMeshNode)this.readWriteTransaction.execute(tx -> this.createNode(name, request));
            log.info("{}: Registered with ID {}", (Object)node, (Object)node.getId());
            this.eventPublisher.publish((Object)new AnalyticsMeshNodeRegisteredEvent((Object)this, (MeshNode)node));
            InternalMeshNode internalMeshNode = node;
            return internalMeshNode;
        }
    }

    @Transactional(propagation=Propagation.SUPPORTS)
    @Unsecured(value="Internal API")
    public void registerSidecar(@Nonnull MeshNode node) {
        Objects.requireNonNull(node, "node");
        Preconditions.checkState((this.sidecar == null ? 1 : 0) != 0, (Object)"A sidecar node has already been registered");
        this.sidecar = node;
    }

    @Transactional
    @Unsecured(value="This is internal API")
    public void resetHierarchy(int partitionId, @Nonnull String hierarchyId) {
        Objects.requireNonNull(hierarchyId, "hierarchyId");
        Preconditions.checkArgument((partitionId >= 0 ? 1 : 0) != 0, (Object)"partition must be a positive number");
        Page repositories = this.repositoryDao.findByHierarchyId(hierarchyId, PageUtils.newRequest((int)0, (int)1));
        if (repositories.getSize() == 0) {
            return;
        }
        Preconditions.checkArgument((boolean)repositories.stream().noneMatch(Repository::isRemote), (String)"hierarchy '%s' cannot be remote", (Object)hierarchyId);
        this.partitionRegistry.getPartition(partitionId).ifPresent(partition -> {
            HashSet<Long> offlineNodeIds = new HashSet<Long>();
            for (MeshPartitionReplica replica : partition.getReplicas()) {
                try {
                    int count = this.managementClient.resetHierarchy(replica.getNode(), partitionId, hierarchyId);
                    log.debug("Reset {} repositories in hierarchy {}/{} on {}", new Object[]{count, partitionId, hierarchyId, replica.getNode()});
                }
                catch (RepositoryOfflineException e) {
                    offlineNodeIds.add(replica.getNode().getId());
                }
            }
            if (offlineNodeIds.size() == partition.getReplicas().size()) {
                throw new MeshResetHierarchyFailedException(this.i18nService.createKeyedMessage("bitbucket.service.mesh.hierarchy.reset.failed", new Object[]{hierarchyId}), hierarchyId);
            }
            this.partitionRegistry.resetHierarchy(partitionId, hierarchyId);
            if (!offlineNodeIds.isEmpty()) {
                PagedIterable repos = new PagedIterable(request -> this.repositoryDao.findByHierarchyId(hierarchyId, request), PageUtils.newRequest((int)0, (int)1000));
                for (InternalRepository repository : repos) {
                    String id = RemoteRepositoryId.format((int)partitionId, (Repository)repository);
                    this.partitionRegistry.reportObservation(new MeshRepositoryReplicaObservation.Builder(id).nodeIds(offlineNodeIds).state(ReplicaState.INCONSISTENT).version(1L).build());
                }
            }
        });
    }

    @DefaultApplicationMode
    public void schedule(@Nonnull SchedulerService schedulerService) throws SchedulerServiceException {
        schedulerService.registerJobRunner(JOB_RUNNER_KEY, this::clusterMaintenanceJob);
        JobConfig jobConfig = JobConfig.forJobRunnerKey((JobRunnerKey)JOB_RUNNER_KEY).withRunMode(RunMode.RUN_ONCE_PER_CLUSTER).withSchedule(Schedule.forInterval((long)EVERY_HOUR, (Date)new Date(System.currentTimeMillis() + 60000L)));
        schedulerService.scheduleJob(JOB_ID, jobConfig);
    }

    @PreAuthorize(value="hasGlobalPermission('SYS_ADMIN')")
    public void unregister(long nodeId, final boolean force) {
        try (LockGuard ignored = LockGuard.lock((Lock)this.lockService.getLock(NODE_REGISTRATION_LOCK));){
            this.readWriteTransaction.executeWithoutResult(tx -> {
                final InternalMeshNode node = (InternalMeshNode)this.nodeDao.getById((Object)nodeId);
                if (node == null) {
                    throw this.newNoSuchMeshNodeException(nodeId);
                }
                List allNodes = this.nodeDao.getAll();
                Optional<InternalMeshNode> deletingNode = allNodes.stream().filter(n -> n.getInternalState() == MeshNode.State.DELETING).findAny();
                if (deletingNode.isPresent()) {
                    throw new IllegalEntityStateException(this.i18nService.createKeyedMessage("bitbucket.service.mesh.node.unregister.invalid.state", new Object[]{deletingNode.get().getRpcUrl()}));
                }
                if (this.partitionRegistry.hasNonEmptyPartition((MeshNode)node) && !force) {
                    this.checkForReplicationFactor(node, allNodes);
                }
                this.nodeDao.update((Object)new InternalMeshNode.Builder(node).state(MeshNode.State.DELETING).build());
                this.checkNoMigrationsRunning();
                final CompletionStage<Void> evacuateFuture = this.partitionAllocationStrategy.evacuateNode((MeshNode)node);
                this.transactionSynchronizer.register(new TransactionSynchronization(){

                    public void afterCommit() {
                        evacuateFuture.whenComplete((unused, throwable) -> {
                            log.info("Finished evacuating node identified by {}", (Object)node.getId());
                            if (throwable != null) {
                                log.error("Error while evacuating node {}", (Object)node.getId(), throwable);
                                return;
                            }
                            DefaultMeshService.this.readWriteTransaction.executeWithoutResult(tx2 -> DefaultMeshService.this.nodeDao.deleteById((Object)node.getId()));
                            DefaultMeshService.this.eventPublisher.publish((Object)new AnalyticsMeshNodeUnregisteredEvent((Object)this, node.getId()));
                            log.info("Unregistered Mesh node identified by {}{}", (Object)node.getId(), (Object)(force ? " forcefully" : ""));
                        }).exceptionally(throwable -> {
                            log.error("Error while deleting node", throwable);
                            return null;
                        });
                    }
                });
            });
        }
    }

    public void unschedule(@Nonnull SchedulerService schedulerService) {
        schedulerService.unscheduleJob(JOB_ID);
        schedulerService.unregisterJobRunner(JOB_RUNNER_KEY);
    }

    @Nonnull
    @PreAuthorize(value="hasGlobalPermission('SYS_ADMIN')")
    public MeshNode update(@Nonnull UpdateMeshNodeRequest request) {
        String requestRpcUrl;
        Objects.requireNonNull(request, "request");
        InternalMeshNode current = (InternalMeshNode)this.readOnlyTransaction.execute(tx -> this.getNodeOrThrow(request.getId()));
        InternalMeshNode previous = new InternalMeshNode.Builder(current).build();
        InternalMeshNode.Builder builder = new InternalMeshNode.Builder(current);
        String nodeName = request.getName();
        if (nodeName != null) {
            builder.name(nodeName);
        }
        if ((requestRpcUrl = request.getRpcUrl()) != null) {
            builder.rpcUrl(requestRpcUrl);
        }
        if (nodeName != null && !nodeName.equals(previous.getName())) {
            this.checkNameNotUsed(nodeName);
        }
        if (requestRpcUrl != null && !requestRpcUrl.equals(previous.getRpcUrl())) {
            this.checkIsValidUrl(requestRpcUrl);
            this.checkUrlNotUsed(requestRpcUrl);
            this.checkConnectivity(requestRpcUrl, nodeName);
        }
        InternalMeshNode updated = (InternalMeshNode)this.readWriteTransaction.execute(tx -> {
            MeshNode.State requestState = request.getState();
            if (requestState != null && requestState != previous.getState()) {
                builder.state(this.startStateTransition(previous, requestState));
            }
            return (InternalMeshNode)this.nodeDao.update((Object)builder.build());
        });
        if (!Objects.equals(previous.getName(), updated.getName())) {
            try {
                RpcNodeConfiguration.Builder nodeConfigBuilder = RpcNodeConfiguration.newBuilder();
                if (updated.getAvailabilityZone() != null) {
                    nodeConfigBuilder.putProperties("node.availability-zone", updated.getAvailabilityZone());
                }
                nodeConfigBuilder.putProperties("node.id", String.valueOf(updated.getId())).putProperties("node.name", updated.getName()).putProperties("node.rpc-url", updated.getRpcUrl());
                this.managementClient.updateConfig((MeshNode)previous, RpcSetConfigurationRequest.newBuilder().setNodeConfiguration(nodeConfigBuilder).build());
            }
            catch (RuntimeException e) {
                log.debug("Failed to update the node name for {} ({})", (Object)updated.getId(), (Object)updated.getRpcUrl());
            }
        }
        this.eventPublisher.publish((Object)new AnalyticsMeshNodeUpdatedEvent((Object)this, (MeshNode)updated));
        return updated;
    }

    @Nonnull
    @PreAuthorize(value="hasGlobalPermission('SYS_ADMIN')")
    @Transactional(propagation=Propagation.SUPPORTS)
    public MeshSettings updateSettings(@Nonnull MeshSettingsUpdateRequest request) {
        Objects.requireNonNull(request, "request");
        Boolean isRepositoryCreationEnabled = request.getRepositoryCreationEnabled();
        if (isRepositoryCreationEnabled != null) {
            this.propertiesService.setMeshRepositoryCreationEnabled(isRepositoryCreationEnabled.booleanValue());
        }
        return this.getSettings();
    }

    @PreAuthorize(value="hasGlobalPermission('SYS_ADMIN')")
    public void writeControlPlanePublicKey(@Nonnull OutputStream outputStream) throws IOException {
        Objects.requireNonNull(outputStream, "outputStream");
        this.keyManager.getSigningKey().writePublicKey(outputStream);
    }

    private void addConnectivityResultToZip(ZipOutputStream zipStream, List<MeshConnectivityReport> reports) throws IOException {
        zipStream.putNextEntry(new ZipEntry("Bitbucket_Mesh_Connectivity_Report.json"));
        try (JsonGenerator jg = new ObjectMapper().createGenerator((OutputStream)zipStream, JsonEncoding.UTF8).useDefaultPrettyPrinter();){
            jg.writeObject(reports);
        }
    }

    private void addNodeSupportZip(ZipOutputStream zipStream, Path supportFile) throws IOException {
        zipStream.putNextEntry(new ZipEntry(supportFile.getFileName().toString()));
        Files.copy(supportFile, zipStream);
        zipStream.closeEntry();
    }

    private void checkConnectivity(String rpcUrl, String name) {
        try {
            this.verifyConnectivityAndCompatibility(rpcUrl, name);
            log.info("Successful connection to {}", (Object)rpcUrl);
        }
        catch (MeshNodeConnectionException e) {
            log.debug("Unable to connect to {}: {}", (Object)rpcUrl, (Object)e);
            throw e;
        }
        catch (MeshNodeIncompatibleException e) {
            log.debug("Node {} is incompatible with {}", new Object[]{rpcUrl, ApplicationConstants.PRODUCT_NAME, e});
            throw e;
        }
    }

    private void checkForReplicationFactor(InternalMeshNode toBeDeleted, List<InternalMeshNode> allNodes) {
        long remainingNodes = allNodes.stream().filter(n -> n.getId() != toBeDeleted.getId()).filter(n -> n.getState() != MeshNode.State.DELETING).count();
        if (remainingNodes < (long)this.replicationFactor) {
            throw new IllegalEntityStateException(this.i18nService.createKeyedMessage("bitbucket.service.mesh.node.unregister.invalid.replication.factor", new Object[]{toBeDeleted.getRpcUrl(), this.replicationFactor}));
        }
    }

    private void checkIsValidUrl(String rpcUrl) {
        try {
            URI uri = new URI(rpcUrl);
            String scheme = StringUtils.lowerCase((String)uri.getScheme(), (Locale)Locale.ROOT);
            if (!VALID_SCHEMES.contains(scheme)) {
                throw new InvalidMeshNodeUrlException(this.i18nService.createKeyedMessage("bitbucket.service.mesh.node.connectivity.incorrectprotocol", new Object[]{rpcUrl}));
            }
            String host = uri.getHost();
            if (host == null) {
                throw new InvalidMeshNodeUrlException(this.i18nService.createKeyedMessage("bitbucket.service.mesh.node.invalid.url", new Object[]{rpcUrl}));
            }
            InetAddress address = InetAddress.getByName(host);
            if (!DevModeUtils.isEnabled() && address.isLoopbackAddress()) {
                throw new InvalidMeshNodeUrlException(this.i18nService.createKeyedMessage("bitbucket.service.mesh.node.invalid.localhost.url", new Object[0]));
            }
        }
        catch (URISyntaxException e) {
            throw new InvalidMeshNodeUrlException(this.i18nService.createKeyedMessage("bitbucket.service.mesh.node.invalid.url", new Object[]{rpcUrl}), (Throwable)e);
        }
        catch (UnknownHostException e) {
            throw new InvalidMeshNodeUrlException(this.i18nService.createKeyedMessage("bitbucket.service.mesh.node.connectivity.unresolvedaddress", new Object[]{rpcUrl}), (Throwable)e);
        }
    }

    private void checkNameNotUsed(String name) {
        if (this.readOnlyTransaction.execute(tx -> this.nodeDao.findByName(name)) != null) {
            throw new MeshNodeNameAlreadyExistsException(this.i18nService.createKeyedMessage("bitbucket.service.mesh.node.conflict.name", new Object[]{name}));
        }
    }

    private void checkNoMigrationsRunning() {
        Page migrationInProgress = this.partitionMigrationService.search(new MeshPartitionMigrationSearchRequest.Builder().states((Iterable)MeshPartitionMigrationJobState.NON_TERMINAL_STATES).build(), PageUtils.newRequest((int)0, (int)1));
        if (migrationInProgress.getSize() == 1) {
            MeshPartitionMigration migration = (MeshPartitionMigration)Iterables.get((Iterable)migrationInProgress.getValues(), (int)0);
            throw new IllegalEntityStateException(this.i18nService.createKeyedMessage("bitbucket.service.mesh.node.create.migration.running", new Object[]{migration.getId(), migration.getState()}));
        }
    }

    private void checkUrlNotUsed(String rpcUrl) {
        InternalMeshNode node = (InternalMeshNode)this.readOnlyTransaction.execute(tx -> this.nodeDao.getByIdOrUrl(null, rpcUrl));
        if (node != null) {
            throw new MeshNodeUrlAlreadyExistsException(this.i18nService.createKeyedMessage("bitbucket.service.mesh.node.conflict.url", new Object[]{rpcUrl}));
        }
    }

    private String chooseName(String name, String rpcUrl) {
        if (StringUtils.isBlank((CharSequence)name)) {
            try {
                URI uri = new URI(rpcUrl);
                Object host = uri.getHost();
                if (host != null) {
                    if (this.readOnlyTransaction.execute(tx -> this.nodeDao.findByName(uri.getHost())) != null) {
                        log.warn("Node name '{}' already exists. Appending port to node name.", host);
                        host = (String)host + "-" + uri.getPort();
                    }
                    return host;
                }
            }
            catch (URISyntaxException uRISyntaxException) {
                // empty catch block
            }
            return rpcUrl;
        }
        return name;
    }

    private void cleanupDeletingNodes() {
        List deletingMeshNodes = (List)this.readOnlyTransaction.execute(tx -> (List)this.nodeDao.getAll().stream().filter(node -> node.getInternalState() == MeshNode.State.DELETING).collect(MoreCollectors.toImmutableList()));
        deletingMeshNodes.forEach(deletingNode -> {
            log.debug("[{}] Attempting to unregister Mesh node.", deletingNode);
            Page activeMigrationsForNode = (Page)this.withSysAdmin.call(() -> this.partitionMigrationService.search(new MeshPartitionMigrationSearchRequest.Builder().states((Iterable)MeshPartitionMigrationJobState.NON_TERMINAL_STATES).sourceNodeId(deletingNode.getId()).build(), PageUtils.newRequest((int)0, (int)1)));
            if (activeMigrationsForNode.getSize() == 0) {
                this.readWriteTransaction.executeWithoutResult(tx2 -> this.nodeDao.deleteById((Object)deletingNode.getId()));
                this.eventPublisher.publish((Object)new AnalyticsMeshNodeUnregisteredEvent((Object)this, deletingNode.getId()));
                log.info("[{}] Unregistered Mesh node.", deletingNode);
            } else {
                log.debug("[{}] There are active migrations present for the Mesh node and we cannot unregister it. Will try again later.", deletingNode);
            }
        });
    }

    private JobRunnerResponse clusterMaintenanceJob(JobRunnerRequest request) {
        try (LockGuard guard = LockGuard.tryLock((Lock)this.lockService.getLock(JOB_NAME));){
            if (guard != null) {
                this.disableDrainedNodes();
                this.cleanupDeletingNodes();
            }
        }
        catch (Exception e) {
            return JobRunnerResponse.failed((Throwable)e);
        }
        return JobRunnerResponse.success();
    }

    @Nonnull
    private InternalMeshNode createNode(String name, RegisterMeshNodeRequest request) {
        InternalMeshNode node = (InternalMeshNode)this.nodeDao.create((Object)new InternalMeshNode.Builder().availabilityZone(request.getAvailabilityZone()).name(name).rpcUrl(request.getRpcUrl()).build());
        Optional publicKey = this.managementClient.provisionNode((MeshNode)node);
        if (publicKey.isPresent()) {
            this.keyManager.addKey((MeshNode)node, (PublicKey)publicKey.get());
        } else {
            log.debug("{}: Authentication is disabled", (Object)node);
        }
        this.partitionAllocationStrategy.rebalancePartitionsToNode((MeshNode)node);
        this.partitionAllocationStrategy.ensurePartitionCount();
        return node;
    }

    private void disableDrainedNodes() {
        List nodes = (List)this.readOnlyTransaction.execute(tx -> this.nodeDao.getAll());
        for (InternalMeshNode node : nodes) {
            if (node.getInternalState() != MeshNode.State.DRAINING) continue;
            new DrainAndDisableNodeTask((MeshNode)node).run();
        }
    }

    private Path getErrorSupportFile(Throwable e, long id) throws IOException {
        Path errorPath = Files.createTempFile("mesh-node-" + id + "-error-", ".txt", new FileAttribute[0]);
        MoreFiles.write((Path)errorPath, (String)String.format("Failed to create support zip: %s\n", e.getMessage()), (OpenOption[])new OpenOption[0]);
        return errorPath;
    }

    @Nonnull
    private InternalMeshNode getNodeOrThrow(long id) {
        InternalMeshNode node = (InternalMeshNode)this.nodeDao.getById((Object)id);
        if (node == null) {
            throw this.newNoSuchMeshNodeException(id);
        }
        return node;
    }

    private NoSuchMeshNodeException newNoSuchMeshNodeException(long id) {
        return new NoSuchMeshNodeException(this.i18nService.createKeyedMessage("bitbucket.service.mesh.node.notfound", new Object[]{id}));
    }

    private MeshNode.State startStateTransition(final InternalMeshNode node, MeshNode.State state) {
        MeshNode.State previous = node.getInternalState();
        if (previous == MeshNode.State.DELETING) {
            log.debug("[{}] Canceling node deletion", (Object)node);
        }
        switch (state) {
            case AVAILABLE: {
                return MeshNode.State.AVAILABLE;
            }
            case DISABLED: {
                if (node.isSidecar()) {
                    throw new InvalidMeshNodeStateException(this.i18nService.createKeyedMessage("bitbucket.service.mesh.sidecar.cannot.disable", new Object[0]));
                }
                this.transactionSynchronizer.register(new TransactionSynchronization(){

                    public void afterCommit() {
                        new DrainAndDisableNodeTask((MeshNode)node).run();
                    }
                });
                return MeshNode.State.DRAINING;
            }
            case DELETING: 
            case DRAINING: 
            case OFFLINE: {
                throw new InvalidMeshNodeStateException(this.i18nService.createKeyedMessage("bitbucket.service.mesh.node.transitional.state", new Object[]{state.name()}));
            }
        }
        throw new IllegalArgumentException("Unexpected state " + String.valueOf(state));
    }

    private void verifyConnectivityAndCompatibility(String rpcUrl, String name) {
        this.capabilityClient.verifyConnectivityAndCompatibility((MeshNode)new InternalMeshNode.Builder().name(name == null ? "check-connectivity" : name).rpcUrl(rpcUrl).build());
    }

    public static class ClusterConnectivityCallback
    extends ResultCollectingExecutionCallback<List<MeshConnectivitySummary>> {
        private final Map<ClusterNode, List<MeshConnectivitySummary>> results = new ConcurrentHashMap<ClusterNode, List<MeshConnectivitySummary>>();
        private final long timeout;

        public ClusterConnectivityCallback(long timeout) {
            this.timeout = timeout;
        }

        public List<MeshConnectivityReport> getResult() {
            try {
                if (!this.await(this.timeout, TimeUnit.SECONDS)) {
                    log.warn("The Mesh connectivity report may be incomplete");
                }
                ImmutableList.Builder builder = ImmutableList.builder();
                for (Map.Entry<ClusterNode, List<MeshConnectivitySummary>> result : this.results.entrySet()) {
                    ClusterNode clusterNode = result.getKey();
                    builder.add((Object)new MeshConnectivityReport(new ConnectivityNode(clusterNode.getId(), clusterNode.getName(), ConnectivityReportNodeType.BITBUCKET), result.getValue()));
                }
                return builder.build();
            }
            catch (InterruptedException e) {
                Thread.currentThread().interrupt();
                throw new ClusterExecutionException("Interrupted while getting connectivity status of Bitbucket to Mesh nodes", (Throwable)e);
            }
        }

        @Override
        protected void onError(Member member, Throwable e) {
            log.error("Received error for {}", (Object)NutclusterClusterNode.transform(member), (Object)e);
            this.results.put(NutclusterClusterNode.transform(member), Collections.emptyList());
        }

        @Override
        protected void onSuccess(Member member, List<MeshConnectivitySummary> result) {
            ClusterNode node = NutclusterClusterNode.transform(member);
            this.results.put(node, result);
        }
    }

    @SpringAware
    public static final class GetClusterConnectivityResults
    implements Callable<List<MeshConnectivitySummary>>,
    Serializable {
        private transient DmzMeshService meshService;

        @Override
        public List<MeshConnectivitySummary> call() {
            return this.meshService.getConnectivitySummaries();
        }

        @Autowired
        public void setMeshService(DmzMeshService meshService) {
            this.meshService = meshService;
        }
    }

    class DrainAndDisableNodeTask
    implements Runnable {
        private final MeshNode node;
        private int attempt;

        DrainAndDisableNodeTask(MeshNode node) {
            this.node = node;
        }

        @Override
        public void run() {
            this.drainThenDisableAsync();
        }

        private boolean disableNode() {
            return (Boolean)DefaultMeshService.this.readWriteTransaction.execute(tx -> {
                InternalMeshNode drained = (InternalMeshNode)DefaultMeshService.this.nodeDao.getById((Object)this.node.getId());
                if (this.maybeAbortDrain(drained)) {
                    return false;
                }
                DefaultMeshService.this.nodeDao.update((Object)new InternalMeshNode.Builder(drained).state(MeshNode.State.DISABLED).build());
                return true;
            });
        }

        private void drainThenDisableAsync() {
            ++this.attempt;
            InternalMeshNode current = (InternalMeshNode)DefaultMeshService.this.readOnlyTransaction.execute(tx -> (InternalMeshNode)DefaultMeshService.this.nodeDao.getById((Object)this.node.getId()));
            if (this.maybeAbortDrain(current)) {
                return;
            }
            DefaultMeshService.this.managementClient.drainNode((MeshNode)current).whenComplete((result, throwable) -> {
                if (throwable != null) {
                    if (current.isOffline()) {
                        log.info("Node {} was/went offline while draining. Assuming draining is complete.", (Object)current, (Object)(throwable instanceof RepositoryOfflineException ? null : throwable));
                    } else {
                        if (this.attempt < 3) {
                            log.info("Retrying draining of node {} after failure (attempt {}/{}).", new Object[]{current, this.attempt + 1, 3, throwable});
                            this.drainThenDisableAsync();
                            return;
                        }
                        log.warn("Abandoning draining of node {} after {} failed attempts", new Object[]{current, this.attempt, throwable});
                        return;
                    }
                }
                if (this.disableNode()) {
                    log.info("Node {} has drained and has now been disabled", (Object)this.node);
                    DefaultMeshService.this.eventPublisher.publish((Object)new AnalyticsMeshNodeUpdatedEvent((Object)this, this.node));
                }
            });
        }

        private boolean maybeAbortDrain(InternalMeshNode current) {
            if (current == null) {
                log.info("Aborted draining node {}. The node has been deleted", (Object)this.node);
                return true;
            }
            if (current.getInternalState() != MeshNode.State.DRAINING) {
                if (current.getInternalState() != MeshNode.State.DISABLED) {
                    log.info("Draining of node {} was aborted (state = {})", (Object)current, (Object)current.getInternalState());
                }
                return true;
            }
            return false;
        }
    }
}

