/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.stash.internal.mesh;

import com.atlassian.stash.internal.mesh.RingHasher;
import com.google.common.base.Preconditions;
import com.google.common.hash.HashFunction;
import com.google.common.hash.Hasher;

public class DefaultRingHasher
implements RingHasher {
    private final HashFunction hashFunction;

    public DefaultRingHasher(HashFunction hashFunction) {
        this.hashFunction = hashFunction;
    }

    @Override
    public long hash(long value) {
        Hasher hasher = this.hashFunction.newHasher();
        hasher.putLong(value);
        return DefaultRingHasher.normaliseHash(hasher.hash().asLong());
    }

    @Override
    public long hash(long value1, long value2) {
        Hasher hasher = this.hashFunction.newHasher();
        hasher.putLong(value1);
        hasher.putLong(value2);
        return DefaultRingHasher.normaliseHash(hasher.hash().asLong());
    }

    @Override
    public long hashWithBounds(long value, long lowerBound, long upperBound) {
        Preconditions.checkArgument((lowerBound >= 0L ? 1 : 0) != 0, (Object)"lowerBound must be >= 0");
        Preconditions.checkArgument((upperBound >= 0L ? 1 : 0) != 0, (Object)"upperBound must be >= 0");
        return lowerBound + this.hash(value) % DefaultRingHasher.segmentSize(lowerBound, upperBound);
    }

    @Override
    public long hashWithUpperBound(long value, long upperBound) {
        Preconditions.checkArgument((upperBound >= 0L ? 1 : 0) != 0, (Object)"upperBound must be >= 0");
        return this.hashWithBounds(value, 0L, upperBound);
    }

    private static long normaliseHash(long hash) {
        return hash < 0L ? hash + Long.MAX_VALUE + 1L : hash;
    }

    private static long segmentSize(long lowerBound, long upperBound) {
        if (lowerBound > upperBound) {
            return Long.MAX_VALUE - lowerBound + upperBound;
        }
        return upperBound - lowerBound;
    }
}

