/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.stash.internal.mesh;

import com.atlassian.stash.internal.mesh.RingMap;
import com.google.common.base.Preconditions;
import jakarta.annotation.Nonnull;
import jakarta.annotation.Nullable;
import java.util.Map;
import java.util.NavigableMap;
import java.util.Objects;
import java.util.TreeMap;

public class DefaultRingMap<T>
implements RingMap<T> {
    private final NavigableMap<Long, T> ring = new TreeMap<Long, T>();

    @Override
    @Nullable
    public RingMap.Entry<T> nextEntry(long key) {
        Preconditions.checkArgument((key >= 0L ? 1 : 0) != 0, (Object)"key must be >= 0");
        Map.Entry<Long, T> nextEntry = this.ring.higherEntry(key);
        if (nextEntry == null) {
            nextEntry = this.ring.firstEntry();
        }
        return nextEntry == null ? null : new RingMapEntry<T>(nextEntry);
    }

    @Override
    @Nullable
    public RingMap.Entry<T> previousEntry(long key) {
        Preconditions.checkArgument((key >= 0L ? 1 : 0) != 0, (Object)"key must be >= 0");
        Map.Entry<Long, T> previousEntry = this.ring.lowerEntry(key);
        if (previousEntry == null) {
            previousEntry = this.ring.lastEntry();
        }
        return previousEntry == null ? null : new RingMapEntry<T>(previousEntry);
    }

    @Override
    public void put(long key, @Nonnull T value) {
        Preconditions.checkArgument((key >= 0L ? 1 : 0) != 0, (Object)"key must be >= 0");
        Objects.requireNonNull(value, "value");
        this.ring.put(key, value);
    }

    private static class RingMapEntry<T>
    implements RingMap.Entry<T> {
        private final long key;
        private final T value;

        private RingMapEntry(@Nonnull Map.Entry<Long, T> entry) {
            Objects.requireNonNull(entry, "entry");
            this.key = entry.getKey();
            this.value = entry.getValue();
        }

        @Override
        public long getKey() {
            return this.key;
        }

        @Override
        public T getValue() {
            return this.value;
        }
    }
}

