/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.stash.internal.mesh;

import com.atlassian.bitbucket.dmz.mesh.MeshConfigProvider;
import com.google.common.collect.ImmutableMap;
import com.google.common.hash.Hasher;
import com.google.common.hash.Hashing;
import jakarta.annotation.Nonnull;
import java.io.Serializable;
import java.nio.charset.StandardCharsets;
import java.util.HashMap;
import java.util.Map;
import java.util.Objects;

class MeshConfig
implements Serializable {
    private static final long serialVersionUID = 6203984716045638662L;
    private final ImmutableMap<String, String> properties;
    private final boolean update;
    private volatile String hash;

    private MeshConfig(Builder builder) {
        this.properties = ImmutableMap.copyOf(builder.properties);
        this.update = builder.update;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        MeshConfig that = (MeshConfig)o;
        return this.properties.equals(that.properties);
    }

    @Nonnull
    public String getHash() {
        if (this.hash == null) {
            Hasher hasher = Hashing.sha256().newHasher();
            this.properties.forEach((key, value) -> hasher.putString((CharSequence)key, StandardCharsets.UTF_8).putByte((byte)0).putString((CharSequence)value, StandardCharsets.UTF_8).putByte((byte)0));
            this.hash = hasher.hash().toString();
        }
        return this.hash;
    }

    @Nonnull
    public Map<String, String> getProperties() {
        return this.properties;
    }

    public int hashCode() {
        return Objects.hash(this.properties);
    }

    public boolean isUpdate() {
        return this.update;
    }

    @Nonnull
    public MeshConfig merge(MeshConfig other) {
        HashMap<String, String> properties = new HashMap<String, String>();
        properties.putAll((Map<String, String>)this.properties);
        properties.putAll((Map<String, String>)other.properties);
        return new Builder(this.update || other.update).putAll(properties).build();
    }

    @Nonnull
    static MeshConfig fullConfig(@Nonnull Iterable<MeshConfigProvider> providers) {
        return new Builder(false).mergeAll(providers).build();
    }

    @Nonnull
    static MeshConfig update(@Nonnull MeshConfigProvider provider) {
        return new Builder(true).merge(provider).build();
    }

    static class Builder
    implements MeshConfigProvider.ConfigBuilder {
        private final Map<String, String> properties = new HashMap<String, String>();
        private final boolean update;

        Builder(boolean update) {
            this.update = update;
        }

        @Nonnull
        public MeshConfig build() {
            return new MeshConfig(this);
        }

        @Nonnull
        public Builder merge(@Nonnull MeshConfigProvider provider) {
            Objects.requireNonNull(provider, "provider").mergeConfig((MeshConfigProvider.ConfigBuilder)this);
            return this;
        }

        @Nonnull
        public Builder mergeAll(@Nonnull Iterable<MeshConfigProvider> providers) {
            Objects.requireNonNull(providers, "providers").forEach(this::merge);
            return this;
        }

        @Nonnull
        public Builder put(@Nonnull String key, Object value) {
            this.properties.put(Objects.requireNonNull(key, "key"), value == null ? "" : String.valueOf(value));
            return this;
        }

        @Nonnull
        public Builder putAll(@Nonnull Map<String, String> value) {
            this.properties.putAll(Objects.requireNonNull(value, "properties"));
            return this;
        }
    }
}

