/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.stash.internal.mesh;

import jakarta.annotation.Nonnull;
import java.io.ByteArrayInputStream;
import java.io.ByteArrayOutputStream;
import java.io.DataInputStream;
import java.io.DataOutputStream;
import java.io.IOException;
import java.nio.charset.StandardCharsets;
import java.security.InvalidAlgorithmParameterException;
import java.security.InvalidKeyException;
import java.security.Key;
import java.security.NoSuchAlgorithmException;
import java.security.PrivateKey;
import java.security.PublicKey;
import java.security.SecureRandom;
import java.util.Base64;
import java.util.Objects;
import javax.crypto.BadPaddingException;
import javax.crypto.Cipher;
import javax.crypto.IllegalBlockSizeException;
import javax.crypto.KeyGenerator;
import javax.crypto.NoSuchPaddingException;
import javax.crypto.SecretKey;
import javax.crypto.spec.GCMParameterSpec;

public class MeshKeySecurityUtils {
    private static final String AES_CIPHER_ALGORITHM = "AES/GCM/NoPadding";
    private static final String AES_KEY_ALGORITHM = "AES";

    private MeshKeySecurityUtils() {
        throw new UnsupportedOperationException(this.getClass().getName() + " is a utility class");
    }

    @Nonnull
    public static String decrypt(@Nonnull String message, @Nonnull PrivateKey privateKey) {
        String string;
        Objects.requireNonNull(message, "message");
        Objects.requireNonNull(privateKey, "privateKey");
        byte[] cipherBytes = Base64.getDecoder().decode(message);
        DataInputStream dataStream = new DataInputStream(new ByteArrayInputStream(cipherBytes));
        try {
            byte[] encryptedAesKey = new byte[dataStream.readShort()];
            dataStream.readFully(encryptedAesKey);
            byte[] initializationVector = new byte[dataStream.readShort()];
            dataStream.readFully(initializationVector);
            byte[] encryptedMessage = new byte[dataStream.available()];
            dataStream.readFully(encryptedMessage);
            Cipher rsaCipher = Cipher.getInstance(privateKey.getAlgorithm());
            rsaCipher.init(4, privateKey);
            Key aesKey = rsaCipher.unwrap(encryptedAesKey, AES_KEY_ALGORITHM, 3);
            Cipher aesCipher = Cipher.getInstance(AES_CIPHER_ALGORITHM);
            GCMParameterSpec spec = new GCMParameterSpec(128, initializationVector);
            aesCipher.init(2, aesKey, spec);
            byte[] decryptedMessage = aesCipher.doFinal(encryptedMessage);
            string = new String(decryptedMessage, StandardCharsets.UTF_8);
        }
        catch (Throwable throwable) {
            try {
                try {
                    dataStream.close();
                }
                catch (Throwable throwable2) {
                    throwable.addSuppressed(throwable2);
                }
                throw throwable;
            }
            catch (IOException | InvalidAlgorithmParameterException | InvalidKeyException | NoSuchAlgorithmException | BadPaddingException | IllegalBlockSizeException | NoSuchPaddingException e) {
                throw new MeshKeySecurityException(e);
            }
        }
        dataStream.close();
        return string;
    }

    @Nonnull
    public static String encrypt(@Nonnull String message, @Nonnull PublicKey publicKey) {
        Objects.requireNonNull(message, "message");
        Objects.requireNonNull(publicKey, "publicKey");
        try {
            KeyGenerator keygen = KeyGenerator.getInstance(AES_KEY_ALGORITHM);
            keygen.init(256);
            SecretKey aesKey = keygen.generateKey();
            byte[] initializationVector = new byte[12];
            SecureRandom random = new SecureRandom();
            random.nextBytes(initializationVector);
            Cipher aesCipher = Cipher.getInstance(AES_CIPHER_ALGORITHM);
            GCMParameterSpec spec = new GCMParameterSpec(128, initializationVector);
            aesCipher.init(1, (Key)aesKey, spec);
            byte[] encryptedMessage = aesCipher.doFinal(message.getBytes(StandardCharsets.UTF_8));
            Cipher rsaCipher = Cipher.getInstance(publicKey.getAlgorithm());
            rsaCipher.init(3, publicKey);
            byte[] encryptedAesKey = rsaCipher.wrap(aesKey);
            ByteArrayOutputStream byteStream = new ByteArrayOutputStream();
            try (DataOutputStream dataStream = new DataOutputStream(byteStream);){
                dataStream.writeShort(encryptedAesKey.length);
                dataStream.write(encryptedAesKey);
                dataStream.writeShort(initializationVector.length);
                dataStream.write(initializationVector);
                dataStream.write(encryptedMessage);
            }
            return Base64.getEncoder().encodeToString(byteStream.toByteArray());
        }
        catch (IOException | InvalidAlgorithmParameterException | InvalidKeyException | NoSuchAlgorithmException | BadPaddingException | IllegalBlockSizeException | NoSuchPaddingException e) {
            throw new MeshKeySecurityException(e);
        }
    }

    public static class MeshKeySecurityException
    extends IllegalStateException {
        public MeshKeySecurityException() {
        }

        public MeshKeySecurityException(Throwable cause) {
            super(cause);
        }
    }
}

