/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.stash.internal.mesh;

import com.atlassian.bitbucket.cluster.ClusterService;
import com.atlassian.bitbucket.dmz.mesh.DmzMeshService;
import com.atlassian.bitbucket.dmz.migration.MeshMigrationContext;
import com.atlassian.bitbucket.dmz.migration.MeshMigrator;
import com.atlassian.bitbucket.dmz.migration.MigrationStep;
import com.atlassian.bitbucket.dmz.repository.DmzRepository;
import com.atlassian.bitbucket.event.cluster.ClusterNodeAddedEvent;
import com.atlassian.bitbucket.event.mesh.MeshNodeAvailabilityChangedEvent;
import com.atlassian.bitbucket.i18n.I18nService;
import com.atlassian.bitbucket.internal.mesh.RpcManagementClient;
import com.atlassian.bitbucket.mesh.MeshNode;
import com.atlassian.bitbucket.permission.Permission;
import com.atlassian.bitbucket.repository.Repository;
import com.atlassian.bitbucket.repository.RepositoryOfflineException;
import com.atlassian.bitbucket.topic.Topic;
import com.atlassian.bitbucket.topic.TopicService;
import com.atlassian.bitbucket.topic.TopicSettings;
import com.atlassian.bitbucket.user.EscalatedSecurityContext;
import com.atlassian.bitbucket.user.SecurityService;
import com.atlassian.event.api.EventListener;
import com.atlassian.stash.internal.InternalConverter;
import com.atlassian.stash.internal.repository.InternalRepository;
import com.atlassian.stash.internal.repository.InternalRepositoryService;
import com.atlassian.stash.internal.repository.RepositoryReadOnlyChangedEvent;
import com.google.common.collect.ImmutableSet;
import jakarta.annotation.Nonnull;
import jakarta.annotation.PostConstruct;
import jakarta.annotation.PreDestroy;
import java.io.Serializable;
import java.util.Collection;
import java.util.List;
import java.util.concurrent.ExecutorService;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.boot.autoconfigure.condition.ConditionalOnProperty;
import org.springframework.context.ApplicationListener;
import org.springframework.context.event.ContextRefreshedEvent;
import org.springframework.stereotype.Component;

@Component
@ConditionalOnProperty(name={"mesh.enabled"}, havingValue="true")
public class MeshReadOnlyController
implements ApplicationListener<ContextRefreshedEvent>,
MeshMigrator {
    static final String READ_ONLY_MODE_TOPIC_NAME = "atl.bbs.mesh.readonly";
    private static final Logger log = LoggerFactory.getLogger(MeshReadOnlyController.class);
    private final ClusterService clusterService;
    private final ExecutorService executorService;
    private final I18nService i18nService;
    private final RpcManagementClient managementClient;
    private final DmzMeshService meshService;
    private final Topic<Integer> readOnlyModeTopic;
    private final InternalRepositoryService repositoryService;
    private final EscalatedSecurityContext withRepoRead;
    private final EscalatedSecurityContext withSysAdmin;
    private boolean initialized;
    private String readOnlyModeSubscriptionId;

    @Autowired
    MeshReadOnlyController(ClusterService clusterService, ExecutorService executorService, I18nService i18nService, RpcManagementClient managementClient, DmzMeshService meshService, InternalRepositoryService repositoryService, SecurityService securityService, TopicService topicService) {
        this.clusterService = clusterService;
        this.executorService = executorService;
        this.i18nService = i18nService;
        this.managementClient = managementClient;
        this.meshService = meshService;
        this.repositoryService = repositoryService;
        this.readOnlyModeTopic = topicService.getTopic(READ_ONLY_MODE_TOPIC_NAME, new TopicSettings.Builder(Integer.class).dedupePendingMessages(true).build());
        this.withRepoRead = securityService.withPermission(Permission.REPO_READ, this.getClass().getSimpleName());
        this.withSysAdmin = securityService.withPermission(Permission.SYS_ADMIN, this.getClass().getSimpleName());
    }

    @PreDestroy
    public void destroy() {
        if (this.readOnlyModeSubscriptionId != null) {
            this.readOnlyModeTopic.unsubscribe(this.readOnlyModeSubscriptionId);
            this.readOnlyModeSubscriptionId = null;
        }
    }

    public int getPhase() {
        return Integer.MAX_VALUE;
    }

    @PostConstruct
    public void init() {
        this.readOnlyModeSubscriptionId = this.readOnlyModeTopic.subscribe(msg -> this.handleReadOnlyModeMessage((Integer)msg.getMessage()));
    }

    public void onApplicationEvent(@Nonnull ContextRefreshedEvent event) {
        if (!this.initialized) {
            this.initialized = true;
            this.executorService.execute(() -> this.getManagedNodes().forEach(this::replaceReadOnlyRepositories));
        }
    }

    @EventListener
    public void onClusterNodeAdded(ClusterNodeAddedEvent event) {
        if (event.isMaybeNetworkPartitionResolved()) {
            this.executorService.execute(() -> this.getManagedNodes().forEach(this::replaceReadOnlyRepositories));
        }
    }

    @EventListener
    public void onMeshNodeAvailabilityChanged(MeshNodeAvailabilityChangedEvent event) {
        if (event.isAvailable() && (this.clusterService.isLeader() || event.getNode().isSidecar())) {
            this.executorService.execute(() -> this.replaceReadOnlyRepositories(event.getNode()));
        }
    }

    @EventListener
    public void onRepositoryReadOnlyChangedEvent(RepositoryReadOnlyChangedEvent event) {
        this.readOnlyModeTopic.publish((Serializable)Integer.valueOf(event.getRepository().getId()));
    }

    public MeshMigrator.HierarchyMigration startHierarchy(@Nonnull MeshMigrationContext context, @Nonnull String hierarchyId, int partition) {
        return new ReadOnlyHierarchyMigration(context, hierarchyId, partition);
    }

    private void handleReadOnlyModeMessage(Integer repositoryId) {
        this.executorService.execute(() -> {
            Repository repository = (Repository)this.withRepoRead.call(() -> this.repositoryService.getById(repositoryId.intValue()));
            if (repository == null) {
                log.debug("Failed to find repository with ID {} for read-only mode update", (Object)repositoryId);
                return;
            }
            boolean readOnly = repository.isReadOnly();
            this.getManagedNodes(repository.getPartition()).forEach(node -> {
                try {
                    this.managementClient.setRepositoryReadOnly(node, repository, readOnly);
                }
                catch (RepositoryOfflineException e) {
                    log.debug("[{}] Failed to set readonly status to {} on offline node {}", new Object[]{repository, readOnly, node});
                }
                catch (RuntimeException e) {
                    log.warn("[{}] Failed to set readonly status to {} on node {}", new Object[]{repository, readOnly, node});
                }
            });
        });
    }

    private void replaceReadOnlyRepositories(MeshNode node) {
        try {
            this.managementClient.replaceReadOnlyRepositories(node);
        }
        catch (RepositoryOfflineException e) {
            log.debug("Failed to update the set of readonly repositories on Mesh node {} because it is offline", (Object)node);
        }
        catch (RuntimeException e) {
            log.warn("Failed to update the set of readonly repositories on Mesh node {}", (Object)node, (Object)e);
        }
    }

    private Collection<MeshNode> getManagedNodes() {
        return (Collection)this.withSysAdmin.call(() -> this.clusterService.isLeader() ? this.meshService.getMembers() : (Collection)this.meshService.getSidecar().map(ImmutableSet::of).orElseGet(ImmutableSet::of));
    }

    private Collection<MeshNode> getManagedNodes(int partition) {
        return (Collection)this.withSysAdmin.call(() -> {
            if (partition < 0) {
                return (Collection)this.meshService.getSidecar().map(ImmutableSet::of).orElseGet(ImmutableSet::of);
            }
            return this.clusterService.isLeader() ? this.meshService.getMembersByPartition(partition) : ImmutableSet.of();
        });
    }

    private class ReadOnlyHierarchyMigration
    implements MeshMigrator.HierarchyMigration {
        private final MeshMigrationContext context;
        private final String hierarchyId;
        private final int partition;

        private ReadOnlyHierarchyMigration(MeshMigrationContext context, String hierarchyId, int partition) {
            this.context = context;
            this.hierarchyId = hierarchyId;
            this.partition = partition;
        }

        public void abort() {
        }

        public void complete(@Nonnull MigrationStep step) {
            List nodes = (List)MeshReadOnlyController.this.withSysAdmin.call(() -> MeshReadOnlyController.this.meshService.getMembersByPartition(this.partition));
            MeshReadOnlyController.this.repositoryService.streamReadOnlyByHierarchy(this.hierarchyId, repository -> {
                this.markReadOnly(repository, nodes);
                return true;
            });
        }

        public void stage(@Nonnull Repository sourceRepository, @Nonnull DmzRepository destinationRepository, @Nonnull MigrationStep step) {
        }

        private void markReadOnly(Repository repository, List<MeshNode> nodes) {
            InternalRepository meshRepository = new InternalRepository.Builder(InternalConverter.convertToInternalRepository((Repository)repository)).partition(this.partition).build();
            nodes.forEach(arg_0 -> this.lambda$markReadOnly$2((Repository)meshRepository, repository, arg_0));
        }

        private /* synthetic */ void lambda$markReadOnly$2(Repository meshRepository, Repository repository, MeshNode node) {
            try {
                MeshReadOnlyController.this.managementClient.setRepositoryReadOnly(node, meshRepository, true);
            }
            catch (RuntimeException e) {
                this.context.addError(MeshReadOnlyController.this.i18nService.createKeyedMessage("bitbucket.service.mesh.migration.readonly.failed", new Object[]{repository.getProject().getKey(), repository.getSlug(), node.toString()}), (Object)repository, (Throwable)e);
                throw e;
            }
        }
    }
}

