/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.stash.internal.mesh;

import com.atlassian.bitbucket.dmz.mesh.DmzMeshNodeRegistry;
import com.atlassian.bitbucket.dmz.mesh.DmzMeshPartitionRegistry;
import com.atlassian.bitbucket.dmz.mesh.DmzMeshService;
import com.atlassian.bitbucket.dmz.mesh.MeshPartition;
import com.atlassian.bitbucket.internal.mesh.RpcManagementClient;
import com.atlassian.bitbucket.internal.mesh.support.SupportInfo;
import com.atlassian.bitbucket.internal.mesh.support.TicketInfo;
import com.atlassian.bitbucket.mesh.MeshNode;
import com.atlassian.troubleshooting.spi.RootLevelSupportDataAppender;
import com.atlassian.troubleshooting.spi.SupportDataBuilder;
import java.time.Instant;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import org.springframework.stereotype.Component;

@Component(value="meshSupportData")
public class MeshSupportData
extends RootLevelSupportDataAppender {
    private static final String MESH = "bitbucket.atst.mesh";
    private static final String MESH_NODE = "bitbucket.atst.mesh.node";
    private static final String NODE_ID = "bitbucket.atst.mesh.node.id";
    private static final String NODE_NAME = "bitbucket.atst.mesh.node.name";
    private static final String NODE_URL = "bitbucket.atst.mesh.node.url";
    private static final String NODE_IS_AVAILABLE = "bitbucket.atst.mesh.node.is.available";
    private static final String PARTITIONS = "bitbucket.atst.partitions";
    private static final String PARTITION = "bitbucket.atst.partitions.partition";
    private static final String PARTITION_ID = "bitbucket.atst.partitions.partition.id";
    private static final String PARTITION_REPLICAS = "bitbucket.atst.partitions.partition.replicas";
    private static final String PARTITION_REPLICA = "bitbucket.atst.partitions.partition.replicas.replica";
    private static final String PARTITION_REPOSITORIES = "bitbucket.atst.partitions.partition.repositories";
    private final RpcManagementClient managementClient;
    private final DmzMeshService meshService;
    private final DmzMeshNodeRegistry nodeRegistry;
    private final DmzMeshPartitionRegistry partitionRegistry;

    public MeshSupportData(Optional<RpcManagementClient> managementClient, Optional<DmzMeshService> meshService, Optional<DmzMeshNodeRegistry> nodeRegistry, Optional<DmzMeshPartitionRegistry> partitionRegistry) {
        this.managementClient = managementClient.orElse(null);
        this.meshService = meshService.orElse(null);
        this.nodeRegistry = nodeRegistry.orElse(null);
        this.partitionRegistry = partitionRegistry.orElse(null);
    }

    protected void addSupportData(SupportDataBuilder supportDataBuilder) {
        if (this.nodeRegistry == null || this.managementClient == null || this.meshService == null || this.partitionRegistry == null) {
            return;
        }
        this.addMeshData(supportDataBuilder);
        this.addPartitionsData(supportDataBuilder);
    }

    private void addMeshData(SupportDataBuilder builder) {
        List nodes = this.meshService.getMembers();
        if (!nodes.isEmpty()) {
            SupportDataBuilder meshData = builder.addCategory(MESH);
            nodes.forEach(node -> this.addNodeData((MeshNode)node, meshData.addCategory(MESH_NODE)));
        }
    }

    private void addNodeData(MeshNode node, SupportDataBuilder builder) {
        builder.addValue(NODE_ID, String.valueOf(node.getId())).addValue(NODE_NAME, node.getName()).addValue(NODE_URL, node.getRpcUrl());
        if (this.nodeRegistry.isAvailable(node)) {
            builder.addValue(NODE_IS_AVAILABLE, String.valueOf(true));
            this.managementClient.getSupportInfo(node).ifPresent(info -> this.addRemoteNodeData((SupportInfo)info, builder));
        } else {
            builder.addValue(NODE_IS_AVAILABLE, String.valueOf(false));
        }
    }

    private void addPartitionsData(SupportDataBuilder builder) {
        SupportDataBuilder partitionsSummary = builder.addCategory(PARTITIONS);
        Map repoCount = this.partitionRegistry.countRepositoriesPerPartition();
        repoCount.forEach((partitionId, count) -> {
            SupportDataBuilder partitionBuilder = partitionsSummary.addCategory(PARTITION).addValue(PARTITION_ID, partitionId == -1 ? "Default" : Integer.toString(partitionId)).addValue(PARTITION_REPOSITORIES, Long.toString(count));
            this.partitionRegistry.getPartition(partitionId.intValue()).ifPresent(partition -> this.addReplicasData((MeshPartition)partition, partitionBuilder));
        });
    }

    private void addRemoteNodeData(SupportInfo info, SupportDataBuilder builder) {
        builder.addValue("git", info.getGitInfo().getCurrent() + "(" + info.getGitInfo().getStartup() + ")");
        SupportDataBuilder throttling = builder.addCategory("throttling");
        info.getTicketInfo().forEach(ticketInfo -> this.addTicketData((TicketInfo)ticketInfo, throttling.addCategory(ticketInfo.getResource())));
    }

    private void addReplicasData(MeshPartition partition, SupportDataBuilder builder) {
        List replicas = partition.getReplicas();
        if (!replicas.isEmpty()) {
            SupportDataBuilder replicasBuilder = builder.addCategory(PARTITION_REPLICAS);
            replicas.forEach(replica -> replicasBuilder.addValue(PARTITION_REPLICA, String.valueOf(replica.getNode().getId())));
        }
    }

    private void addTicketData(TicketInfo info, SupportDataBuilder builder) {
        builder.addValue("available", String.valueOf(info.getAvailable())).addValue("queued", String.valueOf(info.getQueuedRequests())).addValue("total", String.valueOf(info.getTotal())).addValue("used", String.valueOf(info.getUsed())).addValue("last-rejection", info.getLastRejection().map(Instant::toString).orElse("N/A")).addValue("oldest-queue", info.getOldestQueuedRequest().map(Instant::toString).orElse("N/A"));
    }
}

