/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.stash.internal.mesh;

import com.atlassian.johnson.Johnson;
import com.atlassian.johnson.JohnsonEventContainer;
import com.atlassian.johnson.event.Event;
import com.atlassian.johnson.event.EventLevel;
import com.atlassian.johnson.event.EventType;
import jakarta.annotation.PostConstruct;
import jakarta.servlet.ServletContext;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Value;
import org.springframework.stereotype.Component;

@Component(value="sidecarJohnsonCheck")
public class SidecarJohnsonCheck {
    private static final Logger log = LoggerFactory.getLogger(SidecarJohnsonCheck.class);
    private static final String SEPARATOR = "================================================================================";
    private final boolean meshEnabled;
    private final ServletContext servletContext;
    private final boolean sidecarEnabled;

    public SidecarJohnsonCheck(ServletContext servletContext, @Value(value="${plugin.bitbucket-git.mesh.sidecar.enabled}") boolean sidecarEnabled, @Value(value="${mesh.enabled}") boolean meshEnabled) {
        this.servletContext = servletContext;
        this.sidecarEnabled = sidecarEnabled;
        this.meshEnabled = meshEnabled;
    }

    @PostConstruct
    public void start() {
        if (this.sidecarEnabled && this.meshEnabled) {
            return;
        }
        String error = "The system has been configured <i>not</i> to use the Sidecar process for Git operations. Mesh and the Sidecar process are now required and can not be disabled anymore. Remove these properties from 'bitbucket.properties' to continue using the system: <ul><li><code>mesh.enabled=false</code></li><li><code>plugin.bitbucket-git.mesh.sidecar.enabled=false</code></li></ul>";
        log.error("Startup halted.\n================================================================================\n\nThe system has been configured not to use the Sidecar process for Git\noperations. Mesh and the Sidecar process are now required and can not be\ndisabled anymore. Remove these properties from 'bitbucket.properties' to\ncontinue using the system:\n\n- mesh.enabled=false\n- plugin.bitbucket-git.mesh.sidecar.enabled=false\n\n================================================================================");
        this.getEventContainer().addEvent(new Event(EventType.get((String)"sidecar-disabled"), error, EventLevel.get((String)"error")));
    }

    private JohnsonEventContainer getEventContainer() {
        return Johnson.getEventContainer((ServletContext)this.servletContext);
    }
}

