/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.stash.internal.mesh;

import com.atlassian.bitbucket.dmz.mesh.MeshPartition;
import com.atlassian.bitbucket.dmz.mesh.MeshPartitionReplica;
import com.atlassian.bitbucket.util.BuilderSupport;
import com.google.common.collect.ImmutableList;
import jakarta.annotation.Nonnull;
import jakarta.annotation.Nullable;
import java.util.List;
import java.util.Objects;

class SimpleMeshPartition
implements MeshPartition {
    private final int id;
    private final List<MeshPartitionReplica> replicas;

    private SimpleMeshPartition(Builder builder) {
        this.id = builder.id;
        this.replicas = builder.replicas.build();
    }

    public int getId() {
        return this.id;
    }

    @Nonnull
    public List<MeshPartitionReplica> getReplicas() {
        return this.replicas;
    }

    public boolean isAvailable() {
        return this.replicas.stream().filter(Objects::nonNull).anyMatch(MeshPartitionReplica::isAvailable);
    }

    public int size() {
        return this.replicas.size();
    }

    public static class Builder
    extends BuilderSupport {
        private final int id;
        private final ImmutableList.Builder<MeshPartitionReplica> replicas;

        public Builder(int id) {
            this.id = id;
            this.replicas = ImmutableList.builder();
        }

        @Nonnull
        public SimpleMeshPartition build() {
            return new SimpleMeshPartition(this);
        }

        @Nonnull
        public Builder replicas(@Nullable MeshPartitionReplica value, MeshPartitionReplica ... moreValues) {
            Builder.addIf(Objects::nonNull, this.replicas, (Object)value, (Object[])moreValues);
            return this;
        }

        @Nonnull
        public Builder replicas(@Nullable Iterable<? extends MeshPartitionReplica> values) {
            Builder.addIf(Objects::nonNull, this.replicas, values);
            return this;
        }
    }
}

