/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.stash.internal.mesh;

import com.atlassian.bitbucket.dmz.mesh.MeshPartitionReplica;
import com.atlassian.bitbucket.mesh.MeshNode;
import com.atlassian.stash.internal.mesh.ReplicaRequirement;
import jakarta.annotation.Nonnull;
import jakarta.annotation.Nullable;
import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Map;
import java.util.Objects;
import java.util.Set;
import java.util.stream.Collectors;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class SingleReplicaPerNodeRequirement
implements ReplicaRequirement {
    private static final Logger log = LoggerFactory.getLogger(SingleReplicaPerNodeRequirement.class);
    private final Map<MeshNode, Map<Integer, Set<ReplicaRequirement.VirtualReplica>>> replicasByNodeAndPartition;

    public SingleReplicaPerNodeRequirement(Map<MeshNode, Set<MeshPartitionReplica>> replicasByNode) {
        this.replicasByNodeAndPartition = replicasByNode.entrySet().stream().map(entry -> Map.entry((MeshNode)entry.getKey(), ((Set)entry.getValue()).stream().map(ReplicaRequirement.VirtualReplica::of).collect(Collectors.groupingBy(ReplicaRequirement.VirtualReplica::partition, Collectors.toSet())))).collect(Collectors.toMap(Map.Entry::getKey, Map.Entry::getValue));
    }

    @Override
    public void move(@Nonnull MeshPartitionReplica replica, @Nullable MeshNode source, @Nonnull MeshNode target) {
        Objects.requireNonNull(replica, "replica");
        Objects.requireNonNull(target, "target");
        if (Objects.equals(source, target)) {
            return;
        }
        log.trace("Moving partition {} from {} to {}", new Object[]{replica.getPartition(), source, target});
        ReplicaRequirement.VirtualReplica virtualReplica = ReplicaRequirement.VirtualReplica.of(replica);
        this.replicasByNodeAndPartition.computeIfAbsent(target, ignored -> new HashMap()).computeIfAbsent(virtualReplica.partition(), ignored -> new HashSet()).add(virtualReplica);
        if (source != null) {
            this.replicasByNodeAndPartition.getOrDefault(source, Collections.emptyMap()).getOrDefault(virtualReplica.partition(), Collections.emptySet()).remove(virtualReplica);
        }
    }

    @Override
    public boolean test(@Nullable MeshPartitionReplica existing, @Nonnull MeshNode meshNode, int partition) {
        Objects.requireNonNull(meshNode, "meshNode");
        ReplicaRequirement.VirtualReplica virtualReplica = existing == null ? null : ReplicaRequirement.VirtualReplica.of(existing);
        Set replicasOnNode = this.replicasByNodeAndPartition.getOrDefault(meshNode, Collections.emptyMap()).getOrDefault(partition, Collections.emptySet());
        if (virtualReplica != null && replicasOnNode.size() == 1 && replicasOnNode.contains(virtualReplica)) {
            return true;
        }
        return replicasOnNode.isEmpty();
    }
}

