/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.stash.internal.migration;

import com.atlassian.bitbucket.EntityOutOfDateException;
import com.atlassian.bitbucket.i18n.I18nService;
import com.atlassian.bitbucket.i18n.KeyedMessage;
import com.atlassian.bitbucket.job.Job;
import com.atlassian.bitbucket.job.JobMessageCreationRequest;
import com.atlassian.bitbucket.job.JobMessageSeverity;
import com.atlassian.bitbucket.job.JobService;
import com.atlassian.bitbucket.job.JobState;
import com.atlassian.bitbucket.job.JobUpdateRequest;
import com.atlassian.stash.internal.migration.MigrationJob;
import com.atlassian.stash.internal.migration.MigrationJobProgressUpdateRequest;
import com.google.common.collect.Sets;
import io.atlassian.fugue.retry.RetryFactory;
import jakarta.annotation.Nonnull;
import java.util.Arrays;
import java.util.Set;
import java.util.stream.Collectors;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

abstract class AbstractMigrationJob
implements MigrationJob {
    private static final Set<JobState> COMPLETED_FINAL_STATES = Sets.immutableEnumSet((Enum)JobState.COMPLETED, (Enum[])new JobState[]{JobState.FAILED});
    private static final int STATE_TRANSITION_RETRY_COUNT = 5;
    private static final Logger log = LoggerFactory.getLogger(AbstractMigrationJob.class);
    protected final I18nService i18nService;
    private final long jobId;
    private final JobService jobService;

    AbstractMigrationJob(I18nService i18nService, JobService jobService, Job job) {
        this.i18nService = i18nService;
        this.jobService = jobService;
        this.jobId = job.getId();
    }

    public void abort() {
        AbstractMigrationJob.withRetry(() -> {
            Job job = this.getJob();
            AbstractMigrationJob.ensureValidStateTransition(job.getState(), JobState.ABORTED, new JobState[0]);
            this.finalizeJob(job, JobState.ABORTED, this.getAbortedMessage());
        });
    }

    public void addMessage(@Nonnull KeyedMessage message, @Nonnull String identifier, @Nonnull JobMessageSeverity severity) {
        this.jobService.createMessage(new JobMessageCreationRequest.Builder(this.getJob(), message.getRootMessage()).severity(severity).subject(identifier).build());
    }

    public void beginCanceling() {
        AbstractMigrationJob.withRetry(() -> {
            Job job = this.getJob();
            JobState state = job.getState();
            if (state == JobState.CANCELING || state == JobState.CANCELED) {
                if (log.isDebugEnabled()) {
                    log.debug("Attempted to cancel already canceled job with ID '{}'", (Object)job.getId());
                }
                return;
            }
            AbstractMigrationJob.ensureValidStateTransition(state, JobState.CANCELING, new JobState[0]);
            this.jobService.update(new JobUpdateRequest.Builder(job).state(JobState.CANCELING).progressMessage(this.getCanceledMessage().getRootMessage()).build());
        });
    }

    public void complete(boolean hasErrors) {
        AbstractMigrationJob.withRetry(() -> {
            Job job = this.getJob();
            if (job.getState() == JobState.CANCELING) {
                this.doFinishCanceling(job);
            } else if (hasErrors) {
                AbstractMigrationJob.ensureValidStateTransition(job.getState(), JobState.FAILED, new JobState[0]);
                this.finalizeJob(job, JobState.FAILED, this.getFailMessage());
            } else {
                AbstractMigrationJob.ensureValidStateTransition(job.getState(), JobState.COMPLETED, new JobState[0]);
                this.finalizeJob(job, JobState.COMPLETED, this.getCompleteMessage());
            }
        });
    }

    public void fail() {
        AbstractMigrationJob.withRetry(() -> {
            Job job = this.getJob();
            AbstractMigrationJob.ensureValidStateTransition(job.getState(), JobState.FAILED, new JobState[0]);
            this.finalizeJob(job, JobState.FAILED, this.getFailMessage());
        });
    }

    public void finishCanceling() {
        AbstractMigrationJob.withRetry(() -> {
            Job job = this.getJob();
            AbstractMigrationJob.ensureValidStateTransition(job.getState(), JobState.CANCELED, new JobState[0]);
            this.doFinishCanceling(job);
        });
    }

    public long getId() {
        return this.jobId;
    }

    @Nonnull
    public JobState getState() {
        return this.getJob().getState();
    }

    @Nonnull
    public String getType() {
        return this.getJob().getType();
    }

    public void start() {
        AbstractMigrationJob.withRetry(() -> {
            Job job = this.getJob();
            AbstractMigrationJob.ensureValidStateTransition(job.getState(), JobState.RUNNING, JobState.INITIALISING, JobState.READY);
            this.jobService.update(new JobUpdateRequest.Builder(job).state(JobState.RUNNING).build());
        });
    }

    public void updateProgress(@Nonnull MigrationJobProgressUpdateRequest request) {
        AbstractMigrationJob.withRetry(() -> {
            Job job = this.getJob();
            if (!job.getState().isTerminated()) {
                JobUpdateRequest.Builder builder = new JobUpdateRequest.Builder(job);
                request.getMessage().map(KeyedMessage::getRootMessage).ifPresent(arg_0 -> ((JobUpdateRequest.Builder)builder).progressMessage(arg_0));
                request.getPercentage().ifPresent(arg_0 -> ((JobUpdateRequest.Builder)builder).progressPercentage(arg_0));
                this.jobService.update(builder.build());
            } else if (log.isDebugEnabled()) {
                log.debug("Failed to update progress on job '{}': Job was already terminated", (Object)job.getId());
            }
        });
    }

    @Nonnull
    protected abstract KeyedMessage getAbortedMessage();

    @Nonnull
    protected abstract KeyedMessage getCanceledMessage();

    @Nonnull
    protected abstract KeyedMessage getCompleteMessage();

    @Nonnull
    protected abstract KeyedMessage getFailMessage();

    private static void ensureValidStateTransition(JobState currentState, JobState targetState, JobState ... validSourceStates) {
        if (validSourceStates.length > 0) {
            if (Arrays.stream(validSourceStates).noneMatch(arg_0 -> currentState.equals(arg_0))) {
                throw new IllegalStateException("Illegal transition from " + String.valueOf(currentState) + " to " + String.valueOf(targetState) + "; Valid states are: " + Arrays.stream(validSourceStates).map(Object::toString).collect(Collectors.joining(", ")));
            }
        }
        if (targetState == currentState) {
            throw new IllegalStateException("Illegal transition: already in state " + String.valueOf(targetState));
        }
        if (!targetState.isFailed() && currentState.isFailed()) {
            throw new IllegalStateException("Illegal transition: cannot transition from failed state " + String.valueOf(currentState) + " to successful state " + String.valueOf(targetState));
        }
        if (currentState.isTerminated()) {
            throw new IllegalStateException("Illegal transition from terminated state " + String.valueOf(currentState) + " to " + String.valueOf(targetState));
        }
    }

    private static void withRetry(Runnable runnable) {
        RetryFactory.create((Runnable)runnable, (int)5, exception -> {
            if (!(exception instanceof EntityOutOfDateException)) {
                throw exception;
            }
        }).run();
    }

    private void doFinishCanceling(Job job) {
        this.jobService.update(new JobUpdateRequest.Builder(job).state(JobState.CANCELED).progressMessage(this.getCanceledMessage().getRootMessage()).build());
    }

    private void finalizeJob(@Nonnull Job job, @Nonnull JobState finalState, @Nonnull KeyedMessage message) {
        JobUpdateRequest.Builder builder = new JobUpdateRequest.Builder(job).state(finalState).progressMessage(message.getRootMessage());
        if (COMPLETED_FINAL_STATES.contains(finalState)) {
            builder.progressPercentage(100);
        }
        this.jobService.update(builder.build());
    }

    private Job getJob() {
        return (Job)this.jobService.getById(this.jobId).orElseThrow(() -> new IllegalStateException("Could not find job id '" + this.jobId + "'"));
    }
}

