/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.stash.internal.migration;

import com.atlassian.bitbucket.i18n.I18nService;
import com.atlassian.stash.internal.db.DatabaseManager;
import com.atlassian.stash.internal.jdbc.DataSourceConfiguration;
import com.atlassian.stash.internal.maintenance.MaintenanceService;
import com.atlassian.stash.internal.maintenance.MaintenanceTask;
import com.atlassian.stash.internal.maintenance.MaintenanceTaskFactory;
import com.atlassian.stash.internal.maintenance.MaintenanceTaskMonitor;
import com.atlassian.stash.internal.maintenance.MaintenanceType;
import com.atlassian.stash.internal.migration.DatabaseMigrationException;
import com.atlassian.stash.internal.migration.DatabaseMigrationService;
import jakarta.annotation.Nonnull;
import java.util.Objects;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.security.access.prepost.PreAuthorize;
import org.springframework.stereotype.Service;

@PreAuthorize(value="hasGlobalPermission('SYS_ADMIN')")
@Service(value="databaseMigrationService")
public class DefaultDatabaseMigrationService
implements DatabaseMigrationService {
    private static final Logger log = LoggerFactory.getLogger(DefaultDatabaseMigrationService.class);
    private final DatabaseManager databaseManager;
    private final I18nService i18nService;
    private final MaintenanceService maintenanceService;
    private final MaintenanceTaskFactory maintenanceTaskFactory;

    @Autowired
    public DefaultDatabaseMigrationService(DatabaseManager databaseManager, I18nService i18nService, MaintenanceService maintenanceService, MaintenanceTaskFactory maintenanceTaskFactory) {
        this.databaseManager = databaseManager;
        this.i18nService = i18nService;
        this.maintenanceService = maintenanceService;
        this.maintenanceTaskFactory = maintenanceTaskFactory;
    }

    @Nonnull
    public MaintenanceTaskMonitor migrate(@Nonnull DataSourceConfiguration newConfiguration) {
        Objects.requireNonNull(newConfiguration, "newConfiguration");
        try {
            return this.maintenanceService.start((MaintenanceTask)this.maintenanceTaskFactory.migrationTask(newConfiguration), MaintenanceType.MIGRATION);
        }
        catch (IllegalStateException e) {
            log.error("An attempt to start a migration was blocked because maintenance is already in progress");
            throw new DatabaseMigrationException(this.i18nService.createKeyedMessage("bitbucket.migration.already.running", new Object[0]));
        }
    }

    @Nonnull
    public MaintenanceTaskMonitor setup(@Nonnull DataSourceConfiguration newConfiguration) {
        Objects.requireNonNull(newConfiguration, "newConfiguration");
        try {
            return this.maintenanceService.start((MaintenanceTask)this.maintenanceTaskFactory.setupTask(newConfiguration), MaintenanceType.MIGRATION);
        }
        catch (IllegalStateException e) {
            log.error("An attempt to setup the database was blocked because maintenance is already in progress");
            throw new DatabaseMigrationException(this.i18nService.createKeyedMessage("bitbucket.migration.already.running", new Object[0]));
        }
    }

    public void validateConfiguration(@Nonnull DataSourceConfiguration configuration) {
        this.databaseManager.validateConfiguration(configuration);
    }
}

