/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.stash.internal.migration;

import com.atlassian.bitbucket.migration.EntityImportMapping;
import com.google.common.collect.BiMap;
import com.google.common.collect.HashBiMap;
import com.google.common.collect.Maps;
import jakarta.annotation.Nonnull;
import java.util.Objects;
import java.util.Optional;

public class DefaultEntityImportMapping<K>
implements EntityImportMapping<K> {
    private final BiMap<String, K> mapping = Maps.synchronizedBiMap((BiMap)HashBiMap.create());

    public void add(@Nonnull String exportId, @Nonnull K localId) {
        Objects.requireNonNull(exportId, "exportId");
        Objects.requireNonNull(localId, "localId");
        String existingExportId = (String)this.mapping.inverse().get(localId);
        if (existingExportId != null) {
            throw new IllegalArgumentException("'" + String.valueOf(localId) + "' already mapped to '" + existingExportId + "'");
        }
        Object existingLocalId = this.mapping.putIfAbsent((Object)exportId, localId);
        if (existingLocalId != null) {
            throw new IllegalArgumentException("'" + exportId + "' already mapped to '" + String.valueOf(existingLocalId) + "'");
        }
    }

    public void clear() {
        this.mapping.clear();
    }

    @Nonnull
    public Optional<String> getExportId(@Nonnull K localId) {
        Objects.requireNonNull(localId, "localId");
        return Optional.ofNullable((String)this.mapping.inverse().get(localId));
    }

    @Nonnull
    public Optional<K> getLocalId(@Nonnull String exportId) {
        Objects.requireNonNull(exportId, "exportId");
        return Optional.ofNullable(this.mapping.get((Object)exportId));
    }
}

