/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.stash.internal.migration;

import com.atlassian.bitbucket.io.IoConsumer;
import com.atlassian.bitbucket.io.IoFunction;
import com.atlassian.bitbucket.migration.EntrySource;
import com.atlassian.bitbucket.util.IoUtils;
import com.google.common.base.MoreObjects;
import jakarta.annotation.Nonnull;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.nio.file.Files;
import java.nio.file.Path;
import java.nio.file.attribute.FileAttribute;
import java.util.Objects;
import java.util.concurrent.atomic.AtomicBoolean;

public class DefaultEntrySource
implements EntrySource {
    private static final int COPY_BUFFER_SIZE = 32768;
    private final InputStream inputStream;
    private final Path path;
    private final AtomicBoolean read = new AtomicBoolean();

    public DefaultEntrySource(@Nonnull InputStream inputStream, @Nonnull Path path) {
        this.inputStream = Objects.requireNonNull(inputStream, "inputStream");
        this.path = Objects.requireNonNull(path, "path");
    }

    public <T> T apply(@Nonnull IoFunction<InputStream, T> reader) throws IOException {
        Objects.requireNonNull(reader, "reader");
        this.guardAgainstRepeatedCalls();
        return (T)reader.apply((Object)this.inputStream);
    }

    public void extractToDisk(@Nonnull Path target) throws IOException {
        Objects.requireNonNull(target, "target");
        this.guardAgainstRepeatedCalls();
        Files.createDirectories(target.getParent(), new FileAttribute[0]);
        try (FileOutputStream out = new FileOutputStream(target.toFile());){
            IoUtils.copy((InputStream)this.inputStream, (OutputStream)out, (int)32768);
        }
    }

    @Nonnull
    public Path getPath() {
        return this.path;
    }

    public void read(@Nonnull IoConsumer<InputStream> reader) throws IOException {
        Objects.requireNonNull(reader, "reader");
        this.guardAgainstRepeatedCalls();
        reader.accept((Object)this.inputStream);
    }

    public String toString() {
        return MoreObjects.toStringHelper((Object)this).add("path", (Object)this.path).toString();
    }

    private void guardAgainstRepeatedCalls() {
        if (!this.read.compareAndSet(false, true)) {
            throw new IllegalStateException("Can not read from this class more than once");
        }
    }
}

