/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.stash.internal.migration;

import com.atlassian.bitbucket.attribute.AttributeMap;
import com.atlassian.bitbucket.i18n.I18nService;
import com.atlassian.bitbucket.i18n.KeyedMessage;
import com.atlassian.bitbucket.io.IoConsumer;
import com.atlassian.bitbucket.job.JobMessageSeverity;
import com.atlassian.bitbucket.job.JobState;
import com.atlassian.bitbucket.migration.CanceledMigrationException;
import com.atlassian.bitbucket.migration.EntityExportMapping;
import com.atlassian.bitbucket.migration.ExportException;
import com.atlassian.bitbucket.migration.ExportSection;
import com.atlassian.bitbucket.migration.MigrationEntityType;
import com.atlassian.bitbucket.migration.SequentialArchive;
import com.atlassian.bitbucket.migration.StandardMigrationEntityType;
import com.atlassian.stash.internal.migration.ExportTarget;
import com.atlassian.stash.internal.migration.InternalExportContext;
import com.atlassian.stash.internal.migration.MigrationJob;
import com.atlassian.stash.internal.migration.NamespacedExportContext;
import com.atlassian.stash.internal.migration.TarArchive;
import com.atlassian.stash.internal.migration.UserEntityExportMapping;
import com.atlassian.stash.internal.migration.entity.MigrationEntityIdentifierMapper;
import com.google.common.annotations.VisibleForTesting;
import com.google.common.collect.Sets;
import com.google.common.util.concurrent.RateLimiter;
import jakarta.annotation.Nonnull;
import java.io.IOException;
import java.io.OutputStream;
import java.nio.file.Path;
import java.util.HashMap;
import java.util.Map;
import java.util.Objects;
import java.util.Set;
import java.util.function.Consumer;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class DefaultExportContext
implements InternalExportContext {
    private static final int CANCELED_CHECK_TIMEOUT_IN_SECONDS = 10;
    private static final DefaultEntityExportMapping<Object> DEFAULT_ENTITY_MAPPING = new DefaultEntityExportMapping();
    private static final Logger log = LoggerFactory.getLogger(DefaultExportContext.class);
    private final RateLimiter canceledCheckerRateLimiter;
    private final Map<MigrationEntityType<?>, EntityExportMapping<?>> entityMappings;
    private final ExportTarget exportTarget;
    private final I18nService i18nService;
    private final MigrationJob job;
    private final Map<Path, NamespacedExportContext> namespaces;
    private final Set<Path> sections;
    private final UserEntityExportMapping userEntityExportMapping;
    private volatile boolean canceled;
    private volatile boolean inError;

    public DefaultExportContext(@Nonnull ExportTarget exportTarget, @Nonnull MigrationJob job, @Nonnull I18nService i18nService, @Nonnull UserEntityExportMapping userEntityExportMapping) {
        this(exportTarget, job, i18nService, userEntityExportMapping, 10);
    }

    @VisibleForTesting
    DefaultExportContext(@Nonnull ExportTarget exportTarget, @Nonnull MigrationJob job, @Nonnull I18nService i18nService, @Nonnull UserEntityExportMapping userEntityExportMapping, int canceledCheckTimeoutInSeconds) {
        this.exportTarget = Objects.requireNonNull(exportTarget, "exportTarget");
        this.i18nService = Objects.requireNonNull(i18nService, "i18nService");
        this.job = Objects.requireNonNull(job, "job");
        this.userEntityExportMapping = Objects.requireNonNull(userEntityExportMapping, "userEntityExportMapping");
        this.canceled = false;
        this.canceledCheckerRateLimiter = RateLimiter.create((double)(1.0 / (double)canceledCheckTimeoutInSeconds));
        this.entityMappings = new HashMap();
        this.namespaces = new HashMap<Path, NamespacedExportContext>();
        this.sections = Sets.newConcurrentHashSet();
    }

    public void abortIfCanceled() {
        if (!this.canceled && this.canceledCheckerRateLimiter.tryAcquire()) {
            this.updateCanceledFlagFromJob();
        }
        if (this.canceled) {
            throw new CanceledMigrationException(this.i18nService.createKeyedMessage("bitbucket.service.migration.export.job.export.canceled", new Object[0]));
        }
    }

    public void addEntriesAsArchive(@Nonnull Path entryName, @Nonnull IoConsumer<SequentialArchive> writer, boolean compress) {
        Objects.requireNonNull(entryName, "entryName");
        Objects.requireNonNull(writer, "writer");
        this.abortIfCanceled();
        Path tarPath = entryName.resolveSibling(String.valueOf(entryName.getFileName()) + ".atl.tar");
        this.addEntry(tarPath, (IoConsumer<OutputStream>)((IoConsumer)outputStream -> {
            try (TarArchive archive = new TarArchive((OutputStream)outputStream);){
                writer.accept((Object)archive);
            }
        }), compress);
    }

    public void addEntry(@Nonnull Path entryName, @Nonnull IoConsumer<OutputStream> writer, boolean compress) {
        Objects.requireNonNull(entryName, "entryName");
        Objects.requireNonNull(writer, "writer");
        this.abortIfCanceled();
        try {
            this.exportTarget.addEntry(entryName, (IoConsumer<OutputStream>)((IoConsumer)outputStream -> writer.accept((Object)new CancellableOutputStream((OutputStream)outputStream))), compress);
        }
        catch (IOException e) {
            throw new ExportException(this.i18nService.createKeyedMessage("bitbucket.service.migration.export.adding.failed", new Object[]{entryName}), (Throwable)e);
        }
    }

    public void addError(@Nonnull KeyedMessage message, Object entity) {
        this.addError(message, entity, null);
    }

    public void addError(@Nonnull KeyedMessage message, Object entity, Throwable t) {
        Objects.requireNonNull(message, "message");
        String identifier = MigrationEntityIdentifierMapper.getEntityIdentifier(entity);
        log.error("Error registered for job {} of type {} ({}) against {}: {}", new Object[]{this.job.getId(), this.job.getType(), this.job.getState(), identifier, message.getRootMessage(), t});
        this.job.addMessage(message, identifier, JobMessageSeverity.ERROR);
        this.inError = true;
    }

    public boolean addSectionIfAbsent(@Nonnull Path path, @Nonnull Consumer<ExportSection> exportSection) {
        Objects.requireNonNull(path, "path");
        this.abortIfCanceled();
        if (this.sections.add(path)) {
            Objects.requireNonNull(exportSection, "exportSection");
            exportSection.accept((ExportSection)this.forNamespace(path));
            return true;
        }
        return false;
    }

    public void addWarning(@Nonnull KeyedMessage message, Object entity) {
        this.addWarning(message, entity, null);
    }

    public void addWarning(@Nonnull KeyedMessage message, Object entity, Throwable t) {
        Objects.requireNonNull(message, "message");
        String identifier = MigrationEntityIdentifierMapper.getEntityIdentifier(entity);
        log.warn("Warning registered for job {} of type {} ({}) against {}: {}", new Object[]{this.job.getId(), this.job.getType(), this.job.getState(), identifier, message.getRootMessage(), t});
        this.job.addMessage(message, identifier, JobMessageSeverity.WARN);
    }

    public void cancel() {
        if (!this.canceled) {
            log.debug("Cancelling export job {}", (Object)this.job);
            this.canceled = true;
            return;
        }
        throw new IllegalStateException("Export has already been canceled");
    }

    public void close() throws Exception {
        this.exportTarget.close();
    }

    @Nonnull
    public InternalExportContext forNamespace(@Nonnull Path namespace) {
        Objects.requireNonNull(namespace, "namespace");
        return this.namespaces.computeIfAbsent(namespace, ns -> new NamespacedExportContext(namespace, this));
    }

    @Nonnull
    public AttributeMap getAttributeMap() {
        throw new UnsupportedOperationException("Top level context does not support attributes");
    }

    @Nonnull
    public <T> EntityExportMapping<T> getEntityMapping(@Nonnull MigrationEntityType<T> entityType) {
        Objects.requireNonNull(entityType, "entityType");
        return this.entityMappings.computeIfAbsent(entityType, migrationEntityType -> {
            if (migrationEntityType == StandardMigrationEntityType.USER) {
                return this.userEntityExportMapping;
            }
            return DEFAULT_ENTITY_MAPPING;
        });
    }

    @Nonnull
    public MigrationJob getJob() {
        return this.job;
    }

    public boolean hasErrors() {
        return this.inError;
    }

    public boolean hasSection(@Nonnull Path path) {
        return this.sections.contains(Objects.requireNonNull(path, "path"));
    }

    private void updateCanceledFlagFromJob() {
        JobState state = this.job.getState();
        if (state.isTerminated() || state == JobState.CANCELING) {
            log.debug("Setting canceled flag from database state");
            this.canceled = true;
        }
    }

    private static class DefaultEntityExportMapping<T>
    implements EntityExportMapping<T> {
        private DefaultEntityExportMapping() {
        }

        @Nonnull
        public String getExportId(@Nonnull T id) {
            Objects.requireNonNull(id, "id");
            return String.valueOf(id);
        }
    }

    private class CancellableOutputStream
    extends OutputStream {
        private final OutputStream delegate;

        CancellableOutputStream(OutputStream delegate) {
            this.delegate = delegate;
        }

        @Override
        public void close() throws IOException {
            this.delegate.close();
        }

        @Override
        public void flush() throws IOException {
            this.delegate.flush();
        }

        @Override
        public void write(@Nonnull byte[] b) throws IOException {
            DefaultExportContext.this.abortIfCanceled();
            this.delegate.write(b);
        }

        @Override
        public void write(@Nonnull byte[] b, int off, int len) throws IOException {
            DefaultExportContext.this.abortIfCanceled();
            this.delegate.write(b, off, len);
        }

        @Override
        public void write(int b) throws IOException {
            DefaultExportContext.this.abortIfCanceled();
            this.delegate.write(b);
        }
    }
}

