/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.stash.internal.migration;

import com.atlassian.bitbucket.i18n.I18nService;
import com.atlassian.bitbucket.i18n.KeyedMessage;
import com.atlassian.bitbucket.migration.CanceledMigrationException;
import com.atlassian.bitbucket.migration.ExportSection;
import com.atlassian.bitbucket.migration.RepositoriesExportRequest;
import com.atlassian.bitbucket.pull.PullRequest;
import com.atlassian.bitbucket.scope.ProjectScope;
import com.atlassian.bitbucket.scope.RepositoryScope;
import com.atlassian.bitbucket.scope.Scope;
import com.atlassian.bitbucket.scope.ScopeVisitor;
import com.atlassian.bitbucket.util.PageUtils;
import com.atlassian.bitbucket.util.PagedIterable;
import com.atlassian.stash.internal.AbstractService;
import com.atlassian.stash.internal.migration.ExportScopeResolver;
import com.atlassian.stash.internal.migration.ExportService;
import com.atlassian.stash.internal.migration.ExporterExecutorService;
import com.atlassian.stash.internal.migration.InternalExportContext;
import com.atlassian.stash.internal.migration.MigrationJob;
import com.atlassian.stash.internal.migration.MigrationJobProgressUpdateRequest;
import com.atlassian.stash.internal.migration.MigrationPaths;
import com.atlassian.stash.internal.migration.ScopeVisitors;
import com.atlassian.stash.internal.pull.InternalPullRequestService;
import jakarta.annotation.Nonnull;
import java.nio.file.Path;
import java.util.Iterator;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Component;
import org.springframework.transaction.annotation.Propagation;
import org.springframework.transaction.annotation.Transactional;

@Component(value="exportTaskService")
public class DefaultExportService
extends AbstractService
implements ExportService {
    private static final int MAX_PAGE_SIZE = 100;
    private static final Logger log = LoggerFactory.getLogger(DefaultExportService.class);
    private final ExportScopeResolver exportScopeResolver;
    private final ExporterExecutorService exporterExecutorService;
    private final I18nService i18nService;
    private final InternalPullRequestService pullRequestService;

    @Autowired
    public DefaultExportService(ExportScopeResolver exportScopeResolver, ExporterExecutorService exporterExecutorService, I18nService i18nService, InternalPullRequestService pullRequestService) {
        this.exportScopeResolver = exportScopeResolver;
        this.exporterExecutorService = exporterExecutorService;
        this.i18nService = i18nService;
        this.pullRequestService = pullRequestService;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Transactional(propagation=Propagation.NOT_SUPPORTED)
    public void exportRepositories(@Nonnull InternalExportContext context, @Nonnull RepositoriesExportRequest request) {
        block29: {
            MigrationJob job = context.getJob();
            long expectedCount = this.exportScopeResolver.count(request);
            try {
                job.start();
                log.info("Export job '{}' has started.", (Object)job.getId());
                boolean onStartResult = this.exporterExecutorService.executeOnStart(context);
                if (onStartResult) {
                    boolean hasErrors;
                    boolean allExportersFinalised;
                    try {
                        long actualCount = 0L;
                        String currentHierarchyId = null;
                        Iterator it = this.exportScopeResolver.stream(request).iterator();
                        while (it.hasNext()) {
                            context.abortIfCanceled();
                            Scope scope = (Scope)it.next();
                            String hierarchyId = (String)scope.accept(ScopeVisitors.HIERARCHY_ID_GETTER);
                            if (hierarchyId != null && !hierarchyId.equals(currentHierarchyId)) {
                                if (currentHierarchyId != null) {
                                    this.updateProgressForPullRequests(job, currentHierarchyId);
                                    this.exportPullRequestsForHierarchy(context, currentHierarchyId);
                                    this.markHierarchyEnd(context, currentHierarchyId);
                                }
                                this.markHierarchyBegin(context, hierarchyId);
                                currentHierarchyId = hierarchyId;
                            }
                            this.updateProgressForScope(job, expectedCount, actualCount++, scope);
                            this.exportProjectOrRepo(context, scope);
                        }
                        if (currentHierarchyId != null) {
                            this.updateProgressForPullRequests(job, currentHierarchyId);
                            this.exportPullRequestsForHierarchy(context, currentHierarchyId);
                            this.markHierarchyEnd(context, currentHierarchyId);
                        }
                        if (actualCount != expectedCount) {
                            context.addWarning(this.i18nService.createKeyedMessage("bitbucket.service.migration.export.job.export.entities.unstable", new Object[0]), null);
                        }
                    }
                    finally {
                        allExportersFinalised = this.exporterExecutorService.executeOnEnd(context);
                    }
                    boolean bl = hasErrors = !allExportersFinalised || context.hasErrors();
                    if (hasErrors) {
                        log.info("Export job '{}' has completed with errors.", (Object)job.getId());
                    } else {
                        log.info("Export job '{}' has completed successfully.", (Object)job.getId());
                    }
                    job.complete(hasErrors);
                    break block29;
                }
                job.abort();
            }
            catch (CanceledMigrationException e) {
                log.info("Export job '{}' has been canceled", (Object)job.getId(), (Object)(log.isDebugEnabled() ? e : null));
                job.finishCanceling();
            }
            catch (Exception e) {
                log.error("Export job '{}' encountered an unrecoverable error", (Object)job.getId(), (Object)e);
                job.abort();
            }
            catch (Error e) {
                log.error("Export job '{}' encountered an unrecoverable error", (Object)job.getId(), (Object)e);
                job.abort();
                throw e;
            }
            finally {
                try {
                    context.close();
                }
                catch (Exception e) {
                    log.error("Failed to close the export context", (Throwable)e);
                }
            }
        }
    }

    private void updateProgressForScope(MigrationJob job, long expectedCount, long currentCount, Scope scope) {
        job.updateProgress(new MigrationJobProgressUpdateRequest.Builder().percentage(Math.min(99, (int)Math.round(100.0 * (double)currentCount / (double)expectedCount))).message(this.getProgressMessage(scope)).build());
    }

    private void updateProgressForPullRequests(MigrationJob job, String currentHierarchyId) {
        job.updateProgress(new MigrationJobProgressUpdateRequest.Builder().message(this.i18nService.createKeyedMessage("bitbucket.service.migration.export.progress.message.pull.requests", new Object[]{currentHierarchyId})).build());
    }

    private void exportProjectOrRepo(final InternalExportContext context, Scope scope) {
        scope.accept((ScopeVisitor)new ScopeVisitor<Void>(){

            public Void visit(@Nonnull ProjectScope scope) {
                DefaultExportService.this.exporterExecutorService.executeExport(context, scope.getProject());
                return null;
            }

            public Void visit(@Nonnull RepositoryScope scope) {
                DefaultExportService.this.exporterExecutorService.executeExport(context, scope.getRepository());
                return null;
            }
        });
    }

    private void exportPullRequestsForHierarchy(InternalExportContext context, String hierarchyId) {
        PagedIterable pullRequests = new PagedIterable(request -> this.pullRequestService.findByHierarchyId(hierarchyId, request), PageUtils.newRequest((int)0, (int)100));
        for (PullRequest pullRequest : pullRequests) {
            this.exporterExecutorService.executeExport(context, pullRequest);
        }
    }

    private KeyedMessage getProgressMessage(@Nonnull Scope scope) {
        return (KeyedMessage)scope.accept((ScopeVisitor)new ScopeVisitor<KeyedMessage>(){

            public KeyedMessage visit(@Nonnull ProjectScope projectScope) {
                return DefaultExportService.this.i18nService.createKeyedMessage("bitbucket.service.migration.export.progress.message.project", new Object[]{projectScope.getProject().getKey()});
            }

            public KeyedMessage visit(@Nonnull RepositoryScope repositoryScope) {
                return DefaultExportService.this.i18nService.createKeyedMessage("bitbucket.service.migration.export.progress.message.repository", new Object[]{repositoryScope.getRepository().getProject().getKey(), repositoryScope.getRepository().getSlug()});
            }
        });
    }

    private void markHierarchyBegin(@Nonnull InternalExportContext context, @Nonnull String hierarchyId) {
        Path path = MigrationPaths.INTERNAL_PREFIX.resolve(MigrationPaths.REPO_PATH_PREFIX).resolve(MigrationPaths.HIERARCHY_BEGIN_PREFIX).resolve(hierarchyId);
        context.addEntry(path, ExportSection.emptyEntry(), false);
    }

    private void markHierarchyEnd(@Nonnull InternalExportContext context, @Nonnull String hierarchyId) {
        Path path = MigrationPaths.INTERNAL_PREFIX.resolve(MigrationPaths.REPO_PATH_PREFIX).resolve(MigrationPaths.HIERARCHY_END_PREFIX).resolve(hierarchyId);
        context.addEntry(path, ExportSection.emptyEntry(), false);
    }
}

