/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.stash.internal.migration;

import com.atlassian.bitbucket.attribute.AttributeMap;
import com.atlassian.bitbucket.i18n.I18nService;
import com.atlassian.bitbucket.i18n.KeyedMessage;
import com.atlassian.bitbucket.io.IoConsumer;
import com.atlassian.bitbucket.job.JobMessageSeverity;
import com.atlassian.bitbucket.job.JobState;
import com.atlassian.bitbucket.migration.ArchiveSource;
import com.atlassian.bitbucket.migration.CanceledMigrationException;
import com.atlassian.bitbucket.migration.EntityImportMapping;
import com.atlassian.bitbucket.migration.EntrySource;
import com.atlassian.bitbucket.migration.MigrationEntityType;
import com.atlassian.bitbucket.migration.StandardMigrationEntityType;
import com.atlassian.bitbucket.util.Operation;
import com.atlassian.stash.internal.migration.DefaultEntityImportMapping;
import com.atlassian.stash.internal.migration.InternalImportContext;
import com.atlassian.stash.internal.migration.MigrationJob;
import com.atlassian.stash.internal.migration.NamespacedImportContext;
import com.atlassian.stash.internal.migration.UserEntityImportMapping;
import com.atlassian.stash.internal.migration.UserImportService;
import com.atlassian.stash.internal.migration.entity.MigrationEntityIdentifierMapper;
import jakarta.annotation.Nonnull;
import jakarta.annotation.Nullable;
import java.io.IOException;
import java.nio.file.Path;
import java.util.HashMap;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class DefaultImportContext
implements InternalImportContext {
    private static final Logger log = LoggerFactory.getLogger(DefaultImportContext.class);
    private final ArchiveSource archiveSource;
    private final AttributeMap attributeMap;
    private final I18nService i18nService;
    private final Map<MigrationEntityType<?>, EntityImportMapping<?>> importMapping;
    private final MigrationJob job;
    private final Map<Path, NamespacedImportContext> namespaces;
    private final Operation<Integer, IOException> progressPercentageSupplier;
    private final UserImportService userImportService;
    private String currentHierarchyId;
    private volatile boolean canceled;
    private volatile boolean inError;

    public DefaultImportContext(ArchiveSource archiveSource, I18nService i18nService, MigrationJob job, Operation<Integer, IOException> progressPercentageSupplier, UserImportService userImportService) {
        this.archiveSource = archiveSource;
        this.i18nService = i18nService;
        this.job = job;
        this.progressPercentageSupplier = progressPercentageSupplier;
        this.userImportService = userImportService;
        this.attributeMap = new AttributeMap();
        this.importMapping = new HashMap();
        this.namespaces = new HashMap<Path, NamespacedImportContext>();
    }

    public void abortIfCanceled() {
        if (!this.canceled) {
            this.updateCanceledFlagFromJob();
        }
        if (this.canceled) {
            throw new CanceledMigrationException(this.i18nService.createKeyedMessage("bitbucket.service.migration.import.job.import.canceled", new Object[0]));
        }
    }

    public void addError(@Nonnull KeyedMessage message, Object entity) {
        this.addError(message, entity, null);
    }

    public void addError(@Nonnull KeyedMessage message, Object entity, Throwable t) {
        Objects.requireNonNull(message, "message");
        String identifier = MigrationEntityIdentifierMapper.getEntityIdentifier(entity);
        log.error("Error registered for job {} of type {} ({}) against {}: {}", new Object[]{this.job.getId(), this.job.getType(), this.job.getState(), identifier, message.getRootMessage(), t});
        this.job.addMessage(message, identifier, JobMessageSeverity.ERROR);
        this.inError = true;
    }

    public void addWarning(@Nonnull KeyedMessage message, Object entity) {
        this.addWarning(message, entity, null);
    }

    public void addWarning(@Nonnull KeyedMessage message, Object entity, Throwable t) {
        Objects.requireNonNull(message, "message");
        String identifier = MigrationEntityIdentifierMapper.getEntityIdentifier(entity);
        log.warn("Warning registered for job {} of type {} ({}) against {}: {}", new Object[]{this.job.getId(), this.job.getType(), this.job.getState(), identifier, message.getRootMessage(), t});
        this.job.addMessage(message, identifier, JobMessageSeverity.WARN);
    }

    public void cancel() {
        if (!this.canceled) {
            log.debug("Cancelling import job {}", (Object)this.job);
            this.canceled = true;
            return;
        }
        throw new IllegalStateException("Import has already been canceled");
    }

    public void close() throws Exception {
        if (this.archiveSource instanceof AutoCloseable) {
            ((AutoCloseable)this.archiveSource).close();
        }
    }

    public void finalizeRepositoryHierarchy(@Nonnull String hierarchyId) {
        this.importMapping.computeIfPresent(StandardMigrationEntityType.COMMENT, (ignored, mapping) -> {
            mapping.clear();
            return mapping;
        });
    }

    @Nonnull
    public InternalImportContext forNamespace(@Nonnull Path namespace) {
        return this.namespaces.computeIfAbsent(namespace, ns -> new NamespacedImportContext(namespace, this));
    }

    @Nonnull
    public AttributeMap getAttributeMap() {
        return this.attributeMap;
    }

    @Nonnull
    public Optional<String> getCurrentHierarchyId() {
        return Optional.ofNullable(this.currentHierarchyId);
    }

    @Nonnull
    public <T> EntityImportMapping<T> getEntityMapping(@Nonnull MigrationEntityType<T> entityType) {
        Objects.requireNonNull(entityType, "entityType");
        return this.importMapping.computeIfAbsent(entityType, type -> {
            if (type == StandardMigrationEntityType.USER) {
                return new UserEntityImportMapping(this.userImportService);
            }
            return new DefaultEntityImportMapping();
        });
    }

    @Nonnull
    public MigrationJob getJob() {
        return this.job;
    }

    public int getProgressPercentage() throws IOException {
        return (Integer)this.progressPercentageSupplier.perform();
    }

    public boolean hasErrors() {
        return this.inError;
    }

    public void iterateEntries(@Nonnull IoConsumer<EntrySource> consumer) throws IOException {
        this.archiveSource.read(consumer);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void updateCanceledFlagFromJob() {
        if (!this.canceled) {
            DefaultImportContext defaultImportContext = this;
            synchronized (defaultImportContext) {
                JobState state;
                if (!this.canceled && ((state = this.job.getState()).isTerminated() || state == JobState.CANCELING)) {
                    log.debug("Setting canceled flag from database state");
                    this.canceled = true;
                }
            }
        }
    }

    public void setCurrentHierarchyId(@Nullable String hierarchyId) {
        this.currentHierarchyId = hierarchyId;
    }
}

