/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.stash.internal.migration;

import com.atlassian.bitbucket.i18n.I18nService;
import com.atlassian.bitbucket.i18n.KeyedMessage;
import com.atlassian.bitbucket.migration.ArchiveSource;
import com.atlassian.bitbucket.migration.CanceledMigrationException;
import com.atlassian.bitbucket.migration.EntrySource;
import com.atlassian.bitbucket.migration.ImportContext;
import com.atlassian.bitbucket.migration.Importer;
import com.atlassian.bitbucket.migration.MigrationException;
import com.atlassian.bitbucket.migration.MigrationHandlerModuleDescriptor;
import com.atlassian.bitbucket.permission.Permission;
import com.atlassian.bitbucket.repository.Repository;
import com.atlassian.bitbucket.user.SecurityService;
import com.atlassian.bitbucket.util.PageUtils;
import com.atlassian.plugin.PluginAccessor;
import com.atlassian.stash.internal.AbstractService;
import com.atlassian.stash.internal.migration.DefaultEntrySource;
import com.atlassian.stash.internal.migration.FatalImportException;
import com.atlassian.stash.internal.migration.ImportService;
import com.atlassian.stash.internal.migration.InternalImportContext;
import com.atlassian.stash.internal.migration.MigrationJob;
import com.atlassian.stash.internal.migration.MigrationJobProgressUpdateRequest;
import com.atlassian.stash.internal.migration.MigrationNamespaces;
import com.atlassian.stash.internal.migration.MigrationPaths;
import com.atlassian.stash.internal.migration.TarArchiveSource;
import com.atlassian.stash.internal.migration.entity.MetadataImporter;
import com.atlassian.stash.internal.migration.entity.pull.PullRequestImporter;
import com.atlassian.stash.internal.migration.integrity.ImportIntegrityCheckHelper;
import com.atlassian.stash.internal.migration.integrity.ImportIntegrityCheckRequest;
import com.atlassian.stash.internal.repository.InternalRepositoryService;
import com.google.common.annotations.VisibleForTesting;
import io.atlassian.util.concurrent.ThreadFactories;
import jakarta.annotation.Nonnull;
import jakarta.annotation.Nullable;
import java.io.IOException;
import java.io.InputStream;
import java.nio.file.FileSystems;
import java.nio.file.Path;
import java.nio.file.PathMatcher;
import java.nio.file.Paths;
import java.time.Duration;
import java.time.LocalDateTime;
import java.util.LinkedHashMap;
import java.util.LinkedList;
import java.util.Map;
import java.util.Objects;
import java.util.concurrent.Executors;
import java.util.concurrent.ScheduledExecutorService;
import java.util.concurrent.ScheduledFuture;
import java.util.concurrent.TimeUnit;
import java.util.function.BinaryOperator;
import java.util.function.Function;
import java.util.function.Supplier;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import java.util.zip.GZIPInputStream;
import org.apache.commons.lang3.ObjectUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Component;
import org.springframework.transaction.annotation.Propagation;
import org.springframework.transaction.annotation.Transactional;

@Component(value="importTaskService")
public class DefaultImportService
extends AbstractService
implements ImportService {
    private static final long PROGRESS_UPDATE_INTERVAL = 5000L;
    private static final int REPO_BATCH_SIZE = 50;
    private static final PathMatcher gzipCompressed = FileSystems.getDefault().getPathMatcher("glob:**.atl.gz");
    private static final Logger log = LoggerFactory.getLogger(DefaultImportService.class);
    private static final PathMatcher tarArchive = FileSystems.getDefault().getPathMatcher("glob:**.atl.tar");
    private final Supplier<ScheduledExecutorService> executorServiceSupplier;
    private final I18nService i18nService;
    private final ImportIntegrityCheckHelper integrityCheckHelper;
    private final PluginAccessor pluginAccessor;
    private final InternalRepositoryService repositoryService;
    private final SecurityService securityService;

    @Autowired
    public DefaultImportService(I18nService i18nService, ImportIntegrityCheckHelper integrityCheckHelper, PluginAccessor pluginAccessor, InternalRepositoryService repositoryService, SecurityService securityService) {
        this(i18nService, integrityCheckHelper, pluginAccessor, repositoryService, securityService, DefaultImportService.newExecutorServiceSupplier());
    }

    @VisibleForTesting
    DefaultImportService(I18nService i18nService, ImportIntegrityCheckHelper integrityCheckHelper, PluginAccessor pluginAccessor, InternalRepositoryService repositoryService, SecurityService securityService, Supplier<ScheduledExecutorService> executorServiceSupplier) {
        this.i18nService = i18nService;
        this.integrityCheckHelper = integrityCheckHelper;
        this.pluginAccessor = pluginAccessor;
        this.repositoryService = repositoryService;
        this.securityService = securityService;
        this.executorServiceSupplier = executorServiceSupplier;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Transactional(propagation=Propagation.NEVER)
    public void importRepositories(@Nonnull InternalImportContext context) {
        Duration duration;
        LocalDateTime startTime = LocalDateTime.now();
        MigrationJob job = context.getJob();
        Runnable progressUpdaterFinalizer = this.startProgressUpdaterThread(context, job);
        try {
            job.start();
            log.info("Import job '{}' has started.", (Object)job.getId());
            Map<Path, ErrorHandlingDataImporter> importerMapping = this.getImporterMapping(context);
            LinkedList<ErrorHandlingDataImporter> startedImporters = new LinkedList<ErrorHandlingDataImporter>();
            for (Map.Entry<Path, ErrorHandlingDataImporter> entry : importerMapping.entrySet()) {
                ErrorHandlingDataImporter importer2 = entry.getValue();
                if (!importer2.onStart()) {
                    startedImporters.forEach(ErrorHandlingDataImporter::onEnd);
                    progressUpdaterFinalizer.run();
                    log.error("Import job '{}' was aborted due to '{}' failing to execute 'onStart'", (Object)job.getId(), (Object)importer2.namespace);
                    job.abort();
                    return;
                }
                startedImporters.add(importer2);
            }
            try {
                context.iterateEntries(entrySource -> {
                    Path path = entrySource.getPath();
                    Path namespace = path.getName(0);
                    Path relativePath = namespace.relativize(path);
                    if (MigrationPaths.INTERNAL_PREFIX.equals(namespace)) {
                        this.handleInternalPath(context, importerMapping, relativePath);
                    } else {
                        this.handleImporterPath(context, importerMapping, relativePath, (EntrySource)entrySource, namespace);
                    }
                });
            }
            finally {
                importerMapping.forEach((namespace, importer) -> importer.onEnd());
            }
            progressUpdaterFinalizer.run();
            boolean hasErrors = context.hasErrors();
            Duration duration2 = Duration.between(startTime, LocalDateTime.now());
            if (hasErrors) {
                log.info("Import job '{}' has completed with errors. Duration: {}", (Object)job.getId(), (Object)duration2);
            } else {
                log.info("Import job '{}' has completed successfully. Duration: {}", (Object)job.getId(), (Object)duration2);
            }
            job.complete(hasErrors);
        }
        catch (CanceledMigrationException e) {
            duration = Duration.between(startTime, LocalDateTime.now());
            log.info("Import job '{}' has been canceled. Duration: {}", new Object[]{job.getId(), duration, log.isDebugEnabled() ? e : null});
            progressUpdaterFinalizer.run();
            job.finishCanceling();
        }
        catch (Error | Exception e) {
            duration = Duration.between(startTime, LocalDateTime.now());
            log.error("Import job '{}' encountered an unrecoverable error. Duration: {}", new Object[]{job.getId(), duration, e});
            progressUpdaterFinalizer.run();
            job.abort();
            if (e instanceof Error) {
                throw (Error)e;
            }
        }
        finally {
            try {
                context.close();
            }
            catch (Exception e) {
                log.error("Failed to close the export context", (Throwable)e);
            }
        }
    }

    @Nullable
    private static Object getSubject(@Nullable Exception e, Object ... fallbackSubject) {
        return ObjectUtils.firstNonNull((Object[])new Object[]{e instanceof MigrationException ? ((MigrationException)e).getSubject().orElse(null) : null, ObjectUtils.firstNonNull((Object[])fallbackSubject)});
    }

    private static Supplier<ScheduledExecutorService> newExecutorServiceSupplier() {
        return () -> Executors.newSingleThreadScheduledExecutor(ThreadFactories.namedThreadFactory((String)"dc-migration-import-progress", (ThreadFactories.Type)ThreadFactories.Type.DAEMON));
    }

    private static String requireCurrentHierarchyId(InternalImportContext context) {
        return (String)context.getCurrentHierarchyId().orElseThrow(() -> new IllegalStateException("Unable to get required hierarchyId"));
    }

    private static <T> BinaryOperator<T> throwingMerger() {
        return (u, v) -> {
            throw new IllegalStateException(String.format("Duplicate key %s", u));
        };
    }

    private void finalizeHierarchy(InternalImportContext context, Map<Path, ErrorHandlingDataImporter> importerMapping, String hierarchyId) {
        Stream importedRepos = PageUtils.toStream(request -> this.repositoryService.findByHierarchyId(hierarchyId, request), (int)50);
        importedRepos.forEach(importedRepo -> this.finalizeImport((ImportContext)context, (Iterable<ErrorHandlingDataImporter>)importerMapping.values(), (Repository)importedRepo));
        try {
            this.securityService.withPermission(Permission.SYS_ADMIN, "Import integrity checks").call(() -> {
                this.integrityCheckHelper.runPullRequestChecks(new ImportIntegrityCheckRequest.Builder().context((ImportContext)context).hierarchyId(hierarchyId).build());
                return null;
            });
        }
        catch (Exception e) {
            context.addError(this.i18nService.createKeyedMessage("bitbucket.service.migration.repository.import.hierarchy.integrity.check.failed", new Object[]{hierarchyId, e.getMessage()}), null, (Throwable)e);
        }
        this.integrityCheckRepositories((ImportContext)context, hierarchyId);
        context.finalizeRepositoryHierarchy(hierarchyId);
    }

    private void finalizeImport(ImportContext context, Iterable<ErrorHandlingDataImporter> importers, Repository repo) {
        importers.forEach(importer -> importer.finaliseRepositoryImport(repo));
        try {
            this.repositoryService.finalizeImport(repo);
        }
        catch (Exception e) {
            context.addError(this.i18nService.createKeyedMessage("bitbucket.service.migration.repository.import.finalization.failed", new Object[]{repo}), DefaultImportService.getSubject(e, repo), (Throwable)e);
        }
    }

    private Map<Path, ErrorHandlingDataImporter> getImporterMapping(InternalImportContext context) {
        return this.pluginAccessor.getEnabledModuleDescriptorsByClass(MigrationHandlerModuleDescriptor.class).stream().sorted().map(descriptor -> descriptor.getImporter().map(importer -> {
            if (log.isDebugEnabled()) {
                log.debug("Found handler {} with weight {}, returning importer {}", new Object[]{MigrationNamespaces.fromModuleDescriptor(descriptor), descriptor.getWeight(), importer.getClass()});
            }
            return new ErrorHandlingDataImporter((Importer)importer, context, Paths.get(MigrationNamespaces.fromModuleDescriptor(descriptor), new String[0]));
        }).orElse(null)).filter(Objects::nonNull).collect(Collectors.toMap(ErrorHandlingDataImporter::getNamespace, Function.identity(), DefaultImportService.throwingMerger(), LinkedHashMap::new));
    }

    private void handleImporterPath(InternalImportContext context, Map<Path, ErrorHandlingDataImporter> importerMapping, Path relativePath, EntrySource entrySource, Path namespace) throws IOException {
        ErrorHandlingDataImporter importer = importerMapping.get(namespace);
        if (importer == null) {
            log.info("Ignoring file {}, namespace {} did not match any importers", (Object)relativePath, (Object)namespace);
            return;
        }
        if (importer.delegate instanceof MetadataImporter || importer.delegate instanceof PullRequestImporter) {
            try {
                context.abortIfCanceled();
            }
            catch (CanceledMigrationException e) {
                this.finalizeHierarchy(context, importerMapping, DefaultImportService.requireCurrentHierarchyId(context));
                throw e;
            }
        }
        entrySource.read(inputStream -> {
            String name;
            Path localPath = relativePath;
            if (gzipCompressed.matches(localPath)) {
                inputStream = new GZIPInputStream((InputStream)inputStream);
                name = localPath.getFileName().toString();
                name = name.substring(0, name.length() - ".atl.gz".length());
                localPath = localPath.resolveSibling(name);
            }
            if (tarArchive.matches(localPath)) {
                name = localPath.getFileName().toString();
                name = name.substring(0, name.length() - ".atl.tar".length());
                localPath = localPath.resolveSibling(name);
                importer.importArchiveEntry(new TarArchiveSource((InputStream)inputStream, localPath));
            } else {
                importer.importEntry(new DefaultEntrySource((InputStream)inputStream, localPath));
            }
        });
    }

    private void handleInternalPath(InternalImportContext context, Map<Path, ErrorHandlingDataImporter> importerMapping, Path relativePath) {
        if (this.isPathHierarchyEndMarker(relativePath)) {
            String currentHierarchyId;
            String hierarchyId = relativePath.getFileName().toString();
            if (!hierarchyId.equals(currentHierarchyId = DefaultImportService.requireCurrentHierarchyId(context))) {
                throw new IllegalStateException("Expected hierarchy ID '" + currentHierarchyId + "' but was: " + hierarchyId);
            }
            this.finalizeHierarchy(context, importerMapping, hierarchyId);
            context.setCurrentHierarchyId(null);
        } else if (this.isPathHierarchyBeginMarker(relativePath)) {
            String hierarchyId = relativePath.getFileName().toString();
            context.setCurrentHierarchyId(hierarchyId);
        }
    }

    private void integrityCheckRepositories(ImportContext context, String hierarchyId) {
        try {
            this.securityService.withPermission(Permission.SYS_ADMIN, "Import integrity checks").call(() -> {
                this.integrityCheckHelper.runRepositoryChecks(new ImportIntegrityCheckRequest.Builder().context(context).hierarchyId(hierarchyId).build());
                return null;
            });
        }
        catch (Exception e) {
            context.addError(this.i18nService.createKeyedMessage("bitbucket.service.migration.repository.import.repository.integrity.check.failed", new Object[]{e.toString()}), null, (Throwable)e);
        }
    }

    private boolean isPathHierarchyBeginMarker(Path relativePath) {
        return relativePath.getNameCount() == 3 && relativePath.getName(0).equals(MigrationPaths.REPO_PATH_PREFIX) && relativePath.getName(1).equals(MigrationPaths.HIERARCHY_BEGIN_PREFIX);
    }

    private boolean isPathHierarchyEndMarker(Path relativePath) {
        return relativePath.getNameCount() == 3 && relativePath.getName(0).equals(MigrationPaths.REPO_PATH_PREFIX) && relativePath.getName(1).equals(MigrationPaths.HIERARCHY_END_PREFIX);
    }

    private Runnable startProgressUpdaterThread(@Nonnull InternalImportContext context, MigrationJob job) {
        ScheduledExecutorService executor = this.executorServiceSupplier.get();
        ScheduledFuture<?> statusUpdater = executor.scheduleAtFixedRate(() -> {
            try {
                this.securityService.withPermission(Permission.ADMIN, "Import job progress update").call(() -> {
                    int progress = context.getProgressPercentage();
                    job.updateProgress(new MigrationJobProgressUpdateRequest.Builder().percentage(Math.min(99, progress)).build());
                    return null;
                });
            }
            catch (IOException e) {
                log.warn("Exception while updating import progress: {}", (Object)e, (Object)(log.isDebugEnabled() ? e : null));
            }
        }, 5000L, 5000L, TimeUnit.MILLISECONDS);
        return () -> {
            statusUpdater.cancel(true);
            executor.shutdown();
        };
    }

    private class ErrorHandlingDataImporter {
        private final InternalImportContext context;
        private final Importer delegate;
        private final Path namespace;

        ErrorHandlingDataImporter(Importer delegate, InternalImportContext context, Path namespace) {
            this.context = context.forNamespace(namespace);
            this.delegate = delegate;
            this.namespace = namespace;
        }

        void finaliseRepositoryImport(Repository repository) {
            block2: {
                try {
                    this.delegate.finalizeRepositoryImport((ImportContext)this.context, repository);
                }
                catch (Exception e) {
                    this.addCallbackErrorFor(e, "finalizeRepositoryImport", repository);
                    if (!(e instanceof FatalImportException)) break block2;
                    throw e;
                }
            }
        }

        Path getNamespace() {
            return this.namespace;
        }

        void importArchiveEntry(ArchiveSource archiveSource) {
            block2: {
                try {
                    this.delegate.onArchiveEntry((ImportContext)this.context, archiveSource);
                }
                catch (Exception e) {
                    this.addCallbackErrorFor(e, "onArchiveEntry", new Object[0]);
                    if (!(e instanceof FatalImportException)) break block2;
                    throw e;
                }
            }
        }

        void importEntry(EntrySource entrySource) {
            block2: {
                try {
                    this.delegate.onEntry((ImportContext)this.context, entrySource);
                }
                catch (Exception e) {
                    this.addCallbackErrorFor(e, "importEntry", new Object[0]);
                    if (!(e instanceof FatalImportException)) break block2;
                    throw e;
                }
            }
        }

        boolean onEnd() {
            try {
                this.delegate.onEnd((ImportContext)this.context);
                return true;
            }
            catch (Exception e) {
                this.addCallbackErrorFor(e, "onError", new Object[0]);
                if (e instanceof FatalImportException) {
                    throw e;
                }
                return false;
            }
        }

        boolean onStart() {
            try {
                this.delegate.onStart((ImportContext)this.context);
                return true;
            }
            catch (Exception e) {
                this.addCallbackErrorFor(e, "onStart", new Object[0]);
                if (e instanceof FatalImportException) {
                    throw e;
                }
                return false;
            }
        }

        private void addCallbackErrorFor(Exception e, String callback, Object ... fallbackSubjects) {
            KeyedMessage message = DefaultImportService.this.i18nService.createKeyedMessage("bitbucket.service.migration.callback.error", new Object[]{callback, this.delegate.getClass(), e.getMessage() == null ? "" : e.getMessage()});
            this.context.addError(message, DefaultImportService.getSubject(e, fallbackSubjects), (Throwable)e);
        }
    }
}

