/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.stash.internal.migration;

import com.atlassian.bitbucket.i18n.I18nService;
import com.atlassian.bitbucket.i18n.KeyedMessage;
import com.atlassian.bitbucket.job.JobMessageSeverity;
import com.atlassian.bitbucket.migration.CanceledMigrationException;
import com.atlassian.bitbucket.migration.MeshMigrationRequest;
import com.atlassian.stash.internal.migration.InternalMeshMigrationContext;
import com.atlassian.stash.internal.migration.MigrationJob;
import com.atlassian.stash.internal.migration.entity.MigrationEntityIdentifierMapper;
import jakarta.annotation.Nonnull;
import jakarta.annotation.Nullable;
import java.util.Objects;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class DefaultMeshMigrationContext
implements InternalMeshMigrationContext {
    private static final Logger log = LoggerFactory.getLogger(DefaultMeshMigrationContext.class);
    private final I18nService i18nService;
    private final MigrationJob job;
    private final MeshMigrationRequest request;
    private volatile boolean canceled;
    private volatile boolean inError;

    public DefaultMeshMigrationContext(@Nonnull MigrationJob job, @Nonnull I18nService i18nService, @Nonnull MeshMigrationRequest request) {
        this.i18nService = Objects.requireNonNull(i18nService, "i18nService");
        this.job = Objects.requireNonNull(job, "job");
        this.request = Objects.requireNonNull(request, "request");
    }

    public void abortIfCanceled() {
        if (this.canceled) {
            throw new CanceledMigrationException(this.i18nService.createKeyedMessage("bitbucket.service.migration.mesh.job.canceled", new Object[0]));
        }
    }

    public void addError(@Nonnull KeyedMessage message, @Nullable Object entity) {
        this.addError(message, entity, null);
    }

    public void addError(@Nonnull KeyedMessage message, @Nullable Object entity, @Nullable Throwable t) {
        Objects.requireNonNull(message, "message");
        String identifier = MigrationEntityIdentifierMapper.getEntityIdentifier(entity);
        log.error("Error registered for job {} of type {} ({}) against {}: {}", new Object[]{this.job.getId(), this.job.getType(), this.job.getState(), identifier, message.getRootMessage(), t});
        this.job.addMessage(message, identifier, JobMessageSeverity.ERROR);
        this.inError = true;
    }

    public void addWarning(@Nonnull KeyedMessage message, Object entity) {
        this.addWarning(message, entity, null);
    }

    public void addWarning(@Nonnull KeyedMessage message, Object entity, Throwable t) {
        Objects.requireNonNull(message, "message");
        String identifier = MigrationEntityIdentifierMapper.getEntityIdentifier(entity);
        log.warn("Warning registered for job {} of type {} ({}) against {}: {}", new Object[]{this.job.getId(), this.job.getType(), this.job.getState(), identifier, message.getRootMessage(), t});
        this.job.addMessage(message, identifier, JobMessageSeverity.WARN);
    }

    public void cancel() {
        if (!this.canceled) {
            log.debug("Cancelling migration job {}", (Object)this.job);
            this.canceled = true;
            return;
        }
        throw new IllegalStateException("Migration has already been canceled");
    }

    @Nonnull
    public MigrationJob getJob() {
        return this.job;
    }

    @Nonnull
    public MeshMigrationRequest getRequest() {
        return this.request;
    }

    public boolean hasErrors() {
        return this.inError;
    }

    public boolean isCanceled() {
        return this.canceled;
    }
}

