/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.stash.internal.migration;

import com.atlassian.audit.api.AuditService;
import com.atlassian.audit.entity.AuditAttribute;
import com.atlassian.audit.entity.AuditEvent;
import com.atlassian.audit.entity.AuditType;
import com.atlassian.audit.entity.CoverageArea;
import com.atlassian.audit.entity.CoverageLevel;
import com.atlassian.bitbucket.NoSuchEntityException;
import com.atlassian.bitbucket.ServiceException;
import com.atlassian.bitbucket.dmz.mesh.AssignPartitionRequest;
import com.atlassian.bitbucket.dmz.mesh.DmzMeshPartitionRegistry;
import com.atlassian.bitbucket.dmz.mesh.DmzMeshRemigrator;
import com.atlassian.bitbucket.dmz.mesh.DmzMeshService;
import com.atlassian.bitbucket.dmz.mesh.MeshPartition;
import com.atlassian.bitbucket.dmz.mesh.MeshPartitionReplica;
import com.atlassian.bitbucket.dmz.migration.MeshMigrationContext;
import com.atlassian.bitbucket.dmz.migration.MeshMigrationJob;
import com.atlassian.bitbucket.dmz.migration.MeshMigrationJobState;
import com.atlassian.bitbucket.dmz.migration.MeshMigrationQueueState;
import com.atlassian.bitbucket.dmz.migration.MeshMigrationSummary;
import com.atlassian.bitbucket.dmz.migration.MeshMigrator;
import com.atlassian.bitbucket.dmz.migration.MigrationRepository;
import com.atlassian.bitbucket.dmz.migration.MigrationRepositorySearchRequest;
import com.atlassian.bitbucket.dmz.migration.MigrationStep;
import com.atlassian.bitbucket.dmz.repository.DmzRepository;
import com.atlassian.bitbucket.dmz.server.DmzStorageService;
import com.atlassian.bitbucket.i18n.I18nService;
import com.atlassian.bitbucket.i18n.KeyedMessage;
import com.atlassian.bitbucket.internal.mesh.RpcManagementClient;
import com.atlassian.bitbucket.migration.CanceledMigrationException;
import com.atlassian.bitbucket.migration.InsufficientDiskSpaceException;
import com.atlassian.bitbucket.migration.MeshMigrationRequest;
import com.atlassian.bitbucket.migration.RepositoriesExportRequest;
import com.atlassian.bitbucket.migration.RepositorySelector;
import com.atlassian.bitbucket.repository.MinimalRef;
import com.atlassian.bitbucket.repository.Repository;
import com.atlassian.bitbucket.repository.RepositoryAlreadyExistsException;
import com.atlassian.bitbucket.scm.CreateCommandParameters;
import com.atlassian.bitbucket.scope.ProjectScope;
import com.atlassian.bitbucket.scope.RepositoryScope;
import com.atlassian.bitbucket.scope.ScopeType;
import com.atlassian.bitbucket.scope.ScopeVisitor;
import com.atlassian.bitbucket.util.MoreCollectors;
import com.atlassian.bitbucket.util.MoreFiles;
import com.atlassian.bitbucket.util.NumberUtils;
import com.atlassian.bitbucket.util.Page;
import com.atlassian.bitbucket.util.PageRequest;
import com.atlassian.bitbucket.util.PageUtils;
import com.atlassian.stash.internal.InternalConverter;
import com.atlassian.stash.internal.mesh.RemoteDataStore;
import com.atlassian.stash.internal.mesh.RemoteDataStoreShard;
import com.atlassian.stash.internal.migration.ExportScopeResolver;
import com.atlassian.stash.internal.migration.InternalMeshMigrationContext;
import com.atlassian.stash.internal.migration.InternalMeshMigrationJob;
import com.atlassian.stash.internal.migration.InternalMeshMigrationQueueItem;
import com.atlassian.stash.internal.migration.MeshMigrationDao;
import com.atlassian.stash.internal.migration.MeshMigrationService;
import com.atlassian.stash.internal.migration.MeshMigrationUnavailableException;
import com.atlassian.stash.internal.migration.MigrationJob;
import com.atlassian.stash.internal.migration.MigrationJobProgressUpdateRequest;
import com.atlassian.stash.internal.migration.MigrationPaths;
import com.atlassian.stash.internal.migration.WeightedMigrationStep;
import com.atlassian.stash.internal.repository.InternalRepository;
import com.atlassian.stash.internal.repository.InternalRepositoryService;
import com.atlassian.stash.internal.scm.InternalScmService;
import com.atlassian.stash.internal.spring.SpringTransactionUtils;
import com.google.common.annotations.VisibleForTesting;
import com.google.common.primitives.Ints;
import jakarta.annotation.Nonnull;
import java.io.FileNotFoundException;
import java.io.IOException;
import java.nio.file.NoSuchFileException;
import java.nio.file.OpenOption;
import java.nio.file.Path;
import java.time.Instant;
import java.util.ArrayList;
import java.util.Comparator;
import java.util.EnumSet;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import java.util.Set;
import java.util.concurrent.CopyOnWriteArrayList;
import java.util.function.Function;
import java.util.stream.Collectors;
import org.apache.commons.lang3.mutable.MutableInt;
import org.apache.commons.lang3.mutable.MutableLong;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.beans.factory.annotation.Value;
import org.springframework.stereotype.Component;
import org.springframework.transaction.PlatformTransactionManager;
import org.springframework.transaction.annotation.Propagation;
import org.springframework.transaction.annotation.Transactional;
import org.springframework.transaction.support.TransactionTemplate;

@Component(value="meshMigrationService")
public class DefaultMeshMigrationService
implements MeshMigrationService {
    static final String AUDIT_I18N_KEY_PREFIX = "bitbucket.service.mesh.audit.";
    @VisibleForTesting
    static final String ACTION_MIGRATION_FINISHED = "bitbucket.service.mesh.audit.action.migration.finished";
    @VisibleForTesting
    static final String ACTION_MIGRATION_STARTED = "bitbucket.service.mesh.audit.action.migration.started";
    @VisibleForTesting
    static final String ATTR_MIGRATION_JOBID = "bitbucket.service.mesh.audit.attribute.migration.jobid";
    @VisibleForTesting
    static final double WEIGHT_COMPLETION = 0.1;
    static final double WEIGHT_STAGING = 0.9;
    private static final String PROP_FREE_SPACE_AFTER_MIGRATION = "${plugin.bitbucket-git.mesh.migration.free-space-after:2147483648}";
    private static final Logger log = LoggerFactory.getLogger(DefaultMeshMigrationService.class);
    private final AuditService auditService;
    private final ExportScopeResolver exportScopeResolver;
    private final I18nService i18nService;
    private final RpcManagementClient managementClient;
    private final MeshMigrationDao meshMigrationDao;
    private final List<MeshMigrator> meshMigrators;
    private final DmzMeshRemigrator meshRemigrator;
    private final DmzMeshService meshService;
    private final DmzMeshPartitionRegistry partitionRegistry;
    private final TransactionTemplate readOnlyTx;
    private final TransactionTemplate readWriteTx;
    private final InternalRepositoryService repositoryService;
    private final long requiredFreeSpaceAfterMigration;
    private final InternalScmService scmService;
    private final DmzStorageService storageService;

    @Autowired
    public DefaultMeshMigrationService(AuditService auditService, ExportScopeResolver exportScopeResolver, I18nService i18nService, Optional<RpcManagementClient> managementClient, MeshMigrationDao meshMigrationDao, List<MeshMigrator> meshMigrators, DmzMeshRemigrator meshRemigrator, DmzMeshService meshService, DmzMeshPartitionRegistry partitionRegistry, InternalRepositoryService repositoryService, @Value(value="${plugin.bitbucket-git.mesh.migration.free-space-after:2147483648}") long requiredFreeSpaceAfterMigration, InternalScmService scmService, DmzStorageService storageService, PlatformTransactionManager transactionManager) {
        this.auditService = auditService;
        this.exportScopeResolver = exportScopeResolver;
        this.i18nService = i18nService;
        this.managementClient = managementClient.orElse(null);
        this.meshMigrationDao = meshMigrationDao;
        this.meshMigrators = (List)meshMigrators.stream().sorted(Comparator.comparing(MeshMigrator::getPhase)).collect(MoreCollectors.toImmutableList());
        this.meshRemigrator = meshRemigrator;
        this.meshService = meshService;
        this.partitionRegistry = partitionRegistry;
        this.repositoryService = repositoryService;
        this.requiredFreeSpaceAfterMigration = Math.max(0x6400000L, requiredFreeSpaceAfterMigration);
        this.scmService = scmService;
        this.storageService = storageService;
        this.readOnlyTx = new TransactionTemplate(transactionManager, SpringTransactionUtils.definitionFor((int)0, (boolean)true));
        this.readWriteTx = new TransactionTemplate(transactionManager, SpringTransactionUtils.REQUIRES_NEW);
    }

    @Transactional
    public boolean beginCanceling(long internalJobId) {
        InternalMeshMigrationJob job = this.meshMigrationDao.findByInternalJobId(internalJobId);
        if (job == null || job.getState() != MeshMigrationJobState.RUNNING && job.getState() != MeshMigrationJobState.PAUSED) {
            return false;
        }
        this.meshMigrationDao.update((Object)new InternalMeshMigrationJob.Builder((MeshMigrationJob)job).state(MeshMigrationJobState.CANCELING).build());
        return true;
    }

    @Nonnull
    @Transactional(readOnly=true)
    public Page<MeshMigrationSummary> findAllMeshMigrationSummaries(@Nonnull PageRequest pageRequest) {
        return this.meshMigrationDao.findAllOrderedByStartTime(pageRequest).transform(job -> new MeshMigrationSummary.Builder((MeshMigrationJob)job).queueCountByState(this.meshMigrationDao.countByState(job)).build());
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Transactional
    public void finishCanceling(long internalJobId) {
        InternalMeshMigrationJob meshMigrationJob = this.meshMigrationDao.findByInternalJobId(internalJobId);
        if (meshMigrationJob == null) {
            throw new NoSuchEntityException(this.i18nService.createKeyedMessage("bitbucket.service.migration.message.error.invalidjob", new Object[]{internalJobId}));
        }
        try {
            this.resetInProgressHierarchy(meshMigrationJob);
        }
        finally {
            this.readWriteTx.executeWithoutResult(ignored -> this.meshMigrationDao.update((Object)new InternalMeshMigrationJob.Builder((MeshMigrationJob)meshMigrationJob).endTime(Instant.now()).state(MeshMigrationJobState.DONE).build()));
        }
    }

    @Nonnull
    @Transactional(readOnly=true)
    public Optional<MeshMigrationSummary> getMigrationSummary(Long internalJobId) {
        return this.getMigrationSummary(internalJobId == null ? this.meshMigrationDao.findActive() : this.meshMigrationDao.findByInternalJobId(internalJobId.longValue()));
    }

    @Transactional(propagation=Propagation.NOT_SUPPORTED)
    public void migrateRepositories(@Nonnull InternalMeshMigrationContext context, @Nonnull MeshMigrationRequest request) {
        MigrationJob job = context.getJob();
        MutableLong totalRepositories = new MutableLong(0L);
        InternalMeshMigrationJob meshMigrationJob = (InternalMeshMigrationJob)this.readWriteTx.execute(ignored -> {
            InternalMeshMigrationJob migrationJob = (InternalMeshMigrationJob)this.meshMigrationDao.create((Object)new InternalMeshMigrationJob.Builder().internalJobId(job.getId()).startTime(Instant.now()).build());
            this.exportScopeResolver.stream(request).filter(scope -> scope.getType() == ScopeType.REPOSITORY).peek(scope -> totalRepositories.increment()).map(scope -> (RepositoryScope)scope).forEach(repositoryScope -> this.meshMigrationDao.addToQueue(migrationJob, InternalConverter.convertToInternalRepository((Repository)repositoryScope.getRepository())));
            return migrationJob;
        });
        MeshMigrationVisitor migrator = new MeshMigrationVisitor(context, meshMigrationJob, totalRepositories.getValue());
        try {
            InternalMeshMigrationQueueItem nextItem;
            job.start();
            this.auditJob((MeshMigrationJob)meshMigrationJob, ACTION_MIGRATION_STARTED);
            log.info("Mesh migration job '{}' has started.", (Object)job.getId());
            while ((nextItem = (InternalMeshMigrationQueueItem)this.readOnlyTx.execute(ignored -> this.meshMigrationDao.getNextFromQueue(meshMigrationJob))) != null) {
                InternalRepository repository = nextItem.getRepository();
                this.exportScopeResolver.stream(new RepositoriesExportRequest.Builder().include(RepositorySelector.of((Repository)repository)).build()).forEach(scope -> {
                    context.abortIfCanceled();
                    scope.accept((ScopeVisitor)migrator);
                });
            }
            try {
                migrator.completeCurrentHierarchy();
            }
            catch (RuntimeException e) {
                migrator.onError(null, e);
            }
            boolean hasErrors = context.hasErrors();
            if (hasErrors) {
                log.info("Migration job '{}' has completed with errors.", (Object)job.getId());
            } else {
                log.info("Migration job '{}' has completed successfully.", (Object)job.getId());
            }
            job.complete(hasErrors);
        }
        catch (CanceledMigrationException e) {
            log.info("Migration job '{}' has been canceled", (Object)job.getId(), (Object)(log.isDebugEnabled() ? e : null));
            migrator.abort(MeshMigrationQueueState.CANCELED);
            job.finishCanceling();
        }
        catch (RuntimeException e) {
            this.handleUnrecoverableError((MeshMigrationContext)context, job, migrator, e);
        }
        catch (Error e) {
            this.handleUnrecoverableError((MeshMigrationContext)context, job, migrator, e);
            throw e;
        }
        finally {
            this.auditJob((MeshMigrationJob)meshMigrationJob, ACTION_MIGRATION_FINISHED);
            this.readWriteTx.executeWithoutResult(ignored -> this.meshMigrationDao.update((Object)new InternalMeshMigrationJob.Builder((MeshMigrationJob)meshMigrationJob).endTime(Instant.now()).state(MeshMigrationJobState.DONE).build()));
        }
    }

    @Transactional(propagation=Propagation.NOT_SUPPORTED)
    public void remigrateRepositories(@Nonnull InternalMeshMigrationContext context) {
        MigrationJob job = context.getJob();
        Map repositoriesByHierarchy = this.exportScopeResolver.stream(context.getRequest()).filter(scope -> scope.getType() == ScopeType.REPOSITORY).map(scope -> ((RepositoryScope)scope).getRepository()).collect(Collectors.toMap(Repository::getHierarchyId, Function.identity(), (oldValue, newValue) -> oldValue));
        double weightPerHierarchy = 1.0 / (double)repositoriesByHierarchy.size();
        job.start();
        log.info("Mesh re-migration job [{}] has started.", (Object)job.getId());
        repositoriesByHierarchy.values().forEach(targetRepo -> {
            try {
                List repositories = this.meshRemigrator.prepare(targetRepo);
                MutableInt completed = new MutableInt();
                repositories.forEach(repository -> {
                    context.abortIfCanceled();
                    this.meshRemigrator.remigrate(repository);
                    completed.increment();
                    context.getJob().updateProgress(new MigrationJobProgressUpdateRequest.Builder().percentage(Ints.saturatedCast((long)Math.round(100.0 * (weightPerHierarchy * completed.doubleValue()) / (double)repositories.size()))).message(this.i18nService.createKeyedMessage("bitbucket.service.migration.mesh.progress.message.repository", new Object[]{repository.getProject().getKey(), repository.getSlug()})).build());
                });
                this.meshRemigrator.commit(targetRepo);
                log.info("[{}] Successfully re-migrated hierarchy containing {} repositories", targetRepo, (Object)repositories.size());
            }
            catch (CanceledMigrationException e) {
                log.info("[{}] Mesh re-migration job canceled. Aborting the rest of the hierarchy {}", targetRepo, (Object)targetRepo.getHierarchyId());
                this.meshRemigrator.abort(targetRepo);
                context.addError(this.i18nService.createKeyedMessage("bitbucket.service.migration.mesh.hierarchy-failed", new Object[]{targetRepo.getHierarchyId()}), null);
            }
            catch (RuntimeException e) {
                log.error("[{}] Mesh re-migration failed. Aborting hierarchy {}", new Object[]{targetRepo, targetRepo.getHierarchyId(), e});
                this.meshRemigrator.abort(targetRepo);
                context.addError(this.i18nService.createKeyedMessage("bitbucket.service.migration.mesh.hierarchy-failed", new Object[]{targetRepo.getHierarchyId()}), null);
            }
        });
        boolean hasErrors = context.hasErrors();
        log.info("Mesh re-migration job [{}] finished {}", (Object)job.getId(), (Object)(hasErrors ? "with errors." : "successfully."));
        job.complete(hasErrors);
    }

    @Nonnull
    @Transactional(readOnly=true)
    public Page<MigrationRepository> searchRepositories(@Nonnull MigrationRepositorySearchRequest request, @Nonnull PageRequest pageRequest) {
        InternalMeshMigrationJob job;
        MigrationRepositorySearchRequest.Builder builder = new MigrationRepositorySearchRequest.Builder(request);
        if (request.getJobId().isPresent()) {
            long jobId = (Long)request.getJobId().get();
            job = this.meshMigrationDao.findByInternalJobId(jobId);
            if (job == null) {
                throw new NoSuchEntityException(this.i18nService.createKeyedMessage("bitbucket.service.migration.message.error.invalidjob", new Object[]{jobId}));
            }
        } else {
            job = this.meshMigrationDao.findActive();
        }
        if (job != null) {
            builder.jobId(Long.valueOf(job.getId()));
        }
        return this.meshMigrationDao.searchRepositories(builder.build(), pageRequest);
    }

    private void auditJob(MeshMigrationJob job, String action) {
        AuditType auditType = AuditType.fromI18nKeys((CoverageArea)CoverageArea.GLOBAL_CONFIG_AND_ADMINISTRATION, (CoverageLevel)CoverageLevel.BASE, (String)"bitbucket.service.audit.category.globaladministration", (String)action).build();
        AuditEvent.Builder builder = AuditEvent.builder((AuditType)auditType).extraAttribute(AuditAttribute.fromI18nKeys((String)ATTR_MIGRATION_JOBID, (String)Long.toString(job.getId())).build());
        this.auditService.audit(builder.build());
    }

    private Path getMigrationDataDir(String hierarchyId) {
        return this.storageService.getHierarchyDataDir(hierarchyId).resolve(MigrationPaths.MESH_MIGRATION_DATA_PATH);
    }

    private Optional<MeshMigrationSummary> getMigrationSummary(InternalMeshMigrationJob job) {
        return Optional.ofNullable(job == null ? null : new MeshMigrationSummary.Builder((MeshMigrationJob)job).queueCountByState(this.meshMigrationDao.countByState(job)).build());
    }

    private Optional<Integer> getPartitionForHierarchy(String hierarchyId) {
        Path path = this.getMigrationDataDir(hierarchyId).resolve("partition");
        try {
            return Optional.of(Integer.parseInt(MoreFiles.toString((Path)path)));
        }
        catch (FileNotFoundException | NoSuchFileException iOException) {
        }
        catch (IOException | RuntimeException e) {
            log.warn("Cannot determine whether hierarchy {} has previously assigned to a partition", (Object)hierarchyId, (Object)e);
        }
        return Optional.empty();
    }

    private void handleUnrecoverableError(MeshMigrationContext context, MigrationJob job, MeshMigrationVisitor migrator, Throwable t) {
        log.error("Migration job '{}' encountered an unrecoverable error", (Object)job.getId(), (Object)t);
        if (t instanceof ServiceException) {
            context.addError(((ServiceException)t).getKeyedMessage(), null);
        } else {
            context.addError(this.i18nService.createKeyedMessage("bitbucket.service.migration.mesh.unrecoverable.error", new Object[0]), null);
        }
        migrator.abort(MeshMigrationQueueState.FAILED);
        job.abort();
    }

    private void resetInProgressHierarchy(InternalMeshMigrationJob job) {
        EnumSet<MeshMigrationQueueState> inProgressStates = EnumSet.of(MeshMigrationQueueState.STAGED, MeshMigrationQueueState.STAGING, MeshMigrationQueueState.QUEUED);
        MigrationRepositorySearchRequest searchRequest = new MigrationRepositorySearchRequest.Builder().jobId(Long.valueOf(job.getId())).states(inProgressStates).build();
        this.meshMigrationDao.searchRepositories(searchRequest, PageUtils.newRequest((int)0, (int)1)).stream().findFirst().ifPresent(m -> {
            String hierarchyId = m.getRepository().getHierarchyId();
            this.getPartitionForHierarchy(hierarchyId).ifPresent(partition -> {
                log.debug("Attempting to reset the hierarchy {} in partition {}", (Object)hierarchyId, partition);
                this.meshService.resetHierarchy(partition.intValue(), hierarchyId);
                this.readWriteTx.execute(ignored -> this.meshMigrationDao.updateQueueStateByHierarchy(job, hierarchyId, (Set)inProgressStates, MeshMigrationQueueState.CANCELED));
            });
        });
    }

    private class MeshMigrationVisitor
    implements ScopeVisitor<Void> {
        private final InternalMeshMigrationContext context;
        private final List<MeshMigrator.HierarchyMigration> currentHierarchyMigrations;
        private final InternalMeshMigrationJob job;
        private final List<Integer> staged;
        private final long total;
        private long availableSpace;
        private long completed;
        private String currentHierarchy;
        private boolean currentHierarchyAborted;
        private int targetPartition;

        private MeshMigrationVisitor(InternalMeshMigrationContext context, InternalMeshMigrationJob job, long total) {
            this.context = context;
            this.job = job;
            this.total = total;
            this.currentHierarchyMigrations = new CopyOnWriteArrayList<MeshMigrator.HierarchyMigration>();
            this.staged = new ArrayList<Integer>();
        }

        public void abort(MeshMigrationQueueState finalState) {
            for (MeshMigrator.HierarchyMigration migration : this.currentHierarchyMigrations) {
                try {
                    migration.abort();
                }
                catch (RuntimeException e) {
                    log.warn("Failed to cleanly abort migration", (Throwable)e);
                }
            }
            if (this.currentHierarchy != null) {
                if (finalState == MeshMigrationQueueState.CANCELED || finalState == MeshMigrationQueueState.FAILED) {
                    DefaultMeshMigrationService.this.meshService.resetHierarchy(this.targetPartition, this.currentHierarchy);
                }
                DefaultMeshMigrationService.this.readWriteTx.executeWithoutResult(ignored -> DefaultMeshMigrationService.this.meshMigrationDao.updateQueueStateByHierarchy(this.job, this.currentHierarchy, EnumSet.of(MeshMigrationQueueState.QUEUED, MeshMigrationQueueState.STAGING, MeshMigrationQueueState.STAGED), finalState));
            }
        }

        public Void visit(@Nonnull ProjectScope scope) {
            this.context.abortIfCanceled();
            return null;
        }

        public Void visit(@Nonnull RepositoryScope scope) {
            block10: {
                Repository repository = scope.getRepository();
                if (repository.isRemote() || !"git".equals(repository.getScmId())) {
                    ++this.completed;
                    DefaultMeshMigrationService.this.readWriteTx.executeWithoutResult(ignored -> DefaultMeshMigrationService.this.meshMigrationDao.updateQueueStateByRepository(this.job, InternalConverter.convertToInternalRepository((Repository)repository), MeshMigrationQueueState.SKIPPED));
                    return null;
                }
                String hierarchy = repository.getHierarchyId();
                try {
                    boolean newHierarchy;
                    boolean bl = newHierarchy = !hierarchy.equals(this.currentHierarchy);
                    if (newHierarchy) {
                        this.completeCurrentHierarchy();
                        this.startHierarchy(hierarchy, repository);
                        this.availableSpace = this.getAvailableSpace();
                    }
                    if (this.currentHierarchyAborted) {
                        ++this.completed;
                        log.info("[{}] Skipping Mesh migration", (Object)repository);
                        break block10;
                    }
                    try {
                        long neededSpace = DefaultMeshMigrationService.this.repositoryService.getSize(repository);
                        long totalSpaceRequired = neededSpace + DefaultMeshMigrationService.this.requiredFreeSpaceAfterMigration;
                        if (totalSpaceRequired > this.availableSpace) {
                            throw new InsufficientDiskSpaceException(DefaultMeshMigrationService.this.i18nService.createKeyedMessage("bitbucket.service.migration.mesh.job.not.enough.space", new Object[]{NumberUtils.formatSize((double)totalSpaceRequired), repository.getId()}));
                        }
                        this.availableSpace -= neededSpace;
                        this.stageRepository(repository);
                    }
                    catch (CanceledMigrationException | InsufficientDiskSpaceException e) {
                        throw e;
                    }
                    catch (RuntimeException e) {
                        if (!newHierarchy) {
                            throw e;
                        }
                        log.warn("[{}] Migration failed. Attempting to reset the hierarchy and retrying...", (Object)repository, (Object)e);
                        DefaultMeshMigrationService.this.meshService.resetHierarchy(this.targetPartition, this.currentHierarchy);
                        this.stageRepository(repository);
                    }
                }
                catch (RuntimeException e) {
                    this.onError(repository, e);
                }
            }
            return null;
        }

        private long getAvailableSpace() {
            if (DefaultMeshMigrationService.this.managementClient == null) {
                throw new MeshMigrationUnavailableException(DefaultMeshMigrationService.this.i18nService.createKeyedMessage("bitbucket.service.migration.mesh.disabled", new Object[0]));
            }
            MeshPartition meshPartition = (MeshPartition)DefaultMeshMigrationService.this.partitionRegistry.getPartition(this.targetPartition).orElseThrow(() -> new IllegalStateException("Partition " + this.targetPartition + " not found"));
            return meshPartition.getReplicas().stream().map(MeshPartitionReplica::getNode).filter(node -> !node.isOffline()).flatMapToLong(node -> DefaultMeshMigrationService.this.managementClient.getDataStores(node).stream().filter(store -> store.getType() == RemoteDataStore.Type.MANAGED).mapToLong(store -> store.getShards().stream().filter(shard -> shard.getPartitions().contains(this.targetPartition)).findFirst().map(RemoteDataStoreShard::getUsableSpace).orElseGet(() -> store.getShards().stream().mapToLong(RemoteDataStoreShard::getUsableSpace).max().orElse(0L)))).min().orElse(0L);
        }

        private InternalRepository asMeshRepository(Repository repository) {
            if (repository == null) {
                return null;
            }
            InternalRepository internalRepository = InternalConverter.convertToInternalRepository((Repository)repository);
            if (internalRepository.isRemote()) {
                return internalRepository;
            }
            return new InternalRepository.Builder(internalRepository).partition(this.targetPartition).origin(this.asMeshRepository((Repository)internalRepository.getOrigin())).build();
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        private void completeCurrentHierarchy() {
            String hierarchy = this.currentHierarchy;
            try {
                if (hierarchy == null || this.currentHierarchyAborted) {
                    return;
                }
                if (!this.currentHierarchyMigrations.isEmpty()) {
                    double weightPerStagedRepo = 0.1 / (double)this.total;
                    double weightPerMigrator = weightPerStagedRepo * (double)this.staged.size() / (double)this.currentHierarchyMigrations.size();
                    for (MeshMigrator.HierarchyMigration migration : this.currentHierarchyMigrations) {
                        this.context.abortIfCanceled();
                        migration.complete((MigrationStep)new WeightedMigrationStep(this.context.getJob(), this.getProgress(), weightPerMigrator));
                    }
                }
                DefaultMeshMigrationService.this.repositoryService.updatePartitionForHierarchy(hierarchy, this.targetPartition);
                DefaultMeshMigrationService.this.readWriteTx.executeWithoutResult(ignored -> DefaultMeshMigrationService.this.meshMigrationDao.updateQueueStateByHierarchy(this.job, hierarchy, EnumSet.of(MeshMigrationQueueState.STAGED), MeshMigrationQueueState.MIGRATED));
                this.currentHierarchy = null;
                this.currentHierarchyMigrations.clear();
                this.completed += (long)this.staged.size();
                this.staged.clear();
                MoreFiles.deleteQuietly((Path)DefaultMeshMigrationService.this.getMigrationDataDir(hierarchy).resolve("partition"));
            }
            finally {
                this.updateProgress(null, this.getProgress());
            }
        }

        private InternalRepository createRepositoryInMesh(Repository repository) {
            MinimalRef defaultBranch = DefaultMeshMigrationService.this.repositoryService.getDefaultBranch(repository);
            InternalRepository meshRepository = this.asMeshRepository(repository);
            try {
                DefaultMeshMigrationService.this.scmService.create((Repository)meshRepository, new CreateCommandParameters.Builder().defaultBranch(defaultBranch.getId()).build());
                log.debug("[{}] Created repository in Mesh", (Object)repository);
            }
            catch (RepositoryAlreadyExistsException e) {
                log.info("[{}] Repository already exists in Mesh", (Object)repository);
            }
            return meshRepository;
        }

        private int getOrCreatePartitionForHierarchy(String hierarchyId) {
            Optional<Integer> currentPartition = DefaultMeshMigrationService.this.getPartitionForHierarchy(hierarchyId);
            if (currentPartition.isPresent()) {
                return currentPartition.get();
            }
            Path path = DefaultMeshMigrationService.this.getMigrationDataDir(hierarchyId).resolve("partition");
            int partition = DefaultMeshMigrationService.this.meshService.assignPartitionForHierarchy(new AssignPartitionRequest.Builder("git", hierarchyId).overrideEnabled(true).build());
            if (partition == -1) {
                this.context.addError(DefaultMeshMigrationService.this.i18nService.createKeyedMessage("bitbucket.service.migration.mesh.insufficient.nodes", new Object[0]), null);
                throw new IllegalStateException("Cannot migrate hierarchy " + hierarchyId);
            }
            MoreFiles.mkdir((Path)path.getParent());
            try {
                MoreFiles.write((Path)path, (String)Integer.toString(partition), (OpenOption[])new OpenOption[0]);
            }
            catch (IOException e) {
                log.warn("Failed to store partition mapping for hierarchy {}. Migration will start from scratch if the migration job is paused and restarted", (Object)hierarchyId, (Object)e);
            }
            return partition;
        }

        private double getProgress() {
            return 100.0 * ((double)this.completed + 0.9 * (double)this.staged.size()) / (double)this.total;
        }

        private KeyedMessage getProgressMessageStaging(Repository repository) {
            return DefaultMeshMigrationService.this.i18nService.createKeyedMessage("bitbucket.service.migration.mesh.progress.message.repository", new Object[]{repository.getProject().getKey(), repository.getSlug()});
        }

        private boolean isVetoed(String hierarchy) {
            return MoreFiles.canOpen((Path)DefaultMeshMigrationService.this.getMigrationDataDir(hierarchy).resolve("veto"));
        }

        private void onError(Repository repository, RuntimeException e) {
            if (e instanceof CanceledMigrationException) {
                throw e;
            }
            log.error("Migration of hierarchy {} failed", (Object)this.currentHierarchy, (Object)e);
            if (e instanceof ServiceException) {
                this.context.addError(((ServiceException)((Object)e)).getKeyedMessage(), null);
            } else {
                this.context.addError(DefaultMeshMigrationService.this.i18nService.createKeyedMessage("bitbucket.service.migration.mesh.hierarchy-failed", new Object[]{this.currentHierarchy}), null);
            }
            this.abort(MeshMigrationQueueState.FAILED);
            this.currentHierarchyAborted = true;
            this.currentHierarchyMigrations.clear();
            this.completed += (long)this.staged.size();
            if (repository != null && !this.staged.contains(repository.getId())) {
                ++this.completed;
            }
            this.staged.clear();
        }

        private void stageRepository(@Nonnull Repository repository) {
            double overallProgress = this.getProgress();
            KeyedMessage progressMessage = this.getProgressMessageStaging(repository);
            this.updateProgress(progressMessage, overallProgress);
            if (!this.currentHierarchyMigrations.isEmpty()) {
                InternalRepository meshRepository = this.createRepositoryInMesh(repository);
                double weight = 0.9 / (double)(this.total * (long)this.currentHierarchyMigrations.size());
                DefaultMeshMigrationService.this.readWriteTx.executeWithoutResult(ignored -> DefaultMeshMigrationService.this.meshMigrationDao.updateQueueStateByRepository(this.job, InternalConverter.convertToInternalRepository((Repository)repository), MeshMigrationQueueState.STAGING));
                for (MeshMigrator.HierarchyMigration migration : this.currentHierarchyMigrations) {
                    this.context.abortIfCanceled();
                    migration.stage(repository, (DmzRepository)meshRepository, (MigrationStep)new WeightedMigrationStep(this.context.getJob(), overallProgress, weight));
                    this.updateProgress(progressMessage, overallProgress += 100.0 * weight);
                }
                DefaultMeshMigrationService.this.readWriteTx.executeWithoutResult(ignored -> DefaultMeshMigrationService.this.meshMigrationDao.updateQueueStateByRepository(this.job, InternalConverter.convertToInternalRepository((Repository)repository), MeshMigrationQueueState.STAGED));
            }
            this.staged.add(repository.getId());
            this.updateProgress(progressMessage, this.getProgress());
        }

        private void startHierarchy(String hierarchyId, Repository repository) {
            this.currentHierarchyMigrations.clear();
            this.currentHierarchy = hierarchyId;
            this.currentHierarchyAborted = this.isVetoed(hierarchyId);
            if (this.currentHierarchyAborted) {
                log.info("Skipping migration of hierarchy {} ({}) because a migration/veto marker was found", (Object)hierarchyId, (Object)repository);
                this.abort(MeshMigrationQueueState.SKIPPED);
                return;
            }
            this.targetPartition = this.getOrCreatePartitionForHierarchy(hierarchyId);
            log.info("Migrating hierarchy {} ({}) to partition {}", new Object[]{hierarchyId, repository, this.targetPartition});
            for (MeshMigrator migrator : DefaultMeshMigrationService.this.meshMigrators) {
                this.context.abortIfCanceled();
                MeshMigrator.HierarchyMigration migration = migrator.startHierarchy((MeshMigrationContext)this.context, hierarchyId, this.targetPartition);
                if (migration == null) continue;
                this.currentHierarchyMigrations.add(migration);
            }
        }

        private void updateProgress(KeyedMessage message, double percentage) {
            this.context.getJob().updateProgress(new MigrationJobProgressUpdateRequest.Builder().percentage(Math.min(100, Ints.saturatedCast((long)Math.round(percentage)))).message(message).build());
        }
    }
}

