/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.stash.internal.migration;

import com.atlassian.sal.api.executor.ThreadLocalDelegateExecutorFactory;
import com.atlassian.stash.internal.migration.MigrationExecutorFactory;
import io.atlassian.util.concurrent.ThreadFactories;
import jakarta.annotation.Nonnull;
import java.util.concurrent.ExecutorService;
import java.util.concurrent.SynchronousQueue;
import java.util.concurrent.ThreadPoolExecutor;
import java.util.concurrent.TimeUnit;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.beans.factory.annotation.Value;
import org.springframework.stereotype.Component;

@Component
public class DefaultMigrationExecutorFactory
implements MigrationExecutorFactory {
    private final int poolSize;
    private final ThreadLocalDelegateExecutorFactory threadLocalDelegateExecutorFactory;

    @Autowired
    public DefaultMigrationExecutorFactory(@Value(value="${migration.threadpool.size}") int poolSize, ThreadLocalDelegateExecutorFactory threadLocalDelegateExecutorFactory) {
        this.poolSize = poolSize;
        this.threadLocalDelegateExecutorFactory = threadLocalDelegateExecutorFactory;
    }

    @Override
    @Nonnull
    public ExecutorService create() {
        return this.threadLocalDelegateExecutorFactory.createExecutorService((ExecutorService)new ThreadPoolExecutor(0, this.poolSize, 0L, TimeUnit.SECONDS, new SynchronousQueue<Runnable>(), ThreadFactories.namedThreadFactory((String)"dc-migration", (ThreadFactories.Type)ThreadFactories.Type.DAEMON)));
    }
}

