/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.stash.internal.migration;

import com.atlassian.bitbucket.NoSuchEntityException;
import com.atlassian.bitbucket.Product;
import com.atlassian.bitbucket.auth.AuthenticationContext;
import com.atlassian.bitbucket.dmz.migration.DmzMigrationService;
import com.atlassian.bitbucket.dmz.migration.MeshMigrationSummary;
import com.atlassian.bitbucket.dmz.migration.MigrationRepository;
import com.atlassian.bitbucket.dmz.migration.MigrationRepositorySearchRequest;
import com.atlassian.bitbucket.i18n.I18nService;
import com.atlassian.bitbucket.i18n.KeyedMessage;
import com.atlassian.bitbucket.job.Job;
import com.atlassian.bitbucket.job.JobCreationRequest;
import com.atlassian.bitbucket.job.JobMessage;
import com.atlassian.bitbucket.job.JobMessageSearchRequest;
import com.atlassian.bitbucket.job.JobMessageSeverity;
import com.atlassian.bitbucket.job.JobSearchRequest;
import com.atlassian.bitbucket.job.JobService;
import com.atlassian.bitbucket.job.JobState;
import com.atlassian.bitbucket.migration.ExportException;
import com.atlassian.bitbucket.migration.ExportRequest;
import com.atlassian.bitbucket.migration.ImportException;
import com.atlassian.bitbucket.migration.ImportRequest;
import com.atlassian.bitbucket.migration.MaxConcurrentMigrationJobsException;
import com.atlassian.bitbucket.migration.MeshMigrationRequest;
import com.atlassian.bitbucket.migration.MigrationJobMessageSearchRequest;
import com.atlassian.bitbucket.migration.MigrationService;
import com.atlassian.bitbucket.migration.event.MeshMigrationFinishedEvent;
import com.atlassian.bitbucket.migration.event.MeshMigrationStartedEvent;
import com.atlassian.bitbucket.migration.event.MigrationExportFinishedEvent;
import com.atlassian.bitbucket.migration.event.MigrationExportStartedEvent;
import com.atlassian.bitbucket.migration.event.MigrationImportFinishedEvent;
import com.atlassian.bitbucket.migration.event.MigrationImportStartedEvent;
import com.atlassian.bitbucket.permission.Permission;
import com.atlassian.bitbucket.project.Project;
import com.atlassian.bitbucket.project.ProjectService;
import com.atlassian.bitbucket.repository.Repository;
import com.atlassian.bitbucket.repository.RepositoryService;
import com.atlassian.bitbucket.scope.Scope;
import com.atlassian.bitbucket.server.Feature;
import com.atlassian.bitbucket.server.FeatureManager;
import com.atlassian.bitbucket.server.StandardFeature;
import com.atlassian.bitbucket.server.StorageService;
import com.atlassian.bitbucket.topic.Topic;
import com.atlassian.bitbucket.topic.TopicService;
import com.atlassian.bitbucket.topic.TopicSettings;
import com.atlassian.bitbucket.user.ApplicationUser;
import com.atlassian.bitbucket.user.SecurityService;
import com.atlassian.bitbucket.util.MoreFiles;
import com.atlassian.bitbucket.util.MoreStreams;
import com.atlassian.bitbucket.util.Operation;
import com.atlassian.bitbucket.util.Page;
import com.atlassian.bitbucket.util.PageRequest;
import com.atlassian.bitbucket.util.PageUtils;
import com.atlassian.bitbucket.util.Progress;
import com.atlassian.bitbucket.util.ProgressImpl;
import com.atlassian.bitbucket.validation.ArgumentValidationException;
import com.atlassian.event.api.EventPublisher;
import com.atlassian.nutcluster.core.IExecutorService;
import com.atlassian.nutcluster.core.Member;
import com.atlassian.nutcluster.core.MultiExecutionCallback;
import com.atlassian.nutcluster.spring.context.SpringAware;
import com.atlassian.plugin.spring.AvailableToPlugins;
import com.atlassian.stash.internal.InternalConverter;
import com.atlassian.stash.internal.cluster.NutclusterClusterNode;
import com.atlassian.stash.internal.maintenance.latch.ResultCollectingExecutionCallback;
import com.atlassian.stash.internal.migration.AbstractMigrationJob;
import com.atlassian.stash.internal.migration.DefaultExportContext;
import com.atlassian.stash.internal.migration.DefaultImportContext;
import com.atlassian.stash.internal.migration.DefaultMeshMigrationContext;
import com.atlassian.stash.internal.migration.ExportJob;
import com.atlassian.stash.internal.migration.ExportScopeResolver;
import com.atlassian.stash.internal.migration.ExportService;
import com.atlassian.stash.internal.migration.ImportJob;
import com.atlassian.stash.internal.migration.ImportService;
import com.atlassian.stash.internal.migration.InstanceMigrationExportDisabledException;
import com.atlassian.stash.internal.migration.InstanceMigrationImportUnavailableException;
import com.atlassian.stash.internal.migration.InternalExportContext;
import com.atlassian.stash.internal.migration.InternalImportContext;
import com.atlassian.stash.internal.migration.InternalMeshMigrationContext;
import com.atlassian.stash.internal.migration.InternalMigrationService;
import com.atlassian.stash.internal.migration.MeshMigrationJob;
import com.atlassian.stash.internal.migration.MeshMigrationService;
import com.atlassian.stash.internal.migration.MeshMigrationUnavailableException;
import com.atlassian.stash.internal.migration.MigrationExecutorFactory;
import com.atlassian.stash.internal.migration.ScopeVisitors;
import com.atlassian.stash.internal.migration.TarArchiveSource;
import com.atlassian.stash.internal.migration.TarExportTarget;
import com.atlassian.stash.internal.migration.UserEntityExportMapping;
import com.atlassian.stash.internal.migration.UserImportService;
import com.atlassian.stash.internal.spring.AbstractSmartLifecycle;
import com.google.common.annotations.VisibleForTesting;
import com.google.common.collect.MapMaker;
import jakarta.annotation.Nonnull;
import jakarta.annotation.PostConstruct;
import java.io.IOException;
import java.io.InputStream;
import java.io.Serializable;
import java.io.UncheckedIOException;
import java.nio.channels.Channels;
import java.nio.channels.FileChannel;
import java.nio.file.Files;
import java.nio.file.LinkOption;
import java.nio.file.Path;
import java.nio.file.Paths;
import java.nio.file.StandardOpenOption;
import java.nio.file.attribute.FileAttribute;
import java.time.Duration;
import java.time.Instant;
import java.time.temporal.ChronoUnit;
import java.util.Arrays;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.concurrent.Callable;
import java.util.concurrent.ExecutorService;
import java.util.concurrent.RejectedExecutionException;
import java.util.concurrent.TimeUnit;
import java.util.function.BiConsumer;
import java.util.function.Function;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import org.apache.commons.lang3.StringUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.beans.factory.annotation.Value;
import org.springframework.boot.convert.DurationUnit;
import org.springframework.security.access.prepost.PreAuthorize;
import org.springframework.stereotype.Service;

@AvailableToPlugins(interfaces={DmzMigrationService.class, MigrationService.class})
@Service(value="migrationService")
public class DefaultMigrationService
extends AbstractSmartLifecycle
implements InternalMigrationService {
    public static final String JOB_TYPE_EXPORT = "com.atlassian.bitbucket.migration.export";
    public static final String JOB_TYPE_IMPORT = "com.atlassian.bitbucket.migration.import";
    public static final String JOB_TYPE_MESH = "com.atlassian.bitbucket.migration.mesh";
    public static final String JOB_TYPE_MESH_REMIGRATION = "com.atlassian.bitbucket.remigration.mesh";
    private static final Path DEFAULT_EXPORT_DIR = Paths.get("migration", "export");
    private static final Path DEFAULT_IMPORT_DIR = Paths.get("migration", "import");
    private static final String EXPORT_ARCHIVE_PREFIX = Product.NAME + "_export_";
    private static final String EXPORT_ARCHIVE_SUFFIX = ".tar";
    private static final Duration IMPORT_JOB_TIMEOUT = Duration.ofMinutes(10L);
    private static final Duration MESH_MIGRATION_JOB_TIMEOUT = Duration.ofHours(3L);
    private static final Logger log = LoggerFactory.getLogger(DefaultMigrationService.class);
    private final Map<Long, InternalExportContext> activeExports;
    private final Map<Long, InternalImportContext> activeImports;
    private final Map<Long, InternalMeshMigrationContext> activeMeshMigrations;
    private final Map<Long, InternalMeshMigrationContext> activeMeshRemigrations;
    private final AuthenticationContext authenticationContext;
    private final Topic<JobCancellationMessage> cancelTopic;
    private final IExecutorService clusterExecutor;
    private final Path defaultExportPath;
    private final Path defaultImportPath;
    private final EventPublisher eventPublisher;
    private final ExecutorService executorService;
    private final ExportScopeResolver exportScopeResolver;
    private final ExportService exportService;
    private final FeatureManager featureManager;
    private final I18nService i18nService;
    private final ImportService importService;
    private final JobService jobService;
    private final Duration meshMigrationCancelClusterTimeout;
    private final MeshMigrationService meshMigrationService;
    private final ProjectService projectService;
    private final RepositoryService repositoryService;
    private final SecurityService securityService;
    private final UserEntityExportMapping userEntityExportMapping;
    private final UserImportService userImportService;
    private String cancelTopicSubscription;
    @Value(value="${mesh.enabled}")
    private boolean meshEnabled;

    @Autowired
    public DefaultMigrationService(AuthenticationContext authenticationContext, EventPublisher eventPublisher, MigrationExecutorFactory executorFactory, ExportScopeResolver exportScopeResolver, ExportService exportService, FeatureManager featureManager, I18nService i18nService, ImportService importService, JobService jobService, MeshMigrationService meshMigrationService, ProjectService projectService, RepositoryService repositoryService, SecurityService securityService, StorageService storageService, TopicService topicService, UserImportService userImportService, UserEntityExportMapping userEntityExportMapping, IExecutorService clusterExecutor, @DurationUnit(value=ChronoUnit.SECONDS) @Value(value="${mesh.migration.cancel.cluster.timeout}") Duration meshMigrationCancelClusterTimeout) {
        this.authenticationContext = authenticationContext;
        this.clusterExecutor = clusterExecutor;
        this.eventPublisher = eventPublisher;
        this.exportScopeResolver = exportScopeResolver;
        this.exportService = exportService;
        this.featureManager = featureManager;
        this.i18nService = i18nService;
        this.importService = importService;
        this.jobService = jobService;
        this.meshMigrationCancelClusterTimeout = meshMigrationCancelClusterTimeout;
        this.meshMigrationService = meshMigrationService;
        this.projectService = projectService;
        this.repositoryService = repositoryService;
        this.securityService = securityService;
        this.userImportService = userImportService;
        this.userEntityExportMapping = userEntityExportMapping;
        this.activeExports = new MapMaker().weakValues().makeMap();
        this.activeImports = new MapMaker().weakValues().makeMap();
        this.activeMeshMigrations = new MapMaker().weakValues().makeMap();
        this.activeMeshRemigrations = new MapMaker().weakValues().makeMap();
        this.cancelTopic = topicService.getTopic("migration:job:cancel", TopicSettings.builder(JobCancellationMessage.class).dedupePendingMessages(true).build());
        this.defaultExportPath = DefaultMigrationService.getOrCreateDefaultExportDirectory(storageService);
        this.defaultImportPath = DefaultMigrationService.getOrCreateDefaultImportDirectory(storageService);
        this.executorService = executorFactory.create();
    }

    @Nonnull
    @PreAuthorize(value="hasGlobalPermission('ADMIN')")
    public Optional<Job> cancelExport(long jobId) {
        Optional<Job> job = this.getExportJob(jobId);
        if (!job.isPresent()) {
            return Optional.empty();
        }
        ExportJob exportJob = new ExportJob(job.get(), this.jobService, this.i18nService);
        exportJob.beginCanceling();
        InternalExportContext context = this.activeExports.get(jobId);
        if (context != null) {
            context.cancel();
        } else {
            this.cancelTopic.publish((Serializable)new JobCancellationMessage(jobId, JobCancellationMessage.Type.EXPORT));
        }
        return job;
    }

    @Nonnull
    @PreAuthorize(value="hasGlobalPermission('ADMIN')")
    public Optional<Job> cancelImport(long jobId) {
        Optional<Job> job = this.getImportJob(jobId);
        if (!job.isPresent()) {
            return Optional.empty();
        }
        ImportJob importJob = new ImportJob(job.get(), this.jobService, this.i18nService);
        importJob.beginCanceling();
        InternalImportContext context = this.activeImports.get(jobId);
        if (context != null) {
            context.cancel();
        } else {
            this.cancelTopic.publish((Serializable)new JobCancellationMessage(jobId, JobCancellationMessage.Type.IMPORT));
        }
        return job;
    }

    public boolean cancelLocalMeshMigration(long jobId) {
        InternalMeshMigrationContext context = this.activeMeshMigrations.get(jobId);
        if (context != null) {
            log.debug("Canceling migration job '{}' running on this node.", (Object)jobId);
            if (context.isCanceled()) {
                return (Boolean)this.securityService.withPermission(Permission.ADMIN, "Mesh migration job cancellation cleanup").call(() -> {
                    this.getMeshMigrationJob(jobId).ifPresent(job -> {
                        log.debug("Finishing cancellation of migration job '{}' since the context has already been canceled", (Object)jobId);
                        MeshMigrationJob migrationJob = new MeshMigrationJob((Job)job, this.jobService, this.i18nService);
                        migrationJob.finishCanceling();
                        this.meshMigrationService.finishCanceling(jobId);
                    });
                    return true;
                });
            }
            return (Boolean)this.securityService.withPermission(Permission.ADMIN, "Mesh migration job cancellation").call(() -> {
                context.cancel();
                return true;
            });
        }
        log.trace("Received notification to cancel migration job '{}', but job is not running on this node.", (Object)jobId);
        return false;
    }

    @Nonnull
    @PreAuthorize(value="hasGlobalPermission('SYS_ADMIN')")
    public Optional<Job> cancelMeshMigration(long jobId) {
        Optional<Job> job = this.getMeshMigrationJob(jobId);
        if (!job.isPresent()) {
            return Optional.empty();
        }
        MeshMigrationJob migrationJob = new MeshMigrationJob(job.get(), this.jobService, this.i18nService);
        migrationJob.beginCanceling();
        this.meshMigrationService.beginCanceling(migrationJob.getId());
        if (!this.cancelLocalMeshMigration(jobId)) {
            MeshMigrationCancellationCallback migrationCancellation = new MeshMigrationCancellationCallback();
            this.clusterExecutor.submitToAllMembers((Callable)new MeshMigrationCancellationTask(jobId), (MultiExecutionCallback)migrationCancellation);
            try {
                if (!migrationCancellation.await(this.meshMigrationCancelClusterTimeout.getSeconds(), TimeUnit.SECONDS)) {
                    log.warn("Timed out waiting for response from all the cluster nodes for cancellation of mesh migration job {}", (Object)jobId);
                    return job;
                }
                if (!migrationCancellation.isCancelled()) {
                    this.executorService.submit(() -> {
                        try {
                            this.meshMigrationService.finishCanceling(migrationJob.getId());
                        }
                        catch (RuntimeException e) {
                            log.error("Exception while cancelling mesh migration job '{}'", (Object)migrationJob.getId(), (Object)e);
                        }
                        finally {
                            migrationJob.finishCanceling();
                        }
                    });
                }
            }
            catch (InterruptedException e) {
                Thread.currentThread().interrupt();
                throw new RuntimeException(e);
            }
        }
        return job;
    }

    @Nonnull
    @PreAuthorize(value="hasGlobalPermission('SYS_ADMIN')")
    public Page<MeshMigrationSummary> findAllMeshMigrationSummaries(@Nonnull PageRequest pageRequest) {
        return this.meshMigrationService.findAllMeshMigrationSummaries(pageRequest).transform(summary -> new MeshMigrationSummary.Builder(summary).queueCountByState(summary.getQueueCountByState()).progressPercentage(this.getMeshMigrationProgress(summary.getJobId())).build());
    }

    @Nonnull
    @PreAuthorize(value="hasGlobalPermission('ADMIN')")
    public Optional<Job> getExportJob(long jobId) {
        return this.jobService.getById(jobId).filter(job -> {
            String type = job.getType();
            return type.equals(JOB_TYPE_EXPORT);
        });
    }

    @Nonnull
    @PreAuthorize(value="hasGlobalPermission('ADMIN')")
    public Optional<Job> getImportJob(long jobId) {
        return this.jobService.getById(jobId).filter(job -> {
            String type = job.getType();
            return type.equals(JOB_TYPE_IMPORT);
        });
    }

    @Nonnull
    @PreAuthorize(value="hasGlobalPermission('SYS_ADMIN')")
    public Optional<Job> getMeshMigrationJob(long jobId) {
        return this.jobService.getById(jobId).filter(job -> {
            String type = job.getType();
            return type.equals(JOB_TYPE_MESH);
        });
    }

    @Nonnull
    @PreAuthorize(value="hasGlobalPermission('SYS_ADMIN')")
    public Optional<MeshMigrationSummary> getMeshMigrationSummary(Long jobId) {
        return this.meshMigrationService.getMigrationSummary(jobId).map(summary -> new MeshMigrationSummary.Builder(summary).progressPercentage(this.getMeshMigrationProgress(summary.getJobId())).build());
    }

    @Nonnull
    @PreAuthorize(value="hasGlobalPermission('SYS_ADMIN')")
    public Optional<Job> getMeshRemigrationJob(long jobId) {
        return this.jobService.getById(jobId).filter(job -> {
            String type = job.getType();
            return type.equals(JOB_TYPE_MESH_REMIGRATION);
        });
    }

    public int getPhase() {
        return 2000;
    }

    @PostConstruct
    public void init() {
        this.cancelTopicSubscription = this.cancelTopic.subscribe(messageEvent -> ((JobCancellationMessage)messageEvent.getMessage()).getType().notify.accept(this, (JobCancellationMessage)messageEvent.getMessage()));
    }

    @Nonnull
    @PreAuthorize(value="hasGlobalPermission('ADMIN')")
    public Stream<Scope> previewExport(@Nonnull ExportRequest request) {
        return this.exportScopeResolver.stream(request.getRepositoriesRequest());
    }

    @Nonnull
    @PreAuthorize(value="hasGlobalPermission('SYS_ADMIN')")
    public Stream<Repository> previewMeshMigration(@Nonnull MeshMigrationRequest request) {
        return this.exportScopeResolver.stream(request).map(scope -> (Repository)scope.accept(ScopeVisitors.REPOSITORY_GETTER)).filter(Objects::nonNull);
    }

    @Nonnull
    @PreAuthorize(value="hasGlobalPermission('ADMIN')")
    public Page<JobMessage> searchExportJobMessages(@Nonnull MigrationJobMessageSearchRequest request, @Nonnull PageRequest pageRequest) {
        return this.getJobMessages(this::getExportJob, request, pageRequest);
    }

    @Nonnull
    @PreAuthorize(value="hasGlobalPermission('ADMIN')")
    public Page<JobMessage> searchImportJobMessages(@Nonnull MigrationJobMessageSearchRequest request, @Nonnull PageRequest pageRequest) {
        return this.getJobMessages(this::getImportJob, request, pageRequest);
    }

    @Nonnull
    @PreAuthorize(value="hasGlobalPermission('SYS_ADMIN')")
    public Page<JobMessage> searchMeshMigrationJobMessages(@Nonnull MigrationJobMessageSearchRequest request, @Nonnull PageRequest pageRequest) {
        return this.getJobMessages(this::getMeshMigrationJob, request, pageRequest);
    }

    @Nonnull
    @PreAuthorize(value="hasGlobalPermission('SYS_ADMIN')")
    public Page<MigrationRepository> searchMeshMigrationRepositories(@Nonnull MigrationRepositorySearchRequest request, @Nonnull PageRequest pageRequest) {
        try {
            return this.meshMigrationService.searchRepositories(request, pageRequest);
        }
        catch (NoSuchEntityException e) {
            throw new IllegalArgumentException(e);
        }
    }

    @Nonnull
    @PreAuthorize(value="hasGlobalPermission('ADMIN')")
    public Job startExport(@Nonnull ExportRequest request) {
        if (!this.featureManager.isEnabled((Feature)StandardFeature.DATA_CENTER_MIGRATION_EXPORT)) {
            throw new InstanceMigrationExportDisabledException(this.i18nService.createKeyedMessage("bitbucket.service.migration.export.disabled", new Object[0]));
        }
        this.validateExportRequest(request);
        Path exportPath = request.getExportLocation().map(x$0 -> Paths.get(x$0, new String[0])).map(this.defaultExportPath::resolve).orElse(this.defaultExportPath);
        try {
            if (!Files.isDirectory(exportPath, new LinkOption[0])) {
                Files.createDirectories(exportPath, new FileAttribute[0]);
            }
        }
        catch (IOException e) {
            log.error("Failed to create export directory", (Throwable)e);
            throw new ExportException(this.i18nService.createKeyedMessage("bitbucket.service.migration.exportpath.notwritable", new Object[]{request.getExportLocation().orElse(this.defaultExportPath.toString())}), (Throwable)e);
        }
        Job job = this.jobService.create(new JobCreationRequest.Builder().initiator((ApplicationUser)InternalConverter.convertToInternalUser((ApplicationUser)this.authenticationContext.getCurrentUser())).type(JOB_TYPE_EXPORT).build());
        this.eventPublisher.publish((Object)new MigrationExportStartedEvent((Object)this, job, request));
        ExportJob exportJob = new ExportJob(job, this.jobService, this.i18nService);
        Path exportArchive = exportPath.resolve(EXPORT_ARCHIVE_PREFIX + exportJob.getId() + EXPORT_ARCHIVE_SUFFIX);
        if (Files.exists(exportArchive, new LinkOption[0]) || !Files.isWritable(exportArchive.getParent())) {
            throw new ExportException(this.i18nService.createKeyedMessage("bitbucket.service.migration.exportpath.notwritable", new Object[]{request.getExportLocation().orElse(this.defaultExportPath.toString())}));
        }
        try {
            this.executorService.submit(() -> {
                try (TarExportTarget exportTarget = new TarExportTarget(exportArchive);){
                    DefaultExportContext context = new DefaultExportContext(exportTarget, exportJob, this.i18nService, this.userEntityExportMapping);
                    this.activeExports.put(exportJob.getId(), context);
                    try {
                        this.exportService.exportRepositories((InternalExportContext)context, request.getRepositoriesRequest());
                        long errorCount = this.jobMessageCount(job, JobMessageSeverity.ERROR);
                        long infoCount = this.jobMessageCount(job, JobMessageSeverity.INFO);
                        long warningCount = this.jobMessageCount(job, JobMessageSeverity.WARN);
                        this.eventPublisher.publish((Object)new MigrationExportFinishedEvent((Object)this, job, errorCount, infoCount, warningCount));
                    }
                    finally {
                        this.activeExports.remove(exportJob.getId());
                    }
                }
                catch (Exception e) {
                    log.error("Export job '{}': uncaught exception", (Object)exportJob.getId(), (Object)e);
                    exportJob.abort();
                }
            });
        }
        catch (RejectedExecutionException e) {
            exportJob.abort();
            throw new MaxConcurrentMigrationJobsException(this.i18nService.createKeyedMessage("bitbucket.service.migration.maximum.concurrency.reached", new Object[0]));
        }
        return job;
    }

    @Nonnull
    @PreAuthorize(value="hasGlobalPermission('ADMIN')")
    public Job startImport(@Nonnull ImportRequest request) {
        if (!this.featureManager.isEnabled((Feature)StandardFeature.DATA_CENTER_MIGRATION_IMPORT)) {
            throw new InstanceMigrationImportUnavailableException(this.i18nService.createKeyedMessage("bitbucket.service.migration.import.disabled", new Object[0]));
        }
        Optional<Job> runningImportJob = this.getRunningJob(JOB_TYPE_IMPORT, IMPORT_JOB_TIMEOUT);
        if (runningImportJob.isPresent()) {
            throw new ImportException(this.i18nService.createKeyedMessage("bitbucket.service.migration.import.job.already.running", new Object[]{runningImportJob.get().getId()}));
        }
        this.validateImportRequest(request);
        Path importPath = this.defaultImportPath.resolve(request.getArchivePath());
        Job job = this.jobService.create(new JobCreationRequest.Builder().initiator((ApplicationUser)InternalConverter.convertToInternalUser((ApplicationUser)this.authenticationContext.getCurrentUser())).type(JOB_TYPE_IMPORT).build());
        this.eventPublisher.publish((Object)new MigrationImportStartedEvent((Object)this, job));
        ImportJob importJob = new ImportJob(job, this.jobService, this.i18nService);
        try {
            this.executorService.submit(() -> {
                try (FileChannel channel = FileChannel.open(importPath, StandardOpenOption.READ);
                     InputStream inputStream = Channels.newInputStream(channel);
                     TarArchiveSource source = new TarArchiveSource(inputStream, importPath);){
                    DefaultImportContext context = new DefaultImportContext(source, this.i18nService, importJob, DefaultMigrationService.getPercentageSupplier(channel.size(), channel), this.userImportService);
                    this.activeImports.put(importJob.getId(), context);
                    try {
                        this.importService.importRepositories((InternalImportContext)context);
                        long errorCount = this.jobMessageCount(job, JobMessageSeverity.ERROR);
                        long infoCount = this.jobMessageCount(job, JobMessageSeverity.INFO);
                        long warningCount = this.jobMessageCount(job, JobMessageSeverity.WARN);
                        this.eventPublisher.publish((Object)new MigrationImportFinishedEvent((Object)this, job, errorCount, infoCount, warningCount));
                    }
                    finally {
                        this.activeImports.remove(importJob.getId());
                    }
                }
                catch (Exception e) {
                    log.error("Import job '{}': uncaught exception", (Object)importJob.getId(), (Object)e);
                    importJob.abort();
                }
            });
        }
        catch (RejectedExecutionException e) {
            importJob.abort();
            throw new MaxConcurrentMigrationJobsException(this.i18nService.createKeyedMessage("bitbucket.service.migration.maximum.concurrency.reached", new Object[0]));
        }
        return job;
    }

    @Nonnull
    @PreAuthorize(value="hasGlobalPermission('SYS_ADMIN')")
    public Job startMeshMigration(@Nonnull MeshMigrationRequest request) {
        if (!this.meshEnabled) {
            throw new MeshMigrationUnavailableException(this.i18nService.createKeyedMessage("bitbucket.service.migration.mesh.disabled", new Object[0]));
        }
        Optional<Job> runningMigrationJob = this.getRunningJob(JOB_TYPE_MESH, MESH_MIGRATION_JOB_TIMEOUT);
        if (runningMigrationJob.isPresent()) {
            throw new MaxConcurrentMigrationJobsException(this.i18nService.createKeyedMessage("bitbucket.service.migration.mesh.job.already.running", new Object[]{runningMigrationJob.get().getId()}));
        }
        this.validateMeshMigrationRequest(request);
        Job job = this.jobService.create(new JobCreationRequest.Builder().initiator((ApplicationUser)InternalConverter.convertToInternalUser((ApplicationUser)this.authenticationContext.getCurrentUser())).type(JOB_TYPE_MESH).build());
        this.eventPublisher.publish((Object)new MeshMigrationStartedEvent((Object)this, job));
        MeshMigrationJob migrationJob = new MeshMigrationJob(job, this.jobService, this.i18nService);
        try {
            this.executorService.submit(() -> {
                try {
                    DefaultMeshMigrationContext context = new DefaultMeshMigrationContext(migrationJob, this.i18nService, request);
                    this.activeMeshMigrations.put(migrationJob.getId(), context);
                    try {
                        this.meshMigrationService.migrateRepositories((InternalMeshMigrationContext)context, request);
                        long errorCount = this.jobMessageCount(job, JobMessageSeverity.ERROR);
                        long infoCount = this.jobMessageCount(job, JobMessageSeverity.INFO);
                        long warningCount = this.jobMessageCount(job, JobMessageSeverity.WARN);
                        this.eventPublisher.publish((Object)new MeshMigrationFinishedEvent((Object)this, job, errorCount, infoCount, warningCount));
                    }
                    finally {
                        this.activeMeshMigrations.remove(migrationJob.getId());
                    }
                }
                catch (Exception e) {
                    log.error("Mesh migration job '{}': uncaught exception", (Object)migrationJob.getId(), (Object)e);
                    migrationJob.abort();
                }
            });
        }
        catch (RejectedExecutionException e) {
            migrationJob.abort();
            throw new MaxConcurrentMigrationJobsException(this.i18nService.createKeyedMessage("bitbucket.service.migration.maximum.concurrency.reached", new Object[0]));
        }
        return job;
    }

    @Nonnull
    @PreAuthorize(value="hasGlobalPermission('SYS_ADMIN')")
    public Job startMeshRemigration(@Nonnull Repository repository) {
        if (!this.meshEnabled) {
            throw new MeshMigrationUnavailableException(this.i18nService.createKeyedMessage("bitbucket.service.migration.mesh.remigration-disabled", new Object[0]));
        }
        Optional<Job> runningRemigrationJob = this.getRunningJob(JOB_TYPE_MESH_REMIGRATION, MESH_MIGRATION_JOB_TIMEOUT);
        if (runningRemigrationJob.isPresent()) {
            throw new MaxConcurrentMigrationJobsException(this.i18nService.createKeyedMessage("bitbucket.service.migration.mesh.job.already.running", new Object[]{runningRemigrationJob.get().getId()}));
        }
        Job job = this.jobService.create(new JobCreationRequest.Builder().initiator((ApplicationUser)InternalConverter.convertToInternalUser((ApplicationUser)this.authenticationContext.getCurrentUser())).type(JOB_TYPE_MESH_REMIGRATION).build());
        MeshMigrationJob remigrationJob = new MeshMigrationJob(job, this.jobService, this.i18nService);
        MeshMigrationRequest remigrationRequest = new MeshMigrationRequest.Builder().repositoryId(repository.getId()).build();
        try {
            this.executorService.submit(() -> {
                DefaultMeshMigrationContext context = new DefaultMeshMigrationContext(remigrationJob, this.i18nService, remigrationRequest);
                try {
                    this.activeMeshRemigrations.put(remigrationJob.getId(), context);
                    try {
                        this.meshMigrationService.remigrateRepositories((InternalMeshMigrationContext)context);
                    }
                    finally {
                        this.activeMeshRemigrations.remove(remigrationJob.getId());
                    }
                }
                catch (RuntimeException e) {
                    log.error("Mesh re-migration job [{}] encountered an exception:", (Object)remigrationJob.getId(), (Object)e);
                    remigrationJob.abort();
                }
            });
        }
        catch (RejectedExecutionException e) {
            remigrationJob.abort();
            throw new MaxConcurrentMigrationJobsException(this.i18nService.createKeyedMessage("bitbucket.service.migration.maximum.concurrency.reached", new Object[0]));
        }
        return job;
    }

    public void stop() {
        this.executorService.shutdown();
        this.securityService.withPermission(Permission.ADMIN, "cancellation on shutdown").call(() -> {
            this.tryCancelActiveJobs();
            try {
                if (!this.executorService.awaitTermination(15L, TimeUnit.SECONDS)) {
                    log.warn("Timed out waiting for canceled jobs to finish.");
                    this.executorService.shutdownNow();
                    this.forceCancelActiveJobs();
                }
            }
            catch (InterruptedException e) {
                Thread.currentThread().interrupt();
                log.info("Interrupted while waiting for canceled jobs to finish", (Throwable)e);
                this.forceCancelActiveJobs();
            }
            return null;
        });
        this.cancelTopic.unsubscribe(this.cancelTopicSubscription);
    }

    @VisibleForTesting
    void setMeshEnabled(boolean enabled) {
        this.meshEnabled = enabled;
    }

    private static Path getOrCreateDefaultExportDirectory(StorageService storageService) {
        try {
            Path dataDir = storageService.getDataDir();
            Path dir = dataDir.resolve(DEFAULT_EXPORT_DIR);
            if (!Files.isDirectory(dir, new LinkOption[0])) {
                Files.createDirectories(dir, new FileAttribute[0]);
            }
            return dir;
        }
        catch (IOException e) {
            throw new UncheckedIOException(e);
        }
    }

    private static Path getOrCreateDefaultImportDirectory(StorageService storageService) {
        try {
            Path dir = storageService.getDataDir().resolve(DEFAULT_IMPORT_DIR);
            if (!Files.isDirectory(dir, new LinkOption[0])) {
                Files.createDirectories(dir, new FileAttribute[0]);
            }
            return dir;
        }
        catch (IOException e) {
            throw new RuntimeException(e);
        }
    }

    private static Operation<Integer, IOException> getPercentageSupplier(long fileSize, FileChannel channel) {
        return () -> Math.min(100, (int)Math.round(100.0 * (double)channel.position() / (double)fileSize));
    }

    private void doCancelExportContext(JobCancellationMessage message) {
        InternalExportContext context = this.activeExports.get(message.getJobId());
        if (context != null) {
            log.debug("Received notification to cancel export job '{}', running on this node.", (Object)message.getJobId());
            this.securityService.withPermission(Permission.ADMIN, "Export job cancellation").call(() -> {
                context.cancel();
                return null;
            });
        } else {
            log.debug("Received notification to cancel export job '{}', but job is not running on this node.", (Object)message.getJobId());
        }
    }

    private void doCancelImportContext(JobCancellationMessage message) {
        InternalImportContext context = this.activeImports.get(message.getJobId());
        if (context != null) {
            log.debug("Received notification to cancel import job '{}', running on this node.", (Object)message.getJobId());
            this.securityService.withPermission(Permission.ADMIN, "Export job cancellation").call(() -> {
                context.cancel();
                return null;
            });
        } else {
            log.debug("Received notification to cancel import job '{}', but job is not running on this node.", (Object)message.getJobId());
        }
    }

    private void forceCancelActiveJobs() {
        this.activeImports.forEach((jobId, context) -> {
            try {
                log.info("Forcing cancellation of import job '{}' before shutdown", jobId);
                this.getImportJob((long)jobId).map(job -> new ImportJob((Job)job, this.jobService, this.i18nService)).ifPresent(AbstractMigrationJob::finishCanceling);
            }
            catch (IllegalStateException e) {
                log.debug("Import job '{}' was already canceled", jobId, (Object)e);
            }
            catch (RuntimeException e) {
                log.error("Failed to cancel import job '{}'", jobId, (Object)e);
            }
        });
        this.activeExports.forEach((jobId, context) -> {
            try {
                log.info("Forcing cancellation of export job '{}' before shutdown", jobId);
                this.getExportJob((long)jobId).map(job -> new ExportJob((Job)job, this.jobService, this.i18nService)).ifPresent(AbstractMigrationJob::finishCanceling);
            }
            catch (IllegalStateException e) {
                log.debug("Export job '{}' was already canceled", jobId, (Object)e);
            }
            catch (RuntimeException e) {
                log.error("Failed to cancel export job '{}'", jobId, (Object)e);
            }
        });
        this.activeMeshMigrations.forEach((jobId, context) -> {
            try {
                log.info("Forcing cancellation of migration job '{}' before shutdown", jobId);
                this.getMeshMigrationJob((long)jobId).map(job -> new MeshMigrationJob((Job)job, this.jobService, this.i18nService)).ifPresent(AbstractMigrationJob::finishCanceling);
            }
            catch (IllegalStateException e) {
                log.debug("Migration job '{}' was already canceled", jobId, (Object)e);
            }
            catch (RuntimeException e) {
                log.error("Failed to cancel migration job '{}'", jobId, (Object)e);
            }
        });
        this.activeMeshRemigrations.forEach((jobId, context) -> {
            try {
                log.info("Forcing cancellation of re-migration job '{}' before shutdown", jobId);
                this.getMeshRemigrationJob((long)jobId).map(job -> new MeshMigrationJob((Job)job, this.jobService, this.i18nService)).ifPresent(AbstractMigrationJob::finishCanceling);
            }
            catch (IllegalStateException e) {
                log.debug("Re-migration job '{}' was already canceled", jobId, (Object)e);
            }
            catch (RuntimeException e) {
                log.error("Failed to cancel re-migration job '{}'", jobId, (Object)e);
            }
        });
    }

    private Page<JobMessage> getJobMessages(Function<Long, Optional<Job>> retrieveJob, MigrationJobMessageSearchRequest request, PageRequest pageRequest) {
        return retrieveJob.apply(request.getJobId()).map(job -> this.jobService.searchMessages(new JobMessageSearchRequest.Builder().job(job).severities((Iterable)request.getSeverities()).subject(request.getSubject().isPresent() ? (String)request.getSubject().get() : null).build(), pageRequest)).orElseThrow(() -> new IllegalArgumentException(this.i18nService.getMessage("bitbucket.service.migration.message.error.invalidjob", new Object[]{request.getJobId()})));
    }

    private int getMeshMigrationProgress(long jobId) {
        return this.getMeshMigrationJob(jobId).map(Job::getProgress).orElse((Progress)new ProgressImpl("", 0)).getPercentage();
    }

    private Optional<Job> getRunningJob(String jobType, Duration timeout) {
        JobSearchRequest jobSearchRequest = new JobSearchRequest.Builder().type(jobType).states((Iterable)Arrays.stream(JobState.values()).filter(jobState -> !jobState.isTerminated()).collect(Collectors.toList())).build();
        return PageUtils.toStream(page -> this.jobService.search(jobSearchRequest, page), (int)50).filter(job -> job.getUpdatedDate().isAfter(Instant.now().minus(timeout))).findAny();
    }

    private long jobMessageCount(Job job, JobMessageSeverity severity) {
        return this.jobService.countMessages(new JobMessageSearchRequest.Builder().job(job).severity(severity).build());
    }

    private void tryCancelActiveJobs() {
        this.activeImports.forEach((jobId, context) -> {
            try {
                log.info("Canceling import job '{}' before shutdown", jobId);
                this.getImportJob((long)jobId).map(job -> new ImportJob((Job)job, this.jobService, this.i18nService)).ifPresent(AbstractMigrationJob::beginCanceling);
                context.cancel();
            }
            catch (IllegalStateException e) {
                log.debug("Import job '{}' was already canceled", jobId, (Object)e);
            }
            catch (RuntimeException e) {
                log.error("Failed to cancel import job '{}'", jobId, (Object)e);
            }
        });
        this.activeExports.forEach((jobId, context) -> {
            try {
                log.info("Canceling export job '{}' before shutdown", jobId);
                this.getExportJob((long)jobId).map(job -> new ExportJob((Job)job, this.jobService, this.i18nService)).ifPresent(AbstractMigrationJob::beginCanceling);
                context.cancel();
            }
            catch (IllegalStateException e) {
                log.debug("Export job '{}' was already canceled", jobId, (Object)e);
            }
            catch (RuntimeException e) {
                log.error("Failed to cancel export job '{}'", jobId, (Object)e);
            }
        });
        this.activeMeshMigrations.forEach((jobId, context) -> {
            try {
                log.info("Canceling migration job '{}' before shutdown", jobId);
                this.getMeshMigrationJob((long)jobId).map(job -> new MeshMigrationJob((Job)job, this.jobService, this.i18nService)).ifPresent(job -> {
                    job.beginCanceling();
                    this.meshMigrationService.beginCanceling(job.getId());
                });
                context.cancel();
            }
            catch (IllegalStateException e) {
                log.debug("Migration job '{}' was already canceled", jobId, (Object)e);
            }
            catch (RuntimeException e) {
                log.error("Failed to cancel migration job '{}'", jobId, (Object)e);
            }
        });
        this.activeMeshRemigrations.forEach((jobId, context) -> {
            try {
                log.info("Canceling re-migration job '{}' before shutdown", jobId);
                this.getMeshRemigrationJob((long)jobId).map(job -> new MeshMigrationJob((Job)job, this.jobService, this.i18nService)).ifPresent(job -> {
                    job.beginCanceling();
                    this.meshMigrationService.beginCanceling(job.getId());
                });
                context.cancel();
            }
            catch (IllegalStateException e) {
                log.debug("Re-migration job '{}' was already canceled", jobId, (Object)e);
            }
            catch (RuntimeException e) {
                log.error("Failed to cancel re-migration job '{}'", jobId, (Object)e);
            }
        });
    }

    private void validateExportRequest(@Nonnull ExportRequest request) {
        Stream<Optional> exportLocationMessages;
        Stream<Optional> repositoryRequestMessages = request.getRepositoriesRequest().getIncludes().stream().map(selector -> {
            String projectKey = selector.getProjectKey();
            String slug = selector.getSlug();
            if (projectKey.equals("*")) {
                return Optional.empty();
            }
            Project project = this.projectService.getByKey(projectKey);
            if (project == null) {
                return Optional.of(this.i18nService.createKeyedMessage("bitbucket.service.migration.project.notfound", new Object[]{projectKey}));
            }
            if (slug.equals("*")) {
                return Optional.empty();
            }
            Repository repository = this.repositoryService.getBySlug(projectKey, slug);
            if (repository == null) {
                return Optional.of(this.i18nService.createKeyedMessage("bitbucket.service.migration.repository.notfound", new Object[]{projectKey, slug}));
            }
            if (repository.isRemote()) {
                return Optional.of(this.i18nService.createKeyedMessage("bitbucket.service.migration.repository.remote.unsupported", new Object[]{projectKey, slug}));
            }
            return Optional.empty();
        });
        String errorDetails = Stream.concat(repositoryRequestMessages, exportLocationMessages = MoreStreams.streamOptional((Optional)request.getExportLocation()).map(x$0 -> Paths.get(x$0, new String[0])).filter(path -> {
            try {
                return !MoreFiles.isWithin((Path)this.defaultExportPath.resolve((Path)path), (Path)this.defaultExportPath);
            }
            catch (IOException e) {
                return true;
            }
        }).map(path -> Optional.of(this.i18nService.createKeyedMessage("bitbucket.service.migration.export.location.invalid", new Object[0])))).filter(Optional::isPresent).map(Optional::get).map(KeyedMessage::getLocalisedMessage).collect(Collectors.joining(",\n\t"));
        if (StringUtils.isNotEmpty((CharSequence)errorDetails)) {
            throw new ArgumentValidationException(this.i18nService.createKeyedMessage("bitbucket.service.migration.invalidexportrequest", new Object[]{errorDetails}));
        }
    }

    private void validateImportRequest(@Nonnull ImportRequest request) {
        Path file = this.defaultImportPath.resolve(request.getArchivePath());
        boolean isValidPath = false;
        try {
            if (MoreFiles.isWithin((Path)file, (Path)this.defaultImportPath)) {
                isValidPath = true;
            }
        }
        catch (IOException e) {
            log.debug("Exception while validating import path", (Throwable)e);
        }
        if (!isValidPath) {
            throw new ArgumentValidationException(this.i18nService.createKeyedMessage("bitbucket.service.migration.import.location.invalid", new Object[0]));
        }
        if (!Files.isRegularFile(file, new LinkOption[0])) {
            throw new ArgumentValidationException(this.i18nService.createKeyedMessage("bitbucket.service.migration.import.archive.not.exist", new Object[]{request.getArchivePath()}));
        }
        if (!Files.isReadable(file)) {
            throw new ArgumentValidationException(this.i18nService.createKeyedMessage("bitbucket.service.migration.import.archive.not.readable", new Object[]{request.getArchivePath()}));
        }
    }

    private void validateMeshMigrationRequest(@Nonnull MeshMigrationRequest request) {
        Stream<KeyedMessage> repositoryErrors;
        if (request.isAll()) {
            return;
        }
        if (request.getProjectIds().isEmpty() && request.getRepositoryIds().isEmpty()) {
            String errorMessage = this.i18nService.createKeyedMessage("bitbucket.service.migration.mesh.empty-selection", new Object[0]).getLocalisedMessage();
            throw new ArgumentValidationException(this.i18nService.createKeyedMessage("bitbucket.service.migration.mesh.invalidrequest", new Object[]{errorMessage}));
        }
        Stream<KeyedMessage> projectErrors = request.getProjectIds().stream().map(projectId -> {
            if (this.projectService.getById(projectId.intValue()) == null) {
                return this.i18nService.createKeyedMessage("bitbucket.service.migration.mesh.project.notfound", new Object[]{projectId});
            }
            return null;
        });
        String errorDetails = Stream.concat(projectErrors, repositoryErrors = request.getRepositoryIds().stream().map(repositoryId -> {
            if (this.repositoryService.getById(repositoryId.intValue()) == null) {
                return this.i18nService.createKeyedMessage("bitbucket.service.migration.mesh.repository.notfound", new Object[]{repositoryId});
            }
            return null;
        })).filter(Objects::nonNull).map(KeyedMessage::getLocalisedMessage).collect(Collectors.joining(",\n\t"));
        if (StringUtils.isNotEmpty((CharSequence)errorDetails)) {
            throw new ArgumentValidationException(this.i18nService.createKeyedMessage("bitbucket.service.migration.mesh.invalidrequest", new Object[]{errorDetails}));
        }
    }

    static class JobCancellationMessage
    implements Serializable {
        private static final long serialVersionUID = 6191468035893303635L;
        private final long jobId;
        private final Type type;

        JobCancellationMessage(long jobId, Type type) {
            this.jobId = jobId;
            this.type = type;
        }

        long getJobId() {
            return this.jobId;
        }

        Type getType() {
            return this.type;
        }

        static enum Type implements Serializable
        {
            IMPORT(DefaultMigrationService::doCancelImportContext),
            EXPORT(DefaultMigrationService::doCancelExportContext);

            final BiConsumer<DefaultMigrationService, JobCancellationMessage> notify;

            private Type(BiConsumer<DefaultMigrationService, JobCancellationMessage> notify) {
                this.notify = notify;
            }
        }
    }

    private static class MeshMigrationCancellationCallback
    extends ResultCollectingExecutionCallback<Boolean> {
        private boolean cancelled;

        private MeshMigrationCancellationCallback() {
        }

        @Override
        protected void onError(Member member, Throwable e) {
            log.error("Received error for {}", (Object)NutclusterClusterNode.transform(member), (Object)e);
        }

        @Override
        protected void onSuccess(Member member, Boolean result) {
            this.cancelled = this.cancelled || result != false;
        }

        private boolean isCancelled() {
            return this.cancelled;
        }
    }

    @SpringAware
    private static class MeshMigrationCancellationTask
    implements Callable<Boolean>,
    Serializable {
        private final long jobId;
        private transient InternalMigrationService migrationService;

        private MeshMigrationCancellationTask(long jobId) {
            this.jobId = jobId;
        }

        @Override
        public Boolean call() {
            return this.migrationService.cancelLocalMeshMigration(this.jobId);
        }

        @Autowired
        public void setMigrationService(InternalMigrationService migrationService) {
            this.migrationService = migrationService;
        }
    }
}

