/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.stash.internal.migration;

import com.atlassian.bitbucket.i18n.I18nService;
import com.atlassian.bitbucket.migration.ImportContext;
import com.atlassian.bitbucket.migration.ImportException;
import com.atlassian.bitbucket.migration.StandardMigrationEntityType;
import com.atlassian.bitbucket.user.ApplicationUser;
import com.atlassian.bitbucket.user.ServiceUser;
import com.atlassian.bitbucket.user.ServiceUserCreateRequest;
import com.atlassian.bitbucket.user.UserAdminService;
import com.atlassian.bitbucket.user.UserService;
import com.atlassian.stash.internal.AbstractService;
import com.atlassian.stash.internal.migration.UserImportService;
import com.atlassian.stash.internal.user.ApplicationUserDao;
import com.atlassian.stash.internal.user.InternalNormalUser;
import jakarta.annotation.Nonnull;
import java.sql.Date;
import java.time.Instant;
import java.util.Objects;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;
import org.springframework.transaction.annotation.Propagation;
import org.springframework.transaction.annotation.Transactional;

@Service(value="userImportService")
@Transactional(propagation=Propagation.SUPPORTS, readOnly=true)
public class DefaultUserImportService
extends AbstractService
implements UserImportService {
    private final I18nService i18nService;
    private final UserAdminService userAdminService;
    private final ApplicationUserDao userDao;
    private final UserService userService;

    @Autowired
    public DefaultUserImportService(I18nService i18nService, UserAdminService userAdminService, ApplicationUserDao userDao, UserService userService) {
        this.i18nService = i18nService;
        this.userAdminService = userAdminService;
        this.userDao = userDao;
        this.userService = userService;
    }

    @Override
    @Nonnull
    @Transactional(propagation=Propagation.REQUIRED)
    public ApplicationUser findOrCreateServiceUser(@Nonnull String username, @Nonnull String displayName) {
        Objects.requireNonNull(username, "username");
        Objects.requireNonNull(displayName, "displayName");
        ServiceUser applicationUser = this.userService.getServiceUserByName(username, true);
        if (applicationUser != null) {
            return applicationUser;
        }
        return this.userAdminService.createServiceUser(((ServiceUserCreateRequest.Builder)((ServiceUserCreateRequest.Builder)new ServiceUserCreateRequest.Builder().displayName(displayName)).active(false)).build());
    }

    @Override
    @Nonnull
    @Transactional(propagation=Propagation.REQUIRED)
    public ApplicationUser findOrCreateNormalUser(@Nonnull String username) {
        Objects.requireNonNull(username, "username");
        ApplicationUser applicationUser = this.userService.getUserByName(username, true);
        if (applicationUser != null) {
            return applicationUser;
        }
        return this.userDao.create(((InternalNormalUser.Builder)new InternalNormalUser.Builder().name(username)).deletedDate(Date.from(Instant.now())).build());
    }

    @Override
    @Nonnull
    @Transactional(propagation=Propagation.REQUIRED)
    public ApplicationUser findOrCreateUser(@Nonnull String exportId, @Nonnull ImportContext importContext) {
        Objects.requireNonNull(exportId, "exportId");
        Objects.requireNonNull(importContext, "importContext");
        return importContext.getEntityMapping(StandardMigrationEntityType.USER).getLocalId(exportId).map(id -> this.userService.getUserById(id.intValue(), true)).orElseThrow(() -> new ImportException(this.i18nService.createKeyedMessage("bitbucket.service.migration.import.no.such.user", new Object[]{exportId})));
    }
}

