/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.stash.internal.migration;

import com.atlassian.bitbucket.migration.MeshMigrationRequest;
import com.atlassian.bitbucket.migration.RepositoriesExportRequest;
import com.atlassian.bitbucket.migration.RepositorySelector;
import com.atlassian.bitbucket.project.Project;
import com.atlassian.bitbucket.repository.Repository;
import com.atlassian.bitbucket.scope.ProjectScope;
import com.atlassian.bitbucket.scope.RepositoryScope;
import com.atlassian.bitbucket.scope.Scope;
import com.atlassian.bitbucket.scope.ScopeType;
import com.atlassian.bitbucket.scope.Scopes;
import com.atlassian.bitbucket.util.MoreStreams;
import com.atlassian.bitbucket.util.PageProvider;
import com.atlassian.bitbucket.util.PageUtils;
import com.atlassian.bitbucket.util.PagedIterable;
import com.atlassian.stash.internal.migration.ScopeVisitors;
import com.atlassian.stash.internal.project.InternalProjectService;
import com.atlassian.stash.internal.repository.InternalRepositoryService;
import com.google.common.annotations.VisibleForTesting;
import com.google.common.collect.ImmutableSet;
import com.google.common.collect.Iterables;
import jakarta.annotation.Nonnull;
import java.util.Collection;
import java.util.HashSet;
import java.util.LinkedList;
import java.util.Map;
import java.util.Objects;
import java.util.Set;
import java.util.function.Function;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Component;

@Component(value="exportScopeResolver")
public class ExportScopeResolver {
    private static final int MAX_PAGE_SIZE = 100;
    private static final Logger log = LoggerFactory.getLogger(ExportScopeResolver.class);
    private final InternalProjectService projectService;
    private final InternalRepositoryService repositoryService;
    private int maxPageSize;

    @Autowired
    public ExportScopeResolver(InternalProjectService projectService, InternalRepositoryService repositoryService) {
        this.projectService = projectService;
        this.repositoryService = repositoryService;
        this.maxPageSize = 100;
    }

    public long count(@Nonnull RepositoriesExportRequest request) {
        if (request.getIncludes().stream().anyMatch(selector -> "*".equals(selector.getProjectKey()))) {
            return this.repositoryService.getCount() + this.projectService.getCount();
        }
        return this.streamSelectedRepositories(request.getIncludes()).count();
    }

    @Nonnull
    public Stream<Scope> stream(@Nonnull RepositoriesExportRequest request) {
        if (request.getIncludes().stream().anyMatch(selector -> "*".equals(selector.getProjectKey()))) {
            return this.streamAllRepositoriesAndProjects();
        }
        return this.streamSelectedRepositories(request.getIncludes());
    }

    public Stream<Scope> stream(@Nonnull MeshMigrationRequest request) {
        if (request.isAll()) {
            return this.streamAllRepositoriesAndProjects();
        }
        ImmutableSet.Builder selectors = new ImmutableSet.Builder();
        request.getProjectIds().stream().map(arg_0 -> ((InternalProjectService)this.projectService).getById(arg_0)).filter(Objects::nonNull).forEach(project -> selectors.add((Object)RepositorySelector.of((String)project.getKey(), (String)"*")));
        request.getRepositoryIds().stream().map(arg_0 -> ((InternalRepositoryService)this.repositoryService).getById(arg_0)).filter(Objects::nonNull).forEach(repository -> selectors.add((Object)RepositorySelector.of((Repository)repository)));
        return this.streamSelectedRepositories((Collection<RepositorySelector>)selectors.build());
    }

    @VisibleForTesting
    Stream<Scope> injectDependencies(Stream<Scope> stream) {
        HashSet<Integer> projectIds = new HashSet<Integer>();
        HashSet<String> hierarchyIds = new HashSet<String>();
        return stream.flatMap(this.injectRepositoryDependencies(hierarchyIds)).flatMap(this.injectProjectDependencies(projectIds));
    }

    @VisibleForTesting
    void setMaxPageSize(int maxPageSize) {
        this.maxPageSize = maxPageSize;
    }

    private PageProvider<Scope> getProjectPageProvider() {
        return request -> this.projectService.findAll(request).transform(Scopes::project);
    }

    private PageProvider<Scope> getRepositoryPageProvider() {
        return request -> this.repositoryService.findAll(request).transform(Scopes::repository);
    }

    private PageProvider<Scope> getRepositoryPageProvider(String projectKey) {
        return request -> this.repositoryService.findByProjectKey(projectKey, request).transform(Scopes::repository);
    }

    private Function<Scope, Stream<? extends Scope>> injectProjectDependencies(Set<Integer> projectIds) {
        return scope -> {
            Project project;
            int projectId;
            if (scope.getType() == ScopeType.PROJECT) {
                if (projectIds.add((Integer)scope.accept(ScopeVisitors.PROJECT_ID_GETTER))) {
                    return Stream.of(scope);
                }
                return Stream.empty();
            }
            if (scope.getType() == ScopeType.REPOSITORY && !projectIds.contains(projectId = (project = (Project)scope.accept(ScopeVisitors.PROJECT_GETTER)).getId())) {
                projectIds.add(projectId);
                return Stream.of(new ProjectScope(project), scope);
            }
            return Stream.of(scope);
        };
    }

    private Function<Scope, Stream<? extends Scope>> injectRepositoryDependencies(Set<String> hierarchyIds) {
        return scope -> {
            if (scope.getType() == ScopeType.REPOSITORY) {
                String hierarchyId = (String)scope.accept(ScopeVisitors.HIERARCHY_ID_GETTER);
                if (!hierarchyIds.add(hierarchyId)) {
                    log.trace("Already processed repositories in hierarchy: {} skipping", (Object)hierarchyId);
                    return Stream.empty();
                }
                HashSet repositoryIds = new HashSet();
                return PageUtils.toStream(pageRequest -> this.repositoryService.findByHierarchyId(hierarchyId, pageRequest), (int)this.maxPageSize).filter(repository -> !repositoryIds.contains(repository.getId())).flatMap(repository -> {
                    log.debug("Processing repository: {} for dependency ordering seen repositoryIds: {}", (Object)repository.getId(), (Object)repositoryIds);
                    LinkedList<RepositoryScope> dependencies = new LinkedList<RepositoryScope>();
                    while (repository != null && repositoryIds.add(repository.getId())) {
                        dependencies.push(new RepositoryScope(repository));
                        repository = repository.getOrigin();
                    }
                    log.debug("Generated dependency chain: {}", dependencies);
                    return dependencies.stream();
                });
            }
            return Stream.of(scope);
        };
    }

    private Stream<Scope> streamAllRepositoriesAndProjects() {
        return this.injectDependencies(MoreStreams.streamIterable((Iterable)Iterables.concat((Iterable)new PagedIterable(this.getProjectPageProvider(), this.maxPageSize), (Iterable)new PagedIterable(this.getRepositoryPageProvider(), this.maxPageSize))));
    }

    private Stream<Scope> streamSelectedRepositories(Collection<RepositorySelector> selectors) {
        Map repoSlugsByProject = selectors.stream().collect(Collectors.groupingBy(RepositorySelector::getProjectKey, Collectors.mapping(RepositorySelector::getSlug, Collectors.toSet())));
        return this.injectDependencies(repoSlugsByProject.entrySet().stream().flatMap(entry -> {
            String projectKey = (String)entry.getKey();
            Project project = this.projectService.getByKey(projectKey);
            if (project == null) {
                log.warn("Skipping project: '{}', the project was not found. It may have been deleted", (Object)projectKey);
                return Stream.empty();
            }
            Set repos = (Set)entry.getValue();
            Stream<Scope> repositoryScopes = repos.contains("*") ? MoreStreams.streamIterable((Iterable)new PagedIterable(this.getRepositoryPageProvider(projectKey), this.maxPageSize)) : repos.stream().map(slug -> this.repositoryService.getBySlug(projectKey, slug)).filter(Objects::nonNull).map(Scopes::repository);
            return Stream.concat(Stream.of(Scopes.project((Project)project)), repositoryScopes);
        }));
    }
}

