/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.stash.internal.migration;

import com.atlassian.bitbucket.Product;
import com.atlassian.bitbucket.cluster.ClusterService;
import com.atlassian.bitbucket.i18n.I18nService;
import com.atlassian.bitbucket.migration.ExportContext;
import com.atlassian.bitbucket.migration.ExportException;
import com.atlassian.bitbucket.migration.Exporter;
import com.atlassian.bitbucket.server.ApplicationPropertiesService;
import com.atlassian.stash.internal.migration.MigrationPaths;
import com.atlassian.stash.internal.migration.entity.InstanceDetailsMetadata;
import com.fasterxml.jackson.databind.ObjectMapper;
import com.fasterxml.jackson.databind.SerializationFeature;
import jakarta.annotation.Nonnull;
import java.io.IOException;
import java.io.OutputStream;
import org.apache.commons.lang3.StringUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class InstanceDetailsExporter
implements Exporter {
    private static final ObjectMapper OBJECT_MAPPER = new ObjectMapper().enable(SerializationFeature.INDENT_OUTPUT);
    private static final Logger log = LoggerFactory.getLogger(InstanceDetailsExporter.class);
    private final ApplicationPropertiesService applicationPropertiesService;
    private final ClusterService clusterService;
    private final I18nService i18nService;

    public InstanceDetailsExporter(ApplicationPropertiesService applicationPropertiesService, ClusterService clusterService, I18nService i18nService) {
        this.applicationPropertiesService = applicationPropertiesService;
        this.clusterService = clusterService;
        this.i18nService = i18nService;
    }

    public void onStart(@Nonnull ExportContext exportContext) {
        exportContext.addEntry(MigrationPaths.INSTANCE_DETAILS_PATH, this::getInstanceData, true);
    }

    private void getInstanceData(@Nonnull OutputStream outputStream) {
        boolean isCluster = this.clusterService.isAvailable();
        String instanceName = this.applicationPropertiesService.getDisplayName();
        InstanceDetailsMetadata instanceDetails = new InstanceDetailsMetadata(isCluster ? Product.DATA_CENTER_NAME : Product.NAME, this.applicationPropertiesService.getBuildVersion(), this.applicationPropertiesService.getBuildNumber(), 2, isCluster, StringUtils.isNotBlank((CharSequence)instanceName) ? instanceName : null, isCluster ? this.clusterService.getNodeId() : null);
        log.debug("Writing instance details: {}", (Object)instanceDetails);
        try {
            OBJECT_MAPPER.writeValue(outputStream, (Object)instanceDetails);
        }
        catch (IOException e) {
            throw new ExportException(this.i18nService.createKeyedMessage("bitbucket.service.migration.export.instance.details.failed", new Object[0]), (Throwable)e);
        }
    }
}

