/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.stash.internal.migration;

import com.atlassian.bitbucket.i18n.I18nService;
import com.atlassian.bitbucket.migration.EntrySource;
import com.atlassian.bitbucket.migration.ImportContext;
import com.atlassian.bitbucket.migration.Importer;
import com.atlassian.stash.internal.migration.FatalImportException;
import com.atlassian.stash.internal.migration.MigrationPaths;
import com.atlassian.stash.internal.migration.entity.InstanceDetailsMetadata;
import com.fasterxml.jackson.databind.ObjectMapper;
import com.google.common.base.Joiner;
import com.google.common.collect.ImmutableMap;
import jakarta.annotation.Nonnull;
import java.io.IOException;
import java.nio.file.Path;
import java.util.Objects;
import java.util.stream.Collectors;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class InstanceDetailsImporter
implements Importer {
    private static final ObjectMapper OBJECT_MAPPER = new ObjectMapper();
    private static final Logger log = LoggerFactory.getLogger(InstanceDetailsImporter.class);
    private final I18nService i18nService;

    public InstanceDetailsImporter(@Nonnull I18nService i18nService) {
        this.i18nService = Objects.requireNonNull(i18nService, "i18nService");
    }

    public void onEntry(@Nonnull ImportContext importContext, @Nonnull EntrySource entrySource) {
        Objects.requireNonNull(importContext);
        Objects.requireNonNull(entrySource);
        Path path = entrySource.getPath();
        log.debug("Importing entity from path: {}", (Object)path);
        Path fileName = path.getFileName();
        if (MigrationPaths.INSTANCE_DETAILS_PATH.equals(fileName)) {
            try {
                this.onInstanceDetails(entrySource);
            }
            catch (IOException e) {
                log.error("Exception while reading instance details", (Throwable)e);
                throw new FatalImportException(this.i18nService.createKeyedMessage("bitbucket.service.migration.import.error.io", new Object[0]), e);
            }
        } else {
            importContext.addWarning(this.i18nService.createKeyedMessage("bitbucket.service.migration.import.unknown.entry", new Object[]{path}), null);
        }
    }

    private void onInstanceDetails(@Nonnull EntrySource entry) throws IOException {
        entry.read(inputStream -> {
            InstanceDetailsMetadata instanceDetails = (InstanceDetailsMetadata)OBJECT_MAPPER.readValue(inputStream, InstanceDetailsMetadata.class);
            this.verifyArchiveVersion(instanceDetails);
            ImmutableMap.Builder builder = ImmutableMap.builder().put((Object)"product", (Object)instanceDetails.getProduct()).put((Object)"version", (Object)instanceDetails.getVersion()).put((Object)"buildVersion", (Object)instanceDetails.getBuildVersion()).put((Object)"archiveVersion", (Object)instanceDetails.getArchiveVersion()).put((Object)"dataCenter", (Object)instanceDetails.isDataCenter());
            if (instanceDetails.getInstanceName() != null) {
                builder.put((Object)"instanceName", (Object)instanceDetails.getInstanceName());
            }
            if (instanceDetails.getNodeId() != null) {
                builder.put((Object)"nodeId", (Object)instanceDetails.getNodeId());
            }
            String instanceDetailsString = builder.build().entrySet().stream().filter(detailEntry -> Objects.nonNull(detailEntry.getValue())).map(detailEntry -> String.valueOf(detailEntry.getKey()) + "=" + String.valueOf(detailEntry.getValue())).collect(Collectors.joining(", "));
            log.info("Importing archive from instance with details {}", (Object)instanceDetailsString);
        });
    }

    private void verifyArchiveVersion(InstanceDetailsMetadata data) {
        int archiveVersion = data.getArchiveVersion();
        if (!SUPPORTED_ARCHIVE_VERSIONS.contains(archiveVersion)) {
            throw new FatalImportException(this.i18nService.createKeyedMessage("bitbucket.service.migration.import.unsupported.archive.version", new Object[]{archiveVersion, Joiner.on((String)", ").join((Iterable)SUPPORTED_ARCHIVE_VERSIONS)}));
        }
    }
}

