/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.stash.internal.migration;

import com.atlassian.bitbucket.attribute.AttributeMap;
import com.atlassian.bitbucket.i18n.KeyedMessage;
import com.atlassian.bitbucket.io.IoConsumer;
import com.atlassian.bitbucket.migration.EntityExportMapping;
import com.atlassian.bitbucket.migration.ExportSection;
import com.atlassian.bitbucket.migration.MigrationEntityType;
import com.atlassian.bitbucket.migration.SequentialArchive;
import com.atlassian.stash.internal.migration.InternalExportContext;
import com.atlassian.stash.internal.migration.MigrationJob;
import jakarta.annotation.Nonnull;
import java.io.OutputStream;
import java.nio.file.Path;
import java.util.function.Consumer;

class NamespacedExportContext
implements InternalExportContext {
    private final AttributeMap attributeMap;
    private final InternalExportContext delegate;
    private final Path namespace;

    NamespacedExportContext(@Nonnull Path namespace, @Nonnull InternalExportContext delegate) {
        this.delegate = delegate;
        this.namespace = namespace;
        this.attributeMap = new AttributeMap();
    }

    public void addEntriesAsArchive(@Nonnull Path entryName, @Nonnull IoConsumer<SequentialArchive> writer, boolean compress) {
        this.delegate.addEntriesAsArchive(this.namespaced(entryName), writer, compress);
    }

    public void addEntry(@Nonnull Path entryName, @Nonnull IoConsumer<OutputStream> writer, boolean compress) {
        this.delegate.addEntry(this.namespaced(entryName), writer, compress);
    }

    public void addError(@Nonnull KeyedMessage message, Object entity) {
        this.delegate.addError(message, entity);
    }

    @Nonnull
    public void addError(@Nonnull KeyedMessage message, Object entity, Throwable t) {
        this.delegate.addError(message, entity, t);
    }

    public boolean addSectionIfAbsent(@Nonnull Path path, @Nonnull Consumer<ExportSection> exportSection) {
        return this.delegate.addSectionIfAbsent(this.namespaced(path), exportSection);
    }

    public void addWarning(@Nonnull KeyedMessage message, Object entity) {
        this.delegate.addWarning(message, entity);
    }

    public void addWarning(@Nonnull KeyedMessage message, Object entity, Throwable t) {
        this.delegate.addWarning(message, entity, t);
    }

    public void close() {
    }

    public void cancel() {
        this.delegate.cancel();
    }

    public void abortIfCanceled() {
        this.delegate.abortIfCanceled();
    }

    @Nonnull
    public InternalExportContext forNamespace(@Nonnull Path namespace) {
        return new NamespacedExportContext(this.namespaced(namespace), this.delegate);
    }

    @Nonnull
    public AttributeMap getAttributeMap() {
        return this.attributeMap;
    }

    @Nonnull
    public <T> EntityExportMapping<T> getEntityMapping(@Nonnull MigrationEntityType<T> entityType) {
        return this.delegate.getEntityMapping(entityType);
    }

    @Nonnull
    public MigrationJob getJob() {
        return this.delegate.getJob();
    }

    public boolean hasErrors() {
        return this.delegate.hasErrors();
    }

    public boolean hasSection(@Nonnull Path path) {
        return this.delegate.hasSection(this.namespaced(path));
    }

    @Nonnull
    private Path namespaced(@Nonnull Path path) {
        return this.namespace.resolve(path);
    }
}

