/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.stash.internal.migration;

import com.atlassian.bitbucket.attribute.AttributeMap;
import com.atlassian.bitbucket.i18n.KeyedMessage;
import com.atlassian.bitbucket.io.IoConsumer;
import com.atlassian.bitbucket.migration.EntityImportMapping;
import com.atlassian.bitbucket.migration.EntrySource;
import com.atlassian.bitbucket.migration.MigrationEntityType;
import com.atlassian.stash.internal.migration.InternalImportContext;
import com.atlassian.stash.internal.migration.MigrationJob;
import jakarta.annotation.Nonnull;
import jakarta.annotation.Nullable;
import java.io.IOException;
import java.nio.file.Path;
import java.util.Optional;

class NamespacedImportContext
implements InternalImportContext {
    private final AttributeMap attributeMap;
    private final InternalImportContext delegate;
    private final Path namespace;

    NamespacedImportContext(Path namespace, InternalImportContext delegate) {
        this.delegate = delegate;
        this.namespace = namespace;
        this.attributeMap = new AttributeMap();
    }

    public void abortIfCanceled() {
        this.delegate.abortIfCanceled();
    }

    public void addError(@Nonnull KeyedMessage message, @Nullable Object entity) {
        this.delegate.addError(message, entity);
    }

    public void addError(@Nonnull KeyedMessage message, @Nullable Object entity, @Nullable Throwable t) {
        this.delegate.addError(message, entity, t);
    }

    public void addWarning(@Nonnull KeyedMessage message, @Nullable Object entity) {
        this.delegate.addWarning(message, entity);
    }

    public void addWarning(@Nonnull KeyedMessage message, @Nullable Object entity, @Nullable Throwable t) {
        this.delegate.addWarning(message, entity, t);
    }

    public void cancel() {
        this.delegate.cancel();
    }

    public void close() {
    }

    public void finalizeRepositoryHierarchy(@Nonnull String hierarchyId) {
        this.delegate.finalizeRepositoryHierarchy(hierarchyId);
    }

    @Nonnull
    public InternalImportContext forNamespace(@Nonnull Path namespace) {
        return this.delegate.forNamespace(this.namespace.resolve(namespace));
    }

    @Nonnull
    public AttributeMap getAttributeMap() {
        return this.attributeMap;
    }

    @Nonnull
    public Optional<String> getCurrentHierarchyId() {
        return this.delegate.getCurrentHierarchyId();
    }

    @Nonnull
    public <T> EntityImportMapping<T> getEntityMapping(@Nonnull MigrationEntityType<T> entityType) {
        return this.delegate.getEntityMapping(entityType);
    }

    @Nonnull
    public MigrationJob getJob() {
        return this.delegate.getJob();
    }

    public int getProgressPercentage() throws IOException {
        return this.delegate.getProgressPercentage();
    }

    public boolean hasErrors() {
        return this.delegate.hasErrors();
    }

    public void iterateEntries(@Nonnull IoConsumer<EntrySource> consumer) throws IOException {
        this.delegate.iterateEntries(consumer);
    }

    public void setCurrentHierarchyId(@Nullable String hierarchyId) {
        this.delegate.setCurrentHierarchyId(hierarchyId);
    }
}

