/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.stash.internal.migration;

import jakarta.annotation.Nonnull;
import jakarta.annotation.Nullable;
import java.io.IOException;
import java.io.OutputStream;
import java.lang.reflect.Field;
import java.nio.ByteBuffer;
import java.nio.channels.SeekableByteChannel;
import java.nio.charset.StandardCharsets;
import java.util.Deque;
import java.util.LinkedList;
import java.util.Objects;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import org.apache.commons.compress.archivers.ArchiveEntry;
import org.apache.commons.compress.archivers.tar.TarArchiveEntry;
import org.apache.commons.compress.archivers.tar.TarArchiveOutputStream;
import org.apache.commons.lang3.StringUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.util.ReflectionUtils;

class RandomAccessTarArchiveOutputStream
extends TarArchiveOutputStream {
    private static final int RECORD_SIZE = 512;
    private static final long UNKNOWN_ENTRY_SIZE = Long.MAX_VALUE;
    private static final Field currBytesField;
    private static final Field currSizeField;
    private static final Logger log;
    private final SeekableByteChannel channel;
    private final Deque<TarArchiveEntry> currentEntry = new LinkedList<TarArchiveEntry>();
    private ArchiveEntry currentPaxHeader;
    private long lastEntryStartPosition;
    private long lastPaxEntryStartPosition = -1L;

    public RandomAccessTarArchiveOutputStream(@Nonnull SeekableByteChannel channel) {
        super(RandomAccessTarArchiveOutputStream.getOutputStream(channel));
        if (currBytesField == null || currSizeField == null) {
            throw new IllegalStateException("Initialization of fields of the superclass failed. An error was logged when this class was initialized.");
        }
        this.setLongFileMode(3);
        this.setBigNumberMode(2);
        this.channel = channel;
    }

    public void closeArchiveEntry() throws IOException {
        TarArchiveEntry current = this.currentEntry.poll();
        if (current == null) {
            super.closeArchiveEntry();
            return;
        }
        if (current.getSize() != Long.MAX_VALUE) {
            super.closeArchiveEntry();
            this.lastEntryStartPosition = this.channel.position();
            if (current.isPaxHeader()) {
                this.currentPaxHeader = current;
            }
            return;
        }
        long size = this.getCurrBytes();
        long lastEntryEndPosition = this.channel.position();
        byte[] header = new byte[512];
        current.setSize(size);
        this.setCurrSize(size);
        current.writeEntryHeader(header);
        this.channel.position(this.lastEntryStartPosition);
        this.channel.write(ByteBuffer.wrap(header));
        if (this.lastPaxEntryStartPosition != -1L) {
            byte[] paxContents = new byte[(int)this.currentPaxHeader.getSize()];
            long lastPaxEntryContentStartPosition = this.lastPaxEntryStartPosition + 512L;
            this.channel.position(lastPaxEntryContentStartPosition);
            this.channel.read(ByteBuffer.wrap(paxContents));
            paxContents = this.generateUpdatedPAXEntryWithSize(size, paxContents);
            this.channel.position(lastPaxEntryContentStartPosition);
            this.channel.write(ByteBuffer.wrap(paxContents));
            this.lastPaxEntryStartPosition = -1L;
        }
        this.channel.position(lastEntryEndPosition);
        super.closeArchiveEntry();
    }

    public void putArchiveEntry(@Nonnull TarArchiveEntry archiveEntry) throws IOException {
        Objects.requireNonNull(archiveEntry, "archiveEntry");
        TarArchiveEntry entry = archiveEntry;
        if (!this.currentEntry.isEmpty() && !entry.isPaxHeader()) {
            this.closeArchiveEntry();
        }
        if (entry.isPaxHeader()) {
            this.lastPaxEntryStartPosition = this.channel.position();
            this.currentPaxHeader = entry;
        } else if (entry.getSize() == 0L && !entry.isDirectory()) {
            TarArchiveEntry newEntry = new TarArchiveEntry(entry.getName());
            newEntry.setSize(Long.MAX_VALUE);
            newEntry.setUserId(entry.getLongUserId());
            newEntry.setGroupId(entry.getLongGroupId());
            newEntry.setNames(entry.getUserName(), entry.getGroupName());
            newEntry.setModTime(entry.getModTime());
            newEntry.setMode(entry.getMode());
            newEntry.setLinkName(entry.getLinkName());
            entry.getExtraPaxHeaders().forEach((arg_0, arg_1) -> ((TarArchiveEntry)newEntry).addPaxHeader(arg_0, arg_1));
            entry = newEntry;
        }
        this.currentEntry.push(entry);
        super.putArchiveEntry(entry);
    }

    @Nonnull
    private static OutputStream getOutputStream(final @Nonnull SeekableByteChannel channel) {
        return new OutputStream(){

            @Override
            public void write(int b) throws IOException {
                channel.write(ByteBuffer.wrap(new byte[]{(byte)b}));
            }

            @Override
            public void write(@Nonnull byte[] b) throws IOException {
                channel.write(ByteBuffer.wrap(b));
            }

            @Override
            public void write(@Nonnull byte[] b, int off, int len) throws IOException {
                channel.write(ByteBuffer.wrap(b, off, len));
            }

            @Override
            public void close() throws IOException {
                channel.close();
            }
        };
    }

    @Nullable
    private static Field lookupFieldAndMakeAccessible(@Nonnull String fieldName) {
        try {
            Field field = ReflectionUtils.findField(TarArchiveOutputStream.class, (String)fieldName, Long.TYPE);
            if (field != null) {
                ReflectionUtils.makeAccessible((Field)field);
            } else {
                log.error("Could not find the field ''{}'' of the superclass", (Object)fieldName);
            }
            return field;
        }
        catch (SecurityException e) {
            log.error("Could access the field ''{}'' of the superclass or make it accessible", (Object)fieldName, (Object)e);
            return null;
        }
    }

    @Nonnull
    private byte[] generateUpdatedPAXEntryWithSize(long size, @Nonnull byte[] paxContents) {
        String paxContentsString = new String(paxContents, StandardCharsets.UTF_8);
        StringBuffer buf = new StringBuffer(paxContentsString.length());
        Matcher m = Pattern.compile("(\\d+)( size=)(\\d+)(\n)").matcher(paxContentsString);
        if (!m.find()) {
            return paxContents;
        }
        String length = m.group(1);
        String keyword = m.group(2);
        String originalSize = m.group(3);
        String stringTerminator = m.group(4);
        String newSize = String.valueOf(size);
        String replacementString = length + keyword + StringUtils.repeat((char)'0', (int)(originalSize.length() - newSize.length())) + newSize + stringTerminator;
        if (m.group(0).length() != replacementString.length()) {
            throw new RuntimeException("Failed to modify the size entry correctly, lengths differ! " + m.group(0).length() + " != " + replacementString.length());
        }
        m.appendReplacement(buf, replacementString);
        m.appendTail(buf);
        return buf.toString().getBytes(StandardCharsets.UTF_8);
    }

    private long getCurrBytes() {
        return (Long)ReflectionUtils.getField((Field)currBytesField, (Object)((Object)this));
    }

    private void setCurrSize(long size) {
        ReflectionUtils.setField((Field)currSizeField, (Object)((Object)this), (Object)size);
    }

    static {
        log = LoggerFactory.getLogger(RandomAccessTarArchiveOutputStream.class);
        currBytesField = RandomAccessTarArchiveOutputStream.lookupFieldAndMakeAccessible("currBytes");
        currSizeField = RandomAccessTarArchiveOutputStream.lookupFieldAndMakeAccessible("currSize");
    }
}

