/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.stash.internal.migration;

import com.atlassian.bitbucket.i18n.I18nService;
import com.atlassian.bitbucket.i18n.KeyedMessage;
import com.atlassian.bitbucket.migration.CanceledMigrationException;
import com.atlassian.bitbucket.migration.ExportContext;
import com.atlassian.bitbucket.migration.Exporter;
import com.atlassian.bitbucket.migration.MigrationException;
import com.atlassian.bitbucket.migration.MigrationHandlerModuleDescriptor;
import com.atlassian.bitbucket.project.Project;
import com.atlassian.bitbucket.pull.PullRequest;
import com.atlassian.bitbucket.repository.Repository;
import com.atlassian.plugin.PluginAccessor;
import com.atlassian.stash.internal.AbstractService;
import com.atlassian.stash.internal.migration.ExporterExecutorService;
import com.atlassian.stash.internal.migration.InternalExportContext;
import com.atlassian.stash.internal.migration.MigrationNamespaces;
import jakarta.annotation.Nonnull;
import jakarta.annotation.Nullable;
import java.nio.file.Paths;
import java.util.stream.Stream;
import org.apache.commons.lang3.ObjectUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Component;

@Component(value="exporterService")
public class SingleThreadedExporterExecutorService
extends AbstractService
implements ExporterExecutorService {
    private static final Logger log = LoggerFactory.getLogger(SingleThreadedExporterExecutorService.class);
    private final I18nService i18nService;
    private final PluginAccessor pluginAccessor;

    @Autowired
    public SingleThreadedExporterExecutorService(I18nService i18nService, PluginAccessor pluginAccessor) {
        this.i18nService = i18nService;
        this.pluginAccessor = pluginAccessor;
    }

    public void executeExport(@Nonnull InternalExportContext context, @Nonnull Project project) {
        this.getDataExporters(context).forEach(exporter -> {
            context.abortIfCanceled();
            exporter.export(project);
        });
    }

    public void executeExport(@Nonnull InternalExportContext context, @Nonnull PullRequest pullRequest) {
        this.getDataExporters(context).forEach(exporter -> {
            context.abortIfCanceled();
            exporter.export(pullRequest);
        });
    }

    public void executeExport(@Nonnull InternalExportContext context, @Nonnull Repository repository) {
        this.getDataExporters(context).forEach(exporter -> {
            context.abortIfCanceled();
            exporter.export(repository);
        });
    }

    public boolean executeOnEnd(@Nonnull InternalExportContext context) {
        return this.getDataExporters(context).map(ErrorHandlingDataExporter::onEnd).reduce(true, (a, b) -> a != false && b != false);
    }

    public boolean executeOnStart(@Nonnull InternalExportContext context) {
        return this.getDataExporters(context).map(ErrorHandlingDataExporter::onStart).filter(r -> r == false).findFirst().orElse(true);
    }

    @Nullable
    private static Object getSubject(@Nullable Exception e, Object ... fallbackSubject) {
        return ObjectUtils.firstNonNull((Object[])new Object[]{e instanceof MigrationException ? ((MigrationException)e).getSubject().orElse(null) : null, ObjectUtils.firstNonNull((Object[])fallbackSubject)});
    }

    private Stream<ErrorHandlingDataExporter> getDataExporters(InternalExportContext context) {
        return this.pluginAccessor.getEnabledModuleDescriptorsByClass(MigrationHandlerModuleDescriptor.class).stream().sorted().map(descriptor -> {
            Exporter exporter = descriptor.getExporter();
            String handlerKey = MigrationNamespaces.fromModuleDescriptor(descriptor);
            if (log.isTraceEnabled()) {
                log.trace("Found handler {} with weight {}, returning exporter {}", new Object[]{handlerKey, descriptor.getWeight(), exporter.getClass()});
            }
            return new ErrorHandlingDataExporter(context, exporter, handlerKey);
        });
    }

    private class ErrorHandlingDataExporter {
        private final InternalExportContext context;
        private final Exporter delegate;

        ErrorHandlingDataExporter(@Nonnull InternalExportContext context, @Nonnull Exporter delegate, String namespace) {
            this.context = context.forNamespace(Paths.get(namespace, new String[0]));
            this.delegate = delegate;
        }

        void export(@Nonnull Project project) {
            try {
                this.delegate.export((ExportContext)this.context, project);
            }
            catch (CanceledMigrationException e) {
                throw e;
            }
            catch (Exception e) {
                this.addCallbackErrorFor(e, "export", project);
            }
        }

        void export(@Nonnull PullRequest pullRequest) {
            try {
                this.delegate.export((ExportContext)this.context, pullRequest);
            }
            catch (CanceledMigrationException e) {
                throw e;
            }
            catch (Exception e) {
                this.addCallbackErrorFor(e, "export", pullRequest);
            }
        }

        void export(@Nonnull Repository repository) {
            try {
                this.delegate.export((ExportContext)this.context, repository);
            }
            catch (CanceledMigrationException e) {
                throw e;
            }
            catch (Exception e) {
                this.addCallbackErrorFor(e, "export", repository);
            }
        }

        boolean onEnd() {
            try {
                this.delegate.onEnd((ExportContext)this.context);
                return true;
            }
            catch (CanceledMigrationException e) {
                log.debug("Canceled during call to 'onEnd' on {}", (Object)this.delegate.getClass());
                return false;
            }
            catch (Exception e) {
                this.addCallbackErrorFor(e, "onEnd", new Object[0]);
                return false;
            }
        }

        boolean onStart() {
            try {
                this.delegate.onStart((ExportContext)this.context);
                return true;
            }
            catch (CanceledMigrationException e) {
                throw e;
            }
            catch (Exception e) {
                this.addCallbackErrorFor(e, "onStart", new Object[0]);
                return false;
            }
        }

        private void addCallbackErrorFor(Exception e, String callback, Object ... fallbackSubjects) {
            KeyedMessage message = SingleThreadedExporterExecutorService.this.i18nService.createKeyedMessage("bitbucket.service.migration.callback.error", new Object[]{callback, this.delegate.getClass(), e.getMessage()});
            this.context.addError(message, SingleThreadedExporterExecutorService.getSubject(e, fallbackSubjects), (Throwable)e);
        }
    }
}

