/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.stash.internal.migration;

import com.atlassian.bitbucket.io.IoConsumer;
import com.atlassian.bitbucket.migration.ArchiveSource;
import com.atlassian.bitbucket.migration.EntrySource;
import com.atlassian.stash.internal.migration.DefaultEntrySource;
import com.atlassian.stash.internal.migration.FilePermissionUtils;
import com.google.common.base.MoreObjects;
import jakarta.annotation.Nonnull;
import java.io.Closeable;
import java.io.IOException;
import java.io.InputStream;
import java.nio.file.Files;
import java.nio.file.LinkOption;
import java.nio.file.NoSuchFileException;
import java.nio.file.Path;
import java.nio.file.Paths;
import java.nio.file.attribute.PosixFileAttributeView;
import java.util.Objects;
import java.util.concurrent.atomic.AtomicBoolean;
import java.util.function.Predicate;
import java.util.stream.IntStream;
import org.apache.commons.compress.archivers.tar.TarArchiveEntry;
import org.apache.commons.compress.archivers.tar.TarArchiveInputStream;
import org.apache.commons.io.input.CloseShieldInputStream;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class TarArchiveSource
implements ArchiveSource,
Closeable {
    private static final Logger log = LoggerFactory.getLogger(TarArchiveSource.class);
    private final TarArchiveInputStream inputStream;
    private final Path path;
    private final AtomicBoolean read = new AtomicBoolean();

    public TarArchiveSource(@Nonnull InputStream inputStream, @Nonnull Path path) {
        Objects.requireNonNull(inputStream, "inputStream");
        this.path = Objects.requireNonNull(path, "path");
        this.inputStream = new TarArchiveInputStream(inputStream);
    }

    @Override
    public void close() throws IOException {
        this.inputStream.close();
    }

    public void extractToDisk(@Nonnull Path target, @Nonnull Predicate<String> filter) throws IOException {
        Objects.requireNonNull(target, "target");
        Objects.requireNonNull(filter, "filter");
        this.read((IoConsumer<EntrySource>)((IoConsumer)entrySource -> {
            Path entryPath = entrySource.getPath();
            String filename = entryPath.getFileName().toString();
            if (filename.endsWith(".atl.deleted")) {
                Path fileToDelete = entryPath.resolveSibling(filename.substring(0, filename.length() - ".atl.deleted".length()));
                log.debug("Deleting entry '{}' in '{}'", (Object)fileToDelete, (Object)target);
                Path path = target.resolve(fileToDelete);
                try {
                    Files.delete(path);
                }
                catch (NoSuchFileException e) {
                    log.debug("Deleting entry '{}' in '{}' failed", new Object[]{fileToDelete, target, e});
                }
            } else {
                entrySource.extractToDisk(target.resolve(entryPath));
            }
        }), filter);
    }

    @Nonnull
    public Path getPath() {
        return this.path;
    }

    public void read(@Nonnull IoConsumer<EntrySource> reader, @Nonnull Predicate<String> filter) throws IOException {
        TarArchiveEntry entry;
        Objects.requireNonNull(reader, "reader");
        Objects.requireNonNull(filter, "filter");
        this.guardAgainstRepeatedCalls();
        while ((entry = this.inputStream.getNextEntry()) != null) {
            CloseShieldInputStream entryInputStream = new CloseShieldInputStream((InputStream)this.inputStream);
            String name = entry.getName();
            Path entryPath = Paths.get(name, new String[0]);
            if (entryPath.isAbsolute() || TarArchiveSource.isRelative(entryPath)) {
                throw new IOException("Archive '" + String.valueOf(this.path) + "': Invalid entry encountered: " + name);
            }
            if (!filter.test(name)) continue;
            reader.accept((Object)new TarEntrySource((InputStream)entryInputStream, entryPath, entry));
        }
    }

    public String toString() {
        return MoreObjects.toStringHelper((Object)this).add("path", (Object)this.path).toString();
    }

    private static boolean isRelative(@Nonnull Path entryPath) {
        return IntStream.range(0, entryPath.getNameCount()).mapToObj(entryPath::getName).map(Path::toString).anyMatch(".."::equals);
    }

    private void guardAgainstRepeatedCalls() {
        if (!this.read.compareAndSet(false, true)) {
            throw new IllegalStateException("You can not read from this source more than once");
        }
    }

    private static class TarEntrySource
    extends DefaultEntrySource {
        private final TarArchiveEntry tarArchiveEntry;

        public TarEntrySource(@Nonnull InputStream inputStream, @Nonnull Path path, @Nonnull TarArchiveEntry tarArchiveEntry) {
            super(inputStream, path);
            this.tarArchiveEntry = tarArchiveEntry;
        }

        @Override
        public void extractToDisk(@Nonnull Path target) throws IOException {
            super.extractToDisk(target);
            PosixFileAttributeView fileAttributeView = Files.getFileAttributeView(target, PosixFileAttributeView.class, new LinkOption[0]);
            if (fileAttributeView != null) {
                fileAttributeView.setPermissions(FilePermissionUtils.toPosixFilePermissions((int)this.tarArchiveEntry.getMode()));
            }
        }
    }
}

