/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.stash.internal.migration;

import com.atlassian.bitbucket.util.MoreStreams;
import jakarta.annotation.Nonnull;
import java.nio.file.Path;
import java.nio.file.Paths;
import java.util.Arrays;
import java.util.regex.Pattern;
import java.util.stream.Collectors;

class TarEntryUtils {
    static final String ARCHIVE_EXTENSION = ".atl.tar";
    static final String COMPRESSED_EXTENSION = ".atl.gz";
    static final String DELETED_EXTENSION = ".atl.deleted";
    private static final String DELIMITER = "/";
    private static final Pattern ENTRY_SEPARATOR = Pattern.compile(Pattern.quote("/"));

    private TarEntryUtils() {
        throw new UnsupportedOperationException("Util class can't be instantiated");
    }

    @Nonnull
    static String normalizeEntry(@Nonnull Path path) {
        return MoreStreams.streamIterable((Iterable)path).map(Object::toString).collect(Collectors.joining(DELIMITER));
    }

    @Nonnull
    static Path toPath(@Nonnull String entryName) {
        return Arrays.stream(ENTRY_SEPARATOR.split(entryName)).reduce(Paths.get("", new String[0]), Path::resolve, Path::resolve);
    }
}

