/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.stash.internal.migration;

import com.atlassian.bitbucket.io.IoConsumer;
import com.atlassian.stash.internal.migration.ExportTarget;
import com.atlassian.stash.internal.migration.RandomAccessTarArchiveOutputStream;
import com.atlassian.stash.internal.migration.TarEntryUtils;
import jakarta.annotation.Nonnull;
import java.io.IOException;
import java.io.OutputStream;
import java.nio.file.Files;
import java.nio.file.LinkOption;
import java.nio.file.Path;
import java.nio.file.StandardOpenOption;
import java.nio.file.attribute.FileAttribute;
import java.util.Objects;
import java.util.concurrent.locks.Lock;
import java.util.concurrent.locks.ReentrantLock;
import java.util.zip.GZIPOutputStream;
import javax.annotation.concurrent.ThreadSafe;
import org.apache.commons.compress.archivers.tar.TarArchiveEntry;
import org.apache.commons.compress.archivers.tar.TarArchiveOutputStream;
import org.apache.commons.io.output.CloseShieldOutputStream;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

@ThreadSafe
public class TarExportTarget
implements ExportTarget {
    private static final Logger log = LoggerFactory.getLogger(TarExportTarget.class);
    private final TarArchiveOutputStream tarOutputStream;
    private final Lock writeLock;

    public TarExportTarget(@Nonnull Path path) throws IOException {
        Objects.requireNonNull(path, "path");
        if (!path.getFileName().toString().endsWith(".tar")) {
            log.warn("Writing TAR file ''{}'' not ending in ''.tar''", (Object)path);
        }
        this.tarOutputStream = new RandomAccessTarArchiveOutputStream(Files.newByteChannel(Files.createFile(path, new FileAttribute[0]), StandardOpenOption.WRITE, StandardOpenOption.READ));
        this.writeLock = new ReentrantLock();
    }

    @Override
    public void addEntry(@Nonnull Path entryName, @Nonnull IoConsumer<OutputStream> writer, boolean compress) throws IOException {
        Objects.requireNonNull(entryName, "entryName");
        Objects.requireNonNull(writer, "writer");
        TarArchiveEntry entry = new TarArchiveEntry(TarEntryUtils.normalizeEntry(entryName));
        this.addEntry(entry, writer, compress);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void addFile(@Nonnull Path entryName, @Nonnull Path sourcePath, boolean compress) throws IOException {
        TarArchiveEntry entry = new TarArchiveEntry(sourcePath.toFile(), TarEntryUtils.normalizeEntry(entryName));
        if (compress) {
            this.addEntry(entry, (IoConsumer<OutputStream>)((IoConsumer)outputStream -> Files.copy(sourcePath, outputStream)), true);
        } else {
            this.writeLock.lock();
            try {
                this.tarOutputStream.putArchiveEntry(entry);
                try {
                    if (!Files.isDirectory(sourcePath, new LinkOption[0])) {
                        Files.copy(sourcePath, (OutputStream)this.tarOutputStream);
                    }
                }
                finally {
                    this.tarOutputStream.closeArchiveEntry();
                }
            }
            finally {
                this.writeLock.unlock();
            }
        }
    }

    @Override
    public void close() throws IOException {
        this.tarOutputStream.close();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void addEntry(@Nonnull TarArchiveEntry entry, @Nonnull IoConsumer<OutputStream> writer, boolean compress) throws IOException {
        this.writeLock.lock();
        try {
            if (compress) {
                TarArchiveEntry tmp = new TarArchiveEntry(entry.getName() + ".atl.gz");
                tmp.setUserId(entry.getLongUserId());
                tmp.setGroupId(entry.getLongGroupId());
                tmp.setNames(entry.getUserName(), entry.getGroupName());
                tmp.setModTime(entry.getModTime());
                tmp.setMode(entry.getMode());
                tmp.setLinkName(entry.getLinkName());
                entry = tmp;
            }
            this.tarOutputStream.putArchiveEntry(entry);
            Object outputStream = new CloseShieldOutputStream((OutputStream)this.tarOutputStream);
            try {
                if (compress) {
                    outputStream = new GZIPOutputStream((OutputStream)outputStream);
                }
                writer.accept(outputStream);
            }
            finally {
                outputStream.close();
                this.tarOutputStream.closeArchiveEntry();
            }
        }
        finally {
            this.writeLock.unlock();
        }
    }
}

