/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.stash.internal.migration;

import com.atlassian.bitbucket.migration.EntityExportMapping;
import com.atlassian.bitbucket.user.ApplicationUser;
import com.atlassian.bitbucket.user.UserService;
import jakarta.annotation.Nonnull;
import java.util.Objects;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Component;

@Component
public class UserEntityExportMapping
implements EntityExportMapping<Integer> {
    private UserService userService;

    @Autowired
    public UserEntityExportMapping(UserService userService) {
        this.userService = userService;
    }

    @Nonnull
    public String getExportId(@Nonnull Integer id) {
        Objects.requireNonNull(id, "id");
        ApplicationUser user = this.userService.getUserById(id.intValue(), true);
        if (user == null) {
            throw new IllegalArgumentException("User id '" + id + "' not found!");
        }
        return Stream.of(user.getName(), user.getDisplayName(), null, user.getType().name()).map(str -> str == null ? "" : str.replace("|", "\\|")).collect(Collectors.joining("|"));
    }
}

