/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.stash.internal.migration;

import com.atlassian.bitbucket.migration.EntityImportMapping;
import com.atlassian.bitbucket.user.UserType;
import com.atlassian.stash.internal.migration.DefaultEntityImportMapping;
import com.atlassian.stash.internal.migration.UserImportService;
import jakarta.annotation.Nonnull;
import java.util.Optional;
import java.util.function.Function;
import java.util.regex.Pattern;

public class UserEntityImportMapping
implements EntityImportMapping<Integer> {
    private static final Pattern EXPORT_ID_ESCAPE_PATTERN = Pattern.compile(Pattern.quote("\\|"));
    private static final Pattern EXPORT_ID_SPLIT_PATTERN = Pattern.compile("(?<!\\\\)\\|");
    private static final Function<String, String> UNESCAPE_EXPORT_ID = string -> EXPORT_ID_ESCAPE_PATTERN.matcher((CharSequence)string).replaceAll("|");
    private final EntityImportMapping<Integer> delegate;
    private final UserImportService userImportService;

    public UserEntityImportMapping(UserImportService userImportService) {
        this.userImportService = userImportService;
        this.delegate = new DefaultEntityImportMapping<Integer>();
    }

    public void add(@Nonnull String exportId, @Nonnull Integer localId) {
        this.delegate.add(exportId, (Object)localId);
    }

    public void clear() {
        throw new UnsupportedOperationException("UserEntityImportMapping does not support clearing");
    }

    @Nonnull
    public Optional<String> getExportId(@Nonnull Integer localId) {
        return this.delegate.getExportId((Object)localId);
    }

    @Nonnull
    public Optional<Integer> getLocalId(@Nonnull String exportId) {
        int userId;
        Optional localId = this.delegate.getLocalId(exportId);
        if (localId.isPresent()) {
            return localId;
        }
        String[] fragments = (String[])EXPORT_ID_SPLIT_PATTERN.splitAsStream(exportId).map(UNESCAPE_EXPORT_ID).toArray(String[]::new);
        if (fragments.length != 4) {
            throw new IllegalArgumentException("Unexpected format for 'exportId': " + exportId);
        }
        String username = fragments[0];
        String displayName = fragments[1];
        UserType userType = UserType.valueOf((String)fragments[3]);
        if (userType == UserType.NORMAL) {
            userId = this.userImportService.findOrCreateNormalUser(username).getId();
        } else if (userType == UserType.SERVICE) {
            userId = this.userImportService.findOrCreateServiceUser(username, displayName).getId();
        } else {
            throw new IllegalArgumentException("Unknown user type " + String.valueOf(userType) + " encountered");
        }
        this.add(exportId, userId);
        return Optional.of(userId);
    }
}

