/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.stash.internal.migration;

import com.atlassian.bitbucket.migration.ExportContext;
import com.atlassian.bitbucket.user.ApplicationUser;
import com.atlassian.bitbucket.util.MoreStreams;
import com.atlassian.bitbucket.watcher.Watcher;
import com.fasterxml.jackson.core.JsonFactory;
import com.fasterxml.jackson.core.JsonGenerator;
import com.google.common.base.Throwables;
import jakarta.annotation.Nonnull;
import java.io.IOException;
import java.nio.file.Path;
import java.util.function.Supplier;

public interface WatchableExporter {
    default public void writeWatchersJson(@Nonnull ExportContext context, @Nonnull Path path, @Nonnull Supplier<Iterable<Watcher>> watchers) {
        context.addEntry(path, outputStream -> {
            try (JsonGenerator jsonGenerator = new JsonFactory().createJsonGenerator(outputStream);){
                jsonGenerator.writeStartArray();
                MoreStreams.streamIterable((Iterable)((Iterable)watchers.get())).map(Watcher::getUser).map(ApplicationUser::getSlug).forEach(exportUserSlug -> {
                    try {
                        jsonGenerator.writeString(exportUserSlug);
                    }
                    catch (IOException e) {
                        throw Throwables.propagate((Throwable)e);
                    }
                });
                jsonGenerator.writeEndArray();
            }
        }, true);
    }
}

