/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.stash.internal.migration;

import com.atlassian.bitbucket.dmz.migration.MigrationStep;
import com.atlassian.stash.internal.migration.MigrationJob;
import com.atlassian.stash.internal.migration.MigrationJobProgressUpdateRequest;
import com.google.common.primitives.Ints;
import java.time.Clock;
import java.time.Duration;
import java.time.Instant;

class WeightedMigrationStep
implements MigrationStep {
    static final Duration INTERVAL_JOB_UPDATE = Duration.ofSeconds(1L);
    private final double baseProgress;
    private final Clock clock;
    private final MigrationJob job;
    private final double weight;
    private Instant lastUpdated;
    private double percentage;

    WeightedMigrationStep(Clock clock, MigrationJob job, double baseProgress, double weight) {
        this.baseProgress = baseProgress;
        this.clock = clock;
        this.job = job;
        this.weight = weight;
    }

    WeightedMigrationStep(MigrationJob job, double baseProgress, double weight) {
        this(Clock.systemDefaultZone(), job, baseProgress, weight);
    }

    public double getProgress() {
        return this.percentage;
    }

    public void updateProgress(double percentage) {
        this.percentage = Math.min(100.0, Math.max(0.0, percentage));
        this.maybeUpdateJob();
    }

    private void maybeUpdateJob() {
        Instant now = this.clock.instant();
        if (this.lastUpdated == null || Duration.between(this.lastUpdated, now).compareTo(INTERVAL_JOB_UPDATE) > 0) {
            double overallProgress = Math.min(100.0, Math.max(0.0, this.baseProgress + this.weight * this.percentage));
            this.job.updateProgress(new MigrationJobProgressUpdateRequest.Builder().percentage(Ints.saturatedCast((long)Math.round(overallProgress))).build());
            this.lastUpdated = now;
        }
    }
}

