/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.stash.internal.migration.entity;

import com.atlassian.bitbucket.migration.ExportContext;
import com.atlassian.bitbucket.migration.Exporter;
import com.atlassian.bitbucket.migration.StandardMigrationEntityType;
import com.atlassian.bitbucket.project.Project;
import com.atlassian.bitbucket.repository.Repository;
import com.atlassian.stash.internal.migration.entity.project.ProjectMetadata;
import com.atlassian.stash.internal.migration.entity.repository.RepositoryMetadata;
import com.fasterxml.jackson.databind.ObjectMapper;
import jakarta.annotation.Nonnull;
import java.nio.file.Path;
import java.nio.file.Paths;

public class MetadataExporter
implements Exporter {
    private static final ObjectMapper OBJECT_MAPPER = new ObjectMapper();

    public void export(@Nonnull ExportContext context, @Nonnull Project project) {
        String projectId = context.getEntityMapping(StandardMigrationEntityType.PROJECT).getExportId((Object)project.getId());
        this.writeJson(context, Paths.get("project_" + projectId, "project.json"), new ProjectMetadata(context, project));
    }

    public void export(@Nonnull ExportContext context, @Nonnull Repository repository) {
        String projectId = context.getEntityMapping(StandardMigrationEntityType.PROJECT).getExportId((Object)repository.getProject().getId());
        String repositoryId = context.getEntityMapping(StandardMigrationEntityType.REPOSITORY).getExportId((Object)repository.getId());
        this.writeJson(context, Paths.get("project_" + projectId, "repository_" + repositoryId + ".json"), new RepositoryMetadata(context, repository));
    }

    private void writeJson(@Nonnull ExportContext context, Path entryName, Object value) {
        context.addEntry(entryName, outputStream -> OBJECT_MAPPER.writeValue(outputStream, value), true);
    }
}

