/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.stash.internal.migration.entity;

import com.atlassian.bitbucket.EntityOutOfDateException;
import com.atlassian.bitbucket.i18n.I18nService;
import com.atlassian.bitbucket.i18n.KeyedMessage;
import com.atlassian.bitbucket.migration.EntrySource;
import com.atlassian.bitbucket.migration.ImportContext;
import com.atlassian.bitbucket.migration.ImportException;
import com.atlassian.bitbucket.migration.Importer;
import com.atlassian.bitbucket.migration.StandardMigrationEntityType;
import com.atlassian.bitbucket.project.Project;
import com.atlassian.bitbucket.project.ProjectCreateRequest;
import com.atlassian.bitbucket.project.ProjectMovedException;
import com.atlassian.bitbucket.project.ProjectType;
import com.atlassian.bitbucket.repository.Repository;
import com.atlassian.bitbucket.repository.RepositoryCreateRequest;
import com.atlassian.bitbucket.repository.RepositoryForkRequest;
import com.atlassian.bitbucket.repository.RepositoryMovedException;
import com.atlassian.bitbucket.user.ApplicationUser;
import com.atlassian.stash.internal.migration.InternalImportContext;
import com.atlassian.stash.internal.migration.MigrationJob;
import com.atlassian.stash.internal.migration.MigrationJobProgressUpdateRequest;
import com.atlassian.stash.internal.migration.UserImportService;
import com.atlassian.stash.internal.migration.entity.UniqueIdentifierGenerator;
import com.atlassian.stash.internal.migration.entity.project.ProjectMetadata;
import com.atlassian.stash.internal.migration.entity.repository.RepositoryMetadata;
import com.atlassian.stash.internal.project.InternalProjectService;
import com.atlassian.stash.internal.repository.InternalRepositoryService;
import com.fasterxml.jackson.databind.ObjectMapper;
import io.atlassian.fugue.retry.RetryFactory;
import jakarta.annotation.Nonnull;
import java.io.IOException;
import java.nio.file.FileSystems;
import java.nio.file.Path;
import java.nio.file.PathMatcher;
import java.nio.file.Paths;
import java.util.Objects;
import java.util.function.Predicate;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class MetadataImporter
implements Importer {
    private static final int ENTITY_CREATION_TRIES = 3;
    private static final ObjectMapper OBJECT_MAPPER = new ObjectMapper();
    private static final Logger log = LoggerFactory.getLogger(MetadataImporter.class);
    private static final PathMatcher matchRepository = FileSystems.getDefault().getPathMatcher("glob:repository_*.json");
    private static final Path projectJsonFilename = Paths.get("project.json", new String[0]);
    private final UniqueIdentifierGenerator generator;
    private final I18nService i18nService;
    private final InternalProjectService projectService;
    private final InternalRepositoryService repositoryService;
    private final UserImportService userImportService;

    public MetadataImporter(UniqueIdentifierGenerator generator, I18nService i18nService, InternalProjectService projectService, InternalRepositoryService repositoryService, UserImportService userImportService) {
        this.generator = generator;
        this.i18nService = i18nService;
        this.projectService = projectService;
        this.repositoryService = repositoryService;
        this.userImportService = userImportService;
    }

    public void onEntry(@Nonnull ImportContext context, @Nonnull EntrySource entry) {
        Objects.requireNonNull(context, "context");
        Objects.requireNonNull(entry, "entry");
        Path path = entry.getPath();
        log.debug("Importing entity from path: {}", (Object)path);
        Path fileName = path.getFileName();
        if (matchRepository.matches(fileName)) {
            this.onRepository(context, entry);
        } else if (projectJsonFilename.equals(fileName)) {
            this.onProject(context, entry);
        } else {
            context.addWarning(this.i18nService.createKeyedMessage("bitbucket.service.migration.import.unknown.entry", new Object[]{path}), null);
        }
    }

    private String findUniqueRepositorySlug(ImportContext context, RepositoryMetadata metadata, String projectKey) {
        String generatedSlug;
        String exportedSlug = metadata.getSlug();
        if (exportedSlug.equals(generatedSlug = this.generator.getUniqueIdentifier(exportedSlug, 128, this.repositorySlugExistsInProject(projectKey)).orElseThrow(() -> this.noUniqueRepositoryIdentifierException(metadata)))) {
            return metadata.getName();
        }
        context.addWarning(this.i18nService.createKeyedMessage("bitbucket.service.migration.repository.import.name.conflict", new Object[]{metadata.getId(), exportedSlug, generatedSlug}), null);
        log.info("Naming conflict with an existing repository when importing repository with external ID {}. Repository being imported has had slug changed. Repository slug: \"{}\" -> \"{}\".", new Object[]{metadata.getId(), exportedSlug, generatedSlug});
        return generatedSlug;
    }

    private Project getOrCreatePersonalProject(ImportContext context, Path path, ProjectMetadata projectMetadata) {
        ApplicationUser user = projectMetadata.getOwnerId().map(exportId -> this.userImportService.findOrCreateUser((String)exportId, context)).orElseThrow(() -> new ImportException(this.i18nService.createKeyedMessage("bitbucket.service.migration.project.import.personal.noowner", new Object[]{path})));
        return this.projectService.getPersonalProject(user);
    }

    private ImportException noUniqueProjectIdentifierException(ProjectMetadata metadata) {
        return new ImportException(this.i18nService.createKeyedMessage("bitbucket.service.migration.project.import.rename.failed", new Object[]{metadata.getId(), metadata.getKey(), metadata.getName()}));
    }

    private ImportException noUniqueRepositoryIdentifierException(RepositoryMetadata metadata) {
        return new ImportException(this.i18nService.createKeyedMessage("bitbucket.service.migration.repository.import.rename.failed", new Object[]{metadata.getId(), metadata.getSlug()}));
    }

    private void onProject(ImportContext context, EntrySource entry) {
        Path path = entry.getPath();
        try {
            entry.read(inputStream -> {
                ProjectMetadata metadata = (ProjectMetadata)OBJECT_MAPPER.readValue(inputStream, ProjectMetadata.class);
                this.updateImportStatusForProject(context, metadata);
                Project project = metadata.getType() == ProjectType.PERSONAL.getId() ? this.getOrCreatePersonalProject(context, path, metadata) : (Project)RetryFactory.create(() -> this.projectService.importProject(this.projectCreateRequest(context, metadata)), (int)3).get();
                context.getEntityMapping(StandardMigrationEntityType.PROJECT).add(metadata.getId(), (Object)project.getId());
                log.debug("Imported project from path: {} externalId: {} internalId: {}", new Object[]{path, metadata.getId(), project.getId()});
            });
        }
        catch (IOException e) {
            throw new ImportException(this.i18nService.createKeyedMessage("bitbucket.service.migration.project.import.failed", new Object[]{path}), (Throwable)e);
        }
    }

    private void onRepository(ImportContext context, EntrySource entry) {
        Path path = entry.getPath();
        try {
            entry.read(inputStream -> {
                RepositoryMetadata metadata = (RepositoryMetadata)OBJECT_MAPPER.readValue(inputStream, RepositoryMetadata.class);
                Project project = context.getEntityMapping(StandardMigrationEntityType.PROJECT).getLocalId(metadata.getProjectId()).map(arg_0 -> ((InternalProjectService)this.projectService).getById(arg_0)).orElseThrow(() -> new ImportException(this.i18nService.createKeyedMessage("bitbucket.service.migration.repository.import.no.project", new Object[]{metadata.getProjectId()})));
                this.updateImportStatusForRepository(context, project, metadata);
                String origin = metadata.getOriginId().orElse(null);
                Repository repository = origin != null ? context.getEntityMapping(StandardMigrationEntityType.REPOSITORY).getLocalId(origin).map(arg_0 -> ((InternalRepositoryService)this.repositoryService).getById(arg_0)).map(parent -> (Repository)RetryFactory.create(() -> this.repositoryService.importFork(this.repositoryForkRequest(context, metadata, project, (Repository)parent)), (int)3).get()).orElseThrow(() -> new ImportException(this.i18nService.createKeyedMessage("bitbucket.service.migration.repository.import.fork.failed", new Object[]{origin}))) : (Repository)RetryFactory.create(() -> this.repositoryService.importRepository(this.repositoryCreateRequest(context, metadata, project), metadata.getHierarchyId()), (int)3).get();
                context.getEntityMapping(StandardMigrationEntityType.REPOSITORY).add(metadata.getId(), (Object)repository.getId());
                log.debug("Imported repository from path: {} externalId: {} internalId: {} isFork : {} into project with id: {}", new Object[]{path, metadata.getId(), repository.getId(), repository.isFork(), project.getId()});
            });
        }
        catch (IOException e) {
            throw new ImportException(this.i18nService.createKeyedMessage("bitbucket.service.migration.repository.import.failed", new Object[]{path}), (Throwable)e);
        }
    }

    private ProjectCreateRequest projectCreateRequest(ImportContext context, ProjectMetadata metadata) {
        String exportedKey = metadata.getKey();
        String key = this.generator.getUniqueIdentifier(exportedKey, 128, this::projectKeyExists).orElseThrow(() -> this.noUniqueProjectIdentifierException(metadata));
        String exportedName = metadata.getName();
        String name = this.generator.getUniqueIdentifier(exportedName, 128, this::projectNameExists).orElseThrow(() -> this.noUniqueProjectIdentifierException(metadata));
        if (!key.equals(exportedKey) || !name.equals(exportedName)) {
            context.addWarning(this.i18nService.createKeyedMessage("bitbucket.service.migration.project.import.name.conflict", new Object[]{metadata.getId(), exportedKey, key, exportedName, name}), null);
            log.info("Naming conflict with an existing project when importing project with external ID {}. Project being imported has had key and/or name changed. Project key: \"{}\" -> \"{}\", project name: \"{}\" -> \"{}\".", new Object[]{metadata.getId(), exportedKey, key, exportedName, name});
        }
        return ((ProjectCreateRequest.Builder)((ProjectCreateRequest.Builder)((ProjectCreateRequest.Builder)((ProjectCreateRequest.Builder)new ProjectCreateRequest.Builder().description(metadata.getDescription())).key(key)).name(name)).publiclyAccessible(metadata.isPublic())).build();
    }

    private boolean projectKeyExists(String key) {
        try {
            return this.projectService.getByKey(key) != null;
        }
        catch (ProjectMovedException e) {
            log.debug("Alias conflict with an existing project when importing project with key {}. Alias will beoverwritten.", (Object)key);
            return false;
        }
    }

    private boolean projectNameExists(String name) {
        return this.projectService.getByName(name) != null;
    }

    private RepositoryCreateRequest repositoryCreateRequest(ImportContext context, RepositoryMetadata metadata, Project project) {
        return ((RepositoryCreateRequest.Builder)((RepositoryCreateRequest.Builder)((RepositoryCreateRequest.Builder)new RepositoryCreateRequest.Builder().forkable(metadata.isForkable())).name(this.findUniqueRepositorySlug(context, metadata, project.getKey()))).project(project).publiclyAccessible(metadata.isPublic())).scmId(metadata.getScmId()).build();
    }

    private RepositoryForkRequest repositoryForkRequest(ImportContext context, RepositoryMetadata metadata, Project project, Repository parent) {
        return ((RepositoryForkRequest.Builder)((RepositoryForkRequest.Builder)((RepositoryForkRequest.Builder)new RepositoryForkRequest.Builder().forkable(metadata.isForkable())).name(this.findUniqueRepositorySlug(context, metadata, project.getKey()))).parent(parent).project(project).publiclyAccessible(metadata.isPublic())).build();
    }

    private Predicate<String> repositorySlugExistsInProject(String projectKey) {
        return slug -> {
            try {
                return this.repositoryService.getBySlug(projectKey, slug) != null;
            }
            catch (RepositoryMovedException e) {
                log.debug("Alias conflict with an existing repository when importing repository with slug {} in project with key {}. Alias will be overwritten.", slug, (Object)projectKey);
                return false;
            }
        };
    }

    private void updateImportStatus(ImportContext context, KeyedMessage message) {
        block3: {
            if (context instanceof InternalImportContext) {
                MigrationJob job = ((InternalImportContext)context).getJob();
                try {
                    job.updateProgress(new MigrationJobProgressUpdateRequest.Builder().message(message).build());
                }
                catch (EntityOutOfDateException e) {
                    if (!log.isDebugEnabled()) break block3;
                    log.debug("Failed to update import job ID '{}' status message to '{}'.", new Object[]{job.getId(), message.getRootMessage(), e});
                }
            }
        }
    }

    private void updateImportStatusForProject(ImportContext context, ProjectMetadata project) {
        this.updateImportStatus(context, this.i18nService.createKeyedMessage("bitbucket.service.migration.import.progress.message.project", new Object[]{project.getKey()}));
    }

    private void updateImportStatusForRepository(ImportContext context, Project project, RepositoryMetadata repository) {
        this.updateImportStatus(context, this.i18nService.createKeyedMessage("bitbucket.service.migration.import.progress.message.repository", new Object[]{project.getKey(), repository.getSlug()}));
    }
}

